/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.shapes.RectShape;
import android.graphics.drawable.shapes.Shape;
import android.util.AttributeSet;
import android.widget.AbsSeekBar;
import com.android.internal.R;

public class RatingBar
extends AbsSeekBar {
    private int mNumStars = 5;
    private int mProgressOnStartTracking;
    private OnRatingBarChangeListener mOnRatingBarChangeListener;

    public RatingBar(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.RatingBar, defStyle, 0);
        int numStars = a.getInt(0, this.mNumStars);
        this.setIsIndicator(a.getBoolean(3, !this.mIsUserSeekable));
        float rating = a.getFloat(1, -1.0f);
        float stepSize = a.getFloat(2, -1.0f);
        a.recycle();
        if (numStars > 0 && numStars != this.mNumStars) {
            this.setNumStars(numStars);
        }
        if (stepSize >= 0.0f) {
            this.setStepSize(stepSize);
        } else {
            this.setStepSize(0.5f);
        }
        if (rating >= 0.0f) {
            this.setRating(rating);
        }
        this.mTouchProgressOffset = 1.1f;
    }

    public RatingBar(Context context, AttributeSet attrs) {
        this(context, attrs, 16842876);
    }

    public RatingBar(Context context) {
        this(context, null);
    }

    public void setOnRatingBarChangeListener(OnRatingBarChangeListener listener) {
        this.mOnRatingBarChangeListener = listener;
    }

    public OnRatingBarChangeListener getOnRatingBarChangeListener() {
        return this.mOnRatingBarChangeListener;
    }

    public void setIsIndicator(boolean isIndicator) {
        this.mIsUserSeekable = !isIndicator;
        this.setFocusable(!isIndicator);
    }

    public boolean isIndicator() {
        return !this.mIsUserSeekable;
    }

    public void setNumStars(int numStars) {
        if (numStars <= 0) {
            return;
        }
        this.mNumStars = numStars;
        this.requestLayout();
    }

    public int getNumStars() {
        return this.mNumStars;
    }

    public void setRating(float rating) {
        this.setProgress(Math.round(rating * this.getProgressPerStar()));
    }

    public float getRating() {
        return (float)this.getProgress() / this.getProgressPerStar();
    }

    public void setStepSize(float stepSize) {
        if (stepSize <= 0.0f) {
            return;
        }
        float newMax = (float)this.mNumStars / stepSize;
        int newProgress = (int)(newMax / (float)this.getMax() * (float)this.getProgress());
        this.setMax((int)newMax);
        this.setProgress(newProgress);
    }

    public float getStepSize() {
        return (float)this.getNumStars() / (float)this.getMax();
    }

    private float getProgressPerStar() {
        if (this.mNumStars > 0) {
            return 1.0f * (float)this.getMax() / (float)this.mNumStars;
        }
        return 1.0f;
    }

    Shape getDrawableShape() {
        return new RectShape();
    }

    void onProgressRefresh(float scale, boolean fromUser) {
        super.onProgressRefresh(scale, fromUser);
        this.updateSecondaryProgress(this.getProgress());
        if (!fromUser) {
            this.dispatchRatingChange(false);
        }
    }

    private void updateSecondaryProgress(int progress) {
        float ratio = this.getProgressPerStar();
        if (ratio > 0.0f) {
            float progressInStars = (float)progress / ratio;
            int secondaryProgress = (int)(Math.ceil(progressInStars) * (double)ratio);
            this.setSecondaryProgress(secondaryProgress);
        }
    }

    protected synchronized void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.mSampleTile != null) {
            int width = this.mSampleTile.getWidth() * this.mNumStars;
            this.setMeasuredDimension(RatingBar.resolveSizeAndState(width, widthMeasureSpec, 0), this.getMeasuredHeight());
        }
    }

    void onStartTrackingTouch() {
        this.mProgressOnStartTracking = this.getProgress();
        super.onStartTrackingTouch();
    }

    void onStopTrackingTouch() {
        super.onStopTrackingTouch();
        if (this.getProgress() != this.mProgressOnStartTracking) {
            this.dispatchRatingChange(true);
        }
    }

    void onKeyChange() {
        super.onKeyChange();
        this.dispatchRatingChange(true);
    }

    void dispatchRatingChange(boolean fromUser) {
        if (this.mOnRatingBarChangeListener != null) {
            this.mOnRatingBarChangeListener.onRatingChanged(this, this.getRating(), fromUser);
        }
    }

    public synchronized void setMax(int max) {
        if (max <= 0) {
            return;
        }
        super.setMax(max);
    }

    public static interface OnRatingBarChangeListener {
        public void onRatingChanged(RatingBar var1, float var2, boolean var3);
    }
}

