/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.PendingIntent;
import android.net.LinkCapabilities;
import android.net.LinkProperties;
import android.net.ProxyProperties;
import android.os.AsyncResult;
import android.os.Message;
import android.os.SystemProperties;
import android.text.TextUtils;
import com.android.internal.telephony.ApnContext;
import com.android.internal.telephony.ApnSetting;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.DataCallState;
import com.android.internal.telephony.DataConnectionTracker;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.RetryManager;
import com.android.internal.util.AsyncChannel;
import com.android.internal.util.State;
import com.android.internal.util.StateMachine;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public abstract class DataConnection
extends StateMachine {
    protected static final boolean DBG = true;
    protected static final boolean VDBG = false;
    protected static Object mCountLock = new Object();
    protected static int mCount;
    protected AsyncChannel mAc;
    private List<ApnContext> mApnList = null;
    PendingIntent mReconnectIntent = null;
    private DataConnectionTracker mDataConnectionTracker = null;
    protected static final int BASE = 262144;
    protected static final int EVENT_CONNECT = 262144;
    protected static final int EVENT_SETUP_DATA_CONNECTION_DONE = 262145;
    protected static final int EVENT_GET_LAST_FAIL_DONE = 262146;
    protected static final int EVENT_DEACTIVATE_DONE = 262147;
    protected static final int EVENT_DISCONNECT = 262148;
    protected static final int EVENT_RIL_CONNECTED = 262149;
    protected static final int EVENT_DISCONNECT_ALL = 262150;
    protected static final int EVENT_LOG_BAD_DNS_ADDRESS = 50100;
    protected ApnSetting mApn;
    protected int mTag;
    protected PhoneBase phone;
    protected int mRilVersion = -1;
    protected int cid;
    protected LinkProperties mLinkProperties = new LinkProperties();
    protected LinkCapabilities mCapabilities = new LinkCapabilities();
    protected long createTime;
    protected long lastFailTime;
    protected FailCause lastFailCause;
    protected int mRetryOverride = -1;
    protected static final String NULL_IP = "0.0.0.0";
    private int mRefCount;
    Object userData;
    private int mId;
    private RetryManager mRetryMgr;
    private DcDefaultState mDefaultState = new DcDefaultState();
    private DcInactiveState mInactiveState = new DcInactiveState();
    private DcActivatingState mActivatingState = new DcActivatingState();
    private DcActiveState mActiveState = new DcActiveState();
    private DcDisconnectingState mDisconnectingState = new DcDisconnectingState();
    private DcDisconnectionErrorCreatingConnection mDisconnectingErrorCreatingConnection = new DcDisconnectionErrorCreatingConnection();

    public abstract String toString();

    protected abstract void onConnect(ConnectionParams var1);

    protected abstract boolean isDnsOk(String[] var1);

    protected abstract void log(String var1);

    protected DataConnection(PhoneBase phone, String name, int id2, RetryManager rm, DataConnectionTracker dct) {
        super(name);
        this.log("DataConnection constructor E");
        this.phone = phone;
        this.mDataConnectionTracker = dct;
        this.mId = id2;
        this.mRetryMgr = rm;
        this.cid = -1;
        this.setDbg(false);
        this.addState(this.mDefaultState);
        this.addState(this.mInactiveState, this.mDefaultState);
        this.addState(this.mActivatingState, this.mDefaultState);
        this.addState(this.mActiveState, this.mDefaultState);
        this.addState(this.mDisconnectingState, this.mDefaultState);
        this.addState(this.mDisconnectingErrorCreatingConnection, this.mDefaultState);
        this.setInitialState(this.mInactiveState);
        this.mApnList = new ArrayList<ApnContext>();
        this.log("DataConnection constructor X");
    }

    private void tearDownData(Object o) {
        int discReason = 0;
        if (o != null && o instanceof DisconnectParams) {
            DisconnectParams dp = (DisconnectParams)o;
            Message m = dp.onCompletedMsg;
            if (TextUtils.equals(dp.reason, "radioTurnedOff")) {
                discReason = 1;
            } else if (TextUtils.equals(dp.reason, "pdpReset")) {
                discReason = 2;
            }
        }
        if (this.phone.mCM.getRadioState().isOn()) {
            this.log("tearDownData radio is on, call deactivateDataCall");
            this.phone.mCM.deactivateDataCall(this.cid, discReason, this.obtainMessage(262147, o));
        } else {
            this.log("tearDownData radio is off sendMessage EVENT_DEACTIVATE_DONE immediately");
            AsyncResult ar = new AsyncResult(o, null, null);
            this.sendMessage(this.obtainMessage(262147, ar));
        }
    }

    private void notifyConnectCompleted(ConnectionParams cp, FailCause cause) {
        Message connectionCompletedMsg = cp.onCompletedMsg;
        if (connectionCompletedMsg == null) {
            return;
        }
        long timeStamp = System.currentTimeMillis();
        connectionCompletedMsg.arg1 = this.cid;
        if (cause == FailCause.NONE) {
            this.createTime = timeStamp;
            AsyncResult.forMessage(connectionCompletedMsg);
        } else {
            this.lastFailCause = cause;
            this.lastFailTime = timeStamp;
            AsyncResult.forMessage(connectionCompletedMsg, (Object)cause, new CallSetupException(this.mRetryOverride));
        }
        this.log("notifyConnectionCompleted at " + timeStamp + " cause=" + (Object)((Object)cause));
        connectionCompletedMsg.sendToTarget();
    }

    private void notifyDisconnectCompleted(DisconnectParams dp, boolean sendAll) {
        ApnContext alreadySent = null;
        String reason = null;
        if (dp.onCompletedMsg != null) {
            Message msg = dp.onCompletedMsg;
            if (msg.obj instanceof ApnContext) {
                alreadySent = (ApnContext)msg.obj;
            }
            reason = dp.reason;
            AsyncResult.forMessage(msg);
            msg.sendToTarget();
        }
        if (sendAll) {
            for (ApnContext a : this.mApnList) {
                if (a == alreadySent) continue;
                if (reason != null) {
                    a.setReason(reason);
                }
                Message msg = this.mDataConnectionTracker.obtainMessage(270351, a);
                AsyncResult.forMessage(msg);
                msg.sendToTarget();
            }
        }
        this.log("NotifyDisconnectCompleted DisconnectParams=" + dp);
    }

    protected int getRadioTechnology(int defaultRadioTechnology) {
        int radioTechnology = this.mRilVersion < 6 ? defaultRadioTechnology : this.phone.getServiceState().getRadioTechnology() + 2;
        return radioTechnology;
    }

    public int getDataConnectionId() {
        return this.mId;
    }

    public int getRetryCount() {
        return this.mRetryMgr.getRetryCount();
    }

    public int getRetryTimer() {
        return this.mRetryMgr.getRetryTimer();
    }

    public void increaseRetryCount() {
        this.mRetryMgr.increaseRetryCount();
    }

    public boolean isRetryNeeded() {
        return this.mRetryMgr.isRetryNeeded();
    }

    public void resetRetryCount() {
        this.mRetryMgr.resetRetryCount();
    }

    public void retryForeverUsingLastTimeout() {
        this.mRetryMgr.retryForeverUsingLastTimeout();
    }

    public boolean isRetryForever() {
        return this.mRetryMgr.isRetryForever();
    }

    public boolean configureRetry(int maxRetryCount, int retryTime, int randomizationTime) {
        return this.mRetryMgr.configure(maxRetryCount, retryTime, randomizationTime);
    }

    public boolean configureRetry(String configStr) {
        return this.mRetryMgr.configure(configStr);
    }

    protected void clearSettings() {
        this.log("clearSettings");
        this.createTime = -1L;
        this.lastFailTime = -1L;
        this.lastFailCause = FailCause.NONE;
        this.mRetryOverride = -1;
        this.mRefCount = 0;
        this.cid = -1;
        this.mLinkProperties = new LinkProperties();
        this.mApn = null;
    }

    private DataCallState.SetupResult onSetupConnectionCompleted(AsyncResult ar) {
        DataCallState.SetupResult result;
        DataCallState response = (DataCallState)ar.result;
        ConnectionParams cp = (ConnectionParams)ar.userObj;
        if (ar.exception != null) {
            this.log("onSetupConnectionCompleted failed, ar.exception=" + ar.exception + " response=" + response);
            if (ar.exception instanceof CommandException && ((CommandException)ar.exception).getCommandError() == CommandException.Error.RADIO_NOT_AVAILABLE) {
                result = DataCallState.SetupResult.ERR_BadCommand;
                result.mFailCause = FailCause.RADIO_NOT_AVAILABLE;
            } else if (response == null || response.version < 4) {
                result = DataCallState.SetupResult.ERR_GetLastErrorFromRil;
            } else {
                result = DataCallState.SetupResult.ERR_RilError;
                result.mFailCause = FailCause.fromInt(response.status);
            }
        } else if (cp.tag != this.mTag) {
            this.log("BUG: onSetupConnectionCompleted is stale cp.tag=" + cp.tag + ", mtag=" + this.mTag);
            result = DataCallState.SetupResult.ERR_Stale;
        } else if (response.status != 0) {
            result = DataCallState.SetupResult.ERR_RilError;
            result.mFailCause = FailCause.fromInt(response.status);
        } else {
            this.log("onSetupConnectionCompleted received DataCallState: " + response);
            this.cid = response.cid;
            result = this.updateLinkProperty((DataCallState)response).setupResult;
        }
        return result;
    }

    private int getSuggestedRetryTime(AsyncResult ar) {
        int retry = -1;
        if (ar.exception == null) {
            DataCallState response = (DataCallState)ar.result;
            retry = response.suggestedRetryTime;
        }
        return retry;
    }

    private DataCallState.SetupResult setLinkProperties(DataCallState response, LinkProperties lp) {
        boolean okToUseSystemPropertyDns = false;
        String propertyPrefix = "net." + response.ifname + ".";
        String[] dnsServers = new String[]{SystemProperties.get(propertyPrefix + "dns1"), SystemProperties.get(propertyPrefix + "dns2")};
        okToUseSystemPropertyDns = this.isDnsOk(dnsServers);
        return response.setLinkProperties(lp, okToUseSystemPropertyDns);
    }

    private UpdateLinkPropertyResult updateLinkProperty(DataCallState newState) {
        UpdateLinkPropertyResult result = new UpdateLinkPropertyResult(this.mLinkProperties);
        if (newState == null) {
            return result;
        }
        result.newLp = new LinkProperties();
        result.setupResult = this.setLinkProperties(newState, result.newLp);
        if (result.setupResult != DataCallState.SetupResult.SUCCESS) {
            this.log("updateLinkProperty failed : " + (Object)((Object)result.setupResult));
            return result;
        }
        result.newLp.setHttpProxy(this.mLinkProperties.getHttpProxy());
        if (!result.oldLp.equals(result.newLp)) {
            this.log("updateLinkProperty old != new");
        }
        this.mLinkProperties = result.newLp;
        return result;
    }

    public void bringUp(Message onCompletedMsg, ApnSetting apn) {
        this.sendMessage(this.obtainMessage(262144, new ConnectionParams(apn, onCompletedMsg)));
    }

    public void tearDown(String reason, Message onCompletedMsg) {
        this.sendMessage(this.obtainMessage(262148, new DisconnectParams(reason, onCompletedMsg)));
    }

    public void tearDownAll(String reason, Message onCompletedMsg) {
        this.sendMessage(this.obtainMessage(262150, new DisconnectParams(reason, onCompletedMsg)));
    }

    private class DcDisconnectionErrorCreatingConnection
    extends State {
        private DcDisconnectionErrorCreatingConnection() {
        }

        public boolean processMessage(Message msg) {
            boolean retVal;
            switch (msg.what) {
                case 262147: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    ConnectionParams cp = (ConnectionParams)ar.userObj;
                    if (cp.tag == DataConnection.this.mTag) {
                        DataConnection.this.log("DcDisconnectionErrorCreatingConnection msg.what=EVENT_DEACTIVATE_DONE");
                        DataConnection.this.mInactiveState.setEnterNotificationParams(cp, FailCause.UNACCEPTABLE_NETWORK_PARAMETER, -1);
                        DataConnection.this.transitionTo(DataConnection.this.mInactiveState);
                    } else {
                        DataConnection.this.log("DcDisconnectionErrorCreatingConnection EVENT_DEACTIVATE_DONE stale dp.tag=" + cp.tag + ", mTag=" + DataConnection.this.mTag);
                    }
                    retVal = true;
                    break;
                }
                default: {
                    retVal = false;
                }
            }
            return retVal;
        }
    }

    private class DcDisconnectingState
    extends State {
        private DcDisconnectingState() {
        }

        public boolean processMessage(Message msg) {
            boolean retVal;
            switch (msg.what) {
                case 262144: {
                    DataConnection.this.log("DcDisconnectingState msg.what=EVENT_CONNECT. Defer. RefCount = " + DataConnection.this.mRefCount);
                    DataConnection.this.deferMessage(msg);
                    retVal = true;
                    break;
                }
                case 262147: {
                    DataConnection.this.log("DcDisconnectingState msg.what=EVENT_DEACTIVATE_DONE");
                    AsyncResult ar = (AsyncResult)msg.obj;
                    DisconnectParams dp = (DisconnectParams)ar.userObj;
                    if (dp.tag == DataConnection.this.mTag) {
                        DataConnection.this.mInactiveState.setEnterNotificationParams((DisconnectParams)ar.userObj);
                        DataConnection.this.transitionTo(DataConnection.this.mInactiveState);
                    } else {
                        DataConnection.this.log("DcDisconnectState EVENT_DEACTIVATE_DONE stale dp.tag=" + dp.tag + " mTag=" + DataConnection.this.mTag);
                    }
                    retVal = true;
                    break;
                }
                default: {
                    retVal = false;
                }
            }
            return retVal;
        }
    }

    private class DcActiveState
    extends State {
        private ConnectionParams mConnectionParams = null;
        private FailCause mFailCause = null;

        private DcActiveState() {
        }

        public void setEnterNotificationParams(ConnectionParams cp, FailCause cause) {
            this.mConnectionParams = cp;
            this.mFailCause = cause;
        }

        public void enter() {
            if (this.mConnectionParams != null && this.mFailCause != null) {
                DataConnection.this.notifyConnectCompleted(this.mConnectionParams, this.mFailCause);
            }
        }

        public void exit() {
            this.mConnectionParams = null;
            this.mFailCause = null;
        }

        public boolean processMessage(Message msg) {
            boolean retVal;
            switch (msg.what) {
                case 262144: {
                    DataConnection.this.mRefCount++;
                    DataConnection.this.log("DcActiveState msg.what=EVENT_CONNECT RefCount=" + DataConnection.this.mRefCount);
                    if (msg.obj != null) {
                        DataConnection.this.notifyConnectCompleted((ConnectionParams)msg.obj, FailCause.NONE);
                    }
                    retVal = true;
                    break;
                }
                case 262148: {
                    DataConnection.this.mRefCount--;
                    DataConnection.this.log("DcActiveState msg.what=EVENT_DISCONNECT RefCount=" + DataConnection.this.mRefCount);
                    if (DataConnection.this.mRefCount == 0) {
                        DisconnectParams dp = (DisconnectParams)msg.obj;
                        dp.tag = DataConnection.this.mTag;
                        DataConnection.this.tearDownData(dp);
                        DataConnection.this.transitionTo(DataConnection.this.mDisconnectingState);
                    } else if (msg.obj != null) {
                        DataConnection.this.notifyDisconnectCompleted((DisconnectParams)msg.obj, false);
                    }
                    retVal = true;
                    break;
                }
                case 262150: {
                    DataConnection.this.log("DcActiveState msg.what=EVENT_DISCONNECT_ALL RefCount=" + DataConnection.this.mRefCount);
                    DataConnection.this.mRefCount = 0;
                    DisconnectParams dp = (DisconnectParams)msg.obj;
                    dp.tag = DataConnection.this.mTag;
                    DataConnection.this.tearDownData(dp);
                    DataConnection.this.transitionTo(DataConnection.this.mDisconnectingState);
                    retVal = true;
                    break;
                }
                default: {
                    retVal = false;
                }
            }
            return retVal;
        }
    }

    private class DcActivatingState
    extends State {
        private DcActivatingState() {
        }

        public boolean processMessage(Message msg) {
            boolean retVal;
            switch (msg.what) {
                case 262144: {
                    DataConnection.this.log("DcActivatingState deferring msg.what=EVENT_CONNECT refCount = " + DataConnection.this.mRefCount);
                    DataConnection.this.deferMessage(msg);
                    retVal = true;
                    break;
                }
                case 262145: {
                    DataConnection.this.log("DcActivatingState msg.what=EVENT_SETUP_DATA_CONNECTION_DONE");
                    AsyncResult ar = (AsyncResult)msg.obj;
                    ConnectionParams cp = (ConnectionParams)ar.userObj;
                    DataCallState.SetupResult result = DataConnection.this.onSetupConnectionCompleted(ar);
                    DataConnection.this.log("DcActivatingState onSetupConnectionCompleted result=" + (Object)((Object)result));
                    switch (result) {
                        case SUCCESS: {
                            DataConnection.this.mActiveState.setEnterNotificationParams(cp, FailCause.NONE);
                            DataConnection.this.transitionTo(DataConnection.this.mActiveState);
                            break;
                        }
                        case ERR_BadCommand: {
                            DataConnection.this.mInactiveState.setEnterNotificationParams(cp, result.mFailCause, -1);
                            DataConnection.this.transitionTo(DataConnection.this.mInactiveState);
                            break;
                        }
                        case ERR_UnacceptableParameter: {
                            DataConnection.this.tearDownData(cp);
                            DataConnection.this.transitionTo(DataConnection.this.mDisconnectingErrorCreatingConnection);
                            break;
                        }
                        case ERR_GetLastErrorFromRil: {
                            DataConnection.this.phone.mCM.getLastDataCallFailCause(DataConnection.this.obtainMessage(262146, cp));
                            break;
                        }
                        case ERR_RilError: {
                            DataConnection.this.mInactiveState.setEnterNotificationParams(cp, result.mFailCause, DataConnection.this.getSuggestedRetryTime(ar));
                            DataConnection.this.transitionTo(DataConnection.this.mInactiveState);
                            break;
                        }
                        case ERR_Stale: {
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unknown SetupResult, should not happen");
                        }
                    }
                    retVal = true;
                    break;
                }
                case 262146: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    ConnectionParams cp = (ConnectionParams)ar.userObj;
                    FailCause cause = FailCause.UNKNOWN;
                    if (cp.tag == DataConnection.this.mTag) {
                        DataConnection.this.log("DcActivatingState msg.what=EVENT_GET_LAST_FAIL_DONE");
                        if (ar.exception == null) {
                            int rilFailCause = ((int[])ar.result)[0];
                            cause = FailCause.fromInt(rilFailCause);
                        }
                        DataConnection.this.mInactiveState.setEnterNotificationParams(cp, cause, -1);
                        DataConnection.this.transitionTo(DataConnection.this.mInactiveState);
                    } else {
                        DataConnection.this.log("DcActivatingState EVENT_GET_LAST_FAIL_DONE is stale cp.tag=" + cp.tag + ", mTag=" + DataConnection.this.mTag);
                    }
                    retVal = true;
                    break;
                }
                default: {
                    retVal = false;
                }
            }
            return retVal;
        }
    }

    private class DcInactiveState
    extends State {
        private ConnectionParams mConnectionParams = null;
        private FailCause mFailCause = null;
        private DisconnectParams mDisconnectParams = null;

        private DcInactiveState() {
        }

        public void setEnterNotificationParams(ConnectionParams cp, FailCause cause, int retryOverride) {
            this.mConnectionParams = cp;
            this.mFailCause = cause;
            DataConnection.this.mRetryOverride = retryOverride;
        }

        public void setEnterNotificationParams(DisconnectParams dp) {
            this.mDisconnectParams = dp;
        }

        public void enter() {
            ++DataConnection.this.mTag;
            if (this.mConnectionParams != null && this.mFailCause != null) {
                DataConnection.this.notifyConnectCompleted(this.mConnectionParams, this.mFailCause);
            }
            if (this.mDisconnectParams != null) {
                DataConnection.this.notifyDisconnectCompleted(this.mDisconnectParams, true);
            }
            DataConnection.this.clearSettings();
        }

        public void exit() {
            this.mConnectionParams = null;
            this.mFailCause = null;
            this.mDisconnectParams = null;
        }

        public boolean processMessage(Message msg) {
            boolean retVal;
            switch (msg.what) {
                case 266254: {
                    DataConnection.this.log("DcInactiveState: msg.what=RSP_RESET, ignore we're already reset");
                    DataConnection.this.mAc.replyToMessage(msg, 266255);
                    retVal = true;
                    break;
                }
                case 262144: {
                    ConnectionParams cp = (ConnectionParams)msg.obj;
                    cp.tag = DataConnection.this.mTag;
                    DataConnection.this.log("DcInactiveState msg.what=EVENT_CONNECT.RefCount = " + DataConnection.this.mRefCount);
                    DataConnection.this.mRefCount = 1;
                    DataConnection.this.onConnect(cp);
                    DataConnection.this.transitionTo(DataConnection.this.mActivatingState);
                    retVal = true;
                    break;
                }
                case 262148: {
                    DataConnection.this.log("DcInactiveState: msg.what=EVENT_DISCONNECT");
                    DataConnection.this.notifyDisconnectCompleted((DisconnectParams)msg.obj, false);
                    retVal = true;
                    break;
                }
                case 262150: {
                    DataConnection.this.log("DcInactiveState: msg.what=EVENT_DISCONNECT_ALL");
                    DataConnection.this.notifyDisconnectCompleted((DisconnectParams)msg.obj, false);
                    retVal = true;
                    break;
                }
                default: {
                    retVal = false;
                }
            }
            return retVal;
        }
    }

    private class DcDefaultState
    extends State {
        private DcDefaultState() {
        }

        public void enter() {
            DataConnection.this.phone.mCM.registerForRilConnected(DataConnection.this.getHandler(), 262149, null);
        }

        public void exit() {
            DataConnection.this.phone.mCM.unregisterForRilConnected(DataConnection.this.getHandler());
        }

        public boolean processMessage(Message msg) {
            switch (msg.what) {
                case 69633: {
                    if (DataConnection.this.mAc != null) {
                        DataConnection.this.mAc.replyToMessage(msg, 69634, 3);
                        break;
                    }
                    DataConnection.this.mAc = new AsyncChannel();
                    DataConnection.this.mAc.connected(null, DataConnection.this.getHandler(), msg.replyTo);
                    DataConnection.this.mAc.replyToMessage(msg, 69634, 0, DataConnection.this.mId, "hi");
                    break;
                }
                case 69635: {
                    DataConnection.this.mAc.disconnect();
                    break;
                }
                case 69636: {
                    DataConnection.this.mAc = null;
                    break;
                }
                case 266240: {
                    boolean val = DataConnection.this.getCurrentState() == DataConnection.this.mInactiveState;
                    DataConnection.this.mAc.replyToMessage(msg, 266241, val ? 1 : 0);
                    break;
                }
                case 266242: {
                    DataConnection.this.mAc.replyToMessage(msg, 266243, DataConnection.this.cid);
                    break;
                }
                case 266244: {
                    DataConnection.this.mAc.replyToMessage(msg, 266245, DataConnection.this.mApn);
                    break;
                }
                case 266246: {
                    LinkProperties lp = new LinkProperties(DataConnection.this.mLinkProperties);
                    DataConnection.this.mAc.replyToMessage(msg, 266247, lp);
                    break;
                }
                case 266248: {
                    ProxyProperties proxy = (ProxyProperties)msg.obj;
                    DataConnection.this.mLinkProperties.setHttpProxy(proxy);
                    DataConnection.this.mAc.replyToMessage(msg, 266249);
                    break;
                }
                case 266252: {
                    DataCallState newState = (DataCallState)msg.obj;
                    UpdateLinkPropertyResult result = DataConnection.this.updateLinkProperty(newState);
                    DataConnection.this.mAc.replyToMessage(msg, 266253, result);
                    break;
                }
                case 266250: {
                    LinkCapabilities lc = new LinkCapabilities(DataConnection.this.mCapabilities);
                    DataConnection.this.mAc.replyToMessage(msg, 266251, lc);
                    break;
                }
                case 266254: {
                    DataConnection.this.mAc.replyToMessage(msg, 266255);
                    DataConnection.this.transitionTo(DataConnection.this.mInactiveState);
                    break;
                }
                case 266256: {
                    DataConnection.this.mAc.replyToMessage(msg, 266257, DataConnection.this.mRefCount);
                    break;
                }
                case 266258: {
                    ApnContext apnContext = (ApnContext)msg.obj;
                    if (!DataConnection.this.mApnList.contains(apnContext)) {
                        DataConnection.this.mApnList.add(apnContext);
                    }
                    DataConnection.this.mAc.replyToMessage(msg, 266259);
                    break;
                }
                case 266260: {
                    ApnContext apnContext = (ApnContext)msg.obj;
                    DataConnection.this.mApnList.remove(apnContext);
                    DataConnection.this.mAc.replyToMessage(msg, 266261);
                    break;
                }
                case 266262: {
                    DataConnection.this.mAc.replyToMessage(msg, 266263, new ArrayList(DataConnection.this.mApnList));
                    break;
                }
                case 266264: {
                    PendingIntent intent;
                    DataConnection.this.mReconnectIntent = intent = (PendingIntent)msg.obj;
                    DataConnection.this.mAc.replyToMessage(msg, 266265);
                    break;
                }
                case 266266: {
                    DataConnection.this.mAc.replyToMessage(msg, 266267, DataConnection.this.mReconnectIntent);
                    break;
                }
                case 262144: {
                    DataConnection.this.log("DcDefaultState: msg.what=EVENT_CONNECT, fail not expected");
                    ConnectionParams cp = (ConnectionParams)msg.obj;
                    DataConnection.this.notifyConnectCompleted(cp, FailCause.UNKNOWN);
                    break;
                }
                case 262148: {
                    DataConnection.this.log("DcDefaultState deferring msg.what=EVENT_DISCONNECT" + DataConnection.this.mRefCount);
                    DataConnection.this.deferMessage(msg);
                    break;
                }
                case 262150: {
                    DataConnection.this.log("DcDefaultState deferring msg.what=EVENT_DISCONNECT_ALL" + DataConnection.this.mRefCount);
                    DataConnection.this.deferMessage(msg);
                    break;
                }
                case 262149: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception == null) {
                        DataConnection.this.mRilVersion = (Integer)ar.result;
                        DataConnection.this.log("DcDefaultState: msg.what=EVENT_RIL_CONNECTED mRilVersion=" + DataConnection.this.mRilVersion);
                        break;
                    }
                    DataConnection.this.log("Unexpected exception on EVENT_RIL_CONNECTED");
                    DataConnection.this.mRilVersion = -1;
                    break;
                }
                default: {
                    DataConnection.this.log("DcDefaultState: shouldn't happen but ignore msg.what=0x" + Integer.toHexString(msg.what));
                }
            }
            return true;
        }
    }

    public static class UpdateLinkPropertyResult {
        public DataCallState.SetupResult setupResult = DataCallState.SetupResult.SUCCESS;
        public LinkProperties oldLp;
        public LinkProperties newLp;

        public UpdateLinkPropertyResult(LinkProperties curLp) {
            this.oldLp = curLp;
            this.newLp = curLp;
        }
    }

    public static class CallSetupException
    extends Exception {
        private int mRetryOverride = -1;

        CallSetupException(int retryOverride) {
            this.mRetryOverride = retryOverride;
        }

        public int getRetryOverride() {
            return this.mRetryOverride;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FailCause {
        NONE(0),
        OPERATOR_BARRED(8),
        INSUFFICIENT_RESOURCES(26),
        MISSING_UNKNOWN_APN(27),
        UNKNOWN_PDP_ADDRESS_TYPE(28),
        USER_AUTHENTICATION(29),
        ACTIVATION_REJECT_GGSN(30),
        ACTIVATION_REJECT_UNSPECIFIED(31),
        SERVICE_OPTION_NOT_SUPPORTED(32),
        SERVICE_OPTION_NOT_SUBSCRIBED(33),
        SERVICE_OPTION_OUT_OF_ORDER(34),
        NSAPI_IN_USE(35),
        ONLY_IPV4_ALLOWED(50),
        ONLY_IPV6_ALLOWED(51),
        ONLY_SINGLE_BEARER_ALLOWED(52),
        PROTOCOL_ERRORS(111),
        REGISTRATION_FAIL(-1),
        GPRS_REGISTRATION_FAIL(-2),
        SIGNAL_LOST(-3),
        PREF_RADIO_TECH_CHANGED(-4),
        RADIO_POWER_OFF(-5),
        TETHERED_CALL_ACTIVE(-6),
        ERROR_UNSPECIFIED(65535),
        UNKNOWN(65536),
        RADIO_NOT_AVAILABLE(65537),
        UNACCEPTABLE_NETWORK_PARAMETER(65538),
        CONNECTION_TO_DATACONNECTIONAC_BROKEN(65539);

        private final int mErrorCode;
        private static final HashMap<Integer, FailCause> sErrorCodeToFailCauseMap;

        private FailCause(int errorCode) {
            this.mErrorCode = errorCode;
        }

        int getErrorCode() {
            return this.mErrorCode;
        }

        public boolean isPermanentFail() {
            return this == OPERATOR_BARRED || this == MISSING_UNKNOWN_APN || this == UNKNOWN_PDP_ADDRESS_TYPE || this == USER_AUTHENTICATION || this == SERVICE_OPTION_NOT_SUPPORTED || this == SERVICE_OPTION_NOT_SUBSCRIBED || this == NSAPI_IN_USE || this == PROTOCOL_ERRORS;
        }

        public boolean isEventLoggable() {
            return this == OPERATOR_BARRED || this == INSUFFICIENT_RESOURCES || this == UNKNOWN_PDP_ADDRESS_TYPE || this == USER_AUTHENTICATION || this == ACTIVATION_REJECT_GGSN || this == ACTIVATION_REJECT_UNSPECIFIED || this == SERVICE_OPTION_NOT_SUBSCRIBED || this == SERVICE_OPTION_NOT_SUPPORTED || this == SERVICE_OPTION_OUT_OF_ORDER || this == NSAPI_IN_USE || this == PROTOCOL_ERRORS || this == UNACCEPTABLE_NETWORK_PARAMETER;
        }

        public static FailCause fromInt(int errorCode) {
            FailCause fc = sErrorCodeToFailCauseMap.get(errorCode);
            if (fc == null) {
                fc = UNKNOWN;
            }
            return fc;
        }

        static {
            sErrorCodeToFailCauseMap = new HashMap();
            for (FailCause fc : FailCause.values()) {
                sErrorCodeToFailCauseMap.put(fc.getErrorCode(), fc);
            }
        }
    }

    protected static class DisconnectParams {
        public int tag;
        public String reason;
        public Message onCompletedMsg;

        public DisconnectParams(String reason, Message onCompletedMsg) {
            this.reason = reason;
            this.onCompletedMsg = onCompletedMsg;
        }
    }

    protected static class ConnectionParams {
        public int tag;
        public ApnSetting apn;
        public Message onCompletedMsg;

        public ConnectionParams(ApnSetting apn, Message onCompletedMsg) {
            this.apn = apn;
            this.onCompletedMsg = onCompletedMsg;
        }
    }
}

