/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.android;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.ServiceConnection;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.content.res.BridgeResources;
import android.content.res.BridgeTypedArray;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.database.DatabaseErrorHandler;
import android.database.sqlite.SQLiteDatabase;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.BridgeInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.textservice.TextServicesManager;
import com.android.ide.common.rendering.api.IProjectCallback;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.android.BridgeContentResolver;
import com.android.layoutlib.bridge.android.BridgeLayoutParamsMapAttributes;
import com.android.layoutlib.bridge.android.BridgeWindowManager;
import com.android.layoutlib.bridge.android.BridgeXmlBlockParser;
import com.android.layoutlib.bridge.impl.ParserFactory;
import com.android.layoutlib.bridge.impl.Stack;
import com.android.resources.ResourceType;
import com.android.util.Pair;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BridgeContext
extends Context {
    private Resources mSystemResources;
    private final HashMap<View, Object> mViewKeyMap = new HashMap();
    private final Object mProjectKey;
    private final DisplayMetrics mMetrics;
    private final RenderResources mRenderResources;
    private final Configuration mConfig;
    private final ApplicationInfo mApplicationInfo;
    private final IProjectCallback mProjectCallback;
    private final BridgeWindowManager mIWindowManager;
    private Resources.Theme mTheme;
    private final Map<Object, Map<String, String>> mDefaultPropMaps = new IdentityHashMap<Object, Map<String, String>>();
    private Map<Integer, StyleResourceValue> mDynamicIdToStyleMap;
    private Map<StyleResourceValue, Integer> mStyleToDynamicIdMap;
    private int mDynamicIdGenerator = 0x1030000;
    private Map<int[], Map<Integer, TypedArray>> mTypedArrayCache;
    private BridgeInflater mBridgeInflater;
    private BridgeContentResolver mContentResolver;
    private final Stack<BridgeXmlBlockParser> mParserStack = new Stack();

    public BridgeContext(Object object, DisplayMetrics displayMetrics, RenderResources renderResources, IProjectCallback iProjectCallback, Configuration configuration, int n) {
        this.mProjectKey = object;
        this.mMetrics = displayMetrics;
        this.mProjectCallback = iProjectCallback;
        this.mRenderResources = renderResources;
        this.mConfig = configuration;
        this.mIWindowManager = new BridgeWindowManager(this.mConfig, displayMetrics, 0);
        this.mApplicationInfo = new ApplicationInfo();
        this.mApplicationInfo.targetSdkVersion = n;
    }

    public void initResources() {
        AssetManager assetManager = AssetManager.getSystem();
        this.mSystemResources = BridgeResources.initSystem(this, assetManager, this.mMetrics, this.mConfig, this.mProjectCallback);
        this.mTheme = this.mSystemResources.newTheme();
    }

    public void disposeResources() {
        BridgeResources.disposeSystem();
    }

    public void setBridgeInflater(BridgeInflater bridgeInflater) {
        this.mBridgeInflater = bridgeInflater;
    }

    public void addViewKey(View view, Object object) {
        this.mViewKeyMap.put(view, object);
    }

    public Object getViewKey(View view) {
        return this.mViewKeyMap.get(view);
    }

    public Object getProjectKey() {
        return this.mProjectKey;
    }

    public DisplayMetrics getMetrics() {
        return this.mMetrics;
    }

    public IProjectCallback getProjectCallback() {
        return this.mProjectCallback;
    }

    public RenderResources getRenderResources() {
        return this.mRenderResources;
    }

    public BridgeWindowManager getIWindowManager() {
        return this.mIWindowManager;
    }

    public Map<String, String> getDefaultPropMap(Object object) {
        return this.mDefaultPropMaps.get(object);
    }

    public void pushParser(BridgeXmlBlockParser bridgeXmlBlockParser) {
        this.mParserStack.push(bridgeXmlBlockParser);
    }

    public void popParser() {
        BridgeXmlBlockParser bridgeXmlBlockParser = this.mParserStack.pop();
    }

    public BridgeXmlBlockParser getCurrentParser() {
        return this.mParserStack.peek();
    }

    public BridgeXmlBlockParser getPreviousParser() {
        if (this.mParserStack.size() < 2) {
            return null;
        }
        return (BridgeXmlBlockParser)this.mParserStack.get(this.mParserStack.size() - 2);
    }

    public boolean resolveThemeAttribute(int n, TypedValue typedValue, boolean bl) {
        Pair pair = Bridge.resolveResourceId(n);
        if (pair == null) {
            pair = this.mProjectCallback.resolveResourceId(n);
        }
        if (pair == null) {
            return false;
        }
        ResourceValue resourceValue = this.mRenderResources.findItemInTheme((String)pair.getSecond());
        if (bl) {
            resourceValue = this.mRenderResources.resolveResValue(resourceValue);
        }
        if (resourceValue instanceof StyleResourceValue) {
            typedValue.resourceId = this.getDynamicIdByStyle((StyleResourceValue)resourceValue);
            return true;
        }
        int n2 = resourceValue.isFramework() ? this.getFrameworkResourceValue(resourceValue.getResourceType(), resourceValue.getName(), 0) : this.getProjectResourceValue(resourceValue.getResourceType(), resourceValue.getName(), 0);
        if (n2 != 0) {
            typedValue.resourceId = n2;
            return true;
        }
        return false;
    }

    public ResourceReference resolveId(int n) {
        Pair pair = Bridge.resolveResourceId(n);
        if (pair != null) {
            return new ResourceReference((String)pair.getSecond(), true);
        }
        if (this.mProjectCallback != null && (pair = this.mProjectCallback.resolveResourceId(n)) != null) {
            return new ResourceReference((String)pair.getSecond(), false);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Pair<View, Boolean> inflateView(ResourceReference resourceReference, ViewGroup viewGroup, boolean bl, boolean bl2) {
        ResourceValue resourceValue;
        boolean bl3 = resourceReference.isFramework();
        if (!bl3 && !bl2 && (resourceValue = resourceReference instanceof ResourceValue ? this.mProjectCallback.getParser((ResourceValue)resourceReference) : this.mProjectCallback.getParser(resourceReference.getName())) != null) {
            BridgeXmlBlockParser bridgeXmlBlockParser = new BridgeXmlBlockParser((XmlPullParser)resourceValue, this, resourceReference.isFramework());
            try {
                this.pushParser(bridgeXmlBlockParser);
                Pair pair = Pair.of((Object)this.mBridgeInflater.inflate(bridgeXmlBlockParser, viewGroup, bl), (Object)true);
                return pair;
            }
            finally {
                this.popParser();
            }
        }
        resourceValue = resourceReference instanceof ResourceValue ? (ResourceValue)resourceReference : (bl3 ? this.mRenderResources.getFrameworkResource(ResourceType.LAYOUT, resourceReference.getName()) : this.mRenderResources.getProjectResource(ResourceType.LAYOUT, resourceReference.getName()));
        if (resourceValue != null) {
            File file = new File(resourceValue.getValue());
            if (file.isFile()) {
                XmlPullParser xmlPullParser = ParserFactory.create(file);
                this.mBridgeInflater.setResourceReference(resourceReference);
                BridgeXmlBlockParser bridgeXmlBlockParser = new BridgeXmlBlockParser(xmlPullParser, this, resourceReference.isFramework());
                try {
                    this.pushParser(bridgeXmlBlockParser);
                    Pair pair = Pair.of((Object)this.mBridgeInflater.inflate(bridgeXmlBlockParser, viewGroup, bl), (Object)false);
                    this.popParser();
                    this.mBridgeInflater.setResourceReference(null);
                    return pair;
                }
                catch (Throwable throwable) {
                    try {
                        this.popParser();
                        throw throwable;
                    }
                    catch (XmlPullParserException xmlPullParserException) {
                        Bridge.getLog().error("broken", "Failed to configure parser for " + file, (Throwable)xmlPullParserException, null);
                        this.mBridgeInflater.setResourceReference(null);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        this.mBridgeInflater.setResourceReference(null);
                        catch (Throwable throwable2) {
                            this.mBridgeInflater.setResourceReference(null);
                            throw throwable2;
                        }
                    }
                }
            } else {
                Bridge.getLog().error("broken", String.format("File %s is missing!", file), null);
            }
        } else {
            Bridge.getLog().error("broken", String.format("Layout %s%s does not exist.", bl3 ? "android:" : "", resourceReference.getName()), null);
        }
        return Pair.of(null, (Object)false);
    }

    @Override
    public Resources getResources() {
        return this.mSystemResources;
    }

    @Override
    public Resources.Theme getTheme() {
        return this.mTheme;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    @Override
    public Object getSystemService(String string2) {
        if ("layout_inflater".equals(string2)) {
            return this.mBridgeInflater;
        }
        if ("textservices".equals(string2)) {
            return TextServicesManager.getInstance();
        }
        if ("window".equals(string2)) {
            return null;
        }
        if ("input_method".equals(string2)) {
            return null;
        }
        throw new UnsupportedOperationException("Unsupported Service: " + string2);
    }

    @Override
    public final TypedArray obtainStyledAttributes(int[] nArray) {
        return this.createStyleBasedTypedArray(this.mRenderResources.getCurrentTheme(), nArray);
    }

    @Override
    public final TypedArray obtainStyledAttributes(int n, int[] nArray) throws Resources.NotFoundException {
        TypedArray typedArray;
        StyleResourceValue styleResourceValue = this.getStyleByDynamicId(n);
        if (styleResourceValue == null) {
            throw new Resources.NotFoundException();
        }
        if (this.mTypedArrayCache == null) {
            this.mTypedArrayCache = new HashMap<int[], Map<Integer, TypedArray>>();
            HashMap<Integer, BridgeTypedArray> hashMap = new HashMap<Integer, BridgeTypedArray>();
            this.mTypedArrayCache.put(nArray, hashMap);
            BridgeTypedArray bridgeTypedArray = this.createStyleBasedTypedArray(styleResourceValue, nArray);
            hashMap.put(n, bridgeTypedArray);
            return bridgeTypedArray;
        }
        Map<Integer, TypedArray> map = this.mTypedArrayCache.get(nArray);
        if (map == null) {
            map = new HashMap<Integer, TypedArray>();
            this.mTypedArrayCache.put(nArray, map);
        }
        if ((typedArray = map.get(n)) == null) {
            typedArray = this.createStyleBasedTypedArray(styleResourceValue, nArray);
            map.put(n, typedArray);
        }
        return typedArray;
    }

    @Override
    public final TypedArray obtainStyledAttributes(AttributeSet attributeSet, int[] nArray) {
        return this.obtainStyledAttributes(attributeSet, nArray, 0, 0);
    }

    @Override
    public TypedArray obtainStyledAttributes(AttributeSet attributeSet, int[] nArray, int n, int n2) {
        ResourceValue resourceValue;
        Object object;
        ResourceValue resourceValue2;
        AtomicReference<String> atomicReference;
        Object object2;
        Map<String, String> map = null;
        boolean bl = true;
        if (attributeSet instanceof BridgeXmlBlockParser) {
            object2 = null;
            object2 = (BridgeXmlBlockParser)attributeSet;
            bl = ((BridgeXmlBlockParser)object2).isPlatformFile();
            atomicReference = ((BridgeXmlBlockParser)object2).getViewCookie();
            if (atomicReference != null && (map = this.mDefaultPropMaps.get(atomicReference)) == null) {
                map = new HashMap<String, String>();
                this.mDefaultPropMaps.put(atomicReference, map);
            }
        } else if (attributeSet instanceof BridgeLayoutParamsMapAttributes) {
            bl = false;
        } else if (attributeSet != null) {
            Bridge.getLog().error("broken", "Parser is not a BridgeXmlBlockParser!", null);
            return null;
        }
        object2 = new AtomicBoolean();
        atomicReference = new AtomicReference<String>();
        TreeMap<Integer, String> treeMap = this.searchAttrs(nArray, (AtomicBoolean)object2, atomicReference);
        BridgeTypedArray bridgeTypedArray = ((BridgeResources)this.mSystemResources).newTypeArray(nArray.length, bl, ((AtomicBoolean)object2).get(), atomicReference.get());
        String string2 = null;
        if (attributeSet != null) {
            string2 = attributeSet.getAttributeValue(null, "style");
        }
        StyleResourceValue styleResourceValue = null;
        if (string2 != null) {
            resourceValue2 = this.mRenderResources.findResValue(string2, false);
            if ((resourceValue2 = this.mRenderResources.resolveResValue(resourceValue2)) instanceof StyleResourceValue) {
                styleResourceValue = (StyleResourceValue)resourceValue2;
            }
        }
        resourceValue2 = null;
        if (n != 0) {
            object = this.searchAttr(n);
            if (map != null) {
                map.put("style", (String)object);
            }
            if ((resourceValue = this.mRenderResources.findItemInTheme(object)) != null) {
                if ((resourceValue = this.mRenderResources.findResValue(resourceValue.getValue(), false)) instanceof StyleResourceValue) {
                    resourceValue2 = (StyleResourceValue)resourceValue;
                }
            } else {
                Bridge.getLog().error(null, String.format("Failed to find style '%s' in current theme", object), null);
            }
        } else if (n2 != 0) {
            object = Bridge.resolveResourceId(n2);
            if (object == null) {
                object = this.mProjectCallback.resolveResourceId(n2);
            }
            if (object != null) {
                if (object.getFirst() == ResourceType.STYLE) {
                    resourceValue = this.mRenderResources.findItemInTheme((String)object.getSecond());
                    if (resourceValue != null) {
                        if (resourceValue instanceof StyleResourceValue) {
                            if (map != null) {
                                map.put("style", resourceValue.getName());
                            }
                            resourceValue2 = (StyleResourceValue)resourceValue;
                        }
                    } else {
                        Bridge.getLog().error(null, String.format("Style with id 0x%x (resolved to '%s') does not exist.", n2, object.getSecond()), null);
                    }
                } else {
                    Bridge.getLog().error(null, String.format("Resouce id 0x%x is not of type STYLE (instead %s)", n2, ((ResourceType)object.getFirst()).toString()), null);
                }
            } else {
                Bridge.getLog().error(null, String.format("Failed to find style with id 0x%x in current theme", n2), null);
            }
        }
        object = "http://schemas.android.com/apk/res/android";
        boolean bl2 = ((AtomicBoolean)object2).get();
        if (!bl2) {
            object = this.mProjectCallback.getNamespace();
        }
        if (treeMap != null) {
            for (Map.Entry<Integer, String> entry : treeMap.entrySet()) {
                int n3 = entry.getKey();
                String string3 = entry.getValue();
                String string4 = null;
                if (attributeSet != null) {
                    string4 = attributeSet.getAttributeValue((String)object, string3);
                    if (!bl2 && string4 == null) {
                        string4 = attributeSet.getAttributeValue("http://schemas.android.com/apk/res-auto", string3);
                    }
                }
                if (string4 == null) {
                    ResourceValue resourceValue3 = null;
                    if (styleResourceValue != null) {
                        resourceValue3 = this.mRenderResources.findItemInStyle(styleResourceValue, string3);
                    }
                    if (resourceValue3 == null && resourceValue2 != null) {
                        resourceValue3 = this.mRenderResources.findItemInStyle((StyleResourceValue)resourceValue2, string3);
                    }
                    if (resourceValue3 == null) {
                        resourceValue3 = this.mRenderResources.findItemInTheme(string3);
                    }
                    if (resourceValue3 != null) {
                        if (map != null) {
                            map.put(string3, resourceValue3.getValue());
                        }
                        resourceValue3 = this.mRenderResources.resolveResValue(resourceValue3);
                    }
                    bridgeTypedArray.bridgeSetValue(n3, string3, resourceValue3);
                    continue;
                }
                bridgeTypedArray.bridgeSetValue(n3, string3, this.mRenderResources.resolveValue(null, string3, string4, bl));
            }
        }
        bridgeTypedArray.sealArray();
        return bridgeTypedArray;
    }

    @Override
    public Looper getMainLooper() {
        return Looper.myLooper();
    }

    private BridgeTypedArray createStyleBasedTypedArray(StyleResourceValue styleResourceValue, int[] nArray) throws Resources.NotFoundException {
        BridgeTypedArray bridgeTypedArray = ((BridgeResources)this.mSystemResources).newTypeArray(nArray.length, false, true, null);
        for (int i = 0; i < nArray.length; ++i) {
            String string2;
            ResourceValue resourceValue;
            Pair<ResourceType, String> pair = Bridge.resolveResourceId(nArray[i]);
            if (pair == null || (resourceValue = this.mRenderResources.findItemInStyle(styleResourceValue, string2 = (String)pair.getSecond())) == null) continue;
            bridgeTypedArray.bridgeSetValue(i, string2, this.mRenderResources.resolveResValue(resourceValue));
            resourceValue = this.mRenderResources.resolveResValue(resourceValue);
        }
        bridgeTypedArray.sealArray();
        return bridgeTypedArray;
    }

    private TreeMap<Integer, String> searchAttrs(int[] nArray, AtomicBoolean atomicBoolean, AtomicReference<String> atomicReference) {
        String string2 = Bridge.resolveResourceId(nArray);
        if (string2 != null) {
            TreeMap<Integer, String> treeMap = new TreeMap<Integer, String>();
            for (int i = 0; i < nArray.length; ++i) {
                Pair<ResourceType, String> pair = Bridge.resolveResourceId(nArray[i]);
                if (pair != null) {
                    treeMap.put(i, (String)pair.getSecond());
                    continue;
                }
                treeMap.put(i, null);
            }
            if (atomicBoolean != null) {
                atomicBoolean.set(true);
            }
            if (atomicReference != null) {
                atomicReference.set(string2);
            }
            return treeMap;
        }
        string2 = this.mProjectCallback.resolveResourceId(nArray);
        if (string2 != null) {
            TreeMap<Integer, String> treeMap = new TreeMap<Integer, String>();
            for (int i = 0; i < nArray.length; ++i) {
                Pair pair = this.mProjectCallback.resolveResourceId(nArray[i]);
                if (pair != null) {
                    treeMap.put(i, (String)pair.getSecond());
                    continue;
                }
                treeMap.put(i, null);
            }
            if (atomicBoolean != null) {
                atomicBoolean.set(false);
            }
            if (atomicReference != null) {
                atomicReference.set(string2);
            }
            return treeMap;
        }
        return null;
    }

    public String searchAttr(int n) {
        Pair pair = Bridge.resolveResourceId(n);
        if (pair != null) {
            return (String)pair.getSecond();
        }
        pair = this.mProjectCallback.resolveResourceId(n);
        if (pair != null) {
            return (String)pair.getSecond();
        }
        return null;
    }

    public int getDynamicIdByStyle(StyleResourceValue styleResourceValue) {
        Integer n;
        if (this.mDynamicIdToStyleMap == null) {
            this.mDynamicIdToStyleMap = new HashMap<Integer, StyleResourceValue>();
            this.mStyleToDynamicIdMap = new HashMap<StyleResourceValue, Integer>();
        }
        if ((n = this.mStyleToDynamicIdMap.get(styleResourceValue)) == null) {
            n = ++this.mDynamicIdGenerator;
            this.mDynamicIdToStyleMap.put(n, styleResourceValue);
            this.mStyleToDynamicIdMap.put(styleResourceValue, n);
        }
        return n;
    }

    private StyleResourceValue getStyleByDynamicId(int n) {
        if (this.mDynamicIdToStyleMap != null) {
            return this.mDynamicIdToStyleMap.get(n);
        }
        return null;
    }

    public int getFrameworkResourceValue(ResourceType resourceType, String string2, int n) {
        Integer n2 = Bridge.getResourceId(resourceType, string2);
        if (n2 != null) {
            return n2;
        }
        return n;
    }

    public int getProjectResourceValue(ResourceType resourceType, String string2, int n) {
        Integer n2;
        if (this.mProjectCallback != null && (n2 = this.mProjectCallback.getResourceId(resourceType, string2)) != null) {
            return n2;
        }
        return n;
    }

    @Override
    public boolean bindService(Intent intent, ServiceConnection serviceConnection, int n) {
        return false;
    }

    @Override
    public int checkCallingOrSelfPermission(String string2) {
        return 0;
    }

    @Override
    public int checkCallingOrSelfUriPermission(Uri uri, int n) {
        return 0;
    }

    @Override
    public int checkCallingPermission(String string2) {
        return 0;
    }

    @Override
    public int checkCallingUriPermission(Uri uri, int n) {
        return 0;
    }

    @Override
    public int checkPermission(String string2, int n, int n2) {
        return 0;
    }

    @Override
    public int checkUriPermission(Uri uri, int n, int n2, int n3) {
        return 0;
    }

    @Override
    public int checkUriPermission(Uri uri, String string2, String string3, int n, int n2, int n3) {
        return 0;
    }

    @Override
    public void clearWallpaper() {
    }

    @Override
    public Context createPackageContext(String string2, int n) {
        return null;
    }

    @Override
    public String[] databaseList() {
        return null;
    }

    @Override
    public boolean deleteDatabase(String string2) {
        return false;
    }

    @Override
    public boolean deleteFile(String string2) {
        return false;
    }

    @Override
    public void enforceCallingOrSelfPermission(String string2, String string3) {
    }

    @Override
    public void enforceCallingOrSelfUriPermission(Uri uri, int n, String string2) {
    }

    @Override
    public void enforceCallingPermission(String string2, String string3) {
    }

    @Override
    public void enforceCallingUriPermission(Uri uri, int n, String string2) {
    }

    @Override
    public void enforcePermission(String string2, int n, int n2, String string3) {
    }

    @Override
    public void enforceUriPermission(Uri uri, int n, int n2, int n3, String string2) {
    }

    @Override
    public void enforceUriPermission(Uri uri, String string2, String string3, int n, int n2, int n3, String string4) {
    }

    @Override
    public String[] fileList() {
        return null;
    }

    @Override
    public AssetManager getAssets() {
        return null;
    }

    @Override
    public File getCacheDir() {
        return null;
    }

    @Override
    public File getExternalCacheDir() {
        return null;
    }

    @Override
    public ContentResolver getContentResolver() {
        if (this.mContentResolver == null) {
            this.mContentResolver = new BridgeContentResolver(this);
        }
        return this.mContentResolver;
    }

    @Override
    public File getDatabasePath(String string2) {
        return null;
    }

    @Override
    public File getDir(String string2, int n) {
        return null;
    }

    @Override
    public File getFileStreamPath(String string2) {
        return null;
    }

    @Override
    public File getFilesDir() {
        return null;
    }

    @Override
    public File getExternalFilesDir(String string2) {
        return null;
    }

    @Override
    public String getPackageCodePath() {
        return null;
    }

    @Override
    public PackageManager getPackageManager() {
        return null;
    }

    @Override
    public String getPackageName() {
        return null;
    }

    @Override
    public ApplicationInfo getApplicationInfo() {
        return this.mApplicationInfo;
    }

    @Override
    public String getPackageResourcePath() {
        return null;
    }

    @Override
    public File getSharedPrefsFile(String string2) {
        return null;
    }

    @Override
    public SharedPreferences getSharedPreferences(String string2, int n) {
        return null;
    }

    @Override
    public Drawable getWallpaper() {
        return null;
    }

    @Override
    public int getWallpaperDesiredMinimumWidth() {
        return -1;
    }

    @Override
    public int getWallpaperDesiredMinimumHeight() {
        return -1;
    }

    @Override
    public void grantUriPermission(String string2, Uri uri, int n) {
    }

    @Override
    public FileInputStream openFileInput(String string2) throws FileNotFoundException {
        return null;
    }

    @Override
    public FileOutputStream openFileOutput(String string2, int n) throws FileNotFoundException {
        return null;
    }

    @Override
    public SQLiteDatabase openOrCreateDatabase(String string2, int n, SQLiteDatabase.CursorFactory cursorFactory) {
        return null;
    }

    @Override
    public SQLiteDatabase openOrCreateDatabase(String string2, int n, SQLiteDatabase.CursorFactory cursorFactory, DatabaseErrorHandler databaseErrorHandler) {
        return null;
    }

    @Override
    public Drawable peekWallpaper() {
        return null;
    }

    @Override
    public Intent registerReceiver(BroadcastReceiver broadcastReceiver, IntentFilter intentFilter) {
        return null;
    }

    @Override
    public Intent registerReceiver(BroadcastReceiver broadcastReceiver, IntentFilter intentFilter, String string2, Handler handler) {
        return null;
    }

    @Override
    public void removeStickyBroadcast(Intent intent) {
    }

    @Override
    public void revokeUriPermission(Uri uri, int n) {
    }

    @Override
    public void sendBroadcast(Intent intent) {
    }

    @Override
    public void sendBroadcast(Intent intent, String string2) {
    }

    @Override
    public void sendOrderedBroadcast(Intent intent, String string2) {
    }

    @Override
    public void sendOrderedBroadcast(Intent intent, String string2, BroadcastReceiver broadcastReceiver, Handler handler, int n, String string3, Bundle bundle) {
    }

    @Override
    public void sendStickyBroadcast(Intent intent) {
    }

    @Override
    public void sendStickyOrderedBroadcast(Intent intent, BroadcastReceiver broadcastReceiver, Handler handler, int n, String string2, Bundle bundle) {
    }

    @Override
    public void setTheme(int n) {
    }

    @Override
    public void setWallpaper(Bitmap bitmap) throws IOException {
    }

    @Override
    public void setWallpaper(InputStream inputStream) throws IOException {
    }

    @Override
    public void startActivity(Intent intent) {
    }

    @Override
    public void startIntentSender(IntentSender intentSender, Intent intent, int n, int n2, int n3) throws IntentSender.SendIntentException {
    }

    @Override
    public boolean startInstrumentation(ComponentName componentName, String string2, Bundle bundle) {
        return false;
    }

    @Override
    public ComponentName startService(Intent intent) {
        return null;
    }

    @Override
    public boolean stopService(Intent intent) {
        return false;
    }

    @Override
    public void unbindService(ServiceConnection serviceConnection) {
    }

    @Override
    public void unregisterReceiver(BroadcastReceiver broadcastReceiver) {
    }

    @Override
    public Context getApplicationContext() {
        return this;
    }

    @Override
    public void startActivities(Intent[] intentArray) {
    }

    @Override
    public boolean isRestricted() {
        return false;
    }

    @Override
    public File getObbDir() {
        Bridge.getLog().error("unsupported", "OBB not supported", null);
        return null;
    }
}

