/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.x509;

import java.io.IOException;
import java.math.BigInteger;
import org.apache.harmony.security.asn1.ASN1Boolean;
import org.apache.harmony.security.asn1.ASN1Integer;
import org.apache.harmony.security.asn1.ASN1Sequence;
import org.apache.harmony.security.asn1.ASN1Type;
import org.apache.harmony.security.asn1.BerInputStream;
import org.apache.harmony.security.x509.ExtensionValue;

public class BasicConstraints
extends ExtensionValue {
    private boolean ca = false;
    private int pathLenConstraint = Integer.MAX_VALUE;
    public static final ASN1Type ASN1 = new ASN1Sequence(new ASN1Type[]{ASN1Boolean.getInstance(), ASN1Integer.getInstance()}){
        {
            this.setDefault(Boolean.FALSE, 0);
            this.setOptional(1);
        }

        public Object getDecodedObject(BerInputStream in) throws IOException {
            return in.content;
        }

        protected void getValues(Object object, Object[] values) {
            Object[] array2 = (Object[])object;
            values[0] = array2[0];
            values[1] = ((BigInteger)array2[1]).toByteArray();
        }
    };

    public BasicConstraints(byte[] encoding) throws IOException {
        super(encoding);
        Object[] values = (Object[])ASN1.decode(encoding);
        this.ca = (Boolean)values[0];
        if (values[1] != null) {
            this.pathLenConstraint = new BigInteger((byte[])values[1]).intValue();
        }
    }

    public int getPathLenConstraint() {
        return this.pathLenConstraint;
    }

    public byte[] getEncoded() {
        if (this.encoding == null) {
            this.encoding = ASN1.encode(new Object[]{this.ca, BigInteger.valueOf(this.pathLenConstraint)});
        }
        return this.encoding;
    }

    public void dumpValue(StringBuilder sb, String prefix) {
        sb.append(prefix).append("BasicConstraints [\n").append(prefix).append("  CA: ").append(this.ca).append("\n  ").append(prefix).append("pathLenConstraint: ").append(this.pathLenConstraint).append('\n').append(prefix).append("]\n");
    }
}

