/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.util.Log;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskStackBuilder {
    private static final String TAG = "TaskStackBuilder";
    private final ArrayList<Intent> mIntents = new ArrayList();
    private final Context mSourceContext;

    private TaskStackBuilder(Context a) {
        this.mSourceContext = a;
    }

    public static TaskStackBuilder create(Context context) {
        return new TaskStackBuilder(context);
    }

    public TaskStackBuilder addNextIntent(Intent nextIntent) {
        this.mIntents.add(nextIntent);
        return this;
    }

    public TaskStackBuilder addNextIntentWithParentStack(Intent nextIntent) {
        ComponentName target = nextIntent.getComponent();
        if (target == null) {
            target = nextIntent.resolveActivity(this.mSourceContext.getPackageManager());
        }
        if (target != null) {
            this.addParentStack(target);
        }
        this.addNextIntent(nextIntent);
        return this;
    }

    public TaskStackBuilder addParentStack(Activity sourceActivity) {
        int insertAt = this.mIntents.size();
        Intent parent = sourceActivity.getParentActivityIntent();
        PackageManager pm = sourceActivity.getPackageManager();
        while (parent != null) {
            this.mIntents.add(insertAt, parent);
            try {
                ActivityInfo info = pm.getActivityInfo(parent.getComponent(), 0);
                String parentActivity = info.parentActivityName;
                if (parentActivity != null) {
                    parent = new Intent().setComponent(new ComponentName(this.mSourceContext, parentActivity));
                    continue;
                }
                parent = null;
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.e(TAG, "Bad ComponentName while traversing activity parent metadata");
                throw new IllegalArgumentException(e);
            }
        }
        return this;
    }

    public TaskStackBuilder addParentStack(Class<?> sourceActivityClass) {
        int insertAt = this.mIntents.size();
        PackageManager pm = this.mSourceContext.getPackageManager();
        try {
            ActivityInfo info = pm.getActivityInfo(new ComponentName(this.mSourceContext, sourceActivityClass), 0);
            String parentActivity = info.parentActivityName;
            while (parentActivity != null) {
                Intent parent = new Intent().setComponent(new ComponentName(this.mSourceContext, parentActivity));
                this.mIntents.add(insertAt, parent);
                info = pm.getActivityInfo(parent.getComponent(), 0);
                parentActivity = info.parentActivityName;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e(TAG, "Bad ComponentName while traversing activity parent metadata");
            throw new IllegalArgumentException(e);
        }
        return this;
    }

    public TaskStackBuilder addParentStack(ComponentName sourceActivityName) {
        int insertAt = this.mIntents.size();
        PackageManager pm = this.mSourceContext.getPackageManager();
        try {
            ActivityInfo info = pm.getActivityInfo(sourceActivityName, 0);
            String parentActivity = info.parentActivityName;
            while (parentActivity != null) {
                Intent parent = new Intent().setComponent(new ComponentName(info.packageName, parentActivity));
                this.mIntents.add(insertAt, parent);
                info = pm.getActivityInfo(parent.getComponent(), 0);
                parentActivity = info.parentActivityName;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e(TAG, "Bad ComponentName while traversing activity parent metadata");
            throw new IllegalArgumentException(e);
        }
        return this;
    }

    public int getIntentCount() {
        return this.mIntents.size();
    }

    public Intent editIntentAt(int index) {
        return this.mIntents.get(index);
    }

    public void startActivities() {
        this.startActivities(null);
    }

    public void startActivities(Bundle options) {
        if (this.mIntents.isEmpty()) {
            throw new IllegalStateException("No intents added to TaskStackBuilder; cannot startActivities");
        }
        Intent[] intents = this.mIntents.toArray(new Intent[this.mIntents.size()]);
        intents[0].addFlags(0x1000C000);
        this.mSourceContext.startActivities(intents, options);
    }

    public PendingIntent getPendingIntent(int requestCode, int flags) {
        return this.getPendingIntent(requestCode, flags, null);
    }

    public PendingIntent getPendingIntent(int requestCode, int flags, Bundle options) {
        if (this.mIntents.isEmpty()) {
            throw new IllegalStateException("No intents added to TaskStackBuilder; cannot getPendingIntent");
        }
        Intent[] intents = this.mIntents.toArray(new Intent[this.mIntents.size()]);
        intents[0].addFlags(0x1000C000);
        return PendingIntent.getActivities(this.mSourceContext, requestCode, intents, flags, options);
    }

    public Intent[] getIntents() {
        return this.mIntents.toArray(new Intent[this.mIntents.size()]);
    }
}

