/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Bitmap;
import android.graphics.Bitmap_Delegate;
import android.graphics.Canvas;
import android.graphics.DrawFilter_Delegate;
import android.graphics.Matrix_Delegate;
import android.graphics.Paint;
import android.graphics.Paint_Delegate;
import android.graphics.Path_Delegate;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode_Delegate;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.Region_Delegate;
import android.graphics.TemporaryBuffer;
import android.graphics.Xfermode_Delegate;
import android.text.TextUtils;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.impl.DelegateManager;
import com.android.layoutlib.bridge.impl.GcSnapshot;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.image.BufferedImage;
import java.util.List;

public final class Canvas_Delegate {
    private static final DelegateManager<Canvas_Delegate> sManager = new DelegateManager<Canvas_Delegate>(Canvas_Delegate.class);
    private static final boolean[] sBoolOut = new boolean[1];
    private Bitmap_Delegate mBitmap;
    private GcSnapshot mSnapshot;
    private DrawFilter_Delegate mDrawFilter = null;

    public static Canvas_Delegate getDelegate(Canvas canvas) {
        return sManager.getDelegate(canvas.mNativeCanvas);
    }

    public static Canvas_Delegate getDelegate(int n) {
        return sManager.getDelegate(n);
    }

    public GcSnapshot getSnapshot() {
        return this.mSnapshot;
    }

    public DrawFilter_Delegate getDrawFilter() {
        return this.mDrawFilter;
    }

    @LayoutlibDelegate
    static boolean isOpaque(Canvas canvas) {
        Canvas_Delegate canvas_Delegate = sManager.getDelegate(canvas.mNativeCanvas);
        if (canvas_Delegate == null) {
            return false;
        }
        return canvas_Delegate.mBitmap.getConfig() == Bitmap.Config.RGB_565;
    }

    @LayoutlibDelegate
    static int getWidth(Canvas canvas) {
        Canvas_Delegate canvas_Delegate = sManager.getDelegate(canvas.mNativeCanvas);
        if (canvas_Delegate == null) {
            return 0;
        }
        return canvas_Delegate.mBitmap.getImage().getWidth();
    }

    @LayoutlibDelegate
    static int getHeight(Canvas canvas) {
        Canvas_Delegate canvas_Delegate = sManager.getDelegate(canvas.mNativeCanvas);
        if (canvas_Delegate == null) {
            return 0;
        }
        return canvas_Delegate.mBitmap.getImage().getHeight();
    }

    @LayoutlibDelegate
    static void translate(Canvas canvas, float f, float f2) {
        Canvas_Delegate canvas_Delegate = sManager.getDelegate(canvas.mNativeCanvas);
        if (canvas_Delegate == null) {
            return;
        }
        canvas_Delegate.getSnapshot().translate(f, f2);
    }

    @LayoutlibDelegate
    static void rotate(Canvas canvas, float f) {
        Canvas_Delegate canvas_Delegate = sManager.getDelegate(canvas.mNativeCanvas);
        if (canvas_Delegate == null) {
            return;
        }
        canvas_Delegate.getSnapshot().rotate(Math.toRadians(f));
    }

    @LayoutlibDelegate
    static void scale(Canvas canvas, float f, float f2) {
        Canvas_Delegate canvas_Delegate = sManager.getDelegate(canvas.mNativeCanvas);
        if (canvas_Delegate == null) {
            return;
        }
        canvas_Delegate.getSnapshot().scale(f, f2);
    }

    @LayoutlibDelegate
    static void skew(Canvas canvas, float f, float f2) {
        Canvas_Delegate canvas_Delegate = sManager.getDelegate(canvas.mNativeCanvas);
        if (canvas_Delegate == null) {
            return;
        }
        GcSnapshot gcSnapshot = canvas_Delegate.getSnapshot();
        AffineTransform affineTransform = gcSnapshot.getTransform();
        float[] fArray = Matrix_Delegate.getSkew(f, f2);
        AffineTransform affineTransform2 = Matrix_Delegate.getAffineTransform(fArray);
        affineTransform.preConcatenate(affineTransform2);
        gcSnapshot.setTransform(affineTransform);
    }

    @LayoutlibDelegate
    static boolean clipRect(Canvas canvas, RectF rectF) {
        return Canvas_Delegate.clipRect(canvas, rectF.left, rectF.top, rectF.right, rectF.bottom);
    }

    @LayoutlibDelegate
    static boolean clipRect(Canvas canvas, Rect rect) {
        return Canvas_Delegate.clipRect(canvas, (float)rect.left, (float)rect.top, (float)rect.right, (float)rect.bottom);
    }

    @LayoutlibDelegate
    static boolean clipRect(Canvas canvas, float f, float f2, float f3, float f4) {
        Canvas_Delegate canvas_Delegate = sManager.getDelegate(canvas.mNativeCanvas);
        if (canvas_Delegate == null) {
            return false;
        }
        return canvas_Delegate.clipRect(f, f2, f3, f4, Region.Op.INTERSECT.nativeInt);
    }

    @LayoutlibDelegate
    static boolean clipRect(Canvas canvas, int n, int n2, int n3, int n4) {
        return Canvas_Delegate.clipRect(canvas, (float)n, (float)n2, (float)n3, (float)n4);
    }

    @LayoutlibDelegate
    static int save(Canvas canvas) {
        return Canvas_Delegate.save(canvas, 3);
    }

    @LayoutlibDelegate
    static int save(Canvas canvas, int n) {
        Canvas_Delegate canvas_Delegate = sManager.getDelegate(canvas.mNativeCanvas);
        if (canvas_Delegate == null) {
            return 0;
        }
        return canvas_Delegate.save(n);
    }

    @LayoutlibDelegate
    static void restore(Canvas canvas) {
        Canvas_Delegate canvas_Delegate = sManager.getDelegate(canvas.mNativeCanvas);
        if (canvas_Delegate == null) {
            return;
        }
        canvas_Delegate.restore();
    }

    @LayoutlibDelegate
    static int getSaveCount(Canvas canvas) {
        Canvas_Delegate canvas_Delegate = sManager.getDelegate(canvas.mNativeCanvas);
        if (canvas_Delegate == null) {
            return 0;
        }
        return canvas_Delegate.getSnapshot().size();
    }

    @LayoutlibDelegate
    static void restoreToCount(Canvas canvas, int n) {
        Canvas_Delegate canvas_Delegate = sManager.getDelegate(canvas.mNativeCanvas);
        if (canvas_Delegate == null) {
            return;
        }
        canvas_Delegate.restoreTo(n);
    }

    @LayoutlibDelegate
    static void drawPoints(Canvas canvas, float[] fArray, int n, int n2, Paint paint) {
        Bridge.getLog().fidelityWarning("unsupported", "Canvas.drawPoint is not supported.", null, null);
    }

    @LayoutlibDelegate
    static void drawPoint(Canvas canvas, float f, float f2, Paint paint) {
        Bridge.getLog().fidelityWarning("unsupported", "Canvas.drawPoint is not supported.", null, null);
    }

    @LayoutlibDelegate
    static void drawLines(Canvas canvas, final float[] fArray, final int n, final int n2, Paint paint) {
        Canvas_Delegate.draw(canvas.mNativeCanvas, paint.mNativePaint, false, false, new GcSnapshot.Drawable(){

            public void draw(Graphics2D graphics2D, Paint_Delegate paint_Delegate) {
                for (int i = 0; i < n2; i += 4) {
                    graphics2D.drawLine((int)fArray[i + n], (int)fArray[i + n + 1], (int)fArray[i + n + 2], (int)fArray[i + n + 3]);
                }
            }
        });
    }

    @LayoutlibDelegate
    static void freeCaches() {
    }

    @LayoutlibDelegate
    static void freeTextLayoutCaches() {
    }

    @LayoutlibDelegate
    static int initRaster(int n) {
        if (n > 0) {
            Bitmap_Delegate bitmap_Delegate = Bitmap_Delegate.getDelegate(n);
            Canvas_Delegate canvas_Delegate = new Canvas_Delegate(bitmap_Delegate);
            return sManager.addNewDelegate(canvas_Delegate);
        }
        Canvas_Delegate canvas_Delegate = new Canvas_Delegate();
        return sManager.addNewDelegate(canvas_Delegate);
    }

    @LayoutlibDelegate
    static void native_setBitmap(int n, int n2) {
        Canvas_Delegate canvas_Delegate = sManager.getDelegate(n);
        if (canvas_Delegate == null) {
            return;
        }
        Bitmap_Delegate bitmap_Delegate = Bitmap_Delegate.getDelegate(n2);
        if (bitmap_Delegate == null) {
            return;
        }
        canvas_Delegate.setBitmap(bitmap_Delegate);
    }

    @LayoutlibDelegate
    static int native_saveLayer(int n, RectF rectF, int n2, int n3) {
        Canvas_Delegate canvas_Delegate = sManager.getDelegate(n);
        if (canvas_Delegate == null) {
            return 0;
        }
        Paint_Delegate paint_Delegate = Paint_Delegate.getDelegate(n2);
        if (paint_Delegate == null) {
            return 0;
        }
        return canvas_Delegate.saveLayer(rectF, paint_Delegate, n3);
    }

    @LayoutlibDelegate
    static int native_saveLayer(int n, float f, float f2, float f3, float f4, int n2, int n3) {
        Canvas_Delegate canvas_Delegate = sManager.getDelegate(n);
        if (canvas_Delegate == null) {
            return 0;
        }
        Paint_Delegate paint_Delegate = Paint_Delegate.getDelegate(n2);
        if (paint_Delegate == null) {
            return 0;
        }
        return canvas_Delegate.saveLayer(new RectF(f, f2, f3, f4), paint_Delegate, n3);
    }

    @LayoutlibDelegate
    static int native_saveLayerAlpha(int n, RectF rectF, int n2, int n3) {
        Canvas_Delegate canvas_Delegate = sManager.getDelegate(n);
        if (canvas_Delegate == null) {
            return 0;
        }
        return canvas_Delegate.saveLayerAlpha(rectF, n2, n3);
    }

    @LayoutlibDelegate
    static int native_saveLayerAlpha(int n, float f, float f2, float f3, float f4, int n2, int n3) {
        Canvas_Delegate canvas_Delegate = sManager.getDelegate(n);
        if (canvas_Delegate == null) {
            return 0;
        }
        return canvas_Delegate.saveLayerAlpha(new RectF(f, f2, f3, f4), n2, n3);
    }

    @LayoutlibDelegate
    static void native_concat(int n, int n2) {
        Canvas_Delegate canvas_Delegate = sManager.getDelegate(n);
        if (canvas_Delegate == null) {
            return;
        }
        Matrix_Delegate matrix_Delegate = Matrix_Delegate.getDelegate(n2);
        if (matrix_Delegate == null) {
            return;
        }
        GcSnapshot gcSnapshot = canvas_Delegate.getSnapshot();
        AffineTransform affineTransform = gcSnapshot.getTransform();
        AffineTransform affineTransform2 = matrix_Delegate.getAffineTransform();
        affineTransform.concatenate(affineTransform2);
        gcSnapshot.setTransform(affineTransform);
    }

    @LayoutlibDelegate
    static void native_setMatrix(int n, int n2) {
        Canvas_Delegate canvas_Delegate = sManager.getDelegate(n);
        if (canvas_Delegate == null) {
            return;
        }
        Matrix_Delegate matrix_Delegate = Matrix_Delegate.getDelegate(n2);
        if (matrix_Delegate == null) {
            return;
        }
        GcSnapshot gcSnapshot = canvas_Delegate.getSnapshot();
        AffineTransform affineTransform = matrix_Delegate.getAffineTransform();
        gcSnapshot.setTransform(affineTransform);
        if (matrix_Delegate.hasPerspective()) {
            assert (false);
            Bridge.getLog().fidelityWarning("matrix.affine", "android.graphics.Canvas#setMatrix(android.graphics.Matrix) only supports affine transformations.", null, null);
        }
    }

    @LayoutlibDelegate
    static boolean native_clipRect(int n, float f, float f2, float f3, float f4, int n2) {
        Canvas_Delegate canvas_Delegate = sManager.getDelegate(n);
        if (canvas_Delegate == null) {
            return false;
        }
        return canvas_Delegate.clipRect(f, f2, f3, f4, n2);
    }

    @LayoutlibDelegate
    static boolean native_clipPath(int n, int n2, int n3) {
        Canvas_Delegate canvas_Delegate = sManager.getDelegate(n);
        if (canvas_Delegate == null) {
            return true;
        }
        Path_Delegate path_Delegate = Path_Delegate.getDelegate(n2);
        if (path_Delegate == null) {
            return true;
        }
        return canvas_Delegate.mSnapshot.clip(path_Delegate.getJavaShape(), n3);
    }

    @LayoutlibDelegate
    static boolean native_clipRegion(int n, int n2, int n3) {
        Canvas_Delegate canvas_Delegate = sManager.getDelegate(n);
        if (canvas_Delegate == null) {
            return true;
        }
        Region_Delegate region_Delegate = Region_Delegate.getDelegate(n2);
        if (region_Delegate == null) {
            return true;
        }
        return canvas_Delegate.mSnapshot.clip(region_Delegate.getJavaArea(), n3);
    }

    @LayoutlibDelegate
    static void nativeSetDrawFilter(int n, int n2) {
        Canvas_Delegate canvas_Delegate = sManager.getDelegate(n);
        if (canvas_Delegate == null) {
            return;
        }
        canvas_Delegate.mDrawFilter = DrawFilter_Delegate.getDelegate(n2);
        if (canvas_Delegate.mDrawFilter != null && !canvas_Delegate.mDrawFilter.isSupported()) {
            Bridge.getLog().fidelityWarning("drawfilter", canvas_Delegate.mDrawFilter.getSupportMessage(), null, null);
        }
    }

    @LayoutlibDelegate
    static boolean native_getClipBounds(int n, Rect rect) {
        Canvas_Delegate canvas_Delegate = sManager.getDelegate(n);
        if (canvas_Delegate == null) {
            return false;
        }
        Rectangle rectangle = canvas_Delegate.getSnapshot().getClip().getBounds();
        if (rectangle != null && !rectangle.isEmpty()) {
            rect.left = rectangle.x;
            rect.top = rectangle.y;
            rect.right = rectangle.x + rectangle.width;
            rect.bottom = rectangle.y + rectangle.height;
            return true;
        }
        return false;
    }

    @LayoutlibDelegate
    static void native_getCTM(int n, int n2) {
        Canvas_Delegate canvas_Delegate = sManager.getDelegate(n);
        if (canvas_Delegate == null) {
            return;
        }
        Matrix_Delegate matrix_Delegate = Matrix_Delegate.getDelegate(n2);
        if (matrix_Delegate == null) {
            return;
        }
        AffineTransform affineTransform = canvas_Delegate.getSnapshot().getTransform();
        matrix_Delegate.set(Matrix_Delegate.makeValues(affineTransform));
    }

    @LayoutlibDelegate
    static boolean native_quickReject(int n, RectF rectF, int n2) {
        return false;
    }

    @LayoutlibDelegate
    static boolean native_quickReject(int n, int n2, int n3) {
        return false;
    }

    @LayoutlibDelegate
    static boolean native_quickReject(int n, float f, float f2, float f3, float f4, int n2) {
        return false;
    }

    @LayoutlibDelegate
    static void native_drawRGB(int n, int n2, int n3, int n4) {
        Canvas_Delegate.native_drawColor(n, 0xFF000000 | n2 << 16 | (n3 & 0xFF) << 8 | n4 & 0xFF, PorterDuff.Mode.SRC_OVER.nativeInt);
    }

    @LayoutlibDelegate
    static void native_drawARGB(int n, int n2, int n3, int n4, int n5) {
        Canvas_Delegate.native_drawColor(n, n2 << 24 | (n3 & 0xFF) << 16 | (n4 & 0xFF) << 8 | n5 & 0xFF, PorterDuff.Mode.SRC_OVER.nativeInt);
    }

    @LayoutlibDelegate
    static void native_drawColor(int n, int n2) {
        Canvas_Delegate.native_drawColor(n, n2, PorterDuff.Mode.SRC_OVER.nativeInt);
    }

    @LayoutlibDelegate
    static void native_drawColor(int n, final int n2, final int n3) {
        Canvas_Delegate canvas_Delegate = sManager.getDelegate(n);
        if (canvas_Delegate == null) {
            return;
        }
        final int n4 = canvas_Delegate.mBitmap.getImage().getWidth();
        final int n5 = canvas_Delegate.mBitmap.getImage().getHeight();
        Canvas_Delegate.draw(n, new GcSnapshot.Drawable(){

            public void draw(Graphics2D graphics2D, Paint_Delegate paint_Delegate) {
                graphics2D.setTransform(new AffineTransform());
                graphics2D.setColor(new Color(n2, true));
                Composite composite = PorterDuffXfermode_Delegate.getComposite(PorterDuffXfermode_Delegate.getPorterDuffMode(n3), 255);
                if (composite != null) {
                    graphics2D.setComposite(composite);
                }
                graphics2D.fillRect(0, 0, n4, n5);
            }
        });
    }

    @LayoutlibDelegate
    static void native_drawPaint(int n, int n2) {
        Bridge.getLog().fidelityWarning("unsupported", "Canvas.drawPaint is not supported.", null, null);
    }

    @LayoutlibDelegate
    static void native_drawLine(int n, final float f, final float f2, final float f3, final float f4, int n2) {
        Canvas_Delegate.draw(n, n2, false, false, new GcSnapshot.Drawable(){

            public void draw(Graphics2D graphics2D, Paint_Delegate paint_Delegate) {
                graphics2D.drawLine((int)f, (int)f2, (int)f3, (int)f4);
            }
        });
    }

    @LayoutlibDelegate
    static void native_drawRect(int n, RectF rectF, int n2) {
        Canvas_Delegate.native_drawRect(n, rectF.left, rectF.top, rectF.right, rectF.bottom, n2);
    }

    @LayoutlibDelegate
    static void native_drawRect(int n, final float f, final float f2, final float f3, final float f4, int n2) {
        Canvas_Delegate.draw(n, n2, false, false, new GcSnapshot.Drawable(){

            public void draw(Graphics2D graphics2D, Paint_Delegate paint_Delegate) {
                int n = paint_Delegate.getStyle();
                if (n == Paint.Style.FILL.nativeInt || n == Paint.Style.FILL_AND_STROKE.nativeInt) {
                    graphics2D.fillRect((int)f, (int)f2, (int)(f3 - f), (int)(f4 - f2));
                }
                if (n == Paint.Style.STROKE.nativeInt || n == Paint.Style.FILL_AND_STROKE.nativeInt) {
                    graphics2D.drawRect((int)f, (int)f2, (int)(f3 - f), (int)(f4 - f2));
                }
            }
        });
    }

    @LayoutlibDelegate
    static void native_drawOval(int n, final RectF rectF, int n2) {
        if (rectF.right > rectF.left && rectF.bottom > rectF.top) {
            Canvas_Delegate.draw(n, n2, false, false, new GcSnapshot.Drawable(){

                public void draw(Graphics2D graphics2D, Paint_Delegate paint_Delegate) {
                    int n = paint_Delegate.getStyle();
                    if (n == Paint.Style.FILL.nativeInt || n == Paint.Style.FILL_AND_STROKE.nativeInt) {
                        graphics2D.fillOval((int)rectF.left, (int)rectF.top, (int)rectF.width(), (int)rectF.height());
                    }
                    if (n == Paint.Style.STROKE.nativeInt || n == Paint.Style.FILL_AND_STROKE.nativeInt) {
                        graphics2D.drawOval((int)rectF.left, (int)rectF.top, (int)rectF.width(), (int)rectF.height());
                    }
                }
            });
        }
    }

    @LayoutlibDelegate
    static void native_drawCircle(int n, float f, float f2, float f3, int n2) {
        Canvas_Delegate.native_drawOval(n, new RectF(f - f3, f2 - f3, f + f3, f2 + f3), n2);
    }

    @LayoutlibDelegate
    static void native_drawArc(int n, final RectF rectF, final float f, final float f2, final boolean bl, int n2) {
        if (rectF.right > rectF.left && rectF.bottom > rectF.top) {
            Canvas_Delegate.draw(n, n2, false, false, new GcSnapshot.Drawable(){

                public void draw(Graphics2D graphics2D, Paint_Delegate paint_Delegate) {
                    int n = paint_Delegate.getStyle();
                    Arc2D.Float float_ = new Arc2D.Float(rectF.left, rectF.top, rectF.width(), rectF.height(), -f, -f2, bl ? 2 : 0);
                    if (n == Paint.Style.FILL.nativeInt || n == Paint.Style.FILL_AND_STROKE.nativeInt) {
                        graphics2D.fill(float_);
                    }
                    if (n == Paint.Style.STROKE.nativeInt || n == Paint.Style.FILL_AND_STROKE.nativeInt) {
                        graphics2D.draw(float_);
                    }
                }
            });
        }
    }

    @LayoutlibDelegate
    static void native_drawRoundRect(int n, final RectF rectF, final float f, final float f2, int n2) {
        Canvas_Delegate.draw(n, n2, false, false, new GcSnapshot.Drawable(){

            public void draw(Graphics2D graphics2D, Paint_Delegate paint_Delegate) {
                int n = paint_Delegate.getStyle();
                if (n == Paint.Style.FILL.nativeInt || n == Paint.Style.FILL_AND_STROKE.nativeInt) {
                    graphics2D.fillRoundRect((int)rectF.left, (int)rectF.top, (int)rectF.width(), (int)rectF.height(), (int)f, (int)f2);
                }
                if (n == Paint.Style.STROKE.nativeInt || n == Paint.Style.FILL_AND_STROKE.nativeInt) {
                    graphics2D.drawRoundRect((int)rectF.left, (int)rectF.top, (int)rectF.width(), (int)rectF.height(), (int)f, (int)f2);
                }
            }
        });
    }

    @LayoutlibDelegate
    static void native_drawPath(int n, int n2, int n3) {
        final Path_Delegate path_Delegate = Path_Delegate.getDelegate(n2);
        if (path_Delegate == null) {
            return;
        }
        Canvas_Delegate.draw(n, n3, false, false, new GcSnapshot.Drawable(){

            public void draw(Graphics2D graphics2D, Paint_Delegate paint_Delegate) {
                Shape shape = path_Delegate.getJavaShape();
                int n = paint_Delegate.getStyle();
                if (n == Paint.Style.FILL.nativeInt || n == Paint.Style.FILL_AND_STROKE.nativeInt) {
                    graphics2D.fill(shape);
                }
                if (n == Paint.Style.STROKE.nativeInt || n == Paint.Style.FILL_AND_STROKE.nativeInt) {
                    graphics2D.draw(shape);
                }
            }
        });
    }

    @LayoutlibDelegate
    static void native_drawBitmap(Canvas canvas, int n, int n2, float f, float f2, int n3, int n4, int n5, int n6) {
        Bitmap_Delegate bitmap_Delegate = Bitmap_Delegate.getDelegate(n2);
        if (bitmap_Delegate == null) {
            return;
        }
        BufferedImage bufferedImage = bitmap_Delegate.getImage();
        float f3 = f + (float)bufferedImage.getWidth();
        float f4 = f2 + (float)bufferedImage.getHeight();
        Canvas_Delegate.drawBitmap(n, bitmap_Delegate, n3, 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), (int)f, (int)f2, (int)f3, (int)f4);
    }

    @LayoutlibDelegate
    static void native_drawBitmap(Canvas canvas, int n, int n2, Rect rect, RectF rectF, int n3, int n4, int n5) {
        Bitmap_Delegate bitmap_Delegate = Bitmap_Delegate.getDelegate(n2);
        if (bitmap_Delegate == null) {
            return;
        }
        BufferedImage bufferedImage = bitmap_Delegate.getImage();
        if (rect == null) {
            Canvas_Delegate.drawBitmap(n, bitmap_Delegate, n3, 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), (int)rectF.left, (int)rectF.top, (int)rectF.right, (int)rectF.bottom);
        } else {
            Canvas_Delegate.drawBitmap(n, bitmap_Delegate, n3, rect.left, rect.top, rect.width(), rect.height(), (int)rectF.left, (int)rectF.top, (int)rectF.right, (int)rectF.bottom);
        }
    }

    @LayoutlibDelegate
    static void native_drawBitmap(int n, int n2, Rect rect, Rect rect2, int n3, int n4, int n5) {
        Bitmap_Delegate bitmap_Delegate = Bitmap_Delegate.getDelegate(n2);
        if (bitmap_Delegate == null) {
            return;
        }
        BufferedImage bufferedImage = bitmap_Delegate.getImage();
        if (rect == null) {
            Canvas_Delegate.drawBitmap(n, bitmap_Delegate, n3, 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), rect2.left, rect2.top, rect2.right, rect2.bottom);
        } else {
            Canvas_Delegate.drawBitmap(n, bitmap_Delegate, n3, rect.left, rect.top, rect.width(), rect.height(), rect2.left, rect2.top, rect2.right, rect2.bottom);
        }
    }

    @LayoutlibDelegate
    static void native_drawBitmap(int n, int[] nArray, int n2, int n3, final float f, final float f2, int n4, int n5, boolean bl, int n6) {
        final BufferedImage bufferedImage = new BufferedImage(n4, n5, bl ? 2 : 1);
        bufferedImage.setRGB(0, 0, n4, n5, nArray, n2, n3);
        Canvas_Delegate.draw(n, n6, true, false, new GcSnapshot.Drawable(){

            public void draw(Graphics2D graphics2D, Paint_Delegate paint_Delegate) {
                if (paint_Delegate != null && paint_Delegate.isFilterBitmap()) {
                    graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                }
                graphics2D.drawImage((Image)bufferedImage, (int)f, (int)f2, null);
            }
        });
    }

    @LayoutlibDelegate
    static void nativeDrawBitmapMatrix(int n, int n2, int n3, int n4) {
        Canvas_Delegate canvas_Delegate = sManager.getDelegate(n);
        if (canvas_Delegate == null) {
            return;
        }
        Paint_Delegate paint_Delegate = Paint_Delegate.getDelegate(n4);
        Bitmap_Delegate bitmap_Delegate = Bitmap_Delegate.getDelegate(n2);
        if (bitmap_Delegate == null) {
            return;
        }
        final BufferedImage bufferedImage = Canvas_Delegate.getImageToDraw(bitmap_Delegate, paint_Delegate, sBoolOut);
        Matrix_Delegate matrix_Delegate = Matrix_Delegate.getDelegate(n3);
        if (matrix_Delegate == null) {
            return;
        }
        final AffineTransform affineTransform = matrix_Delegate.getAffineTransform();
        canvas_Delegate.getSnapshot().draw(new GcSnapshot.Drawable(){

            public void draw(Graphics2D graphics2D, Paint_Delegate paint_Delegate) {
                if (paint_Delegate != null && paint_Delegate.isFilterBitmap()) {
                    graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                }
                graphics2D.drawImage(bufferedImage, affineTransform, null);
            }
        }, paint_Delegate, true, false);
    }

    @LayoutlibDelegate
    static void nativeDrawBitmapMesh(int n, int n2, int n3, int n4, float[] fArray, int n5, int[] nArray, int n6, int n7) {
        Bridge.getLog().fidelityWarning("unsupported", "Canvas.drawBitmapMesh is not supported.", null, null);
    }

    @LayoutlibDelegate
    static void nativeDrawVertices(int n, int n2, int n3, float[] fArray, int n4, float[] fArray2, int n5, int[] nArray, int n6, short[] sArray, int n7, int n8, int n9) {
        Bridge.getLog().fidelityWarning("unsupported", "Canvas.drawVertices is not supported.", null, null);
    }

    @LayoutlibDelegate
    static void native_drawText(int n, final char[] cArray, final int n2, final int n3, final float f, final float f2, int n4, int n5) {
        Canvas_Delegate.draw(n, n5, false, false, new GcSnapshot.Drawable(){

            public void draw(Graphics2D graphics2D, Paint_Delegate paint_Delegate) {
                List<Paint_Delegate.FontInfo> list;
                float f4 = f;
                float f22 = f2;
                if (paint_Delegate.getTextAlign() != Paint.Align.LEFT.nativeInt) {
                    float f3 = paint_Delegate.measureText(cArray, n2, n3);
                    if (paint_Delegate.getTextAlign() == Paint.Align.CENTER.nativeInt) {
                        f4 -= f3 / 2.0f;
                    } else if (paint_Delegate.getTextAlign() == Paint.Align.RIGHT.nativeInt) {
                        f4 -= f3;
                    }
                }
                if ((list = paint_Delegate.getFonts()).size() > 0) {
                    Paint_Delegate.FontInfo fontInfo = list.get(0);
                    int n = n2;
                    int n22 = n2 + n3;
                    while (n < n22) {
                        int n32;
                        int n4 = fontInfo.mFont.canDisplayUpTo(cArray, n, n22);
                        if (n4 == -1) {
                            graphics2D.setFont(fontInfo.mFont);
                            graphics2D.drawChars(cArray, n, n22 - n, (int)f4, (int)f22);
                            return;
                        }
                        if (n4 > 0) {
                            graphics2D.setFont(fontInfo.mFont);
                            graphics2D.drawChars(cArray, n, n4 - n, (int)f4, (int)f22);
                            f4 += (float)fontInfo.mMetrics.charsWidth(cArray, n, n4 - n);
                            n = n4;
                        }
                        boolean bl = false;
                        for (n32 = 1; n32 < list.size(); ++n32) {
                            Paint_Delegate.FontInfo fontInfo2 = list.get(n32);
                            int n5 = Character.isHighSurrogate(cArray[n]) ? 2 : 1;
                            n4 = fontInfo2.mFont.canDisplayUpTo(cArray, n, n + n5);
                            if (n4 != -1) continue;
                            graphics2D.setFont(fontInfo2.mFont);
                            graphics2D.drawChars(cArray, n, n5, (int)f4, (int)f22);
                            f4 += (float)fontInfo2.mMetrics.charsWidth(cArray, n, n5);
                            n += n5;
                            bl = true;
                            break;
                        }
                        if (bl) continue;
                        n32 = Character.isHighSurrogate(cArray[n]) ? 2 : 1;
                        graphics2D.setFont(fontInfo.mFont);
                        graphics2D.drawChars(cArray, n, n32, (int)f4, (int)f22);
                        f4 += (float)fontInfo.mMetrics.charsWidth(cArray, n, n32);
                        n += n32;
                    }
                }
            }
        });
    }

    @LayoutlibDelegate
    static void native_drawText(int n, String string2, int n2, int n3, float f, float f2, int n4, int n5) {
        int n6 = n3 - n2;
        char[] cArray = TemporaryBuffer.obtain(n6);
        TextUtils.getChars(string2, n2, n3, cArray, 0);
        Canvas_Delegate.native_drawText(n, cArray, 0, n6, f, f2, n4, n5);
    }

    @LayoutlibDelegate
    static void native_drawTextRun(int n, String string2, int n2, int n3, int n4, int n5, float f, float f2, int n6, int n7) {
        int n8 = n3 - n2;
        char[] cArray = TemporaryBuffer.obtain(n8);
        TextUtils.getChars(string2, n2, n3, cArray, 0);
        Canvas_Delegate.native_drawText(n, cArray, 0, n8, f, f2, n6, n7);
    }

    @LayoutlibDelegate
    static void native_drawTextRun(int n, char[] cArray, int n2, int n3, int n4, int n5, float f, float f2, int n6, int n7) {
        Canvas_Delegate.native_drawText(n, cArray, n2, n3, f, f2, n6, n7);
    }

    @LayoutlibDelegate
    static void native_drawPosText(int n, char[] cArray, int n2, int n3, float[] fArray, int n4) {
        Bridge.getLog().fidelityWarning("unsupported", "Canvas.drawPosText is not supported.", null, null);
    }

    @LayoutlibDelegate
    static void native_drawPosText(int n, String string2, float[] fArray, int n2) {
        Bridge.getLog().fidelityWarning("unsupported", "Canvas.drawPosText is not supported.", null, null);
    }

    @LayoutlibDelegate
    static void native_drawTextOnPath(int n, char[] cArray, int n2, int n3, int n4, float f, float f2, int n5, int n6) {
        Bridge.getLog().fidelityWarning("unsupported", "Canvas.drawTextOnPath is not supported.", null, null);
    }

    @LayoutlibDelegate
    static void native_drawTextOnPath(int n, String string2, int n2, float f, float f2, int n3, int n4) {
        Bridge.getLog().fidelityWarning("unsupported", "Canvas.drawTextOnPath is not supported.", null, null);
    }

    @LayoutlibDelegate
    static void native_drawPicture(int n, int n2) {
        Bridge.getLog().fidelityWarning("unsupported", "Canvas.drawPicture is not supported.", null, null);
    }

    @LayoutlibDelegate
    static void finalizer(int n) {
        Canvas_Delegate canvas_Delegate = sManager.getDelegate(n);
        if (canvas_Delegate == null) {
            return;
        }
        canvas_Delegate.dispose();
        sManager.removeJavaReferenceFor(n);
    }

    private static void draw(int n, int n2, boolean bl, boolean bl2, GcSnapshot.Drawable drawable2) {
        Canvas_Delegate canvas_Delegate = sManager.getDelegate(n);
        if (canvas_Delegate == null) {
            return;
        }
        Paint_Delegate paint_Delegate = Paint_Delegate.getDelegate(n2);
        canvas_Delegate.getSnapshot().draw(drawable2, paint_Delegate, bl, bl2);
    }

    private static void draw(int n, GcSnapshot.Drawable drawable2) {
        Canvas_Delegate canvas_Delegate = sManager.getDelegate(n);
        if (canvas_Delegate == null) {
            return;
        }
        canvas_Delegate.mSnapshot.draw(drawable2);
    }

    private Canvas_Delegate(Bitmap_Delegate bitmap_Delegate) {
        this.mBitmap = bitmap_Delegate;
        this.mSnapshot = GcSnapshot.createDefaultSnapshot(this.mBitmap);
    }

    private Canvas_Delegate() {
        this.mSnapshot = GcSnapshot.createDefaultSnapshot(null);
    }

    private void dispose() {
        this.mSnapshot.dispose();
    }

    private int save(int n) {
        int n2 = this.mSnapshot.size();
        this.mSnapshot = this.mSnapshot.save(n);
        return n2;
    }

    private int saveLayerAlpha(RectF rectF, int n, int n2) {
        Paint_Delegate paint_Delegate = new Paint_Delegate();
        paint_Delegate.setAlpha(n);
        return this.saveLayer(rectF, paint_Delegate, n2);
    }

    private int saveLayer(RectF rectF, Paint_Delegate paint_Delegate, int n) {
        int n2 = this.mSnapshot.size();
        this.mSnapshot = this.mSnapshot.saveLayer(rectF, paint_Delegate, n);
        return n2;
    }

    private void restoreTo(int n) {
        this.mSnapshot = this.mSnapshot.restoreTo(n);
    }

    private void restore() {
        this.mSnapshot = this.mSnapshot.restore();
    }

    private boolean clipRect(float f, float f2, float f3, float f4, int n) {
        return this.mSnapshot.clipRect(f, f2, f3, f4, n);
    }

    private void setBitmap(Bitmap_Delegate bitmap_Delegate) {
        this.mBitmap = bitmap_Delegate;
        assert (this.mSnapshot.size() == 1);
        this.mSnapshot.setBitmap(this.mBitmap);
    }

    private static void drawBitmap(int n, Bitmap_Delegate bitmap_Delegate, int n2, final int n3, final int n4, final int n5, final int n6, final int n7, final int n8, final int n9, final int n10) {
        Canvas_Delegate canvas_Delegate = sManager.getDelegate(n);
        if (canvas_Delegate == null) {
            return;
        }
        Paint_Delegate paint_Delegate = Paint_Delegate.getDelegate(n2);
        final BufferedImage bufferedImage = Canvas_Delegate.getImageToDraw(bitmap_Delegate, paint_Delegate, sBoolOut);
        Canvas_Delegate.draw(n, n2, true, sBoolOut[0], new GcSnapshot.Drawable(){

            public void draw(Graphics2D graphics2D, Paint_Delegate paint_Delegate) {
                if (paint_Delegate != null && paint_Delegate.isFilterBitmap()) {
                    graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                }
                graphics2D.drawImage(bufferedImage, n7, n8, n9, n10, n3, n4, n5, n6, null);
            }
        });
    }

    private static BufferedImage getImageToDraw(Bitmap_Delegate bitmap_Delegate, Paint_Delegate paint_Delegate, boolean[] blArray) {
        BufferedImage bufferedImage = bitmap_Delegate.getImage();
        blArray[0] = false;
        if (bitmap_Delegate.getConfig() == Bitmap.Config.ALPHA_8) {
            Canvas_Delegate.fixAlpha8Bitmap(bufferedImage);
        } else if (!bitmap_Delegate.hasAlpha()) {
            Xfermode_Delegate xfermode_Delegate;
            if (paint_Delegate != null && (xfermode_Delegate = paint_Delegate.getXfermode()) instanceof PorterDuffXfermode_Delegate) {
                PorterDuff.Mode mode = ((PorterDuffXfermode_Delegate)xfermode_Delegate).getMode();
                boolean bl = blArray[0] = mode == PorterDuff.Mode.SRC_OVER || mode == PorterDuff.Mode.SRC;
            }
            if (!blArray[0]) {
                bufferedImage = Bitmap_Delegate.createCopy(bufferedImage, 1, 255);
            }
        }
        return bufferedImage;
    }

    private static void fixAlpha8Bitmap(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int[] nArray = new int[n * n2];
        bufferedImage.getRGB(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), nArray, 0, bufferedImage.getWidth());
        int n3 = nArray.length;
        int n4 = 0;
        while (n4 < n3) {
            int n5 = n4++;
            nArray[n5] = nArray[n5] & 0xFF000000;
        }
        bufferedImage.setRGB(0, 0, n, n2, nArray, 0, n);
    }
}

