/*
 * Decompiled with CFR 0.152.
 */
package android.net.rtp;

import android.net.rtp.AudioCodec;
import android.net.rtp.AudioStream;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.util.HashMap;
import java.util.Map;

public class AudioGroup {
    public static final int MODE_ON_HOLD = 0;
    public static final int MODE_MUTED = 1;
    public static final int MODE_NORMAL = 2;
    public static final int MODE_ECHO_SUPPRESSION = 3;
    private static final int MODE_LAST = 3;
    private final Map<AudioStream, Integer> mStreams = new HashMap<AudioStream, Integer>();
    private int mMode = 0;
    private int mNative;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioStream[] getStreams() {
        AudioGroup audioGroup = this;
        synchronized (audioGroup) {
            return this.mStreams.keySet().toArray(new AudioStream[this.mStreams.size()]);
        }
    }

    public int getMode() {
        return this.mMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMode(int mode) {
        if (mode < 0 || mode > 3) {
            throw new IllegalArgumentException("Invalid mode");
        }
        AudioGroup audioGroup = this;
        synchronized (audioGroup) {
            this.nativeSetMode(mode);
            this.mMode = mode;
        }
    }

    private void nativeSetMode(int n) {
        OverrideMethod.invokeV("android.net.rtp.AudioGroup#nativeSetMode(I)V", true, this);
    }

    synchronized void add(AudioStream stream) {
        if (!this.mStreams.containsKey(stream)) {
            try {
                AudioCodec codec = stream.getCodec();
                String codecSpec = String.format("%d %s %s", codec.type, codec.rtpmap, codec.fmtp);
                int id2 = this.nativeAdd(stream.getMode(), stream.getSocket(), stream.getRemoteAddress().getHostAddress(), stream.getRemotePort(), codecSpec, stream.getDtmfType());
                this.mStreams.put(stream, id2);
            }
            catch (NullPointerException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private int nativeAdd(int n, int n2, String string2, int n3, String string3, int n4) {
        return OverrideMethod.invokeI("android.net.rtp.AudioGroup#nativeAdd(IILjava/lang/String;ILjava/lang/String;I)I", true, this);
    }

    synchronized void remove(AudioStream stream) {
        Integer id2 = this.mStreams.remove(stream);
        if (id2 != null) {
            this.nativeRemove(id2);
        }
    }

    private void nativeRemove(int n) {
        OverrideMethod.invokeV("android.net.rtp.AudioGroup#nativeRemove(I)V", true, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendDtmf(int event) {
        if (event < 0 || event > 15) {
            throw new IllegalArgumentException("Invalid event");
        }
        AudioGroup audioGroup = this;
        synchronized (audioGroup) {
            this.nativeSendDtmf(event);
        }
    }

    private void nativeSendDtmf(int n) {
        OverrideMethod.invokeV("android.net.rtp.AudioGroup#nativeSendDtmf(I)V", true, this);
    }

    public void clear() {
        for (AudioStream stream : this.getStreams()) {
            stream.join(null);
        }
    }

    protected void finalize() throws Throwable {
        this.nativeRemove(0);
        super.finalize();
    }

    static {
        System.loadLibrary("rtp_jni");
    }
}

