/*
 * Decompiled with CFR 0.152.
 */
package android.net.rtp;

import com.android.tools.layoutlib.create.OverrideMethod;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.SocketException;

public class RtpStream {
    public static final int MODE_NORMAL = 0;
    public static final int MODE_SEND_ONLY = 1;
    public static final int MODE_RECEIVE_ONLY = 2;
    private static final int MODE_LAST = 2;
    private final InetAddress mLocalAddress;
    private final int mLocalPort;
    private InetAddress mRemoteAddress;
    private int mRemotePort = -1;
    private int mMode = 0;
    private int mSocket = -1;

    RtpStream(InetAddress address) throws SocketException {
        this.mLocalPort = this.create(address.getHostAddress());
        this.mLocalAddress = address;
    }

    private int create(String string2) throws SocketException {
        return OverrideMethod.invokeI("android.net.rtp.RtpStream#create(Ljava/lang/String;)I", true, this);
    }

    public InetAddress getLocalAddress() {
        return this.mLocalAddress;
    }

    public int getLocalPort() {
        return this.mLocalPort;
    }

    public InetAddress getRemoteAddress() {
        return this.mRemoteAddress;
    }

    public int getRemotePort() {
        return this.mRemotePort;
    }

    public boolean isBusy() {
        return false;
    }

    public int getMode() {
        return this.mMode;
    }

    public void setMode(int mode) {
        if (this.isBusy()) {
            throw new IllegalStateException("Busy");
        }
        if (mode < 0 || mode > 2) {
            throw new IllegalArgumentException("Invalid mode");
        }
        this.mMode = mode;
    }

    public void associate(InetAddress address, int port) {
        if (this.isBusy()) {
            throw new IllegalStateException("Busy");
        }
        if (!(address instanceof Inet4Address && this.mLocalAddress instanceof Inet4Address || address instanceof Inet6Address && this.mLocalAddress instanceof Inet6Address)) {
            throw new IllegalArgumentException("Unsupported address");
        }
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Invalid port");
        }
        this.mRemoteAddress = address;
        this.mRemotePort = port;
    }

    int getSocket() {
        return this.mSocket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        RtpStream rtpStream = this;
        synchronized (rtpStream) {
            if (this.isBusy()) {
                throw new IllegalStateException("Busy");
            }
            this.close();
        }
    }

    private void close() {
        OverrideMethod.invokeV("android.net.rtp.RtpStream#close()V", true, this);
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    static {
        System.loadLibrary("rtp_jni");
    }
}

