/*
 * Decompiled with CFR 0.152.
 */
package android.net.sip;

import android.app.PendingIntent;
import android.net.sip.ISipSession;
import android.net.sip.ISipSessionListener;
import android.net.sip.SipProfile;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;

public interface ISipService
extends IInterface {
    public void open(SipProfile var1) throws RemoteException;

    public void open3(SipProfile var1, PendingIntent var2, ISipSessionListener var3) throws RemoteException;

    public void close(String var1) throws RemoteException;

    public boolean isOpened(String var1) throws RemoteException;

    public boolean isRegistered(String var1) throws RemoteException;

    public void setRegistrationListener(String var1, ISipSessionListener var2) throws RemoteException;

    public ISipSession createSession(SipProfile var1, ISipSessionListener var2) throws RemoteException;

    public ISipSession getPendingSession(String var1) throws RemoteException;

    public SipProfile[] getListOfProfiles() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISipService {
        private static final String DESCRIPTOR = "android.net.sip.ISipService";
        static final int TRANSACTION_open = 1;
        static final int TRANSACTION_open3 = 2;
        static final int TRANSACTION_close = 3;
        static final int TRANSACTION_isOpened = 4;
        static final int TRANSACTION_isRegistered = 5;
        static final int TRANSACTION_setRegistrationListener = 6;
        static final int TRANSACTION_createSession = 7;
        static final int TRANSACTION_getPendingSession = 8;
        static final int TRANSACTION_getListOfProfiles = 9;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ISipService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ISipService) {
                return (ISipService)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            switch (code) {
                case 1598968902: {
                    reply.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    data.enforceInterface(DESCRIPTOR);
                    SipProfile _arg0 = 0 != data.readInt() ? SipProfile.CREATOR.createFromParcel(data) : null;
                    this.open(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 2: {
                    data.enforceInterface(DESCRIPTOR);
                    SipProfile _arg0 = 0 != data.readInt() ? SipProfile.CREATOR.createFromParcel(data) : null;
                    PendingIntent _arg1 = 0 != data.readInt() ? PendingIntent.CREATOR.createFromParcel(data) : null;
                    ISipSessionListener _arg2 = ISipSessionListener.Stub.asInterface(data.readStrongBinder());
                    this.open3(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 3: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    this.close(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 4: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    boolean _result = this.isOpened(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 5: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    boolean _result = this.isRegistered(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 6: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    ISipSessionListener _arg1 = ISipSessionListener.Stub.asInterface(data.readStrongBinder());
                    this.setRegistrationListener(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 7: {
                    data.enforceInterface(DESCRIPTOR);
                    SipProfile _arg0 = 0 != data.readInt() ? SipProfile.CREATOR.createFromParcel(data) : null;
                    ISipSessionListener _arg1 = ISipSessionListener.Stub.asInterface(data.readStrongBinder());
                    ISipSession _result = this.createSession(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeStrongBinder(_result != null ? _result.asBinder() : null);
                    return true;
                }
                case 8: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    ISipSession _result = this.getPendingSession(_arg0);
                    reply.writeNoException();
                    reply.writeStrongBinder(_result != null ? _result.asBinder() : null);
                    return true;
                }
                case 9: {
                    data.enforceInterface(DESCRIPTOR);
                    Parcelable[] _result = this.getListOfProfiles();
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        private static class Proxy
        implements ISipService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void open(SipProfile localProfile) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (localProfile != null) {
                        _data.writeInt(1);
                        localProfile.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    Object var5_4 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void open3(SipProfile localProfile, PendingIntent incomingCallPendingIntent, ISipSessionListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (localProfile != null) {
                        _data.writeInt(1);
                        localProfile.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (incomingCallPendingIntent != null) {
                        _data.writeInt(1);
                        incomingCallPendingIntent.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    Object var7_6 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void close(String localProfileUri) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(localProfileUri);
                    this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    Object var5_4 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean isOpened(String localProfileUri) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(localProfileUri);
                    this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                    Object var6_5 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean isRegistered(String localProfileUri) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(localProfileUri);
                    this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                    Object var6_5 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void setRegistrationListener(String localProfileUri, ISipSessionListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(localProfileUri);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    Object var6_5 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public ISipSession createSession(SipProfile localProfile, ISipSessionListener listener) throws RemoteException {
                ISipSession _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (localProfile != null) {
                        _data.writeInt(1);
                        localProfile.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = ISipSession.Stub.asInterface(_reply.readStrongBinder());
                    Object var7_6 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public ISipSession getPendingSession(String callId) throws RemoteException {
                ISipSession _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callId);
                    this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = ISipSession.Stub.asInterface(_reply.readStrongBinder());
                    Object var6_5 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public SipProfile[] getListOfProfiles() throws RemoteException {
                SipProfile[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArray(SipProfile.CREATOR);
                    Object var5_4 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
                return _result;
            }
        }
    }
}

