/*
 * Decompiled with CFR 0.152.
 */
package android.net.sip;

import android.net.sip.ISipSession;
import android.net.sip.SipProfile;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ISipSessionListener
extends IInterface {
    public void onCalling(ISipSession var1) throws RemoteException;

    public void onRinging(ISipSession var1, SipProfile var2, String var3) throws RemoteException;

    public void onRingingBack(ISipSession var1) throws RemoteException;

    public void onCallEstablished(ISipSession var1, String var2) throws RemoteException;

    public void onCallEnded(ISipSession var1) throws RemoteException;

    public void onCallBusy(ISipSession var1) throws RemoteException;

    public void onCallTransferring(ISipSession var1, String var2) throws RemoteException;

    public void onError(ISipSession var1, int var2, String var3) throws RemoteException;

    public void onCallChangeFailed(ISipSession var1, int var2, String var3) throws RemoteException;

    public void onRegistering(ISipSession var1) throws RemoteException;

    public void onRegistrationDone(ISipSession var1, int var2) throws RemoteException;

    public void onRegistrationFailed(ISipSession var1, int var2, String var3) throws RemoteException;

    public void onRegistrationTimeout(ISipSession var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISipSessionListener {
        private static final String DESCRIPTOR = "android.net.sip.ISipSessionListener";
        static final int TRANSACTION_onCalling = 1;
        static final int TRANSACTION_onRinging = 2;
        static final int TRANSACTION_onRingingBack = 3;
        static final int TRANSACTION_onCallEstablished = 4;
        static final int TRANSACTION_onCallEnded = 5;
        static final int TRANSACTION_onCallBusy = 6;
        static final int TRANSACTION_onCallTransferring = 7;
        static final int TRANSACTION_onError = 8;
        static final int TRANSACTION_onCallChangeFailed = 9;
        static final int TRANSACTION_onRegistering = 10;
        static final int TRANSACTION_onRegistrationDone = 11;
        static final int TRANSACTION_onRegistrationFailed = 12;
        static final int TRANSACTION_onRegistrationTimeout = 13;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ISipSessionListener asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ISipSessionListener) {
                return (ISipSessionListener)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            switch (code) {
                case 1598968902: {
                    reply.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    data.enforceInterface(DESCRIPTOR);
                    ISipSession _arg0 = ISipSession.Stub.asInterface(data.readStrongBinder());
                    this.onCalling(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 2: {
                    data.enforceInterface(DESCRIPTOR);
                    ISipSession _arg0 = ISipSession.Stub.asInterface(data.readStrongBinder());
                    SipProfile _arg1 = 0 != data.readInt() ? SipProfile.CREATOR.createFromParcel(data) : null;
                    String _arg2 = data.readString();
                    this.onRinging(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 3: {
                    data.enforceInterface(DESCRIPTOR);
                    ISipSession _arg0 = ISipSession.Stub.asInterface(data.readStrongBinder());
                    this.onRingingBack(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 4: {
                    data.enforceInterface(DESCRIPTOR);
                    ISipSession _arg0 = ISipSession.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    this.onCallEstablished(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 5: {
                    data.enforceInterface(DESCRIPTOR);
                    ISipSession _arg0 = ISipSession.Stub.asInterface(data.readStrongBinder());
                    this.onCallEnded(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 6: {
                    data.enforceInterface(DESCRIPTOR);
                    ISipSession _arg0 = ISipSession.Stub.asInterface(data.readStrongBinder());
                    this.onCallBusy(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 7: {
                    data.enforceInterface(DESCRIPTOR);
                    ISipSession _arg0 = ISipSession.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    this.onCallTransferring(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 8: {
                    data.enforceInterface(DESCRIPTOR);
                    ISipSession _arg0 = ISipSession.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    this.onError(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 9: {
                    data.enforceInterface(DESCRIPTOR);
                    ISipSession _arg0 = ISipSession.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    this.onCallChangeFailed(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 10: {
                    data.enforceInterface(DESCRIPTOR);
                    ISipSession _arg0 = ISipSession.Stub.asInterface(data.readStrongBinder());
                    this.onRegistering(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 11: {
                    data.enforceInterface(DESCRIPTOR);
                    ISipSession _arg0 = ISipSession.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    this.onRegistrationDone(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 12: {
                    data.enforceInterface(DESCRIPTOR);
                    ISipSession _arg0 = ISipSession.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    this.onRegistrationFailed(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 13: {
                    data.enforceInterface(DESCRIPTOR);
                    ISipSession _arg0 = ISipSession.Stub.asInterface(data.readStrongBinder());
                    this.onRegistrationTimeout(_arg0);
                    reply.writeNoException();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        private static class Proxy
        implements ISipSessionListener {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onCalling(ISipSession session) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(session != null ? session.asBinder() : null);
                    this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    Object var5_4 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onRinging(ISipSession session, SipProfile caller, String sessionDescription) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(session != null ? session.asBinder() : null);
                    if (caller != null) {
                        _data.writeInt(1);
                        caller.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(sessionDescription);
                    this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    Object var7_6 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onRingingBack(ISipSession session) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(session != null ? session.asBinder() : null);
                    this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    Object var5_4 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onCallEstablished(ISipSession session, String sessionDescription) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(session != null ? session.asBinder() : null);
                    _data.writeString(sessionDescription);
                    this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    Object var6_5 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onCallEnded(ISipSession session) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(session != null ? session.asBinder() : null);
                    this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    Object var5_4 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onCallBusy(ISipSession session) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(session != null ? session.asBinder() : null);
                    this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    Object var5_4 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onCallTransferring(ISipSession newSession, String sessionDescription) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(newSession != null ? newSession.asBinder() : null);
                    _data.writeString(sessionDescription);
                    this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    Object var6_5 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onError(ISipSession session, int errorCode, String errorMessage) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(session != null ? session.asBinder() : null);
                    _data.writeInt(errorCode);
                    _data.writeString(errorMessage);
                    this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    Object var7_6 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onCallChangeFailed(ISipSession session, int errorCode, String errorMessage) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(session != null ? session.asBinder() : null);
                    _data.writeInt(errorCode);
                    _data.writeString(errorMessage);
                    this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    Object var7_6 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onRegistering(ISipSession session) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(session != null ? session.asBinder() : null);
                    this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    Object var5_4 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onRegistrationDone(ISipSession session, int duration) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(session != null ? session.asBinder() : null);
                    _data.writeInt(duration);
                    this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    Object var6_5 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onRegistrationFailed(ISipSession session, int errorCode, String errorMessage) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(session != null ? session.asBinder() : null);
                    _data.writeInt(errorCode);
                    _data.writeString(errorMessage);
                    this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    Object var7_6 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onRegistrationTimeout(ISipSession session) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(session != null ? session.asBinder() : null);
                    this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                    Object var5_4 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
            }
        }
    }
}

