/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.net.DhcpInfo;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiInfo;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Messenger;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.WorkSource;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface IWifiManager
extends IInterface {
    public List<WifiConfiguration> getConfiguredNetworks() throws RemoteException;

    public int addOrUpdateNetwork(WifiConfiguration var1) throws RemoteException;

    public boolean removeNetwork(int var1) throws RemoteException;

    public boolean enableNetwork(int var1, boolean var2) throws RemoteException;

    public boolean disableNetwork(int var1) throws RemoteException;

    public boolean pingSupplicant() throws RemoteException;

    public void startScan(boolean var1) throws RemoteException;

    public List<ScanResult> getScanResults() throws RemoteException;

    public void disconnect() throws RemoteException;

    public void reconnect() throws RemoteException;

    public void reassociate() throws RemoteException;

    public WifiInfo getConnectionInfo() throws RemoteException;

    public boolean setWifiEnabled(boolean var1) throws RemoteException;

    public int getWifiEnabledState() throws RemoteException;

    public void setCountryCode(String var1, boolean var2) throws RemoteException;

    public void setFrequencyBand(int var1, boolean var2) throws RemoteException;

    public int getFrequencyBand() throws RemoteException;

    public boolean isDualBandSupported() throws RemoteException;

    public boolean saveConfiguration() throws RemoteException;

    public DhcpInfo getDhcpInfo() throws RemoteException;

    public boolean acquireWifiLock(IBinder var1, int var2, String var3, WorkSource var4) throws RemoteException;

    public void updateWifiLockWorkSource(IBinder var1, WorkSource var2) throws RemoteException;

    public boolean releaseWifiLock(IBinder var1) throws RemoteException;

    public void initializeMulticastFiltering() throws RemoteException;

    public boolean isMulticastEnabled() throws RemoteException;

    public void acquireMulticastLock(IBinder var1, String var2) throws RemoteException;

    public void releaseMulticastLock() throws RemoteException;

    public void setWifiApEnabled(WifiConfiguration var1, boolean var2) throws RemoteException;

    public int getWifiApEnabledState() throws RemoteException;

    public WifiConfiguration getWifiApConfiguration() throws RemoteException;

    public void setWifiApConfiguration(WifiConfiguration var1) throws RemoteException;

    public void startWifi() throws RemoteException;

    public void stopWifi() throws RemoteException;

    public void addToBlacklist(String var1) throws RemoteException;

    public void clearBlacklist() throws RemoteException;

    public Messenger getWifiServiceMessenger() throws RemoteException;

    public Messenger getWifiStateMachineMessenger() throws RemoteException;

    public String getConfigFile() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IWifiManager {
        private static final String DESCRIPTOR = "android.net.wifi.IWifiManager";
        static final int TRANSACTION_getConfiguredNetworks = 1;
        static final int TRANSACTION_addOrUpdateNetwork = 2;
        static final int TRANSACTION_removeNetwork = 3;
        static final int TRANSACTION_enableNetwork = 4;
        static final int TRANSACTION_disableNetwork = 5;
        static final int TRANSACTION_pingSupplicant = 6;
        static final int TRANSACTION_startScan = 7;
        static final int TRANSACTION_getScanResults = 8;
        static final int TRANSACTION_disconnect = 9;
        static final int TRANSACTION_reconnect = 10;
        static final int TRANSACTION_reassociate = 11;
        static final int TRANSACTION_getConnectionInfo = 12;
        static final int TRANSACTION_setWifiEnabled = 13;
        static final int TRANSACTION_getWifiEnabledState = 14;
        static final int TRANSACTION_setCountryCode = 15;
        static final int TRANSACTION_setFrequencyBand = 16;
        static final int TRANSACTION_getFrequencyBand = 17;
        static final int TRANSACTION_isDualBandSupported = 18;
        static final int TRANSACTION_saveConfiguration = 19;
        static final int TRANSACTION_getDhcpInfo = 20;
        static final int TRANSACTION_acquireWifiLock = 21;
        static final int TRANSACTION_updateWifiLockWorkSource = 22;
        static final int TRANSACTION_releaseWifiLock = 23;
        static final int TRANSACTION_initializeMulticastFiltering = 24;
        static final int TRANSACTION_isMulticastEnabled = 25;
        static final int TRANSACTION_acquireMulticastLock = 26;
        static final int TRANSACTION_releaseMulticastLock = 27;
        static final int TRANSACTION_setWifiApEnabled = 28;
        static final int TRANSACTION_getWifiApEnabledState = 29;
        static final int TRANSACTION_getWifiApConfiguration = 30;
        static final int TRANSACTION_setWifiApConfiguration = 31;
        static final int TRANSACTION_startWifi = 32;
        static final int TRANSACTION_stopWifi = 33;
        static final int TRANSACTION_addToBlacklist = 34;
        static final int TRANSACTION_clearBlacklist = 35;
        static final int TRANSACTION_getWifiServiceMessenger = 36;
        static final int TRANSACTION_getWifiStateMachineMessenger = 37;
        static final int TRANSACTION_getConfigFile = 38;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IWifiManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IWifiManager) {
                return (IWifiManager)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            switch (code) {
                case 1598968902: {
                    reply.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    data.enforceInterface(DESCRIPTOR);
                    List<WifiConfiguration> _result = this.getConfiguredNetworks();
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
                case 2: {
                    data.enforceInterface(DESCRIPTOR);
                    WifiConfiguration _arg0 = 0 != data.readInt() ? WifiConfiguration.CREATOR.createFromParcel(data) : null;
                    int _result = this.addOrUpdateNetwork(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 3: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    boolean _result = this.removeNetwork(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 4: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    boolean _arg1 = 0 != data.readInt();
                    boolean _result = this.enableNetwork(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 5: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    boolean _result = this.disableNetwork(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 6: {
                    data.enforceInterface(DESCRIPTOR);
                    boolean _result = this.pingSupplicant();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 7: {
                    data.enforceInterface(DESCRIPTOR);
                    boolean _arg0 = 0 != data.readInt();
                    this.startScan(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 8: {
                    data.enforceInterface(DESCRIPTOR);
                    List<ScanResult> _result = this.getScanResults();
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
                case 9: {
                    data.enforceInterface(DESCRIPTOR);
                    this.disconnect();
                    reply.writeNoException();
                    return true;
                }
                case 10: {
                    data.enforceInterface(DESCRIPTOR);
                    this.reconnect();
                    reply.writeNoException();
                    return true;
                }
                case 11: {
                    data.enforceInterface(DESCRIPTOR);
                    this.reassociate();
                    reply.writeNoException();
                    return true;
                }
                case 12: {
                    data.enforceInterface(DESCRIPTOR);
                    WifiInfo _result = this.getConnectionInfo();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 13: {
                    data.enforceInterface(DESCRIPTOR);
                    boolean _arg0 = 0 != data.readInt();
                    boolean _result = this.setWifiEnabled(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 14: {
                    data.enforceInterface(DESCRIPTOR);
                    int _result = this.getWifiEnabledState();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 15: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    boolean _arg1 = 0 != data.readInt();
                    this.setCountryCode(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 16: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    boolean _arg1 = 0 != data.readInt();
                    this.setFrequencyBand(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 17: {
                    data.enforceInterface(DESCRIPTOR);
                    int _result = this.getFrequencyBand();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 18: {
                    data.enforceInterface(DESCRIPTOR);
                    boolean _result = this.isDualBandSupported();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 19: {
                    data.enforceInterface(DESCRIPTOR);
                    boolean _result = this.saveConfiguration();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 20: {
                    data.enforceInterface(DESCRIPTOR);
                    DhcpInfo _result = this.getDhcpInfo();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 21: {
                    data.enforceInterface(DESCRIPTOR);
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    WorkSource _arg3 = 0 != data.readInt() ? WorkSource.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.acquireWifiLock(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 22: {
                    data.enforceInterface(DESCRIPTOR);
                    IBinder _arg0 = data.readStrongBinder();
                    WorkSource _arg1 = 0 != data.readInt() ? WorkSource.CREATOR.createFromParcel(data) : null;
                    this.updateWifiLockWorkSource(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 23: {
                    data.enforceInterface(DESCRIPTOR);
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _result = this.releaseWifiLock(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 24: {
                    data.enforceInterface(DESCRIPTOR);
                    this.initializeMulticastFiltering();
                    reply.writeNoException();
                    return true;
                }
                case 25: {
                    data.enforceInterface(DESCRIPTOR);
                    boolean _result = this.isMulticastEnabled();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 26: {
                    data.enforceInterface(DESCRIPTOR);
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    this.acquireMulticastLock(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 27: {
                    data.enforceInterface(DESCRIPTOR);
                    this.releaseMulticastLock();
                    reply.writeNoException();
                    return true;
                }
                case 28: {
                    data.enforceInterface(DESCRIPTOR);
                    WifiConfiguration _arg0 = 0 != data.readInt() ? WifiConfiguration.CREATOR.createFromParcel(data) : null;
                    boolean _arg1 = 0 != data.readInt();
                    this.setWifiApEnabled(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 29: {
                    data.enforceInterface(DESCRIPTOR);
                    int _result = this.getWifiApEnabledState();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 30: {
                    data.enforceInterface(DESCRIPTOR);
                    WifiConfiguration _result = this.getWifiApConfiguration();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 31: {
                    data.enforceInterface(DESCRIPTOR);
                    WifiConfiguration _arg0 = 0 != data.readInt() ? WifiConfiguration.CREATOR.createFromParcel(data) : null;
                    this.setWifiApConfiguration(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 32: {
                    data.enforceInterface(DESCRIPTOR);
                    this.startWifi();
                    reply.writeNoException();
                    return true;
                }
                case 33: {
                    data.enforceInterface(DESCRIPTOR);
                    this.stopWifi();
                    reply.writeNoException();
                    return true;
                }
                case 34: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    this.addToBlacklist(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 35: {
                    data.enforceInterface(DESCRIPTOR);
                    this.clearBlacklist();
                    reply.writeNoException();
                    return true;
                }
                case 36: {
                    data.enforceInterface(DESCRIPTOR);
                    Messenger _result = this.getWifiServiceMessenger();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 37: {
                    data.enforceInterface(DESCRIPTOR);
                    Messenger _result = this.getWifiStateMachineMessenger();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 38: {
                    data.enforceInterface(DESCRIPTOR);
                    String _result = this.getConfigFile();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class Proxy
        implements IWifiManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<WifiConfiguration> getConfiguredNetworks() throws RemoteException {
                ArrayList<WifiConfiguration> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(WifiConfiguration.CREATOR);
                    Object var5_4 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int addOrUpdateNetwork(WifiConfiguration config) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (config != null) {
                        _data.writeInt(1);
                        config.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                    Object var6_5 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean removeNetwork(int netId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(netId);
                    this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                    Object var6_5 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean enableNetwork(int netId, boolean disableOthers) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(netId);
                    _data.writeInt(disableOthers ? 1 : 0);
                    this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                    Object var7_6 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean disableNetwork(int netId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(netId);
                    this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                    Object var6_5 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean pingSupplicant() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                    Object var5_4 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startScan(boolean forceActive) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(forceActive ? 1 : 0);
                    this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    Object var5_4 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<ScanResult> getScanResults() throws RemoteException {
                ArrayList<ScanResult> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(ScanResult.CREATOR);
                    Object var5_4 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disconnect() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    Object var4_3 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reconnect() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    Object var4_3 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reassociate() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    Object var4_3 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public WifiInfo getConnectionInfo() throws RemoteException {
                WifiInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? WifiInfo.CREATOR.createFromParcel(_reply) : null;
                    Object var5_4 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setWifiEnabled(boolean enable) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(enable ? 1 : 0);
                    this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                    Object var6_5 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getWifiEnabledState() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                    Object var5_4 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setCountryCode(String country, boolean persist) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(country);
                    _data.writeInt(persist ? 1 : 0);
                    this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                    Object var6_5 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setFrequencyBand(int band, boolean persist) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(band);
                    _data.writeInt(persist ? 1 : 0);
                    this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                    Object var6_5 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getFrequencyBand() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                    Object var5_4 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isDualBandSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                    Object var5_4 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean saveConfiguration() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                    Object var5_4 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public DhcpInfo getDhcpInfo() throws RemoteException {
                DhcpInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? DhcpInfo.CREATOR.createFromParcel(_reply) : null;
                    Object var5_4 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean acquireWifiLock(IBinder lock, int lockType, String tag, WorkSource ws) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(lock);
                    _data.writeInt(lockType);
                    _data.writeString(tag);
                    if (ws != null) {
                        _data.writeInt(1);
                        ws.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                    Object var9_8 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateWifiLockWorkSource(IBinder lock, WorkSource ws) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(lock);
                    if (ws != null) {
                        _data.writeInt(1);
                        ws.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                    Object var6_5 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean releaseWifiLock(IBinder lock) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(lock);
                    this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                    Object var6_5 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void initializeMulticastFiltering() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                    Object var4_3 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isMulticastEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                    Object var5_4 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void acquireMulticastLock(IBinder binder, String tag) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(binder);
                    _data.writeString(tag);
                    this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                    Object var6_5 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void releaseMulticastLock() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                    Object var4_3 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setWifiApEnabled(WifiConfiguration wifiConfig, boolean enable) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (wifiConfig != null) {
                        _data.writeInt(1);
                        wifiConfig.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(enable ? 1 : 0);
                    this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                    Object var6_5 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getWifiApEnabledState() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                    Object var5_4 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public WifiConfiguration getWifiApConfiguration() throws RemoteException {
                WifiConfiguration _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? WifiConfiguration.CREATOR.createFromParcel(_reply) : null;
                    Object var5_4 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setWifiApConfiguration(WifiConfiguration wifiConfig) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (wifiConfig != null) {
                        _data.writeInt(1);
                        wifiConfig.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                    Object var5_4 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startWifi() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                    Object var4_3 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopWifi() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                    Object var4_3 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addToBlacklist(String bssid) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(bssid);
                    this.mRemote.transact(34, _data, _reply, 0);
                    _reply.readException();
                    Object var5_4 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearBlacklist() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(35, _data, _reply, 0);
                    _reply.readException();
                    Object var4_3 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Messenger getWifiServiceMessenger() throws RemoteException {
                Messenger _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(36, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? Messenger.CREATOR.createFromParcel(_reply) : null;
                    Object var5_4 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Messenger getWifiStateMachineMessenger() throws RemoteException {
                Messenger _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(37, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? Messenger.CREATOR.createFromParcel(_reply) : null;
                    Object var5_4 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getConfigFile() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(38, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                    Object var5_4 = null;
                    _reply.recycle();
                    _data.recycle();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    _reply.recycle();
                    _data.recycle();
                    throw throwable;
                }
                return _result;
            }
        }
    }
}

