/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.p2p;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WifiP2pDevice
implements Parcelable {
    private static final String TAG = "WifiP2pDevice";
    public String deviceName = "";
    public String deviceAddress = "";
    public String primaryDeviceType;
    public String secondaryDeviceType;
    private static final int WPS_CONFIG_DISPLAY = 8;
    private static final int WPS_CONFIG_PUSHBUTTON = 128;
    private static final int WPS_CONFIG_KEYPAD = 256;
    private static final int DEVICE_CAPAB_SERVICE_DISCOVERY = 1;
    private static final int DEVICE_CAPAB_CLIENT_DISCOVERABILITY = 2;
    private static final int DEVICE_CAPAB_CONCURRENT_OPER = 4;
    private static final int DEVICE_CAPAB_INFRA_MANAGED = 8;
    private static final int DEVICE_CAPAB_DEVICE_LIMIT = 16;
    private static final int DEVICE_CAPAB_INVITATION_PROCEDURE = 32;
    private static final int GROUP_CAPAB_GROUP_OWNER = 1;
    private static final int GROUP_CAPAB_PERSISTENT_GROUP = 2;
    private static final int GROUP_CAPAB_GROUP_LIMIT = 4;
    private static final int GROUP_CAPAB_INTRA_BSS_DIST = 8;
    private static final int GROUP_CAPAB_CROSS_CONN = 16;
    private static final int GROUP_CAPAB_PERSISTENT_RECONN = 32;
    private static final int GROUP_CAPAB_GROUP_FORMATION = 64;
    public int wpsConfigMethodsSupported;
    public int deviceCapability;
    public int groupCapability;
    public static final int CONNECTED = 0;
    public static final int INVITED = 1;
    public static final int FAILED = 2;
    public static final int AVAILABLE = 3;
    public static final int UNAVAILABLE = 4;
    public int status = 4;
    private static final Pattern detailedDevicePattern = Pattern.compile("((?:[0-9a-f]{2}:){5}[0-9a-f]{2}) (\\d+ )?p2p_dev_addr=((?:[0-9a-f]{2}:){5}[0-9a-f]{2}) pri_dev_type=(\\d+-[0-9a-fA-F]+-\\d+) name='(.*)' config_methods=(0x[0-9a-fA-F]+) dev_capab=(0x[0-9a-fA-F]+) group_capab=(0x[0-9a-fA-F]+)");
    private static final Pattern twoTokenPattern = Pattern.compile("(p2p_dev_addr=)?((?:[0-9a-f]{2}:){5}[0-9a-f]{2})");
    private static final Pattern threeTokenPattern = Pattern.compile("(?:[0-9a-f]{2}:){5}[0-9a-f]{2} p2p_dev_addr=((?:[0-9a-f]{2}:){5}[0-9a-f]{2})");
    public static final Parcelable.Creator<WifiP2pDevice> CREATOR = new Parcelable.Creator<WifiP2pDevice>(){

        @Override
        public WifiP2pDevice createFromParcel(Parcel in) {
            WifiP2pDevice device = new WifiP2pDevice();
            device.deviceName = in.readString();
            device.deviceAddress = in.readString();
            device.primaryDeviceType = in.readString();
            device.secondaryDeviceType = in.readString();
            device.wpsConfigMethodsSupported = in.readInt();
            device.deviceCapability = in.readInt();
            device.groupCapability = in.readInt();
            device.status = in.readInt();
            return device;
        }

        public WifiP2pDevice[] newArray(int size) {
            return new WifiP2pDevice[size];
        }
    };

    public WifiP2pDevice() {
    }

    public WifiP2pDevice(String string2) throws IllegalArgumentException {
        String[] tokens = string2.split("[ \n]");
        if (tokens.length < 1) {
            throw new IllegalArgumentException("Malformed supplicant event");
        }
        switch (tokens.length) {
            case 1: {
                this.deviceAddress = string2;
                return;
            }
            case 2: {
                Matcher match = twoTokenPattern.matcher(string2);
                if (!match.find()) {
                    throw new IllegalArgumentException("Malformed supplicant event");
                }
                this.deviceAddress = match.group(2);
                return;
            }
            case 3: {
                Matcher match = threeTokenPattern.matcher(string2);
                if (!match.find()) {
                    throw new IllegalArgumentException("Malformed supplicant event");
                }
                this.deviceAddress = match.group(1);
                return;
            }
        }
        Matcher match = detailedDevicePattern.matcher(string2);
        if (!match.find()) {
            throw new IllegalArgumentException("Malformed supplicant event");
        }
        this.deviceAddress = match.group(3);
        this.primaryDeviceType = match.group(4);
        this.deviceName = match.group(5);
        this.wpsConfigMethodsSupported = this.parseHex(match.group(6));
        this.deviceCapability = this.parseHex(match.group(7));
        this.groupCapability = this.parseHex(match.group(8));
        if (tokens[0].startsWith("P2P-DEVICE-FOUND")) {
            this.status = 3;
        }
    }

    public boolean wpsPbcSupported() {
        return (this.wpsConfigMethodsSupported & 0x80) != 0;
    }

    public boolean wpsKeypadSupported() {
        return (this.wpsConfigMethodsSupported & 0x100) != 0;
    }

    public boolean wpsDisplaySupported() {
        return (this.wpsConfigMethodsSupported & 8) != 0;
    }

    public boolean isServiceDiscoveryCapable() {
        return (this.deviceCapability & 1) != 0;
    }

    public boolean isGroupOwner() {
        return (this.groupCapability & 1) != 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof WifiP2pDevice)) {
            return false;
        }
        WifiP2pDevice other = (WifiP2pDevice)obj;
        if (other == null || other.deviceAddress == null) {
            return this.deviceAddress == null;
        }
        return other.deviceAddress.equals(this.deviceAddress);
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("Device: ").append(this.deviceName);
        sbuf.append("\n deviceAddress: ").append(this.deviceAddress);
        sbuf.append("\n primary type: ").append(this.primaryDeviceType);
        sbuf.append("\n secondary type: ").append(this.secondaryDeviceType);
        sbuf.append("\n wps: ").append(this.wpsConfigMethodsSupported);
        sbuf.append("\n grpcapab: ").append(this.groupCapability);
        sbuf.append("\n devcapab: ").append(this.deviceCapability);
        sbuf.append("\n status: ").append(this.status);
        return sbuf.toString();
    }

    public int describeContents() {
        return 0;
    }

    public WifiP2pDevice(WifiP2pDevice source) {
        if (source != null) {
            this.deviceName = source.deviceName;
            this.deviceAddress = source.deviceAddress;
            this.primaryDeviceType = source.primaryDeviceType;
            this.secondaryDeviceType = source.secondaryDeviceType;
            this.wpsConfigMethodsSupported = source.wpsConfigMethodsSupported;
            this.deviceCapability = source.deviceCapability;
            this.groupCapability = source.groupCapability;
            this.status = source.status;
        }
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.deviceName);
        dest.writeString(this.deviceAddress);
        dest.writeString(this.primaryDeviceType);
        dest.writeString(this.secondaryDeviceType);
        dest.writeInt(this.wpsConfigMethodsSupported);
        dest.writeInt(this.deviceCapability);
        dest.writeInt(this.groupCapability);
        dest.writeInt(this.status);
    }

    private int parseHex(String hexString) {
        int num = 0;
        if (hexString.startsWith("0x") || hexString.startsWith("0X")) {
            hexString = hexString.substring(2);
        }
        try {
            num = Integer.parseInt(hexString, 16);
        }
        catch (NumberFormatException e) {
            Log.e(TAG, "Failed to parse hex string " + hexString);
        }
        return num;
    }
}

