/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.ICancellationSignal;
import android.os.OperationCanceledException;
import android.os.RemoteException;

public class CancellationSignal {
    private boolean mIsCanceled;
    private OnCancelListener mOnCancelListener;
    private ICancellationSignal mRemote;
    private boolean mCancelInProgress;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCanceled() {
        CancellationSignal cancellationSignal = this;
        synchronized (cancellationSignal) {
            return this.mIsCanceled;
        }
    }

    public void throwIfCanceled() {
        if (this.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        CancellationSignal cancellationSignal;
        ICancellationSignal remote;
        OnCancelListener listener;
        CancellationSignal cancellationSignal2 = this;
        synchronized (cancellationSignal2) {
            if (this.mIsCanceled) {
                return;
            }
            this.mIsCanceled = true;
            this.mCancelInProgress = true;
            listener = this.mOnCancelListener;
            remote = this.mRemote;
        }
        try {
            if (listener != null) {
                listener.onCancel();
            }
            if (remote != null) {
                try {
                    remote.cancel();
                }
                catch (RemoteException remoteException) {
                }
            }
            Object var6_6 = null;
            cancellationSignal = this;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            CancellationSignal cancellationSignal3 = this;
            synchronized (cancellationSignal3) {
                this.mCancelInProgress = false;
                this.notifyAll();
            }
            throw throwable;
        }
        synchronized (cancellationSignal) {
            this.mCancelInProgress = false;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnCancelListener(OnCancelListener listener) {
        CancellationSignal cancellationSignal = this;
        synchronized (cancellationSignal) {
            this.waitForCancelFinishedLocked();
            if (this.mOnCancelListener == listener) {
                return;
            }
            this.mOnCancelListener = listener;
            if (!this.mIsCanceled || listener == null) {
                return;
            }
        }
        listener.onCancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRemote(ICancellationSignal remote) {
        CancellationSignal cancellationSignal = this;
        synchronized (cancellationSignal) {
            this.waitForCancelFinishedLocked();
            if (this.mRemote == remote) {
                return;
            }
            this.mRemote = remote;
            if (!this.mIsCanceled || remote == null) {
                return;
            }
        }
        try {
            remote.cancel();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void waitForCancelFinishedLocked() {
        while (this.mCancelInProgress) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static ICancellationSignal createTransport() {
        return new Transport();
    }

    public static CancellationSignal fromTransport(ICancellationSignal transport) {
        if (transport instanceof Transport) {
            return ((Transport)transport).mCancellationSignal;
        }
        return null;
    }

    private static class Transport
    extends ICancellationSignal.Stub {
        final CancellationSignal mCancellationSignal = new CancellationSignal();

        private Transport() {
        }

        public void cancel() throws RemoteException {
            this.mCancellationSignal.cancel();
        }
    }

    public static interface OnCancelListener {
        public void onCancel();
    }
}

