/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.StrictMode;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;

public class FileUtils {
    public static final int S_IRWXU = 448;
    public static final int S_IRUSR = 256;
    public static final int S_IWUSR = 128;
    public static final int S_IXUSR = 64;
    public static final int S_IRWXG = 56;
    public static final int S_IRGRP = 32;
    public static final int S_IWGRP = 16;
    public static final int S_IXGRP = 8;
    public static final int S_IRWXO = 7;
    public static final int S_IROTH = 4;
    public static final int S_IWOTH = 2;
    public static final int S_IXOTH = 1;
    private static final Pattern SAFE_FILENAME_PATTERN = Pattern.compile("[\\w%+,./=_-]+");

    @Deprecated
    public static boolean getFileStatus(String path, FileStatus status) {
        StrictMode.noteDiskRead();
        return FileUtils.getFileStatusNative(path, status);
    }

    private static boolean getFileStatusNative(String string2, FileStatus fileStatus) {
        return OverrideMethod.invokeI("android.os.FileUtils#getFileStatusNative(Ljava/lang/String;Landroid/os/FileUtils$FileStatus;)Z", true, null) != 0;
    }

    public static int setPermissions(String string2, int n, int n2, int n3) {
        return OverrideMethod.invokeI("android.os.FileUtils#setPermissions(Ljava/lang/String;III)I", true, null);
    }

    @Deprecated
    public static int getPermissions(String string2, int[] nArray) {
        return OverrideMethod.invokeI("android.os.FileUtils#getPermissions(Ljava/lang/String;[I)I", true, null);
    }

    public static int setUMask(int n) {
        return OverrideMethod.invokeI("android.os.FileUtils#setUMask(I)I", true, null);
    }

    public static int getFatVolumeId(String string2) {
        return OverrideMethod.invokeI("android.os.FileUtils#getFatVolumeId(Ljava/lang/String;)I", true, null);
    }

    public static boolean sync(FileOutputStream stream) {
        try {
            if (stream != null) {
                stream.getFD().sync();
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(File srcFile, File destFile) {
        boolean result = false;
        try {
            FileInputStream in = new FileInputStream(srcFile);
            try {
                result = FileUtils.copyToFile(in, destFile);
            }
            finally {
                ((InputStream)in).close();
            }
        }
        catch (IOException e) {
            result = false;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyToFile(InputStream inputStream, File destFile) {
        try {
            if (destFile.exists()) {
                destFile.delete();
            }
            FileOutputStream out = new FileOutputStream(destFile);
            try {
                int bytesRead;
                byte[] buffer = new byte[4096];
                while ((bytesRead = inputStream.read(buffer)) >= 0) {
                    out.write(buffer, 0, bytesRead);
                }
            }
            finally {
                out.flush();
                try {
                    out.getFD().sync();
                }
                catch (IOException iOException) {}
                out.close();
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean isFilenameSafe(File file) {
        return SAFE_FILENAME_PATTERN.matcher(file.getPath()).matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readTextFile(File file, int max, String ellipsis) throws IOException {
        FileInputStream input = new FileInputStream(file);
        try {
            int len;
            long size = file.length();
            if (max > 0 || size > 0L && max == 0) {
                byte[] data;
                int length;
                if (size > 0L && (max == 0 || size < (long)max)) {
                    max = (int)size;
                }
                if ((length = ((InputStream)input).read(data = new byte[max + 1])) <= 0) {
                    String string2 = "";
                    return string2;
                }
                if (length <= max) {
                    String string3 = new String(data, 0, length);
                    return string3;
                }
                if (ellipsis == null) {
                    String string4 = new String(data, 0, max);
                    return string4;
                }
                String string5 = new String(data, 0, max) + ellipsis;
                return string5;
            }
            if (max < 0) {
                String string6;
                int len2;
                boolean rolled = false;
                byte[] last = null;
                byte[] data = null;
                do {
                    if (last != null) {
                        rolled = true;
                    }
                    byte[] tmp = last;
                    last = data;
                    data = tmp;
                    if (data != null) continue;
                    data = new byte[-max];
                } while ((len2 = ((InputStream)input).read(data)) == data.length);
                if (last == null && len2 <= 0) {
                    string6 = "";
                    return string6;
                }
                if (last == null) {
                    string6 = new String(data, 0, len2);
                    return string6;
                }
                if (len2 > 0) {
                    rolled = true;
                    System.arraycopy(last, len2, last, 0, last.length - len2);
                    System.arraycopy(data, 0, last, last.length - len2, len2);
                }
                if (ellipsis == null || !rolled) {
                    string6 = new String(last);
                    return string6;
                }
                string6 = ellipsis + new String(last);
                return string6;
            }
            ByteArrayOutputStream contents = new ByteArrayOutputStream();
            byte[] data = new byte[1024];
            do {
                if ((len = ((InputStream)input).read(data)) <= 0) continue;
                contents.write(data, 0, len);
            } while (len == data.length);
            String string7 = contents.toString();
            return string7;
        }
        finally {
            ((InputStream)input).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stringToFile(String filename, String string2) throws IOException {
        FileWriter out = new FileWriter(filename);
        try {
            out.write(string2);
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long checksumCrc32(File file) throws FileNotFoundException, IOException {
        CRC32 checkSummer = new CRC32();
        FilterInputStream cis = null;
        try {
            cis = new CheckedInputStream(new FileInputStream(file), checkSummer);
            byte[] buf = new byte[128];
            while (cis.read(buf) >= 0) {
            }
            long l = checkSummer.getValue();
            return l;
        }
        finally {
            if (cis != null) {
                try {
                    cis.close();
                }
                catch (IOException e) {}
            }
        }
    }

    @Deprecated
    public static class FileStatus {
        public int dev;
        public int ino;
        public int mode;
        public int nlink;
        public int uid;
        public int gid;
        public int rdev;
        public long size;
        public int blksize;
        public long blocks;
        public long atime;
        public long mtime;
        public long ctime;
    }
}

