/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.SystemProperties;
import com.android.tools.layoutlib.create.OverrideMethod;

public class Trace {
    public static final long TRACE_TAG_NEVER = 0L;
    public static final long TRACE_TAG_ALWAYS = 1L;
    public static final long TRACE_TAG_GRAPHICS = 2L;
    public static final long TRACE_TAG_INPUT = 4L;
    public static final long TRACE_TAG_VIEW = 8L;
    public static final long TRACE_TAG_WEBVIEW = 16L;
    public static final long TRACE_TAG_WINDOW_MANAGER = 32L;
    public static final long TRACE_TAG_ACTIVITY_MANAGER = 64L;
    public static final long TRACE_TAG_SYNC_MANAGER = 128L;
    public static final long TRACE_TAG_AUDIO = 256L;
    public static final long TRACE_TAG_VIDEO = 512L;
    public static final int TRACE_FLAGS_START_BIT = 1;
    public static final String[] TRACE_TAGS = new String[]{"Graphics", "Input", "View", "WebView", "Window Manager", "Activity Manager", "Sync Manager", "Audio", "Video"};
    public static final String PROPERTY_TRACE_TAG_ENABLEFLAGS = "debug.atrace.tags.enableflags";
    private static long sEnabledTags = Trace.nativeGetEnabledTags();

    private static long nativeGetEnabledTags() {
        return OverrideMethod.invokeL("android.os.Trace#nativeGetEnabledTags()J", true, null);
    }

    private static void nativeTraceCounter(long l, String string2, int n) {
        OverrideMethod.invokeV("android.os.Trace#nativeTraceCounter(JLjava/lang/String;I)V", true, null);
    }

    private static void nativeTraceBegin(long l, String string2) {
        OverrideMethod.invokeV("android.os.Trace#nativeTraceBegin(JLjava/lang/String;)V", true, null);
    }

    private static void nativeTraceEnd(long l) {
        OverrideMethod.invokeV("android.os.Trace#nativeTraceEnd(J)V", true, null);
    }

    private Trace() {
    }

    public static boolean isTagEnabled(long traceTag) {
        return (sEnabledTags & traceTag) != 0L;
    }

    public static void traceCounter(long traceTag, String counterName, int counterValue) {
        if ((sEnabledTags & traceTag) != 0L) {
            Trace.nativeTraceCounter(traceTag, counterName, counterValue);
        }
    }

    public static void traceBegin(long traceTag, String methodName) {
        if ((sEnabledTags & traceTag) != 0L) {
            Trace.nativeTraceBegin(traceTag, methodName);
        }
    }

    public static void traceEnd(long traceTag) {
        if ((sEnabledTags & traceTag) != 0L) {
            Trace.nativeTraceEnd(traceTag);
        }
    }

    static {
        SystemProperties.addChangeCallback(new Runnable(){

            public void run() {
                sEnabledTags = Trace.nativeGetEnabledTags();
            }
        });
    }
}

