/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.Allocation;
import android.renderscript.BaseObj;
import android.renderscript.Element;
import android.renderscript.FieldPacker;
import android.renderscript.RSIllegalArgumentException;
import android.renderscript.RenderScript;
import android.renderscript.Type;
import java.io.UnsupportedEncodingException;

public class Script
extends BaseObj {
    protected void invoke(int slot) {
        this.mRS.nScriptInvoke(this.getID(this.mRS), slot);
    }

    protected void invoke(int slot, FieldPacker v) {
        if (v != null) {
            this.mRS.nScriptInvokeV(this.getID(this.mRS), slot, v.getData());
        } else {
            this.mRS.nScriptInvoke(this.getID(this.mRS), slot);
        }
    }

    protected void forEach(int slot, Allocation ain, Allocation aout, FieldPacker v) {
        if (ain == null && aout == null) {
            throw new RSIllegalArgumentException("At least one of ain or aout is required to be non-null.");
        }
        int in_id = 0;
        if (ain != null) {
            in_id = ain.getID(this.mRS);
        }
        int out_id = 0;
        if (aout != null) {
            out_id = aout.getID(this.mRS);
        }
        byte[] params = null;
        if (v != null) {
            params = v.getData();
        }
        this.mRS.nScriptForEach(this.getID(this.mRS), slot, in_id, out_id, params);
    }

    Script(int id2, RenderScript rs) {
        super(id2, rs);
    }

    public void bindAllocation(Allocation va, int slot) {
        this.mRS.validate();
        if (va != null) {
            this.mRS.nScriptBindAllocation(this.getID(this.mRS), va.getID(this.mRS), slot);
        } else {
            this.mRS.nScriptBindAllocation(this.getID(this.mRS), 0, slot);
        }
    }

    public void setVar(int index, float v) {
        this.mRS.nScriptSetVarF(this.getID(this.mRS), index, v);
    }

    public void setVar(int index, double v) {
        this.mRS.nScriptSetVarD(this.getID(this.mRS), index, v);
    }

    public void setVar(int index, int v) {
        this.mRS.nScriptSetVarI(this.getID(this.mRS), index, v);
    }

    public void setVar(int index, long v) {
        this.mRS.nScriptSetVarJ(this.getID(this.mRS), index, v);
    }

    public void setVar(int index, boolean v) {
        this.mRS.nScriptSetVarI(this.getID(this.mRS), index, v ? 1 : 0);
    }

    public void setVar(int index, BaseObj o) {
        this.mRS.nScriptSetVarObj(this.getID(this.mRS), index, o == null ? 0 : o.getID(this.mRS));
    }

    public void setVar(int index, FieldPacker v) {
        this.mRS.nScriptSetVarV(this.getID(this.mRS), index, v.getData());
    }

    public void setVar(int index, FieldPacker v, Element e, int[] dims) {
        this.mRS.nScriptSetVarVE(this.getID(this.mRS), index, v.getData(), e.getID(this.mRS), dims);
    }

    public void setTimeZone(String timeZone) {
        this.mRS.validate();
        try {
            this.mRS.nScriptSetTimeZone(this.getID(this.mRS), timeZone.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static class FieldBase {
        protected Element mElement;
        protected Allocation mAllocation;

        protected void init(RenderScript rs, int dimx) {
            this.mAllocation = Allocation.createSized(rs, this.mElement, dimx, 1);
        }

        protected void init(RenderScript rs, int dimx, int usages) {
            this.mAllocation = Allocation.createSized(rs, this.mElement, dimx, 1 | usages);
        }

        protected FieldBase() {
        }

        public Element getElement() {
            return this.mElement;
        }

        public Type getType() {
            return this.mAllocation.getType();
        }

        public Allocation getAllocation() {
            return this.mAllocation;
        }

        public void updateAllocation() {
        }
    }

    public static class Builder {
        RenderScript mRS;

        Builder(RenderScript rs) {
            this.mRS = rs;
        }
    }
}

