/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.CellIdentity;
import android.telephony.GsmCellIdentity;
import android.telephony.SignalStrength;

public class CellInfo
implements Parcelable {
    public static final int CELL_INFO_TIMESTAMP_TYPE_UNKNOWN = 0;
    public static final int CELL_INFO_TIMESTAMP_TYPE_ANTENNA = 1;
    public static final int CELL_INFO_TIMESTAMP_TYPE_MODEM = 2;
    public static final int CELL_INFO_TIMESTAMP_TYPE_OEM_RIL = 3;
    public static final int CELL_INFO_TIMESTAMP_TYPE_JAVA_RIL = 4;
    private final long mTimeStamp;
    private final int mTimeStampType;
    private final boolean mRegistered;
    private final SignalStrength mStrength;
    private final long mTimingAdvance;
    private final int mCellIdentityType;
    private final CellIdentity mCellIdentity;
    public static final Parcelable.Creator<CellInfo> CREATOR = new Parcelable.Creator<CellInfo>(){

        @Override
        public CellInfo createFromParcel(Parcel in) {
            return new CellInfo(in);
        }

        public CellInfo[] newArray(int size) {
            return new CellInfo[size];
        }
    };

    public CellInfo(int timeStampType, long timeStamp, long timingAdv, boolean registered, SignalStrength strength, CellIdentity cellIdentity) {
        this.mTimeStampType = timeStampType < 0 || timeStampType > 4 ? 0 : timeStampType;
        this.mRegistered = registered;
        this.mTimeStamp = timeStamp;
        this.mTimingAdvance = timingAdv;
        this.mStrength = new SignalStrength(strength);
        this.mCellIdentityType = cellIdentity.getCellIdType();
        this.mCellIdentity = cellIdentity;
    }

    public CellInfo(CellInfo ci) {
        this.mTimeStampType = ci.mTimeStampType;
        this.mRegistered = ci.mRegistered;
        this.mTimeStamp = ci.mTimeStamp;
        this.mTimingAdvance = ci.mTimingAdvance;
        this.mCellIdentityType = ci.mCellIdentityType;
        this.mStrength = new SignalStrength(ci.mStrength);
        switch (this.mCellIdentityType) {
            case 1: {
                this.mCellIdentity = new GsmCellIdentity((GsmCellIdentity)ci.mCellIdentity);
                break;
            }
            default: {
                this.mCellIdentity = null;
            }
        }
    }

    private CellInfo(Parcel in) {
        this.mTimeStampType = in.readInt();
        this.mRegistered = in.readInt() == 1;
        this.mTimeStamp = in.readLong();
        this.mTimingAdvance = in.readLong();
        this.mCellIdentityType = in.readInt();
        this.mStrength = SignalStrength.CREATOR.createFromParcel(in);
        switch (this.mCellIdentityType) {
            case 1: {
                this.mCellIdentity = GsmCellIdentity.CREATOR.createFromParcel(in);
                break;
            }
            default: {
                this.mCellIdentity = null;
            }
        }
    }

    public long getTimeStamp() {
        return this.mTimeStamp;
    }

    public int getTimeStampType() {
        return this.mTimeStampType;
    }

    public boolean isRegistered() {
        return this.mRegistered;
    }

    public long getTimingAdvance() {
        return this.mTimingAdvance;
    }

    public SignalStrength getSignalStrength() {
        return new SignalStrength(this.mStrength);
    }

    public CellIdentity getCellIdentity() {
        return this.mCellIdentity;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("TimeStampType: ");
        switch (this.mTimeStampType) {
            case 1: {
                sb.append("antenna");
                break;
            }
            case 2: {
                sb.append("modem");
                break;
            }
            case 3: {
                sb.append("oem_ril");
                break;
            }
            case 4: {
                sb.append("java_ril");
                break;
            }
            default: {
                sb.append("unknown");
            }
        }
        sb.append(", TimeStamp: ").append(this.mTimeStamp).append(" ns");
        sb.append(", Registered: ").append(this.mRegistered ? "YES" : "NO");
        sb.append(", TimingAdvance: ").append(this.mTimingAdvance);
        sb.append(", Strength : " + this.mStrength);
        sb.append(", Cell Iden: " + this.mCellIdentity);
        return sb.toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mTimeStampType);
        dest.writeInt(this.mRegistered ? 1 : 0);
        dest.writeLong(this.mTimeStamp);
        dest.writeLong(this.mTimingAdvance);
        dest.writeInt(this.mCellIdentityType);
        this.mStrength.writeToParcel(dest, flags);
        this.mCellIdentity.writeToParcel(dest, flags);
    }
}

