/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.text.Layout;
import android.text.SpanSet;
import android.text.Spanned;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.CharacterStyle;
import android.text.style.MetricAffectingSpan;
import android.text.style.ReplacementSpan;
import com.android.internal.util.ArrayUtils;

class TextLine {
    private static final boolean DEBUG = false;
    private TextPaint mPaint;
    private CharSequence mText;
    private int mStart;
    private int mLen;
    private int mDir;
    private Layout.Directions mDirections;
    private boolean mHasTabs;
    private Layout.TabStops mTabs;
    private char[] mChars;
    private boolean mCharsValid;
    private Spanned mSpanned;
    private final TextPaint mWorkPaint = new TextPaint();
    private final SpanSet<MetricAffectingSpan> mMetricAffectingSpanSpanSet = new SpanSet<MetricAffectingSpan>(MetricAffectingSpan.class);
    private final SpanSet<CharacterStyle> mCharacterStyleSpanSet = new SpanSet<CharacterStyle>(CharacterStyle.class);
    private final SpanSet<ReplacementSpan> mReplacementSpanSpanSet = new SpanSet<ReplacementSpan>(ReplacementSpan.class);
    private static final TextLine[] sCached = new TextLine[3];
    private static final int TAB_INCREMENT = 20;

    TextLine() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TextLine obtain() {
        TextLine[] textLineArray = sCached;
        synchronized (sCached) {
            int i = sCached.length;
            while (--i >= 0) {
                if (sCached[i] == null) continue;
                TextLine tl = sCached[i];
                TextLine.sCached[i] = null;
                // ** MonitorExit[var1] (shouldn't be in output)
                return tl;
            }
            // ** MonitorExit[var1] (shouldn't be in output)
            TextLine tl = new TextLine();
            return tl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TextLine recycle(TextLine tl) {
        tl.mText = null;
        tl.mPaint = null;
        tl.mDirections = null;
        tl.mMetricAffectingSpanSpanSet.recycle();
        tl.mCharacterStyleSpanSet.recycle();
        tl.mReplacementSpanSpanSet.recycle();
        TextLine[] textLineArray = sCached;
        synchronized (sCached) {
            for (int i = 0; i < sCached.length; ++i) {
                if (sCached[i] != null) continue;
                TextLine.sCached[i] = tl;
                break;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return null;
        }
    }

    void set(TextPaint paint, CharSequence text, int start, int limit, int dir, Layout.Directions directions, boolean hasTabs, Layout.TabStops tabStops) {
        this.mPaint = paint;
        this.mText = text;
        this.mStart = start;
        this.mLen = limit - start;
        this.mDir = dir;
        this.mDirections = directions;
        if (this.mDirections == null) {
            throw new IllegalArgumentException("Directions cannot be null");
        }
        this.mHasTabs = hasTabs;
        this.mSpanned = null;
        boolean hasReplacement = false;
        if (text instanceof Spanned) {
            this.mSpanned = (Spanned)text;
            this.mReplacementSpanSpanSet.init(this.mSpanned, start, limit);
            hasReplacement = this.mReplacementSpanSpanSet.numberOfSpans > 0;
        }
        boolean bl = this.mCharsValid = hasReplacement || hasTabs || directions != Layout.DIRS_ALL_LEFT_TO_RIGHT;
        if (this.mCharsValid) {
            if (this.mChars == null || this.mChars.length < this.mLen) {
                this.mChars = new char[ArrayUtils.idealCharArraySize(this.mLen)];
            }
            TextUtils.getChars(text, start, limit, this.mChars, 0);
            if (hasReplacement) {
                char[] chars = this.mChars;
                int i = start;
                while (i < limit) {
                    int inext = this.mReplacementSpanSpanSet.getNextTransition(i, limit);
                    if (this.mReplacementSpanSpanSet.hasSpansIntersecting(i, inext)) {
                        chars[i - start] = 65532;
                        int e = inext - start;
                        for (int j = i - start + 1; j < e; ++j) {
                            chars[j] = 65279;
                        }
                    }
                    i = inext;
                }
            }
        }
        this.mTabs = tabStops;
    }

    /*
     * Unable to fully structure code
     */
    void draw(Canvas c, float x, int top, int y, int bottom) {
        if (!this.mHasTabs) {
            if (this.mDirections == Layout.DIRS_ALL_LEFT_TO_RIGHT) {
                this.drawRun(c, 0, this.mLen, false, x, top, y, bottom, false);
                return;
            }
            if (this.mDirections == Layout.DIRS_ALL_RIGHT_TO_LEFT) {
                this.drawRun(c, 0, this.mLen, true, x, top, y, bottom, false);
                return;
            }
        }
        h = 0.0f;
        runs = this.mDirections.mDirections;
        emojiRect = null;
        lastRunIndex = runs.length - 2;
        for (i = 0; i < runs.length; i += 2) {
            runStart = runs[i];
            runLimit = runStart + (runs[i + 1] & 0x3FFFFFF);
            if (runLimit > this.mLen) {
                runLimit = this.mLen;
            }
            runIsRtl = (runs[i + 1] & 0x4000000) != 0;
            segstart = runStart;
            v0 = j = this.mHasTabs != false ? runStart : runLimit;
            while (j <= runLimit) {
                block13: {
                    codept = 0;
                    bm = null;
                    if (!this.mHasTabs || j >= runLimit || (codept = this.mChars[j]) < 55296 || codept >= 56320 || j + 1 >= runLimit) ** GOTO lbl-1000
                    codept = Character.codePointAt(this.mChars, j);
                    if (codept < Layout.MIN_EMOJI || codept > Layout.MAX_EMOJI) break block13;
                    bm = Layout.EMOJI_FACTORY.getBitmapFromAndroidPua(codept);
                    ** GOTO lbl-1000
                }
                if (codept > 65535) {
                    ++j;
                } else if (j == runLimit || codept == 9 || bm != null) {
                    h += this.drawRun(c, segstart, j, runIsRtl, x + h, top, y, bottom, i != lastRunIndex || j != this.mLen);
                    if (codept == 9) {
                        h = (float)this.mDir * this.nextTab(h * (float)this.mDir);
                    } else if (bm != null) {
                        bmAscent = this.ascent(j);
                        bitmapHeight = bm.getHeight();
                        scale = -bmAscent / bitmapHeight;
                        width = (float)bm.getWidth() * scale;
                        if (emojiRect == null) {
                            emojiRect = new RectF();
                        }
                        emojiRect.set(x + h, (float)y + bmAscent, x + h + width, y);
                        c.drawBitmap(bm, null, emojiRect, (Paint)this.mPaint);
                        h += width;
                        ++j;
                    }
                    segstart = j + 1;
                }
                ++j;
            }
        }
    }

    float metrics(Paint.FontMetricsInt fmi) {
        return this.measure(this.mLen, false, fmi);
    }

    /*
     * Unable to fully structure code
     */
    float measure(int offset, boolean trailing, Paint.FontMetricsInt fmi) {
        v0 = target = trailing != false ? offset - 1 : offset;
        if (target < 0) {
            return 0.0f;
        }
        h = 0.0f;
        if (!this.mHasTabs) {
            if (this.mDirections == Layout.DIRS_ALL_LEFT_TO_RIGHT) {
                return this.measureRun(0, offset, this.mLen, false, fmi);
            }
            if (this.mDirections == Layout.DIRS_ALL_RIGHT_TO_LEFT) {
                return this.measureRun(0, offset, this.mLen, true, fmi);
            }
        }
        chars = this.mChars;
        runs = this.mDirections.mDirections;
        for (i = 0; i < runs.length; i += 2) {
            runStart = runs[i];
            runLimit = runStart + (runs[i + 1] & 0x3FFFFFF);
            if (runLimit > this.mLen) {
                runLimit = this.mLen;
            }
            runIsRtl = (runs[i + 1] & 0x4000000) != 0;
            segstart = runStart;
            v1 = j = this.mHasTabs != false ? runStart : runLimit;
            while (j <= runLimit) {
                block16: {
                    codept = 0;
                    bm = null;
                    if (!this.mHasTabs || j >= runLimit || (codept = chars[j]) < 55296 || codept >= 56320 || j + 1 >= runLimit) ** GOTO lbl-1000
                    codept = Character.codePointAt(chars, j);
                    if (codept < Layout.MIN_EMOJI || codept > Layout.MAX_EMOJI) break block16;
                    bm = Layout.EMOJI_FACTORY.getBitmapFromAndroidPua(codept);
                    ** GOTO lbl-1000
                }
                if (codept > 65535) {
                    ++j;
                } else if (j == runLimit || codept == 9 || bm != null) {
                    inSegment = target >= segstart && target < j;
                    v2 = advance = this.mDir == -1 == runIsRtl;
                    if (inSegment && advance) {
                        return h += this.measureRun(segstart, offset, j, runIsRtl, fmi);
                    }
                    w = this.measureRun(segstart, j, j, runIsRtl, fmi);
                    h += advance != false ? w : -w;
                    if (inSegment) {
                        return h += this.measureRun(segstart, offset, j, runIsRtl, null);
                    }
                    if (codept == 9) {
                        if (offset == j) {
                            return h;
                        }
                        h = (float)this.mDir * this.nextTab(h * (float)this.mDir);
                        if (target == j) {
                            return h;
                        }
                    }
                    if (bm != null) {
                        bmAscent = this.ascent(j);
                        wid = (float)bm.getWidth() * -bmAscent / (float)bm.getHeight();
                        h += (float)this.mDir * wid;
                        ++j;
                    }
                    segstart = j + 1;
                }
                ++j;
            }
        }
        return h;
    }

    private float drawRun(Canvas c, int start, int limit, boolean runIsRtl, float x, int top, int y, int bottom, boolean needWidth) {
        if (this.mDir == 1 == runIsRtl) {
            float w = -this.measureRun(start, limit, limit, runIsRtl, null);
            this.handleRun(start, limit, limit, runIsRtl, c, x + w, top, y, bottom, null, false);
            return w;
        }
        return this.handleRun(start, limit, limit, runIsRtl, c, x, top, y, bottom, null, needWidth);
    }

    private float measureRun(int start, int offset, int limit, boolean runIsRtl, Paint.FontMetricsInt fmi) {
        return this.handleRun(start, offset, limit, runIsRtl, null, 0.0f, 0, 0, 0, fmi, true);
    }

    int getOffsetToLeftRightOf(int cursor, boolean toLeft) {
        int newCaret;
        block13: {
            boolean advance;
            int lineEnd;
            int lineStart;
            block14: {
                int otherRunIndex;
                int runIndex;
                lineStart = 0;
                lineEnd = this.mLen;
                boolean paraIsRtl = this.mDir == -1;
                int[] runs = this.mDirections.mDirections;
                int runLevel = 0;
                int runStart = lineStart;
                int runLimit = lineEnd;
                newCaret = -1;
                boolean trailing = false;
                if (cursor == lineStart) {
                    runIndex = -2;
                } else if (cursor == lineEnd) {
                    runIndex = runs.length;
                } else {
                    boolean runIsRtl;
                    boolean advance2;
                    block0: for (runIndex = 0; runIndex < runs.length; runIndex += 2) {
                        runStart = lineStart + runs[runIndex];
                        if (cursor < runStart) continue;
                        runLimit = runStart + (runs[runIndex + 1] & 0x3FFFFFF);
                        if (runLimit > lineEnd) {
                            runLimit = lineEnd;
                        }
                        if (cursor >= runLimit) continue;
                        runLevel = runs[runIndex + 1] >>> 26 & 0x3F;
                        if (cursor != runStart) break;
                        int pos = cursor - 1;
                        for (int prevRunIndex = 0; prevRunIndex < runs.length; prevRunIndex += 2) {
                            int prevRunLevel;
                            int prevRunStart = lineStart + runs[prevRunIndex];
                            if (pos < prevRunStart) continue;
                            int prevRunLimit = prevRunStart + (runs[prevRunIndex + 1] & 0x3FFFFFF);
                            if (prevRunLimit > lineEnd) {
                                prevRunLimit = lineEnd;
                            }
                            if (pos >= prevRunLimit || (prevRunLevel = runs[prevRunIndex + 1] >>> 26 & 0x3F) >= runLevel) continue;
                            runIndex = prevRunIndex;
                            runLevel = prevRunLevel;
                            runStart = prevRunStart;
                            runLimit = prevRunLimit;
                            trailing = true;
                            break block0;
                        }
                        break;
                    }
                    if (runIndex != runs.length && (cursor != ((advance2 = toLeft == (runIsRtl = runLevel & true)) ? runLimit : runStart) || advance2 != trailing) && (newCaret = this.getOffsetBeforeAfter(runIndex, runStart, runLimit, runIsRtl, cursor, advance2)) != (advance2 ? runLimit : runStart)) {
                        return newCaret;
                    }
                }
                while ((otherRunIndex = runIndex + ((advance = toLeft == paraIsRtl) ? 2 : -2)) >= 0 && otherRunIndex < runs.length) {
                    int otherRunLevel;
                    int otherRunStart = lineStart + runs[otherRunIndex];
                    int otherRunLimit = otherRunStart + (runs[otherRunIndex + 1] & 0x3FFFFFF);
                    if (otherRunLimit > lineEnd) {
                        otherRunLimit = lineEnd;
                    }
                    boolean otherRunIsRtl = ((otherRunLevel = runs[otherRunIndex + 1] >>> 26 & 0x3F) & 1) != 0;
                    boolean bl = advance = toLeft == otherRunIsRtl;
                    if (newCaret == -1) {
                        newCaret = this.getOffsetBeforeAfter(otherRunIndex, otherRunStart, otherRunLimit, otherRunIsRtl, advance ? otherRunStart : otherRunLimit, advance);
                        if (newCaret == (advance ? otherRunLimit : otherRunStart)) {
                            runIndex = otherRunIndex;
                            runLevel = otherRunLevel;
                            continue;
                        }
                        break block13;
                    }
                    if (otherRunLevel >= runLevel) break block13;
                    newCaret = advance ? otherRunStart : otherRunLimit;
                    break block13;
                }
                if (newCaret != -1) break block14;
                newCaret = advance ? this.mLen + 1 : -1;
                break block13;
            }
            if (newCaret > lineEnd) break block13;
            newCaret = advance ? lineEnd : lineStart;
        }
        return newCaret;
    }

    private int getOffsetBeforeAfter(int runIndex, int runStart, int runLimit, boolean runIsRtl, int offset, boolean after) {
        int cursorOpt;
        int spanLimit;
        if (runIndex < 0 || offset == (after ? this.mLen : 0)) {
            if (after) {
                return TextUtils.getOffsetAfter(this.mText, offset + this.mStart) - this.mStart;
            }
            return TextUtils.getOffsetBefore(this.mText, offset + this.mStart) - this.mStart;
        }
        TextPaint wp = this.mWorkPaint;
        wp.set(this.mPaint);
        int spanStart = runStart;
        if (this.mSpanned == null) {
            spanLimit = runLimit;
        } else {
            int target = after ? offset + 1 : offset;
            int limit = this.mStart + runLimit;
            while ((spanLimit = this.mSpanned.nextSpanTransition(this.mStart + spanStart, limit, MetricAffectingSpan.class) - this.mStart) < target) {
                spanStart = spanLimit;
            }
            MetricAffectingSpan[] spans = this.mSpanned.getSpans(this.mStart + spanStart, this.mStart + spanLimit, MetricAffectingSpan.class);
            spans = TextUtils.removeEmptySpans(spans, this.mSpanned, MetricAffectingSpan.class);
            if (spans.length > 0) {
                ReplacementSpan replacement = null;
                for (int j = 0; j < spans.length; ++j) {
                    MetricAffectingSpan span = spans[j];
                    if (span instanceof ReplacementSpan) {
                        replacement = (ReplacementSpan)span;
                        continue;
                    }
                    span.updateMeasureState(wp);
                }
                if (replacement != null) {
                    return after ? spanLimit : spanStart;
                }
            }
        }
        int flags = runIsRtl ? 1 : 0;
        int n = cursorOpt = after ? 0 : 2;
        if (this.mCharsValid) {
            return wp.getTextRunCursor(this.mChars, spanStart, spanLimit - spanStart, flags, offset, cursorOpt);
        }
        return wp.getTextRunCursor(this.mText, this.mStart + spanStart, this.mStart + spanLimit, flags, this.mStart + offset, cursorOpt) - this.mStart;
    }

    private static void expandMetricsFromPaint(Paint.FontMetricsInt fmi, TextPaint wp) {
        int previousTop = fmi.top;
        int previousAscent = fmi.ascent;
        int previousDescent = fmi.descent;
        int previousBottom = fmi.bottom;
        int previousLeading = fmi.leading;
        wp.getFontMetricsInt(fmi);
        TextLine.updateMetrics(fmi, previousTop, previousAscent, previousDescent, previousBottom, previousLeading);
    }

    static void updateMetrics(Paint.FontMetricsInt fmi, int previousTop, int previousAscent, int previousDescent, int previousBottom, int previousLeading) {
        fmi.top = Math.min(fmi.top, previousTop);
        fmi.ascent = Math.min(fmi.ascent, previousAscent);
        fmi.descent = Math.max(fmi.descent, previousDescent);
        fmi.bottom = Math.max(fmi.bottom, previousBottom);
        fmi.leading = Math.max(fmi.leading, previousLeading);
    }

    private float handleText(TextPaint wp, int start, int end, int contextStart, int contextEnd, boolean runIsRtl, Canvas c, float x, int top, int y, int bottom, Paint.FontMetricsInt fmi, boolean needWidth) {
        int runLen;
        if (fmi != null) {
            TextLine.expandMetricsFromPaint(fmi, wp);
        }
        if ((runLen = end - start) == 0) {
            return 0.0f;
        }
        float ret = 0.0f;
        int contextLen = contextEnd - contextStart;
        if (needWidth || c != null && (wp.bgColor != 0 || wp.underlineColor != 0 || runIsRtl)) {
            int flags;
            int n = flags = runIsRtl ? 1 : 0;
            if (this.mCharsValid) {
                ret = wp.getTextRunAdvances(this.mChars, start, runLen, contextStart, contextLen, flags, null, 0);
            } else {
                int delta = this.mStart;
                ret = wp.getTextRunAdvances(this.mText, delta + start, delta + end, delta + contextStart, delta + contextEnd, flags, null, 0);
            }
        }
        if (c != null) {
            if (runIsRtl) {
                x -= ret;
            }
            if (wp.bgColor != 0) {
                int previousColor = wp.getColor();
                Paint.Style previousStyle = wp.getStyle();
                wp.setColor(wp.bgColor);
                wp.setStyle(Paint.Style.FILL);
                c.drawRect(x, top, x + ret, bottom, wp);
                wp.setStyle(previousStyle);
                wp.setColor(previousColor);
            }
            if (wp.underlineColor != 0) {
                float underlineTop = (float)(y + wp.baselineShift) + 0.11111111f * wp.getTextSize();
                int previousColor = wp.getColor();
                Paint.Style previousStyle = wp.getStyle();
                boolean previousAntiAlias = wp.isAntiAlias();
                wp.setStyle(Paint.Style.FILL);
                wp.setAntiAlias(true);
                wp.setColor(wp.underlineColor);
                c.drawRect(x, underlineTop, x + ret, underlineTop + wp.underlineThickness, wp);
                wp.setStyle(previousStyle);
                wp.setColor(previousColor);
                wp.setAntiAlias(previousAntiAlias);
            }
            this.drawTextRun(c, wp, start, end, contextStart, contextEnd, runIsRtl, x, y + wp.baselineShift);
        }
        return runIsRtl ? -ret : ret;
    }

    private float handleReplacement(ReplacementSpan replacement, TextPaint wp, int start, int limit, boolean runIsRtl, Canvas c, float x, int top, int y, int bottom, Paint.FontMetricsInt fmi, boolean needWidth) {
        float ret = 0.0f;
        int textStart = this.mStart + start;
        int textLimit = this.mStart + limit;
        if (needWidth || c != null && runIsRtl) {
            boolean needUpdateMetrics;
            int previousTop = 0;
            int previousAscent = 0;
            int previousDescent = 0;
            int previousBottom = 0;
            int previousLeading = 0;
            boolean bl = needUpdateMetrics = fmi != null;
            if (needUpdateMetrics) {
                previousTop = fmi.top;
                previousAscent = fmi.ascent;
                previousDescent = fmi.descent;
                previousBottom = fmi.bottom;
                previousLeading = fmi.leading;
            }
            ret = replacement.getSize(wp, this.mText, textStart, textLimit, fmi);
            if (needUpdateMetrics) {
                TextLine.updateMetrics(fmi, previousTop, previousAscent, previousDescent, previousBottom, previousLeading);
            }
        }
        if (c != null) {
            if (runIsRtl) {
                x -= ret;
            }
            replacement.draw(c, this.mText, textStart, textLimit, x, top, y, bottom, wp);
        }
        return runIsRtl ? -ret : ret;
    }

    private float handleRun(int start, int measureLimit, int limit, boolean runIsRtl, Canvas c, float x, int top, int y, int bottom, Paint.FontMetricsInt fmi, boolean needWidth) {
        if (start == measureLimit) {
            TextPaint wp = this.mWorkPaint;
            wp.set(this.mPaint);
            if (fmi != null) {
                TextLine.expandMetricsFromPaint(fmi, wp);
            }
            return 0.0f;
        }
        if (this.mSpanned == null) {
            TextPaint wp = this.mWorkPaint;
            wp.set(this.mPaint);
            int mlimit = measureLimit;
            return this.handleText(wp, start, mlimit, start, limit, runIsRtl, c, x, top, y, bottom, fmi, needWidth || mlimit < measureLimit);
        }
        this.mMetricAffectingSpanSpanSet.init(this.mSpanned, this.mStart + start, this.mStart + limit);
        this.mCharacterStyleSpanSet.init(this.mSpanned, this.mStart + start, this.mStart + limit);
        float originalX = x;
        int i = start;
        while (i < measureLimit) {
            int j;
            TextPaint wp = this.mWorkPaint;
            wp.set(this.mPaint);
            int inext = this.mMetricAffectingSpanSpanSet.getNextTransition(this.mStart + i, this.mStart + limit) - this.mStart;
            int mlimit = Math.min(inext, measureLimit);
            ReplacementSpan replacement = null;
            for (j = 0; j < this.mMetricAffectingSpanSpanSet.numberOfSpans; ++j) {
                if (this.mMetricAffectingSpanSpanSet.spanStarts[j] >= this.mStart + mlimit || this.mMetricAffectingSpanSpanSet.spanEnds[j] <= this.mStart + i) continue;
                MetricAffectingSpan span = ((MetricAffectingSpan[])this.mMetricAffectingSpanSpanSet.spans)[j];
                if (span instanceof ReplacementSpan) {
                    replacement = (ReplacementSpan)span;
                    continue;
                }
                span.updateDrawState(wp);
            }
            if (replacement != null) {
                x += this.handleReplacement(replacement, wp, i, mlimit, runIsRtl, c, x, top, y, bottom, fmi, needWidth || mlimit < measureLimit);
            } else if (c == null) {
                x += this.handleText(wp, i, mlimit, i, inext, runIsRtl, c, x, top, y, bottom, fmi, needWidth || mlimit < measureLimit);
            } else {
                j = i;
                while (j < mlimit) {
                    int jnext = this.mCharacterStyleSpanSet.getNextTransition(this.mStart + j, this.mStart + mlimit) - this.mStart;
                    wp.set(this.mPaint);
                    for (int k = 0; k < this.mCharacterStyleSpanSet.numberOfSpans; ++k) {
                        if (this.mCharacterStyleSpanSet.spanStarts[k] >= this.mStart + jnext || this.mCharacterStyleSpanSet.spanEnds[k] <= this.mStart + j) continue;
                        CharacterStyle span = ((CharacterStyle[])this.mCharacterStyleSpanSet.spans)[k];
                        span.updateDrawState(wp);
                    }
                    x += this.handleText(wp, j, jnext, i, inext, runIsRtl, c, x, top, y, bottom, fmi, needWidth || jnext < measureLimit);
                    j = jnext;
                }
            }
            i = inext;
        }
        return x - originalX;
    }

    private void drawTextRun(Canvas c, TextPaint wp, int start, int end, int contextStart, int contextEnd, boolean runIsRtl, float x, int y) {
        int flags;
        int n = flags = runIsRtl ? 1 : 0;
        if (this.mCharsValid) {
            int count = end - start;
            int contextCount = contextEnd - contextStart;
            c.drawTextRun(this.mChars, start, count, contextStart, contextCount, x, (float)y, flags, (Paint)wp);
        } else {
            int delta = this.mStart;
            c.drawTextRun(this.mText, delta + start, delta + end, delta + contextStart, delta + contextEnd, x, (float)y, flags, (Paint)wp);
        }
    }

    float ascent(int pos) {
        MetricAffectingSpan[] spans;
        if (this.mSpanned == null) {
            return this.mPaint.ascent();
        }
        if ((spans = this.mSpanned.getSpans(pos += this.mStart, pos + 1, MetricAffectingSpan.class)).length == 0) {
            return this.mPaint.ascent();
        }
        TextPaint wp = this.mWorkPaint;
        wp.set(this.mPaint);
        for (MetricAffectingSpan span : spans) {
            span.updateMeasureState(wp);
        }
        return wp.ascent();
    }

    float nextTab(float h) {
        if (this.mTabs != null) {
            return this.mTabs.nextTab(h);
        }
        return Layout.TabStops.nextDefaultStop(h, 20);
    }
}

