/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.os.RemoteException;
import android.util.Pool;
import android.util.Poolable;
import android.util.PoolableManager;
import android.util.Pools;
import android.util.SparseLongArray;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewRootImpl;
import android.view.accessibility.AccessibilityInteractionClient;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityNodeProvider;
import android.view.accessibility.IAccessibilityInteractionConnectionCallback;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class AccessibilityInteractionController {
    private static final int POOL_SIZE = 5;
    private ArrayList<AccessibilityNodeInfo> mTempAccessibilityNodeInfoList = new ArrayList();
    private final Handler mHandler;
    private final ViewRootImpl mViewRootImpl;
    private final AccessibilityNodePrefetcher mPrefetcher;
    private final long mMyLooperThreadId;
    private final int mMyProcessId;
    private final ArrayList<View> mTempArrayList = new ArrayList();
    private final Pool<SomeArgs> mPool = Pools.synchronizedPool(Pools.finitePool(new PoolableManager<SomeArgs>(){

        @Override
        public SomeArgs newInstance() {
            return new SomeArgs();
        }

        @Override
        public void onAcquired(SomeArgs info) {
        }

        @Override
        public void onReleased(SomeArgs info) {
            info.clear();
        }
    }, 5));

    public AccessibilityInteractionController(ViewRootImpl viewRootImpl) {
        Looper looper = viewRootImpl.mHandler.getLooper();
        this.mMyLooperThreadId = looper.getThread().getId();
        this.mMyProcessId = Process.myPid();
        this.mHandler = new PrivateHandler(looper);
        this.mViewRootImpl = viewRootImpl;
        this.mPrefetcher = new AccessibilityNodePrefetcher();
    }

    private boolean isShown(View view) {
        return view.mAttachInfo != null && view.mAttachInfo.mWindowVisibility == 0 && view.isShown();
    }

    public void findAccessibilityNodeInfoByAccessibilityIdClientThread(long accessibilityNodeId, int windowLeft, int windowTop, int interactionId, IAccessibilityInteractionConnectionCallback callback, int flags, int interrogatingPid, long interrogatingTid) {
        Message message = this.mHandler.obtainMessage();
        message.what = 2;
        message.arg1 = flags;
        SomeArgs args = this.mPool.acquire();
        args.argi1 = AccessibilityNodeInfo.getAccessibilityViewId(accessibilityNodeId);
        args.argi2 = AccessibilityNodeInfo.getVirtualDescendantId(accessibilityNodeId);
        args.argi3 = interactionId;
        args.arg1 = callback;
        SomeArgs moreArgs = this.mPool.acquire();
        moreArgs.argi1 = windowLeft;
        moreArgs.argi2 = windowTop;
        args.arg2 = moreArgs;
        message.obj = args;
        if (interrogatingPid == this.mMyProcessId && interrogatingTid == this.mMyLooperThreadId) {
            AccessibilityInteractionClient.getInstanceForThread(interrogatingTid).setSameThreadMessage(message);
        } else {
            this.mHandler.sendMessage(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void findAccessibilityNodeInfoByAccessibilityIdUiThread(Message message) {
        block9: {
            ArrayList<AccessibilityNodeInfo> infos;
            IAccessibilityInteractionConnectionCallback callback;
            int interactionId;
            block6: {
                int virtualDescendantId;
                int accessibilityViewId;
                int flags;
                block7: {
                    flags = message.arg1;
                    SomeArgs args = (SomeArgs)message.obj;
                    accessibilityViewId = args.argi1;
                    virtualDescendantId = args.argi2;
                    interactionId = args.argi3;
                    callback = (IAccessibilityInteractionConnectionCallback)args.arg1;
                    SomeArgs moreArgs = (SomeArgs)args.arg2;
                    this.mViewRootImpl.mAttachInfo.mActualWindowLeft = moreArgs.argi1;
                    this.mViewRootImpl.mAttachInfo.mActualWindowTop = moreArgs.argi2;
                    this.mPool.release(moreArgs);
                    this.mPool.release(args);
                    infos = this.mTempAccessibilityNodeInfoList;
                    infos.clear();
                    if (this.mViewRootImpl.mView == null) break block7;
                    if (this.mViewRootImpl.mAttachInfo != null) break block8;
                }
                Object var12_10 = null;
                try {
                    this.mViewRootImpl.mAttachInfo.mIncludeNotImportantViews = false;
                    callback.setFindAccessibilityNodeInfosResult(infos, interactionId);
                    infos.clear();
                }
                catch (RemoteException re) {
                    // empty catch block
                }
                {
                    block8: {
                        return;
                    }
                    this.mViewRootImpl.mAttachInfo.mIncludeNotImportantViews = (flags & 8) != 0;
                    View root = null;
                    root = accessibilityViewId == -1 ? this.mViewRootImpl.mView : this.findViewByAccessibilityId(accessibilityViewId);
                    if (root == null || !this.isShown(root)) break block6;
                    this.mPrefetcher.prefetchAccessibilityNodeInfos(root, virtualDescendantId, flags, infos);
                }
            }
            Object var12_11 = null;
            try {
                this.mViewRootImpl.mAttachInfo.mIncludeNotImportantViews = false;
                callback.setFindAccessibilityNodeInfosResult(infos, interactionId);
                infos.clear();
            }
            catch (RemoteException re) {}
            break block9;
            catch (Throwable throwable) {
                Object var12_12 = null;
                try {
                    this.mViewRootImpl.mAttachInfo.mIncludeNotImportantViews = false;
                    callback.setFindAccessibilityNodeInfosResult(infos, interactionId);
                    infos.clear();
                }
                catch (RemoteException re) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public void findAccessibilityNodeInfoByViewIdClientThread(long accessibilityNodeId, int viewId, int windowLeft, int windowTop, int interactionId, IAccessibilityInteractionConnectionCallback callback, int flags, int interrogatingPid, long interrogatingTid) {
        Message message = this.mHandler.obtainMessage();
        message.what = 3;
        message.arg1 = flags;
        message.arg2 = AccessibilityNodeInfo.getAccessibilityViewId(accessibilityNodeId);
        SomeArgs args = this.mPool.acquire();
        args.argi1 = viewId;
        args.argi2 = interactionId;
        args.arg1 = callback;
        SomeArgs moreArgs = this.mPool.acquire();
        moreArgs.argi1 = windowLeft;
        moreArgs.argi2 = windowTop;
        args.arg2 = moreArgs;
        message.obj = args;
        if (interrogatingPid == this.mMyProcessId && interrogatingTid == this.mMyLooperThreadId) {
            AccessibilityInteractionClient.getInstanceForThread(interrogatingTid).setSameThreadMessage(message);
        } else {
            this.mHandler.sendMessage(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void findAccessibilityNodeInfoByViewIdUiThread(Message message) {
        block9: {
            AccessibilityNodeInfo info;
            IAccessibilityInteractionConnectionCallback callback;
            int interactionId;
            block6: {
                int viewId;
                int accessibilityViewId;
                int flags;
                block7: {
                    flags = message.arg1;
                    accessibilityViewId = message.arg2;
                    SomeArgs args = (SomeArgs)message.obj;
                    viewId = args.argi1;
                    interactionId = args.argi2;
                    callback = (IAccessibilityInteractionConnectionCallback)args.arg1;
                    SomeArgs moreArgs = (SomeArgs)args.arg2;
                    this.mViewRootImpl.mAttachInfo.mActualWindowLeft = moreArgs.argi1;
                    this.mViewRootImpl.mAttachInfo.mActualWindowTop = moreArgs.argi2;
                    this.mPool.release(moreArgs);
                    this.mPool.release(args);
                    info = null;
                    if (this.mViewRootImpl.mView == null) break block7;
                    if (this.mViewRootImpl.mAttachInfo != null) break block8;
                }
                Object var13_10 = null;
                try {
                    this.mViewRootImpl.mAttachInfo.mIncludeNotImportantViews = false;
                    callback.setFindAccessibilityNodeInfoResult(info, interactionId);
                }
                catch (RemoteException re) {
                    // empty catch block
                }
                {
                    View target;
                    block8: {
                        return;
                    }
                    this.mViewRootImpl.mAttachInfo.mIncludeNotImportantViews = (flags & 8) != 0;
                    View root = null;
                    root = accessibilityViewId != -1 ? this.findViewByAccessibilityId(accessibilityViewId) : this.mViewRootImpl.mView;
                    if (root == null || (target = root.findViewById(viewId)) == null || !this.isShown(target)) break block6;
                    info = target.createAccessibilityNodeInfo();
                }
            }
            Object var13_11 = null;
            try {
                this.mViewRootImpl.mAttachInfo.mIncludeNotImportantViews = false;
                callback.setFindAccessibilityNodeInfoResult(info, interactionId);
            }
            catch (RemoteException re) {}
            break block9;
            catch (Throwable throwable) {
                Object var13_12 = null;
                try {
                    this.mViewRootImpl.mAttachInfo.mIncludeNotImportantViews = false;
                    callback.setFindAccessibilityNodeInfoResult(info, interactionId);
                }
                catch (RemoteException re) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public void findAccessibilityNodeInfosByTextClientThread(long accessibilityNodeId, String text, int windowLeft, int windowTop, int interactionId, IAccessibilityInteractionConnectionCallback callback, int flags, int interrogatingPid, long interrogatingTid) {
        Message message = this.mHandler.obtainMessage();
        message.what = 4;
        message.arg1 = flags;
        SomeArgs args = this.mPool.acquire();
        args.arg1 = text;
        args.argi1 = AccessibilityNodeInfo.getAccessibilityViewId(accessibilityNodeId);
        args.argi2 = AccessibilityNodeInfo.getVirtualDescendantId(accessibilityNodeId);
        args.argi3 = interactionId;
        SomeArgs moreArgs = this.mPool.acquire();
        moreArgs.arg1 = callback;
        moreArgs.argi1 = windowLeft;
        moreArgs.argi2 = windowTop;
        args.arg2 = moreArgs;
        message.obj = args;
        if (interrogatingPid == this.mMyProcessId && interrogatingTid == this.mMyLooperThreadId) {
            AccessibilityInteractionClient.getInstanceForThread(interrogatingTid).setSameThreadMessage(message);
        } else {
            this.mHandler.sendMessage(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void findAccessibilityNodeInfosByTextUiThread(Message message) {
        block12: {
            List<AccessibilityNodeInfo> infos;
            IAccessibilityInteractionConnectionCallback callback;
            int interactionId;
            block9: {
                int virtualDescendantId;
                int accessibilityViewId;
                String text;
                int flags;
                block10: {
                    flags = message.arg1;
                    SomeArgs args = (SomeArgs)message.obj;
                    text = (String)args.arg1;
                    accessibilityViewId = args.argi1;
                    virtualDescendantId = args.argi2;
                    interactionId = args.argi3;
                    SomeArgs moreArgs = (SomeArgs)args.arg2;
                    callback = (IAccessibilityInteractionConnectionCallback)moreArgs.arg1;
                    this.mViewRootImpl.mAttachInfo.mActualWindowLeft = moreArgs.argi1;
                    this.mViewRootImpl.mAttachInfo.mActualWindowTop = moreArgs.argi2;
                    this.mPool.release(moreArgs);
                    this.mPool.release(args);
                    infos = null;
                    if (this.mViewRootImpl.mView == null) break block10;
                    if (this.mViewRootImpl.mAttachInfo != null) break block11;
                }
                Object var19_11 = null;
                try {
                    this.mViewRootImpl.mAttachInfo.mIncludeNotImportantViews = false;
                    callback.setFindAccessibilityNodeInfosResult(infos, interactionId);
                }
                catch (RemoteException re) {
                    // empty catch block
                }
                {
                    block11: {
                        return;
                    }
                    this.mViewRootImpl.mAttachInfo.mIncludeNotImportantViews = (flags & 8) != 0;
                    View root = null;
                    root = accessibilityViewId != -1 ? this.findViewByAccessibilityId(accessibilityViewId) : this.mViewRootImpl.mView;
                    if (root == null || !this.isShown(root)) break block9;
                    AccessibilityNodeProvider provider = root.getAccessibilityNodeProvider();
                    if (provider != null) {
                        infos = provider.findAccessibilityNodeInfosByText(text, virtualDescendantId);
                        break block9;
                    }
                    if (virtualDescendantId != -1) break block9;
                    ArrayList<View> foundViews = this.mTempArrayList;
                    foundViews.clear();
                    root.findViewsWithText(foundViews, text, 7);
                    if (foundViews.isEmpty()) break block9;
                    infos = this.mTempAccessibilityNodeInfoList;
                    infos.clear();
                    int viewCount = foundViews.size();
                    for (int i = 0; i < viewCount; ++i) {
                        View foundView = foundViews.get(i);
                        if (!this.isShown(foundView)) continue;
                        provider = foundView.getAccessibilityNodeProvider();
                        if (provider != null) {
                            List<AccessibilityNodeInfo> infosFromProvider = provider.findAccessibilityNodeInfosByText(text, -1);
                            if (infosFromProvider == null) continue;
                            infos.addAll(infosFromProvider);
                            continue;
                        }
                        infos.add(foundView.createAccessibilityNodeInfo());
                    }
                }
            }
            Object var19_12 = null;
            try {
                this.mViewRootImpl.mAttachInfo.mIncludeNotImportantViews = false;
                callback.setFindAccessibilityNodeInfosResult(infos, interactionId);
            }
            catch (RemoteException re) {}
            break block12;
            catch (Throwable throwable) {
                Object var19_13 = null;
                try {
                    this.mViewRootImpl.mAttachInfo.mIncludeNotImportantViews = false;
                    callback.setFindAccessibilityNodeInfosResult(infos, interactionId);
                }
                catch (RemoteException re) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public void findFocusClientThread(long accessibilityNodeId, int focusType, int windowLeft, int windowTop, int interactionId, IAccessibilityInteractionConnectionCallback callback, int flags, int interogatingPid, long interrogatingTid) {
        Message message = this.mHandler.obtainMessage();
        message.what = 5;
        message.arg1 = flags;
        message.arg2 = focusType;
        SomeArgs args = this.mPool.acquire();
        args.argi1 = interactionId;
        args.argi2 = AccessibilityNodeInfo.getAccessibilityViewId(accessibilityNodeId);
        args.argi3 = AccessibilityNodeInfo.getVirtualDescendantId(accessibilityNodeId);
        args.arg1 = callback;
        SomeArgs moreArgs = this.mPool.acquire();
        moreArgs.argi1 = windowLeft;
        moreArgs.argi2 = windowTop;
        args.arg2 = moreArgs;
        message.obj = args;
        if (interogatingPid == this.mMyProcessId && interrogatingTid == this.mMyLooperThreadId) {
            AccessibilityInteractionClient.getInstanceForThread(interrogatingTid).setSameThreadMessage(message);
        } else {
            this.mHandler.sendMessage(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void findFocusUiThread(Message message) {
        block19: {
            AccessibilityNodeInfo focused;
            IAccessibilityInteractionConnectionCallback callback;
            int interactionId;
            block16: {
                int virtualDescendantId;
                int accessibilityViewId;
                int focusType;
                int flags;
                block17: {
                    flags = message.arg1;
                    focusType = message.arg2;
                    SomeArgs args = (SomeArgs)message.obj;
                    interactionId = args.argi1;
                    accessibilityViewId = args.argi2;
                    virtualDescendantId = args.argi3;
                    callback = (IAccessibilityInteractionConnectionCallback)args.arg1;
                    SomeArgs moreArgs = (SomeArgs)args.arg2;
                    this.mViewRootImpl.mAttachInfo.mActualWindowLeft = moreArgs.argi1;
                    this.mViewRootImpl.mAttachInfo.mActualWindowTop = moreArgs.argi2;
                    this.mPool.release(moreArgs);
                    this.mPool.release(args);
                    focused = null;
                    if (this.mViewRootImpl.mView == null) break block17;
                    if (this.mViewRootImpl.mAttachInfo != null) break block18;
                }
                Object var15_11 = null;
                try {
                    this.mViewRootImpl.mAttachInfo.mIncludeNotImportantViews = false;
                    callback.setFindAccessibilityNodeInfoResult(focused, interactionId);
                }
                catch (RemoteException re) {
                    // empty catch block
                }
                {
                    block18: {
                        return;
                    }
                    this.mViewRootImpl.mAttachInfo.mIncludeNotImportantViews = (flags & 8) != 0;
                    View root = null;
                    root = accessibilityViewId != -1 ? this.findViewByAccessibilityId(accessibilityViewId) : this.mViewRootImpl.mView;
                    if (root == null || !this.isShown(root)) break block16;
                    switch (focusType) {
                        case 2: {
                            View host = this.mViewRootImpl.mAccessibilityFocusedHost;
                            if (host != null) {
                                if (!ViewRootImpl.isViewDescendantOf(host, root)) break;
                                AccessibilityNodeProvider provider = host.getAccessibilityNodeProvider();
                                if (provider != null) {
                                    if (this.mViewRootImpl.mAccessibilityFocusedVirtualView != null) {
                                        focused = AccessibilityNodeInfo.obtain(this.mViewRootImpl.mAccessibilityFocusedVirtualView);
                                    }
                                } else if (virtualDescendantId == -1) {
                                    focused = host.createAccessibilityNodeInfo();
                                }
                            }
                            break;
                        }
                        case 1: {
                            View target = root.findFocus();
                            if (target != null && this.isShown(target)) {
                                focused = target.createAccessibilityNodeInfo();
                            }
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown focus type: " + focusType);
                        }
                    }
                }
            }
            Object var15_12 = null;
            try {
                this.mViewRootImpl.mAttachInfo.mIncludeNotImportantViews = false;
                callback.setFindAccessibilityNodeInfoResult(focused, interactionId);
            }
            catch (RemoteException re) {}
            break block19;
            catch (Throwable throwable) {
                Object var15_13 = null;
                try {
                    this.mViewRootImpl.mAttachInfo.mIncludeNotImportantViews = false;
                    callback.setFindAccessibilityNodeInfoResult(focused, interactionId);
                }
                catch (RemoteException re) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public void focusSearchClientThread(long accessibilityNodeId, int direction, int windowLeft, int windowTop, int interactionId, IAccessibilityInteractionConnectionCallback callback, int flags, int interogatingPid, long interrogatingTid) {
        Message message = this.mHandler.obtainMessage();
        message.what = 6;
        message.arg1 = flags;
        message.arg2 = AccessibilityNodeInfo.getAccessibilityViewId(accessibilityNodeId);
        SomeArgs args = this.mPool.acquire();
        args.argi1 = AccessibilityNodeInfo.getVirtualDescendantId(accessibilityNodeId);
        args.argi2 = direction;
        args.argi3 = interactionId;
        args.arg1 = callback;
        SomeArgs moreArgs = this.mPool.acquire();
        moreArgs.argi1 = windowLeft;
        moreArgs.argi2 = windowTop;
        args.arg2 = moreArgs;
        message.obj = args;
        if (interogatingPid == this.mMyProcessId && interrogatingTid == this.mMyLooperThreadId) {
            AccessibilityInteractionClient.getInstanceForThread(interrogatingTid).setSameThreadMessage(message);
        } else {
            this.mHandler.sendMessage(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void focusSearchUiThread(Message message) {
        block16: {
            AccessibilityNodeInfo next;
            IAccessibilityInteractionConnectionCallback callback;
            int interactionId;
            block11: {
                AccessibilityNodeProvider provider;
                View root;
                int direction;
                int virtualDescendantId;
                int accessibilityViewId;
                int flags;
                block12: {
                    flags = message.arg1;
                    accessibilityViewId = message.arg2;
                    SomeArgs args = (SomeArgs)message.obj;
                    virtualDescendantId = args.argi1;
                    direction = args.argi2;
                    interactionId = args.argi3;
                    callback = (IAccessibilityInteractionConnectionCallback)args.arg1;
                    SomeArgs moreArgs = (SomeArgs)args.arg2;
                    this.mViewRootImpl.mAttachInfo.mActualWindowLeft = moreArgs.argi1;
                    this.mViewRootImpl.mAttachInfo.mActualWindowTop = moreArgs.argi2;
                    this.mPool.release(moreArgs);
                    this.mPool.release(args);
                    next = null;
                    if (this.mViewRootImpl.mView == null) break block12;
                    if (this.mViewRootImpl.mAttachInfo != null) break block13;
                }
                Object var15_11 = null;
                try {
                    this.mViewRootImpl.mAttachInfo.mIncludeNotImportantViews = false;
                    callback.setFindAccessibilityNodeInfoResult(next, interactionId);
                }
                catch (RemoteException re) {
                    // empty catch block
                }
                {
                    block13: {
                        return;
                    }
                    this.mViewRootImpl.mAttachInfo.mIncludeNotImportantViews = (flags & 8) != 0;
                    root = null;
                    root = accessibilityViewId != -1 ? this.findViewByAccessibilityId(accessibilityViewId) : this.mViewRootImpl.mView;
                    if (root == null || !this.isShown(root)) break block11;
                    if ((direction & 0x1000) != 4096) break block14;
                    provider = root.getAccessibilityNodeProvider();
                    if (provider == null || (next = provider.accessibilityFocusSearch(direction, virtualDescendantId)) == null) break block15;
                }
                Object var15_12 = null;
                try {
                    this.mViewRootImpl.mAttachInfo.mIncludeNotImportantViews = false;
                    callback.setFindAccessibilityNodeInfoResult(next, interactionId);
                }
                catch (RemoteException re) {
                    // empty catch block
                }
                {
                    block14: {
                        block15: {
                            return;
                        }
                        for (View nextView = root.focusSearch(direction); nextView != null; nextView = nextView.focusSearch(direction)) {
                            provider = nextView.getAccessibilityNodeProvider();
                            if (provider != null) {
                                next = provider.accessibilityFocusSearch(direction, -1);
                                if (next == null) {
                                    continue;
                                }
                            } else {
                                next = nextView.createAccessibilityNodeInfo();
                            }
                            break block11;
                        }
                        break block11;
                    }
                    View nextView = root.focusSearch(direction);
                    if (nextView == null) break block11;
                    next = nextView.createAccessibilityNodeInfo();
                }
            }
            Object var15_13 = null;
            try {
                this.mViewRootImpl.mAttachInfo.mIncludeNotImportantViews = false;
                callback.setFindAccessibilityNodeInfoResult(next, interactionId);
            }
            catch (RemoteException re) {}
            break block16;
            catch (Throwable throwable) {
                Object var15_14 = null;
                try {
                    this.mViewRootImpl.mAttachInfo.mIncludeNotImportantViews = false;
                    callback.setFindAccessibilityNodeInfoResult(next, interactionId);
                }
                catch (RemoteException re) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public void performAccessibilityActionClientThread(long accessibilityNodeId, int action, Bundle arguments, int interactionId, IAccessibilityInteractionConnectionCallback callback, int flags, int interogatingPid, long interrogatingTid) {
        Message message = this.mHandler.obtainMessage();
        message.what = 1;
        message.arg1 = flags;
        message.arg2 = AccessibilityNodeInfo.getAccessibilityViewId(accessibilityNodeId);
        SomeArgs args = this.mPool.acquire();
        args.argi1 = AccessibilityNodeInfo.getVirtualDescendantId(accessibilityNodeId);
        args.argi2 = action;
        args.argi3 = interactionId;
        args.arg1 = callback;
        args.arg2 = arguments;
        message.obj = args;
        if (interogatingPid == this.mMyProcessId && interrogatingTid == this.mMyLooperThreadId) {
            AccessibilityInteractionClient.getInstanceForThread(interrogatingTid).setSameThreadMessage(message);
        } else {
            this.mHandler.sendMessage(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void perfromAccessibilityActionUiThread(Message message) {
        block10: {
            boolean succeeded;
            IAccessibilityInteractionConnectionCallback callback;
            int interactionId;
            block7: {
                Bundle arguments;
                int action;
                int virtualDescendantId;
                int accessibilityViewId;
                int flags;
                block8: {
                    flags = message.arg1;
                    accessibilityViewId = message.arg2;
                    SomeArgs args = (SomeArgs)message.obj;
                    virtualDescendantId = args.argi1;
                    action = args.argi2;
                    interactionId = args.argi3;
                    callback = (IAccessibilityInteractionConnectionCallback)args.arg1;
                    arguments = (Bundle)args.arg2;
                    this.mPool.release(args);
                    succeeded = false;
                    if (this.mViewRootImpl.mView == null) break block8;
                    if (this.mViewRootImpl.mAttachInfo != null) break block9;
                }
                Object var14_11 = null;
                try {
                    this.mViewRootImpl.mAttachInfo.mIncludeNotImportantViews = false;
                    callback.setPerformAccessibilityActionResult(succeeded, interactionId);
                }
                catch (RemoteException re) {
                    // empty catch block
                }
                {
                    block9: {
                        return;
                    }
                    this.mViewRootImpl.mAttachInfo.mIncludeNotImportantViews = (flags & 8) != 0;
                    View target = null;
                    target = accessibilityViewId != -1 ? this.findViewByAccessibilityId(accessibilityViewId) : this.mViewRootImpl.mView;
                    if (target == null || !this.isShown(target)) break block7;
                    AccessibilityNodeProvider provider = target.getAccessibilityNodeProvider();
                    if (provider != null) {
                        succeeded = provider.performAction(virtualDescendantId, action, arguments);
                        break block7;
                    }
                    if (virtualDescendantId != -1) break block7;
                    succeeded = target.performAccessibilityAction(action, arguments);
                }
            }
            Object var14_12 = null;
            try {
                this.mViewRootImpl.mAttachInfo.mIncludeNotImportantViews = false;
                callback.setPerformAccessibilityActionResult(succeeded, interactionId);
            }
            catch (RemoteException re) {}
            break block10;
            catch (Throwable throwable) {
                Object var14_13 = null;
                try {
                    this.mViewRootImpl.mAttachInfo.mIncludeNotImportantViews = false;
                    callback.setPerformAccessibilityActionResult(succeeded, interactionId);
                }
                catch (RemoteException re) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private View findViewByAccessibilityId(int accessibilityId) {
        View root = this.mViewRootImpl.mView;
        if (root == null) {
            return null;
        }
        View foundView = root.findViewByAccessibilityId(accessibilityId);
        if (foundView != null && !this.isShown(foundView)) {
            return null;
        }
        return foundView;
    }

    private class PrivateHandler
    extends Handler {
        private static final int MSG_PERFORM_ACCESSIBILITY_ACTION = 1;
        private static final int MSG_FIND_ACCESSIBLITY_NODE_INFO_BY_ACCESSIBILITY_ID = 2;
        private static final int MSG_FIND_ACCESSIBLITY_NODE_INFO_BY_VIEW_ID = 3;
        private static final int MSG_FIND_ACCESSIBLITY_NODE_INFO_BY_TEXT = 4;
        private static final int MSG_FIND_FOCUS = 5;
        private static final int MSG_FOCUS_SEARCH = 6;

        public PrivateHandler(Looper looper) {
            super(looper);
        }

        public String getMessageName(Message message) {
            int type = message.what;
            switch (type) {
                case 1: {
                    return "MSG_PERFORM_ACCESSIBILITY_ACTION";
                }
                case 2: {
                    return "MSG_FIND_ACCESSIBLITY_NODE_INFO_BY_ACCESSIBILITY_ID";
                }
                case 3: {
                    return "MSG_FIND_ACCESSIBLITY_NODE_INFO_BY_VIEW_ID";
                }
                case 4: {
                    return "MSG_FIND_ACCESSIBLITY_NODE_INFO_BY_TEXT";
                }
                case 5: {
                    return "MSG_FIND_FOCUS";
                }
                case 6: {
                    return "MSG_FOCUS_SEARCH";
                }
            }
            throw new IllegalArgumentException("Unknown message type: " + type);
        }

        public void handleMessage(Message message) {
            int type = message.what;
            switch (type) {
                case 2: {
                    AccessibilityInteractionController.this.findAccessibilityNodeInfoByAccessibilityIdUiThread(message);
                    break;
                }
                case 1: {
                    AccessibilityInteractionController.this.perfromAccessibilityActionUiThread(message);
                    break;
                }
                case 3: {
                    AccessibilityInteractionController.this.findAccessibilityNodeInfoByViewIdUiThread(message);
                    break;
                }
                case 4: {
                    AccessibilityInteractionController.this.findAccessibilityNodeInfosByTextUiThread(message);
                    break;
                }
                case 5: {
                    AccessibilityInteractionController.this.findFocusUiThread(message);
                    break;
                }
                case 6: {
                    AccessibilityInteractionController.this.focusSearchUiThread(message);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown message type: " + type);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AccessibilityNodePrefetcher {
        private static final int MAX_ACCESSIBILITY_NODE_INFO_BATCH_SIZE = 50;
        private final ArrayList<View> mTempViewList = new ArrayList();

        private AccessibilityNodePrefetcher() {
        }

        public void prefetchAccessibilityNodeInfos(View view, int virtualViewId, int prefetchFlags, List<AccessibilityNodeInfo> outInfos) {
            AccessibilityNodeProvider provider = view.getAccessibilityNodeProvider();
            if (provider == null) {
                AccessibilityNodeInfo root = view.createAccessibilityNodeInfo();
                if (root != null) {
                    outInfos.add(root);
                    if ((prefetchFlags & 1) != 0) {
                        this.prefetchPredecessorsOfRealNode(view, outInfos);
                    }
                    if ((prefetchFlags & 2) != 0) {
                        this.prefetchSiblingsOfRealNode(view, outInfos);
                    }
                    if ((prefetchFlags & 4) != 0) {
                        this.prefetchDescendantsOfRealNode(view, outInfos);
                    }
                }
            } else {
                AccessibilityNodeInfo root = provider.createAccessibilityNodeInfo(virtualViewId);
                if (root != null) {
                    outInfos.add(root);
                    if ((prefetchFlags & 1) != 0) {
                        this.prefetchPredecessorsOfVirtualNode(root, view, provider, outInfos);
                    }
                    if ((prefetchFlags & 2) != 0) {
                        this.prefetchSiblingsOfVirtualNode(root, view, provider, outInfos);
                    }
                    if ((prefetchFlags & 4) != 0) {
                        this.prefetchDescendantsOfVirtualNode(root, provider, outInfos);
                    }
                }
            }
        }

        private void prefetchPredecessorsOfRealNode(View view, List<AccessibilityNodeInfo> outInfos) {
            ViewParent parent = view.getParentForAccessibility();
            while (parent instanceof View && outInfos.size() < 50) {
                View parentView = (View)((Object)parent);
                AccessibilityNodeInfo info = parentView.createAccessibilityNodeInfo();
                if (info != null) {
                    outInfos.add(info);
                }
                parent = parent.getParentForAccessibility();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void prefetchSiblingsOfRealNode(View current, List<AccessibilityNodeInfo> outInfos) {
            ViewParent parent = current.getParentForAccessibility();
            if (parent instanceof ViewGroup) {
                ViewGroup parentGroup = (ViewGroup)parent;
                ArrayList<View> children = this.mTempViewList;
                children.clear();
                try {
                    parentGroup.addChildrenForAccessibility(children);
                    int childCount = children.size();
                    for (int i = 0; i < childCount; ++i) {
                        if (outInfos.size() >= 50) {
                            Object var12_11 = null;
                            children.clear();
                            return;
                        }
                        View child = children.get(i);
                        if (child.getAccessibilityViewId() == current.getAccessibilityViewId() || !AccessibilityInteractionController.this.isShown(child)) continue;
                        AccessibilityNodeInfo info = null;
                        AccessibilityNodeProvider provider = child.getAccessibilityNodeProvider();
                        info = provider == null ? child.createAccessibilityNodeInfo() : provider.createAccessibilityNodeInfo(-1);
                        if (info == null) continue;
                        outInfos.add(info);
                    }
                }
                catch (Throwable throwable) {
                    Object var12_13 = null;
                    children.clear();
                    throw throwable;
                }
                Object var12_12 = null;
                children.clear();
                {
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void prefetchDescendantsOfRealNode(View root, List<AccessibilityNodeInfo> outInfos) {
            if (!(root instanceof ViewGroup)) {
                return;
            }
            HashMap<View, AccessibilityNodeInfo> addedChildren = new HashMap<View, AccessibilityNodeInfo>();
            ArrayList<View> children = this.mTempViewList;
            children.clear();
            try {
                root.addChildrenForAccessibility(children);
                int childCount = children.size();
                for (int i = 0; i < childCount; ++i) {
                    AccessibilityNodeInfo info;
                    if (outInfos.size() >= 50) {
                        Object var11_12 = null;
                        children.clear();
                        return;
                    }
                    View child = children.get(i);
                    if (!AccessibilityInteractionController.this.isShown(child)) continue;
                    AccessibilityNodeProvider provider = child.getAccessibilityNodeProvider();
                    if (provider == null) {
                        info = child.createAccessibilityNodeInfo();
                        if (info == null) continue;
                        outInfos.add(info);
                        addedChildren.put(child, null);
                        continue;
                    }
                    info = provider.createAccessibilityNodeInfo(-1);
                    if (info == null) continue;
                    outInfos.add(info);
                    addedChildren.put(child, info);
                }
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                children.clear();
                throw throwable;
            }
            Object var11_13 = null;
            children.clear();
            if (outInfos.size() < 50) {
                for (Map.Entry entry : addedChildren.entrySet()) {
                    View addedChild = (View)entry.getKey();
                    AccessibilityNodeInfo virtualRoot = (AccessibilityNodeInfo)entry.getValue();
                    if (virtualRoot == null) {
                        this.prefetchDescendantsOfRealNode(addedChild, outInfos);
                        continue;
                    }
                    AccessibilityNodeProvider provider = addedChild.getAccessibilityNodeProvider();
                    this.prefetchDescendantsOfVirtualNode(virtualRoot, provider, outInfos);
                }
            }
        }

        private void prefetchPredecessorsOfVirtualNode(AccessibilityNodeInfo root, View providerHost, AccessibilityNodeProvider provider, List<AccessibilityNodeInfo> outInfos) {
            long parentNodeId = root.getParentNodeId();
            int accessibilityViewId = AccessibilityNodeInfo.getAccessibilityViewId(parentNodeId);
            while (accessibilityViewId != -1) {
                if (outInfos.size() >= 50) {
                    return;
                }
                int virtualDescendantId = AccessibilityNodeInfo.getVirtualDescendantId(parentNodeId);
                if (virtualDescendantId != -1 || accessibilityViewId == providerHost.getAccessibilityViewId()) {
                    AccessibilityNodeInfo parent = provider.createAccessibilityNodeInfo(virtualDescendantId);
                    if (parent != null) {
                        outInfos.add(parent);
                    }
                    parentNodeId = parent.getParentNodeId();
                    accessibilityViewId = AccessibilityNodeInfo.getAccessibilityViewId(parentNodeId);
                    continue;
                }
                this.prefetchPredecessorsOfRealNode(providerHost, outInfos);
                return;
            }
        }

        private void prefetchSiblingsOfVirtualNode(AccessibilityNodeInfo current, View providerHost, AccessibilityNodeProvider provider, List<AccessibilityNodeInfo> outInfos) {
            long parentNodeId = current.getParentNodeId();
            int parentAccessibilityViewId = AccessibilityNodeInfo.getAccessibilityViewId(parentNodeId);
            int parentVirtualDescendantId = AccessibilityNodeInfo.getVirtualDescendantId(parentNodeId);
            if (parentVirtualDescendantId != -1 || parentAccessibilityViewId == providerHost.getAccessibilityViewId()) {
                AccessibilityNodeInfo parent = provider.createAccessibilityNodeInfo(parentVirtualDescendantId);
                if (parent != null) {
                    SparseLongArray childNodeIds = parent.getChildNodeIds();
                    int childCount = childNodeIds.size();
                    for (int i = 0; i < childCount; ++i) {
                        int childVirtualDescendantId;
                        AccessibilityNodeInfo child;
                        if (outInfos.size() >= 50) {
                            return;
                        }
                        long childNodeId = childNodeIds.get(i);
                        if (childNodeId == current.getSourceNodeId() || (child = provider.createAccessibilityNodeInfo(childVirtualDescendantId = AccessibilityNodeInfo.getVirtualDescendantId(childNodeId))) == null) continue;
                        outInfos.add(child);
                    }
                }
            } else {
                this.prefetchSiblingsOfRealNode(providerHost, outInfos);
            }
        }

        private void prefetchDescendantsOfVirtualNode(AccessibilityNodeInfo root, AccessibilityNodeProvider provider, List<AccessibilityNodeInfo> outInfos) {
            SparseLongArray childNodeIds = root.getChildNodeIds();
            int initialOutInfosSize = outInfos.size();
            int childCount = childNodeIds.size();
            for (int i = 0; i < childCount; ++i) {
                if (outInfos.size() >= 50) {
                    return;
                }
                long childNodeId = childNodeIds.get(i);
                AccessibilityNodeInfo child = provider.createAccessibilityNodeInfo(AccessibilityNodeInfo.getVirtualDescendantId(childNodeId));
                if (child == null) continue;
                outInfos.add(child);
            }
            if (outInfos.size() < 50) {
                int addedChildCount = outInfos.size() - initialOutInfosSize;
                for (int i = 0; i < addedChildCount; ++i) {
                    AccessibilityNodeInfo child = outInfos.get(initialOutInfosSize + i);
                    this.prefetchDescendantsOfVirtualNode(child, provider, outInfos);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SomeArgs
    implements Poolable<SomeArgs> {
        private SomeArgs mNext;
        private boolean mIsPooled;
        public Object arg1;
        public Object arg2;
        public int argi1;
        public int argi2;
        public int argi3;

        private SomeArgs() {
        }

        @Override
        public SomeArgs getNextPoolable() {
            return this.mNext;
        }

        @Override
        public boolean isPooled() {
            return this.mIsPooled;
        }

        @Override
        public void setNextPoolable(SomeArgs args) {
            this.mNext = args;
        }

        @Override
        public void setPooled(boolean isPooled) {
            this.mIsPooled = isPooled;
        }

        private void clear() {
            this.arg1 = null;
            this.arg2 = null;
            this.argi1 = 0;
            this.argi2 = 0;
            this.argi3 = 0;
        }
    }
}

