/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.os.Looper;
import android.os.MessageQueue;
import android.util.Log;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.system.CloseGuard;

public abstract class DisplayEventReceiver {
    private static final String TAG = "DisplayEventReceiver";
    private final CloseGuard mCloseGuard = CloseGuard.get();
    private int mReceiverPtr;
    private MessageQueue mMessageQueue;

    private static int nativeInit(DisplayEventReceiver displayEventReceiver, MessageQueue messageQueue) {
        return OverrideMethod.invokeI("android.view.DisplayEventReceiver#nativeInit(Landroid/view/DisplayEventReceiver;Landroid/os/MessageQueue;)I", true, null);
    }

    private static void nativeDispose(int n) {
        OverrideMethod.invokeV("android.view.DisplayEventReceiver#nativeDispose(I)V", true, null);
    }

    private static void nativeScheduleVsync(int n) {
        OverrideMethod.invokeV("android.view.DisplayEventReceiver#nativeScheduleVsync(I)V", true, null);
    }

    public DisplayEventReceiver(Looper looper) {
        if (looper == null) {
            throw new IllegalArgumentException("looper must not be null");
        }
        this.mMessageQueue = looper.getQueue();
        this.mReceiverPtr = DisplayEventReceiver.nativeInit(this, this.mMessageQueue);
        this.mCloseGuard.open("dispose");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.dispose();
        }
        finally {
            super.finalize();
        }
    }

    public void dispose() {
        if (this.mCloseGuard != null) {
            this.mCloseGuard.close();
        }
        if (this.mReceiverPtr != 0) {
            DisplayEventReceiver.nativeDispose(this.mReceiverPtr);
            this.mReceiverPtr = 0;
        }
        this.mMessageQueue = null;
    }

    public void onVsync(long timestampNanos, int frame) {
    }

    public void scheduleVsync() {
        if (this.mReceiverPtr == 0) {
            Log.w(TAG, "Attempted to schedule a vertical sync pulse but the display event receiver has already been disposed.");
        } else {
            DisplayEventReceiver.nativeScheduleVsync(this.mReceiverPtr);
        }
    }

    private void dispatchVsync(long timestampNanos, int frame) {
        this.onVsync(timestampNanos, frame);
    }
}

