/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.hardware.input.InputManager;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AndroidRuntimeException;
import android.util.SparseIntArray;
import android.view.InputDevice;
import android.view.KeyEvent;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.text.Normalizer;

public class KeyCharacterMap
implements Parcelable {
    @Deprecated
    public static final int BUILT_IN_KEYBOARD = 0;
    public static final int VIRTUAL_KEYBOARD = -1;
    public static final int NUMERIC = 1;
    public static final int PREDICTIVE = 2;
    public static final int ALPHA = 3;
    public static final int FULL = 4;
    public static final int SPECIAL_FUNCTION = 5;
    public static final char HEX_INPUT = '\uef00';
    public static final char PICKER_DIALOG_INPUT = '\uef01';
    public static final int MODIFIER_BEHAVIOR_CHORDED = 0;
    public static final int MODIFIER_BEHAVIOR_CHORDED_OR_TOGGLED = 1;
    public static final int COMBINING_ACCENT = Integer.MIN_VALUE;
    public static final int COMBINING_ACCENT_MASK = Integer.MAX_VALUE;
    private static final int ACCENT_ACUTE = 180;
    private static final int ACCENT_BREVE = 728;
    private static final int ACCENT_CARON = 711;
    private static final int ACCENT_CEDILLA = 184;
    private static final int ACCENT_CIRCUMFLEX = 710;
    private static final int ACCENT_COMMA_ABOVE = 8125;
    private static final int ACCENT_COMMA_ABOVE_RIGHT = 700;
    private static final int ACCENT_DOT_ABOVE = 729;
    private static final int ACCENT_DOT_BELOW = 46;
    private static final int ACCENT_DOUBLE_ACUTE = 733;
    private static final int ACCENT_GRAVE = 715;
    private static final int ACCENT_HOOK_ABOVE = 704;
    private static final int ACCENT_HORN = 39;
    private static final int ACCENT_MACRON = 175;
    private static final int ACCENT_MACRON_BELOW = 717;
    private static final int ACCENT_OGONEK = 731;
    private static final int ACCENT_REVERSED_COMMA_ABOVE = 701;
    private static final int ACCENT_RING_ABOVE = 730;
    private static final int ACCENT_STROKE = 45;
    private static final int ACCENT_TILDE = 732;
    private static final int ACCENT_TURNED_COMMA_ABOVE = 699;
    private static final int ACCENT_UMLAUT = 168;
    private static final int ACCENT_VERTICAL_LINE_ABOVE = 712;
    private static final int ACCENT_VERTICAL_LINE_BELOW = 716;
    private static final int ACCENT_GRAVE_LEGACY = 96;
    private static final int ACCENT_CIRCUMFLEX_LEGACY = 94;
    private static final int ACCENT_TILDE_LEGACY = 126;
    private static final SparseIntArray sCombiningToAccent = new SparseIntArray();
    private static final SparseIntArray sAccentToCombining = new SparseIntArray();
    private static final SparseIntArray sDeadKeyCache;
    private static final StringBuilder sDeadKeyBuilder;
    public static final Parcelable.Creator<KeyCharacterMap> CREATOR;
    private int mPtr;

    private static void addCombining(int combining, int accent) {
        sCombiningToAccent.append(combining, accent);
        sAccentToCombining.append(accent, combining);
    }

    private static void addDeadKey(int accent, int c, int result) {
        int combining = sAccentToCombining.get(accent);
        if (combining == 0) {
            throw new IllegalStateException("Invalid dead key declaration.");
        }
        int combination = combining << 16 | c;
        sDeadKeyCache.put(combination, result);
    }

    private static int nativeReadFromParcel(Parcel parcel) {
        return OverrideMethod.invokeI("android.view.KeyCharacterMap#nativeReadFromParcel(Landroid/os/Parcel;)I", true, null);
    }

    private static void nativeWriteToParcel(int n, Parcel parcel) {
        OverrideMethod.invokeV("android.view.KeyCharacterMap#nativeWriteToParcel(ILandroid/os/Parcel;)V", true, null);
    }

    private static void nativeDispose(int n) {
        OverrideMethod.invokeV("android.view.KeyCharacterMap#nativeDispose(I)V", true, null);
    }

    private static char nativeGetCharacter(int n, int n2, int n3) {
        return (char)OverrideMethod.invokeI("android.view.KeyCharacterMap#nativeGetCharacter(III)C", true, null);
    }

    private static boolean nativeGetFallbackAction(int n, int n2, int n3, FallbackAction fallbackAction) {
        return OverrideMethod.invokeI("android.view.KeyCharacterMap#nativeGetFallbackAction(IIILandroid/view/KeyCharacterMap$FallbackAction;)Z", true, null) != 0;
    }

    private static char nativeGetNumber(int n, int n2) {
        return (char)OverrideMethod.invokeI("android.view.KeyCharacterMap#nativeGetNumber(II)C", true, null);
    }

    private static char nativeGetMatch(int n, int n2, char[] cArray, int n3) {
        return (char)OverrideMethod.invokeI("android.view.KeyCharacterMap#nativeGetMatch(II[CI)C", true, null);
    }

    private static char nativeGetDisplayLabel(int n, int n2) {
        return (char)OverrideMethod.invokeI("android.view.KeyCharacterMap#nativeGetDisplayLabel(II)C", true, null);
    }

    private static int nativeGetKeyboardType(int n) {
        return OverrideMethod.invokeI("android.view.KeyCharacterMap#nativeGetKeyboardType(I)I", true, null);
    }

    private static KeyEvent[] nativeGetEvents(int n, char[] cArray) {
        return (KeyEvent[])OverrideMethod.invokeA("android.view.KeyCharacterMap#nativeGetEvents(I[C)[Landroid/view/KeyEvent;", true, null);
    }

    private KeyCharacterMap(Parcel in) {
        if (in == null) {
            throw new IllegalArgumentException("parcel must not be null");
        }
        this.mPtr = KeyCharacterMap.nativeReadFromParcel(in);
        if (this.mPtr == 0) {
            throw new RuntimeException("Could not read KeyCharacterMap from parcel.");
        }
    }

    private KeyCharacterMap(int ptr) {
        this.mPtr = ptr;
    }

    protected void finalize() throws Throwable {
        if (this.mPtr != 0) {
            KeyCharacterMap.nativeDispose(this.mPtr);
            this.mPtr = 0;
        }
    }

    public static KeyCharacterMap load(int deviceId) {
        InputManager im = InputManager.getInstance();
        InputDevice inputDevice = im.getInputDevice(deviceId);
        if (inputDevice == null && (inputDevice = im.getInputDevice(-1)) == null) {
            throw new UnavailableException("Could not load key character map for device " + deviceId);
        }
        return inputDevice.getKeyCharacterMap();
    }

    public int get(int keyCode, int metaState) {
        char ch = KeyCharacterMap.nativeGetCharacter(this.mPtr, keyCode, metaState = KeyEvent.normalizeMetaState(metaState));
        int map = sCombiningToAccent.get(ch);
        if (map != 0) {
            return map | Integer.MIN_VALUE;
        }
        return ch;
    }

    public FallbackAction getFallbackAction(int keyCode, int metaState) {
        FallbackAction action = FallbackAction.obtain();
        if (KeyCharacterMap.nativeGetFallbackAction(this.mPtr, keyCode, metaState = KeyEvent.normalizeMetaState(metaState), action)) {
            action.metaState = KeyEvent.normalizeMetaState(action.metaState);
            return action;
        }
        action.recycle();
        return null;
    }

    public char getNumber(int keyCode) {
        return KeyCharacterMap.nativeGetNumber(this.mPtr, keyCode);
    }

    public char getMatch(int keyCode, char[] chars) {
        return this.getMatch(keyCode, chars, 0);
    }

    public char getMatch(int keyCode, char[] chars, int metaState) {
        if (chars == null) {
            throw new IllegalArgumentException("chars must not be null.");
        }
        metaState = KeyEvent.normalizeMetaState(metaState);
        return KeyCharacterMap.nativeGetMatch(this.mPtr, keyCode, chars, metaState);
    }

    public char getDisplayLabel(int keyCode) {
        return KeyCharacterMap.nativeGetDisplayLabel(this.mPtr, keyCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getDeadChar(int accent, int c) {
        int combined;
        int combining = sAccentToCombining.get(accent);
        if (combining == 0) {
            return 0;
        }
        int combination = combining << 16 | c;
        SparseIntArray sparseIntArray = sDeadKeyCache;
        synchronized (sparseIntArray) {
            combined = sDeadKeyCache.get(combination, -1);
            if (combined == -1) {
                sDeadKeyBuilder.setLength(0);
                sDeadKeyBuilder.append((char)c);
                sDeadKeyBuilder.append((char)combining);
                String result = Normalizer.normalize(sDeadKeyBuilder, Normalizer.Form.NFC);
                combined = result.length() == 1 ? (int)result.charAt(0) : 0;
                sDeadKeyCache.put(combination, combined);
            }
        }
        return combined;
    }

    @Deprecated
    public boolean getKeyData(int keyCode, KeyData results) {
        if (results.meta.length < 4) {
            throw new IndexOutOfBoundsException("results.meta.length must be >= 4");
        }
        char displayLabel = KeyCharacterMap.nativeGetDisplayLabel(this.mPtr, keyCode);
        if (displayLabel == '\u0000') {
            return false;
        }
        results.displayLabel = displayLabel;
        results.number = KeyCharacterMap.nativeGetNumber(this.mPtr, keyCode);
        results.meta[0] = KeyCharacterMap.nativeGetCharacter(this.mPtr, keyCode, 0);
        results.meta[1] = KeyCharacterMap.nativeGetCharacter(this.mPtr, keyCode, 1);
        results.meta[2] = KeyCharacterMap.nativeGetCharacter(this.mPtr, keyCode, 2);
        results.meta[3] = KeyCharacterMap.nativeGetCharacter(this.mPtr, keyCode, 3);
        return true;
    }

    public KeyEvent[] getEvents(char[] chars) {
        if (chars == null) {
            throw new IllegalArgumentException("chars must not be null.");
        }
        return KeyCharacterMap.nativeGetEvents(this.mPtr, chars);
    }

    public boolean isPrintingKey(int keyCode) {
        int type = Character.getType(KeyCharacterMap.nativeGetDisplayLabel(this.mPtr, keyCode));
        switch (type) {
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                return false;
            }
        }
        return true;
    }

    public int getKeyboardType() {
        return KeyCharacterMap.nativeGetKeyboardType(this.mPtr);
    }

    public int getModifierBehavior() {
        switch (this.getKeyboardType()) {
            case 4: 
            case 5: {
                return 0;
            }
        }
        return 1;
    }

    public static boolean deviceHasKey(int keyCode) {
        return InputManager.getInstance().deviceHasKeys(new int[]{keyCode})[0];
    }

    public static boolean[] deviceHasKeys(int[] keyCodes) {
        return InputManager.getInstance().deviceHasKeys(keyCodes);
    }

    public void writeToParcel(Parcel out, int flags) {
        if (out == null) {
            throw new IllegalArgumentException("parcel must not be null");
        }
        KeyCharacterMap.nativeWriteToParcel(this.mPtr, out);
    }

    public int describeContents() {
        return 0;
    }

    static {
        KeyCharacterMap.addCombining(768, 715);
        KeyCharacterMap.addCombining(769, 180);
        KeyCharacterMap.addCombining(770, 710);
        KeyCharacterMap.addCombining(771, 732);
        KeyCharacterMap.addCombining(772, 175);
        KeyCharacterMap.addCombining(774, 728);
        KeyCharacterMap.addCombining(775, 729);
        KeyCharacterMap.addCombining(776, 168);
        KeyCharacterMap.addCombining(777, 704);
        KeyCharacterMap.addCombining(778, 730);
        KeyCharacterMap.addCombining(779, 733);
        KeyCharacterMap.addCombining(780, 711);
        KeyCharacterMap.addCombining(781, 712);
        KeyCharacterMap.addCombining(786, 699);
        KeyCharacterMap.addCombining(787, 8125);
        KeyCharacterMap.addCombining(788, 701);
        KeyCharacterMap.addCombining(789, 700);
        KeyCharacterMap.addCombining(795, 39);
        KeyCharacterMap.addCombining(803, 46);
        KeyCharacterMap.addCombining(807, 184);
        KeyCharacterMap.addCombining(808, 731);
        KeyCharacterMap.addCombining(809, 716);
        KeyCharacterMap.addCombining(817, 717);
        KeyCharacterMap.addCombining(821, 45);
        sCombiningToAccent.append(832, 715);
        sCombiningToAccent.append(833, 180);
        sCombiningToAccent.append(835, 8125);
        sAccentToCombining.append(96, 768);
        sAccentToCombining.append(94, 770);
        sAccentToCombining.append(126, 771);
        sDeadKeyCache = new SparseIntArray();
        sDeadKeyBuilder = new StringBuilder();
        KeyCharacterMap.addDeadKey(45, 68, 272);
        KeyCharacterMap.addDeadKey(45, 71, 484);
        KeyCharacterMap.addDeadKey(45, 72, 294);
        KeyCharacterMap.addDeadKey(45, 73, 407);
        KeyCharacterMap.addDeadKey(45, 76, 321);
        KeyCharacterMap.addDeadKey(45, 79, 216);
        KeyCharacterMap.addDeadKey(45, 84, 358);
        KeyCharacterMap.addDeadKey(45, 100, 273);
        KeyCharacterMap.addDeadKey(45, 103, 485);
        KeyCharacterMap.addDeadKey(45, 104, 295);
        KeyCharacterMap.addDeadKey(45, 105, 616);
        KeyCharacterMap.addDeadKey(45, 108, 322);
        KeyCharacterMap.addDeadKey(45, 111, 248);
        KeyCharacterMap.addDeadKey(45, 116, 359);
        CREATOR = new Parcelable.Creator<KeyCharacterMap>(){

            @Override
            public KeyCharacterMap createFromParcel(Parcel in) {
                return new KeyCharacterMap(in);
            }

            public KeyCharacterMap[] newArray(int size) {
                return new KeyCharacterMap[size];
            }
        };
    }

    public static class FallbackAction {
        private static final int MAX_RECYCLED = 10;
        private static final Object sRecycleLock = new Object();
        private static FallbackAction sRecycleBin;
        private static int sRecycledCount;
        private FallbackAction next;
        public int keyCode;
        public int metaState;

        private FallbackAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static FallbackAction obtain() {
            FallbackAction target;
            Object object = sRecycleLock;
            synchronized (object) {
                if (sRecycleBin == null) {
                    target = new FallbackAction();
                } else {
                    target = sRecycleBin;
                    sRecycleBin = target.next;
                    --sRecycledCount;
                    target.next = null;
                }
            }
            return target;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void recycle() {
            Object object = sRecycleLock;
            synchronized (object) {
                if (sRecycledCount < 10) {
                    this.next = sRecycleBin;
                    sRecycleBin = this;
                    ++sRecycledCount;
                } else {
                    this.next = null;
                }
            }
        }
    }

    public static class UnavailableException
    extends AndroidRuntimeException {
        public UnavailableException(String msg) {
            super(msg);
        }
    }

    @Deprecated
    public static class KeyData {
        public static final int META_LENGTH = 4;
        public char displayLabel;
        public char number;
        public char[] meta = new char[4];
    }
}

