/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.SurfaceTexture;
import android.media.MediaPlayer;
import android.net.http.EventHandler;
import android.net.http.Headers;
import android.net.http.RequestHandle;
import android.net.http.RequestQueue;
import android.net.http.SslCertificate;
import android.net.http.SslError;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import android.webkit.HTML5VideoFullScreen;
import android.webkit.HTML5VideoInline;
import android.webkit.HTML5VideoView;
import android.webkit.WebChromeClient;
import android.webkit.WebViewClassic;
import android.webkit.WebViewCore;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

class HTML5VideoViewProxy
extends Handler
implements MediaPlayer.OnPreparedListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnInfoListener,
SurfaceTexture.OnFrameAvailableListener {
    private static final String LOGTAG = "HTML5VideoViewProxy";
    private static final int PLAY = 100;
    private static final int SEEK = 101;
    private static final int PAUSE = 102;
    private static final int ERROR = 103;
    private static final int LOAD_DEFAULT_POSTER = 104;
    private static final int BUFFERING_START = 105;
    private static final int BUFFERING_END = 106;
    private static final int PREPARED = 200;
    private static final int ENDED = 201;
    private static final int POSTER_FETCHED = 202;
    private static final int PAUSED = 203;
    private static final int STOPFULLSCREEN = 204;
    private static final int RESTORESTATE = 205;
    private static final int TIMEUPDATE = 300;
    int mNativePointer;
    private Handler mWebCoreHandler;
    private WebViewClassic mWebView;
    private Bitmap mPoster;
    private PosterDownloader mPosterDownloader;
    private int mSeekPosition;

    public void onPrepared(MediaPlayer mp) {
        VideoPlayer.onPrepared();
        Message msg = Message.obtain(this.mWebCoreHandler, 200);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("dur", new Integer(mp.getDuration()));
        map.put("width", new Integer(mp.getVideoWidth()));
        map.put("height", new Integer(mp.getVideoHeight()));
        msg.obj = map;
        this.mWebCoreHandler.sendMessage(msg);
    }

    public void onCompletion(MediaPlayer mp) {
        this.sendMessage(this.obtainMessage(201, 1, 0));
    }

    public boolean onError(MediaPlayer mp, int what, int extra) {
        this.sendMessage(this.obtainMessage(103));
        return false;
    }

    public void dispatchOnEnded() {
        Message msg = Message.obtain(this.mWebCoreHandler, 201);
        this.mWebCoreHandler.sendMessage(msg);
    }

    public void dispatchOnPaused() {
        Message msg = Message.obtain(this.mWebCoreHandler, 203);
        this.mWebCoreHandler.sendMessage(msg);
    }

    public void dispatchOnStopFullScreen() {
        Message msg = Message.obtain(this.mWebCoreHandler, 204);
        this.mWebCoreHandler.sendMessage(msg);
    }

    public void dispatchOnRestoreState() {
        Message msg = Message.obtain(this.mWebCoreHandler, 205);
        this.mWebCoreHandler.sendMessage(msg);
    }

    public void onTimeupdate() {
        this.sendMessage(this.obtainMessage(300));
    }

    public void onFrameAvailable(SurfaceTexture surfaceTexture) {
        this.mWebView.invalidate();
    }

    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 100: {
                String url = (String)msg.obj;
                WebChromeClient client = this.mWebView.getWebChromeClient();
                int videoLayerID = msg.arg1;
                if (client == null) break;
                VideoPlayer.play(url, this.mSeekPosition, this, client, videoLayerID);
                break;
            }
            case 101: {
                Integer time = (Integer)msg.obj;
                this.mSeekPosition = time;
                VideoPlayer.seek(this.mSeekPosition, this);
                break;
            }
            case 102: {
                VideoPlayer.pause(this);
                break;
            }
            case 201: {
                if (msg.arg1 == 1) {
                    VideoPlayer.isVideoSelfEnded = true;
                }
                VideoPlayer.end();
                break;
            }
            case 103: {
                WebChromeClient client = this.mWebView.getWebChromeClient();
                if (client == null) break;
                client.onHideCustomView();
                break;
            }
            case 104: {
                WebChromeClient client = this.mWebView.getWebChromeClient();
                if (client == null) break;
                this.doSetPoster(client.getDefaultVideoPoster());
                break;
            }
            case 300: {
                if (!VideoPlayer.isPlaying(this)) break;
                this.sendTimeupdate();
                break;
            }
            case 105: {
                VideoPlayer.setPlayerBuffering(true);
                break;
            }
            case 106: {
                VideoPlayer.setPlayerBuffering(false);
            }
        }
    }

    private HTML5VideoViewProxy(WebViewClassic webView, int nativePtr) {
        super(Looper.getMainLooper());
        this.mWebView = webView;
        this.mWebView.setHTML5VideoViewProxy(this);
        this.mNativePointer = nativePtr;
        this.createWebCoreHandler();
    }

    private void createWebCoreHandler() {
        this.mWebCoreHandler = new Handler(){

            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 200: {
                        Map map = (Map)msg.obj;
                        Integer duration = (Integer)map.get("dur");
                        Integer width = (Integer)map.get("width");
                        Integer height = (Integer)map.get("height");
                        HTML5VideoViewProxy.this.nativeOnPrepared(duration, width, height, HTML5VideoViewProxy.this.mNativePointer);
                        break;
                    }
                    case 201: {
                        HTML5VideoViewProxy.this.mSeekPosition = 0;
                        HTML5VideoViewProxy.this.nativeOnEnded(HTML5VideoViewProxy.this.mNativePointer);
                        break;
                    }
                    case 203: {
                        HTML5VideoViewProxy.this.nativeOnPaused(HTML5VideoViewProxy.this.mNativePointer);
                        break;
                    }
                    case 202: {
                        Bitmap poster = (Bitmap)msg.obj;
                        HTML5VideoViewProxy.this.nativeOnPosterFetched(poster, HTML5VideoViewProxy.this.mNativePointer);
                        break;
                    }
                    case 300: {
                        HTML5VideoViewProxy.this.nativeOnTimeupdate(msg.arg1, HTML5VideoViewProxy.this.mNativePointer);
                        break;
                    }
                    case 204: {
                        HTML5VideoViewProxy.this.nativeOnStopFullscreen(HTML5VideoViewProxy.this.mNativePointer);
                        break;
                    }
                    case 205: {
                        HTML5VideoViewProxy.this.nativeOnRestoreState(HTML5VideoViewProxy.this.mNativePointer);
                    }
                }
            }
        };
    }

    private void doSetPoster(Bitmap poster) {
        if (poster == null) {
            return;
        }
        this.mPoster = poster;
        Message msg = Message.obtain(this.mWebCoreHandler, 202);
        msg.obj = poster;
        this.mWebCoreHandler.sendMessage(msg);
    }

    private void sendTimeupdate() {
        Message msg = Message.obtain(this.mWebCoreHandler, 300);
        msg.arg1 = VideoPlayer.getCurrentPosition();
        this.mWebCoreHandler.sendMessage(msg);
    }

    public Context getContext() {
        return this.mWebView.getContext();
    }

    public void play(String url, int position, int videoLayerID) {
        if (url == null) {
            return;
        }
        if (position > 0) {
            this.seek(position);
        }
        Message message = this.obtainMessage(100);
        message.arg1 = videoLayerID;
        message.obj = url;
        this.sendMessage(message);
    }

    public void seek(int time) {
        Message message = this.obtainMessage(101);
        message.obj = new Integer(time);
        this.sendMessage(message);
    }

    public void pause() {
        Message message = this.obtainMessage(102);
        this.sendMessage(message);
    }

    public void teardown() {
        if (this.mPosterDownloader != null) {
            this.mPosterDownloader.cancelAndReleaseQueue();
        }
        this.mNativePointer = 0;
    }

    public void loadPoster(String url) {
        if (url == null) {
            Message message = this.obtainMessage(104);
            this.sendMessage(message);
            return;
        }
        if (this.mPosterDownloader != null) {
            this.mPosterDownloader.cancelAndReleaseQueue();
        }
        this.mPosterDownloader = new PosterDownloader(url, this);
        this.mPosterDownloader.start();
    }

    public void setBaseLayer(int layer) {
        VideoPlayer.setBaseLayer(layer);
    }

    public void pauseAndDispatch() {
        VideoPlayer.pauseAndDispatch();
    }

    public void enterFullScreenVideo(int layerId, String url) {
        VideoPlayer.enterFullScreenVideo(layerId, url, this, this.mWebView);
    }

    public void exitFullScreenVideo() {
        VideoPlayer.exitFullScreenVideo(this, this.mWebView);
    }

    public static HTML5VideoViewProxy getInstance(WebViewCore webViewCore, int nativePtr) {
        return new HTML5VideoViewProxy(webViewCore.getWebViewClassic(), nativePtr);
    }

    WebViewClassic getWebView() {
        return this.mWebView;
    }

    private void nativeOnPrepared(int n, int n2, int n3, int n4) {
        OverrideMethod.invokeV("android.webkit.HTML5VideoViewProxy#nativeOnPrepared(IIII)V", true, this);
    }

    private void nativeOnEnded(int n) {
        OverrideMethod.invokeV("android.webkit.HTML5VideoViewProxy#nativeOnEnded(I)V", true, this);
    }

    private void nativeOnPaused(int n) {
        OverrideMethod.invokeV("android.webkit.HTML5VideoViewProxy#nativeOnPaused(I)V", true, this);
    }

    private void nativeOnPosterFetched(Bitmap bitmap, int n) {
        OverrideMethod.invokeV("android.webkit.HTML5VideoViewProxy#nativeOnPosterFetched(Landroid/graphics/Bitmap;I)V", true, this);
    }

    private void nativeOnTimeupdate(int n, int n2) {
        OverrideMethod.invokeV("android.webkit.HTML5VideoViewProxy#nativeOnTimeupdate(II)V", true, this);
    }

    private void nativeOnStopFullscreen(int n) {
        OverrideMethod.invokeV("android.webkit.HTML5VideoViewProxy#nativeOnStopFullscreen(I)V", true, this);
    }

    private void nativeOnRestoreState(int n) {
        OverrideMethod.invokeV("android.webkit.HTML5VideoViewProxy#nativeOnRestoreState(I)V", true, this);
    }

    private static boolean nativeSendSurfaceTexture(SurfaceTexture surfaceTexture, int n, int n2, int n3, int n4) {
        return OverrideMethod.invokeI("android.webkit.HTML5VideoViewProxy#nativeSendSurfaceTexture(Landroid/graphics/SurfaceTexture;IIII)Z", true, null) != 0;
    }

    public boolean onInfo(MediaPlayer mp, int what, int extra) {
        if (what == 701) {
            this.sendMessage(this.obtainMessage(105, what, extra));
        } else if (what == 702) {
            this.sendMessage(this.obtainMessage(106, what, extra));
        }
        return false;
    }

    private static class PosterDownloader
    implements EventHandler {
        private static RequestQueue mRequestQueue;
        private static int mQueueRefCount;
        private URL mUrl;
        private final HTML5VideoViewProxy mProxy;
        private ByteArrayOutputStream mPosterBytes;
        private RequestHandle mRequestHandle;
        private int mStatusCode;
        private Headers mHeaders;
        private Handler mHandler;

        public PosterDownloader(String url, HTML5VideoViewProxy proxy) {
            try {
                this.mUrl = new URL(url);
            }
            catch (MalformedURLException e) {
                this.mUrl = null;
            }
            this.mProxy = proxy;
            this.mHandler = new Handler();
        }

        public void start() {
            this.retainQueue();
            if (this.mUrl == null) {
                return;
            }
            String protocol = this.mUrl.getProtocol();
            if ("http".equals(protocol) || "https".equals(protocol)) {
                this.mRequestHandle = mRequestQueue.queueRequest(this.mUrl.toString(), "GET", null, this, null, 0);
            }
        }

        public void cancelAndReleaseQueue() {
            if (this.mRequestHandle != null) {
                this.mRequestHandle.cancel();
                this.mRequestHandle = null;
            }
            this.releaseQueue();
        }

        public void status(int major_version, int minor_version, int code, String reason_phrase) {
            this.mStatusCode = code;
        }

        public void headers(Headers headers) {
            this.mHeaders = headers;
        }

        public void data(byte[] data, int len) {
            if (this.mPosterBytes == null) {
                this.mPosterBytes = new ByteArrayOutputStream();
            }
            this.mPosterBytes.write(data, 0, len);
        }

        public void endData() {
            if (this.mStatusCode == 200) {
                if (this.mPosterBytes.size() > 0) {
                    Bitmap poster = BitmapFactory.decodeByteArray(this.mPosterBytes.toByteArray(), 0, this.mPosterBytes.size());
                    this.mProxy.doSetPoster(poster);
                }
                this.cleanup();
            } else if (this.mStatusCode >= 300 && this.mStatusCode < 400) {
                try {
                    this.mUrl = new URL(this.mHeaders.getLocation());
                }
                catch (MalformedURLException e) {
                    this.mUrl = null;
                }
                if (this.mUrl != null) {
                    this.mHandler.post(new Runnable(){

                        public void run() {
                            if (PosterDownloader.this.mRequestHandle != null) {
                                PosterDownloader.this.mRequestHandle.setupRedirect(PosterDownloader.this.mUrl.toString(), PosterDownloader.this.mStatusCode, new HashMap<String, String>());
                            }
                        }
                    });
                }
            }
        }

        public void certificate(SslCertificate certificate) {
        }

        public void error(int id2, String description) {
            this.cleanup();
        }

        public boolean handleSslErrorRequest(SslError error) {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cleanup() {
            if (this.mPosterBytes != null) {
                try {
                    try {
                        this.mPosterBytes.close();
                    }
                    catch (IOException iOException) {
                        Object var3_2 = null;
                        this.mPosterBytes = null;
                    }
                    Object var3_1 = null;
                    this.mPosterBytes = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.mPosterBytes = null;
                    throw throwable;
                }
            }
        }

        private void retainQueue() {
            if (mRequestQueue == null) {
                mRequestQueue = new RequestQueue(this.mProxy.getContext());
            }
            ++mQueueRefCount;
        }

        private void releaseQueue() {
            if (mQueueRefCount == 0) {
                return;
            }
            if (--mQueueRefCount == 0) {
                mRequestQueue.shutdown();
                mRequestQueue = null;
            }
        }

        static {
            mQueueRefCount = 0;
        }
    }

    private static class VideoPlayer {
        private static HTML5VideoViewProxy mCurrentProxy;
        private static HTML5VideoView mHTML5VideoView;
        private static boolean isVideoSelfEnded;
        private static int mBaseLayer;

        private VideoPlayer() {
        }

        private static void setPlayerBuffering(boolean playerBuffering) {
            mHTML5VideoView.setPlayerBuffering(playerBuffering);
        }

        public static void setBaseLayer(int layer) {
            if (mHTML5VideoView != null && !mHTML5VideoView.isFullScreenMode() && !mHTML5VideoView.surfaceTextureDeleted()) {
                mBaseLayer = layer;
                int currentVideoLayerId = mHTML5VideoView.getVideoLayerId();
                SurfaceTexture surfTexture = HTML5VideoInline.getSurfaceTexture(currentVideoLayerId);
                int textureName = mHTML5VideoView.getTextureName();
                if (layer != 0 && surfTexture != null && currentVideoLayerId != -1) {
                    int playerState = mHTML5VideoView.getCurrentState();
                    if (mHTML5VideoView.getPlayerBuffering()) {
                        playerState = 1;
                    }
                    boolean foundInTree = HTML5VideoViewProxy.nativeSendSurfaceTexture(surfTexture, layer, currentVideoLayerId, textureName, playerState);
                    if (playerState >= 2 && !foundInTree) {
                        mHTML5VideoView.pauseAndDispatch(mCurrentProxy);
                        mHTML5VideoView.deleteSurfaceTexture();
                    }
                }
            }
        }

        public static void pauseAndDispatch() {
            if (mHTML5VideoView != null) {
                mHTML5VideoView.pauseAndDispatch(mCurrentProxy);
                VideoPlayer.setBaseLayer(mBaseLayer);
            }
        }

        public static void enterFullScreenVideo(int layerId, String url, HTML5VideoViewProxy proxy, WebViewClassic webView) {
            int savePosition = 0;
            boolean canSkipPrepare = false;
            boolean forceStart = false;
            if (mHTML5VideoView != null) {
                if (!mHTML5VideoView.fullScreenExited() && mHTML5VideoView.isFullScreenMode()) {
                    Log.w(HTML5VideoViewProxy.LOGTAG, "Try to reenter the full screen mode");
                    return;
                }
                int playerState = mHTML5VideoView.getCurrentState();
                if (layerId == mHTML5VideoView.getVideoLayerId()) {
                    savePosition = mHTML5VideoView.getCurrentPosition();
                    boolean bl = canSkipPrepare = (playerState == 1 || playerState == 2 || playerState == 3) && !mHTML5VideoView.isFullScreenMode();
                }
                if (!canSkipPrepare) {
                    mHTML5VideoView.reset();
                } else {
                    forceStart = playerState == 1 || playerState == 3;
                }
            }
            mHTML5VideoView = new HTML5VideoFullScreen(proxy.getContext(), layerId, savePosition, canSkipPrepare);
            mHTML5VideoView.setStartWhenPrepared(forceStart);
            mCurrentProxy = proxy;
            mHTML5VideoView.setVideoURI(url, mCurrentProxy);
            mHTML5VideoView.enterFullScreenVideoState(layerId, proxy, webView);
        }

        public static void exitFullScreenVideo(HTML5VideoViewProxy proxy, WebViewClassic webView) {
            WebChromeClient client;
            if (!mHTML5VideoView.fullScreenExited() && mHTML5VideoView.isFullScreenMode() && (client = webView.getWebChromeClient()) != null) {
                client.onHideCustomView();
            }
        }

        public static void play(String url, int time, HTML5VideoViewProxy proxy, WebChromeClient client, int videoLayerId) {
            int currentVideoLayerId = -1;
            boolean backFromFullScreenMode = false;
            if (mHTML5VideoView != null) {
                currentVideoLayerId = mHTML5VideoView.getVideoLayerId();
                backFromFullScreenMode = mHTML5VideoView.fullScreenExited();
                if (mHTML5VideoView.isFullScreenMode() && !backFromFullScreenMode && currentVideoLayerId != videoLayerId && mCurrentProxy != proxy) {
                    mCurrentProxy = proxy;
                    mHTML5VideoView.setStartWhenPrepared(true);
                    mHTML5VideoView.setVideoURI(url, proxy);
                    mHTML5VideoView.reprepareData(proxy);
                    return;
                }
            }
            if (backFromFullScreenMode || currentVideoLayerId != videoLayerId || mHTML5VideoView.surfaceTextureDeleted()) {
                if (mHTML5VideoView != null) {
                    if (!backFromFullScreenMode) {
                        mHTML5VideoView.pauseAndDispatch(mCurrentProxy);
                    }
                    mHTML5VideoView.reset();
                }
                mCurrentProxy = proxy;
                mHTML5VideoView = new HTML5VideoInline(videoLayerId, time);
                mHTML5VideoView.setVideoURI(url, mCurrentProxy);
                mHTML5VideoView.prepareDataAndDisplayMode(proxy);
            } else if (mCurrentProxy == proxy) {
                if (!mHTML5VideoView.isPlaying()) {
                    mHTML5VideoView.seekTo(time);
                    mHTML5VideoView.start();
                }
            } else if (mCurrentProxy != null) {
                proxy.dispatchOnEnded();
            }
        }

        public static boolean isPlaying(HTML5VideoViewProxy proxy) {
            return mCurrentProxy == proxy && mHTML5VideoView != null && mHTML5VideoView.isPlaying();
        }

        public static int getCurrentPosition() {
            int currentPosMs = 0;
            if (mHTML5VideoView != null) {
                currentPosMs = mHTML5VideoView.getCurrentPosition();
            }
            return currentPosMs;
        }

        public static void seek(int time, HTML5VideoViewProxy proxy) {
            if (mCurrentProxy == proxy && time >= 0 && mHTML5VideoView != null) {
                mHTML5VideoView.seekTo(time);
            }
        }

        public static void pause(HTML5VideoViewProxy proxy) {
            if (mCurrentProxy == proxy && mHTML5VideoView != null) {
                mHTML5VideoView.pause();
            }
        }

        public static void onPrepared() {
            if (!mHTML5VideoView.isFullScreenMode()) {
                mHTML5VideoView.start();
            }
            if (mBaseLayer != 0) {
                VideoPlayer.setBaseLayer(mBaseLayer);
            }
        }

        public static void end() {
            mHTML5VideoView.showControllerInFullScreen();
            if (mCurrentProxy != null) {
                if (isVideoSelfEnded) {
                    mCurrentProxy.dispatchOnEnded();
                } else {
                    mCurrentProxy.dispatchOnPaused();
                }
            }
            isVideoSelfEnded = false;
        }

        static {
            isVideoSelfEnded = false;
            mBaseLayer = 0;
        }
    }
}

