/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.graphics.PointF;

class QuadF {
    public PointF p1 = new PointF();
    public PointF p2 = new PointF();
    public PointF p3 = new PointF();
    public PointF p4 = new PointF();

    public void offset(float dx, float dy) {
        this.p1.offset(dx, dy);
        this.p2.offset(dx, dy);
        this.p3.offset(dx, dy);
        this.p4.offset(dx, dy);
    }

    public boolean containsPoint(float x, float y) {
        return QuadF.isPointInTriangle(x, y, this.p1, this.p2, this.p3) || QuadF.isPointInTriangle(x, y, this.p1, this.p3, this.p4);
    }

    public String toString() {
        StringBuilder s = new StringBuilder("QuadF(");
        s.append(this.p1.x).append(",").append(this.p1.y);
        s.append(" - ");
        s.append(this.p2.x).append(",").append(this.p2.y);
        s.append(" - ");
        s.append(this.p3.x).append(",").append(this.p3.y);
        s.append(" - ");
        s.append(this.p4.x).append(",").append(this.p4.y);
        s.append(")");
        return s.toString();
    }

    private static boolean isPointInTriangle(float x0, float y0, PointF r1, PointF r2, PointF r3) {
        float x13 = r1.x - r3.x;
        float y13 = r1.y - r3.y;
        float x23 = r2.x - r3.x;
        float y23 = r2.y - r3.y;
        float x03 = x0 - r3.x;
        float y03 = y0 - r3.y;
        float determinant = y23 * x13 - x23 * y13;
        float lambda1 = (y23 * x03 - x23 * y03) / determinant;
        float lambda2 = (x13 * y03 - y13 * x03) / determinant;
        float lambda3 = 1.0f - lambda1 - lambda2;
        return lambda1 >= 0.0f && lambda2 >= 0.0f && lambda3 >= 0.0f;
    }
}

