/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.webkit.WebView;
import android.webkit.WebViewClassic;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

class WebCoreThreadWatchdog
implements Runnable {
    private static final int IS_ALIVE = 100;
    private static final int TIMED_OUT = 101;
    private static final int HEARTBEAT_PERIOD = 10000;
    private static final int TIMEOUT_PERIOD = 30000;
    private static final int SUBSEQUENT_TIMEOUT_PERIOD = 15000;
    private Handler mWebCoreThreadHandler;
    private Handler mHandler;
    private boolean mPaused;
    private Set<WebViewClassic> mWebViews;
    private static WebCoreThreadWatchdog sInstance;

    public static synchronized WebCoreThreadWatchdog start(Handler webCoreThreadHandler) {
        if (sInstance == null) {
            sInstance = new WebCoreThreadWatchdog(webCoreThreadHandler);
            new Thread((Runnable)sInstance, "WebCoreThreadWatchdog").start();
        }
        return sInstance;
    }

    public static synchronized void registerWebView(WebViewClassic w) {
        if (sInstance != null) {
            sInstance.addWebView(w);
        }
    }

    public static synchronized void unregisterWebView(WebViewClassic w) {
        if (sInstance != null) {
            sInstance.removeWebView(w);
        }
    }

    public static synchronized void pause() {
        if (sInstance != null) {
            sInstance.pauseWatchdog();
        }
    }

    public static synchronized void resume() {
        if (sInstance != null) {
            sInstance.resumeWatchdog();
        }
    }

    private void addWebView(WebViewClassic w) {
        if (this.mWebViews == null) {
            this.mWebViews = new HashSet<WebViewClassic>();
        }
        this.mWebViews.add(w);
    }

    private void removeWebView(WebViewClassic w) {
        this.mWebViews.remove(w);
    }

    private WebCoreThreadWatchdog(Handler webCoreThreadHandler) {
        this.mWebCoreThreadHandler = webCoreThreadHandler;
    }

    private void pauseWatchdog() {
        this.mPaused = true;
        if (this.mHandler == null) {
            return;
        }
        this.mHandler.removeMessages(101);
        this.mHandler.removeMessages(100);
        this.mWebCoreThreadHandler.removeMessages(197);
    }

    private void resumeWatchdog() {
        if (!this.mPaused) {
            return;
        }
        this.mPaused = false;
        if (this.mHandler == null) {
            return;
        }
        this.mWebCoreThreadHandler.obtainMessage(197, this.mHandler.obtainMessage(100)).sendToTarget();
        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(101), 30000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createHandler() {
        Class<WebCoreThreadWatchdog> clazz = WebCoreThreadWatchdog.class;
        synchronized (WebCoreThreadWatchdog.class) {
            this.mHandler = new Handler(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public void handleMessage(Message msg) {
                    switch (msg.what) {
                        case 100: {
                            Class<WebCoreThreadWatchdog> clazz = WebCoreThreadWatchdog.class;
                            synchronized (WebCoreThreadWatchdog.class) {
                                if (WebCoreThreadWatchdog.this.mPaused) {
                                    // ** MonitorExit[var2_2] (shouldn't be in output)
                                    return;
                                }
                                this.removeMessages(101);
                                this.sendMessageDelayed(this.obtainMessage(101), 30000L);
                                WebCoreThreadWatchdog.this.mWebCoreThreadHandler.sendMessageDelayed(WebCoreThreadWatchdog.this.mWebCoreThreadHandler.obtainMessage(197, WebCoreThreadWatchdog.this.mHandler.obtainMessage(100)), 10000L);
                                // ** MonitorExit[var2_2] (shouldn't be in output)
                                return;
                            }
                        }
                        case 101: {
                            boolean postedDialog = false;
                            Class<WebCoreThreadWatchdog> clazz = WebCoreThreadWatchdog.class;
                            synchronized (WebCoreThreadWatchdog.class) {
                                WebView activeView;
                                Iterator it = WebCoreThreadWatchdog.this.mWebViews.iterator();
                                while (it.hasNext() && ((activeView = ((WebViewClassic)it.next()).getWebView()).getWindowToken() == null || activeView.getViewRootImpl() == null || !(postedDialog = activeView.post(new PageNotRespondingRunnable(activeView.getContext(), this))))) {
                                }
                                if (postedDialog) return;
                                this.sendMessageDelayed(this.obtainMessage(101), 15000L);
                                // ** MonitorExit[var3_5] (shouldn't be in output)
                                return;
                            }
                        }
                    }
                }
            };
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Looper.prepare();
        this.createHandler();
        Class<WebCoreThreadWatchdog> clazz = WebCoreThreadWatchdog.class;
        synchronized (WebCoreThreadWatchdog.class) {
            if (!this.mPaused) {
                this.mWebCoreThreadHandler.obtainMessage(197, this.mHandler.obtainMessage(100)).sendToTarget();
                this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(101), 30000L);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            Looper.loop();
            return;
        }
    }

    private class PageNotRespondingRunnable
    implements Runnable {
        Context mContext;
        private Handler mWatchdogHandler;

        public PageNotRespondingRunnable(Context context, Handler watchdogHandler) {
            this.mContext = context;
            this.mWatchdogHandler = watchdogHandler;
        }

        public void run() {
            assert (Looper.getMainLooper().getThread() == Thread.currentThread());
            new AlertDialog.Builder(this.mContext).setMessage(17040346).setPositiveButton(17040343, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    Process.killProcess(Process.myPid());
                }
            }).setNegativeButton(17040345, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    PageNotRespondingRunnable.this.mWatchdogHandler.sendMessageDelayed(PageNotRespondingRunnable.this.mWatchdogHandler.obtainMessage(101), 15000L);
                }
            }).setOnCancelListener(new DialogInterface.OnCancelListener(){

                public void onCancel(DialogInterface dialog) {
                    PageNotRespondingRunnable.this.mWatchdogHandler.sendMessageDelayed(PageNotRespondingRunnable.this.mWatchdogHandler.obtainMessage(101), 15000L);
                }
            }).setIcon(17301543).show();
        }
    }
}

