/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.graphics.Bitmap;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.net.MalformedURLException;
import java.net.URL;

public class WebHistoryItem
implements Cloneable {
    private static int sNextId = 0;
    private final int mId;
    private int mNativeBridge;
    private Bitmap mFavicon;
    private byte[] mFlattenedData;
    private String mTouchIconUrlFromLink;
    private String mTouchIconUrlServerDefault;
    private Object mCustomData;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WebHistoryItem(int nativeBridge) {
        Class<WebHistoryItem> clazz = WebHistoryItem.class;
        synchronized (WebHistoryItem.class) {
            this.mId = sNextId++;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.mNativeBridge = nativeBridge;
            this.nativeRef(this.mNativeBridge);
            return;
        }
    }

    protected void finalize() throws Throwable {
        if (this.mNativeBridge != 0) {
            this.nativeUnref(this.mNativeBridge);
            this.mNativeBridge = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WebHistoryItem(byte[] data) {
        this.mFlattenedData = data;
        Class<WebHistoryItem> clazz = WebHistoryItem.class;
        synchronized (WebHistoryItem.class) {
            this.mId = sNextId++;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private WebHistoryItem(WebHistoryItem item) {
        this.mFlattenedData = item.mFlattenedData;
        this.mId = item.mId;
        this.mFavicon = item.mFavicon;
        this.mNativeBridge = item.mNativeBridge;
        if (this.mNativeBridge != 0) {
            this.nativeRef(this.mNativeBridge);
        }
    }

    @Deprecated
    public int getId() {
        return this.mId;
    }

    public String getUrl() {
        if (this.mNativeBridge == 0) {
            return null;
        }
        return this.nativeGetUrl(this.mNativeBridge);
    }

    public String getOriginalUrl() {
        if (this.mNativeBridge == 0) {
            return null;
        }
        return this.nativeGetOriginalUrl(this.mNativeBridge);
    }

    public String getTitle() {
        if (this.mNativeBridge == 0) {
            return null;
        }
        return this.nativeGetTitle(this.mNativeBridge);
    }

    public Bitmap getFavicon() {
        if (this.mFavicon == null && this.mNativeBridge != 0) {
            this.mFavicon = this.nativeGetFavicon(this.mNativeBridge);
        }
        return this.mFavicon;
    }

    public String getTouchIconUrl() {
        if (this.mTouchIconUrlFromLink != null) {
            return this.mTouchIconUrlFromLink;
        }
        if (this.mTouchIconUrlServerDefault != null) {
            return this.mTouchIconUrlServerDefault;
        }
        try {
            URL url = new URL(this.getOriginalUrl());
            this.mTouchIconUrlServerDefault = new URL(url.getProtocol(), url.getHost(), url.getPort(), "/apple-touch-icon.png").toString();
        }
        catch (MalformedURLException e) {
            return null;
        }
        return this.mTouchIconUrlServerDefault;
    }

    public Object getCustomData() {
        return this.mCustomData;
    }

    public void setCustomData(Object data) {
        this.mCustomData = data;
    }

    void setFavicon(Bitmap icon) {
        this.mFavicon = icon;
    }

    void setTouchIconUrl(String url, boolean precomposed) {
        if (precomposed || this.mTouchIconUrlFromLink == null) {
            this.mTouchIconUrlFromLink = url;
        }
    }

    byte[] getFlattenedData() {
        if (this.mNativeBridge != 0) {
            return this.nativeGetFlattenedData(this.mNativeBridge);
        }
        return this.mFlattenedData;
    }

    void inflate(int nativeFrame) {
        this.mNativeBridge = this.inflate(nativeFrame, this.mFlattenedData);
        this.mFlattenedData = null;
    }

    protected synchronized WebHistoryItem clone() {
        return new WebHistoryItem(this);
    }

    private int inflate(int n, byte[] byArray) {
        return OverrideMethod.invokeI("android.webkit.WebHistoryItem#inflate(I[B)I", true, this);
    }

    private void nativeRef(int n) {
        OverrideMethod.invokeV("android.webkit.WebHistoryItem#nativeRef(I)V", true, this);
    }

    private void nativeUnref(int n) {
        OverrideMethod.invokeV("android.webkit.WebHistoryItem#nativeUnref(I)V", true, this);
    }

    private String nativeGetTitle(int n) {
        return (String)OverrideMethod.invokeA("android.webkit.WebHistoryItem#nativeGetTitle(I)Ljava/lang/String;", true, this);
    }

    private String nativeGetUrl(int n) {
        return (String)OverrideMethod.invokeA("android.webkit.WebHistoryItem#nativeGetUrl(I)Ljava/lang/String;", true, this);
    }

    private String nativeGetOriginalUrl(int n) {
        return (String)OverrideMethod.invokeA("android.webkit.WebHistoryItem#nativeGetOriginalUrl(I)Ljava/lang/String;", true, this);
    }

    private byte[] nativeGetFlattenedData(int n) {
        return (byte[])OverrideMethod.invokeA("android.webkit.WebHistoryItem#nativeGetFlattenedData(I)[B", true, this);
    }

    private Bitmap nativeGetFavicon(int n) {
        return (Bitmap)OverrideMethod.invokeA("android.webkit.WebHistoryItem#nativeGetFavicon(I)Landroid/graphics/Bitmap;", true, this);
    }
}

