/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.graphics.Point;
import android.graphics.Rect;
import android.media.MediaFile;
import android.net.ProxyProperties;
import android.net.Uri;
import android.net.http.CertificateChainValidator;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.util.Log;
import android.util.SparseBooleanArray;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.SurfaceView;
import android.view.View;
import android.webkit.BrowserFrame;
import android.webkit.CacheManager;
import android.webkit.CallbackProxy;
import android.webkit.CookieManagerClassic;
import android.webkit.DeviceMotionAndOrientationManager;
import android.webkit.DeviceMotionService;
import android.webkit.DeviceOrientationService;
import android.webkit.GeolocationPermissions;
import android.webkit.GeolocationPermissionsClassic;
import android.webkit.PluginManager;
import android.webkit.SslCertLookupTable;
import android.webkit.ValueCallback;
import android.webkit.ViewManager;
import android.webkit.ViewStateSerializer;
import android.webkit.WebBackForwardList;
import android.webkit.WebCoreThreadWatchdog;
import android.webkit.WebIconDatabase;
import android.webkit.WebIconDatabaseClassic;
import android.webkit.WebSettingsClassic;
import android.webkit.WebStorage;
import android.webkit.WebStorageClassic;
import android.webkit.WebView;
import android.webkit.WebViewClassic;
import android.webkit.WebViewInputDispatcher;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebViewCore {
    private static final String LOGTAG = "webcore";
    private WebViewClassic mWebViewClassic;
    private final CallbackProxy mCallbackProxy;
    private final WebSettingsClassic mSettings;
    private final Context mContext;
    private int mNativeClass;
    private BrowserFrame mBrowserFrame;
    private Map<String, Object> mJavascriptInterfaces;
    private int mViewportWidth = -1;
    private int mViewportHeight = -1;
    private int mViewportInitialScale = 0;
    private int mViewportMinimumScale = 0;
    private int mViewportMaximumScale = 0;
    private boolean mViewportUserScalable = true;
    private int mViewportDensityDpi = -1;
    private boolean mIsRestored = false;
    private float mRestoredScale = 0.0f;
    private float mRestoredTextWrapScale = 0.0f;
    private int mRestoredX = 0;
    private int mRestoredY = 0;
    private DeviceMotionAndOrientationManager mDeviceMotionAndOrientationManager = new DeviceMotionAndOrientationManager(this);
    private DeviceMotionService mDeviceMotionService;
    private DeviceOrientationService mDeviceOrientationService;
    private int mLowMemoryUsageThresholdMb;
    private int mHighMemoryUsageThresholdMb;
    private int mHighUsageDeltaMb;
    private int mChromeCanFocusDirection;
    private int mTextSelectionChangeReason = 0;
    private static boolean sShouldMonitorWebCoreThread;
    static final String THREAD_NAME = "WebViewCoreThread";
    private final EventHub mEventHub;
    private static Handler sWebCoreHandler;
    static final int ACTION_LONGPRESS = 256;
    static final int ACTION_DOUBLETAP = 512;
    private static final int TOUCH_FLAG_HIT_HANDLER = 1;
    private static final int TOUCH_FLAG_PREVENT_DEFAULT = 2;
    static final String[] HandlerDebugString;
    private int mCurrentViewWidth = 0;
    private int mCurrentViewHeight = 0;
    private float mCurrentViewScale = 1.0f;
    private boolean mDrawIsScheduled;
    private boolean mDrawIsPaused;
    private ViewState mInitialViewState = null;
    private boolean mFirstLayoutForNonStandardLoad;
    DrawData mLastDrawData = null;
    private Object m_skipDrawFlagLock = new Object();
    private boolean m_skipDrawFlag = false;
    private boolean m_drawWasSkipped = false;
    private static boolean mRepaintScheduled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebViewCore(Context context, WebViewClassic w, CallbackProxy proxy, Map<String, Object> javascriptInterfaces) {
        this.mCallbackProxy = proxy;
        this.mWebViewClassic = w;
        this.mJavascriptInterfaces = javascriptInterfaces;
        this.mContext = context;
        Class<WebViewCore> clazz = WebViewCore.class;
        synchronized (WebViewCore.class) {
            if (sWebCoreHandler == null) {
                Thread t = new Thread(new WebCoreThread());
                t.setName(THREAD_NAME);
                t.start();
                try {
                    WebViewCore.class.wait();
                }
                catch (InterruptedException e) {
                    Log.e(LOGTAG, "Caught exception while waiting for thread creation.");
                    Log.e(LOGTAG, Log.getStackTraceString(e));
                }
                if (sShouldMonitorWebCoreThread) {
                    WebCoreThreadWatchdog.start(sWebCoreHandler);
                }
            }
            WebCoreThreadWatchdog.registerWebView(w);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            this.mEventHub = new EventHub();
            this.mSettings = new WebSettingsClassic(this.mContext, this.mWebViewClassic);
            WebIconDatabase.getInstance();
            WebStorageClassic.getInstance().createUIHandler();
            GeolocationPermissionsClassic.getInstance().createUIHandler();
            ActivityManager manager = (ActivityManager)this.mContext.getSystemService("activity");
            ActivityManager.MemoryInfo memInfo = new ActivityManager.MemoryInfo();
            manager.getMemoryInfo(memInfo);
            this.mLowMemoryUsageThresholdMb = manager.getLargeMemoryClass();
            this.mHighMemoryUsageThresholdMb = (int)((double)this.mLowMemoryUsageThresholdMb * 1.5);
            this.mHighUsageDeltaMb = this.mLowMemoryUsageThresholdMb / 32;
            Message init = sWebCoreHandler.obtainMessage(0, this);
            sWebCoreHandler.sendMessage(init);
            return;
        }
    }

    private void initialize() {
        this.mBrowserFrame = new BrowserFrame(this.mContext, this, this.mCallbackProxy, this.mSettings, this.mJavascriptInterfaces);
        this.mJavascriptInterfaces = null;
        this.mSettings.syncSettingsAndCreateHandler(this.mBrowserFrame);
        WebIconDatabaseClassic.getInstance().createHandler();
        WebStorageClassic.getInstance().createHandler();
        GeolocationPermissionsClassic.getInstance().createHandler();
        this.mEventHub.transferMessages();
        if (this.mWebViewClassic != null) {
            Message.obtain(this.mWebViewClassic.mPrivateHandler, 107, this.mNativeClass, 0).sendToTarget();
        }
    }

    void initializeSubwindow() {
        this.initialize();
        sWebCoreHandler.removeMessages(0, this);
    }

    synchronized BrowserFrame getBrowserFrame() {
        return this.mBrowserFrame;
    }

    public WebViewInputDispatcher.WebKitCallbacks getInputDispatcherCallbacks() {
        return this.mEventHub;
    }

    public static void pauseTimers() {
        if (BrowserFrame.sJavaBridge == null) {
            throw new IllegalStateException("No WebView has been created in this process!");
        }
        BrowserFrame.sJavaBridge.pause();
    }

    public static void resumeTimers() {
        if (BrowserFrame.sJavaBridge == null) {
            throw new IllegalStateException("No WebView has been created in this process!");
        }
        BrowserFrame.sJavaBridge.resume();
    }

    public WebSettingsClassic getSettings() {
        return this.mSettings;
    }

    static boolean isSupportedMediaMimeType(String mimeType) {
        int fileType = MediaFile.getFileTypeForMimeType(mimeType);
        return MediaFile.isAudioFileType(fileType) || MediaFile.isVideoFileType(fileType) || MediaFile.isPlayListFileType(fileType) || mimeType != null && mimeType.startsWith("video/m4v");
    }

    protected void addMessageToConsole(String message, int lineNumber, String sourceID, int msgLevel) {
        this.mCallbackProxy.addMessageToConsole(message, lineNumber, sourceID, msgLevel);
    }

    protected void jsAlert(String url, String message) {
        this.mCallbackProxy.onJsAlert(url, message);
    }

    private void focusNodeChanged(int nodePointer, WebKitHitTest hitTest) {
        if (this.mWebViewClassic == null) {
            return;
        }
        this.mWebViewClassic.mPrivateHandler.obtainMessage(147, nodePointer, 0, hitTest).sendToTarget();
    }

    private void chromeTakeFocus(int webkitDirection) {
        if (this.mWebViewClassic == null) {
            return;
        }
        Message m = this.mWebViewClassic.mPrivateHandler.obtainMessage(110);
        m.arg1 = this.mapDirection(webkitDirection);
        m.sendToTarget();
    }

    private boolean chromeCanTakeFocus(int webkitDirection) {
        int direction = this.mapDirection(webkitDirection);
        return direction == this.mChromeCanFocusDirection && direction != 0;
    }

    private int mapDirection(int webkitDirection) {
        switch (webkitDirection) {
            case 1: {
                return 2;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 33;
            }
            case 4: {
                return 130;
            }
            case 5: {
                return 17;
            }
            case 6: {
                return 66;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String openFileChooser(String acceptType, String capture) {
        Uri uri = this.mCallbackProxy.openFileChooser(acceptType, capture);
        if (uri != null) {
            String filePath = "";
            Cursor cursor = this.mContext.getContentResolver().query(uri, new String[]{"_data"}, null, null, null);
            if (cursor != null) {
                try {
                    if (cursor.moveToNext()) {
                        filePath = cursor.getString(0);
                    }
                    Object var7_6 = null;
                    cursor.close();
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    cursor.close();
                    throw throwable;
                }
            } else {
                filePath = uri.getLastPathSegment();
            }
            String uriString = uri.toString();
            BrowserFrame.sJavaBridge.storeFilePathForContentUri(filePath, uriString);
            return uriString;
        }
        return "";
    }

    protected void exceededDatabaseQuota(String url, String databaseIdentifier, long quota, long estimatedDatabaseSize) {
        this.mCallbackProxy.onExceededDatabaseQuota(url, databaseIdentifier, quota, estimatedDatabaseSize, this.getUsedQuota(), new WebStorage.QuotaUpdater(){

            public void updateQuota(long newQuota) {
                WebViewCore.this.nativeSetNewStorageLimit(WebViewCore.this.mNativeClass, newQuota);
            }
        });
    }

    protected void reachedMaxAppCacheSize(long requiredStorage) {
        this.mCallbackProxy.onReachedMaxAppCacheSize(requiredStorage, this.getUsedQuota(), new WebStorage.QuotaUpdater(){

            public void updateQuota(long newQuota) {
                WebViewCore.this.nativeSetNewStorageLimit(WebViewCore.this.mNativeClass, newQuota);
            }
        });
    }

    protected void populateVisitedLinks() {
        ValueCallback<String[]> callback = new ValueCallback<String[]>(){

            @Override
            public void onReceiveValue(String[] value) {
                WebViewCore.this.sendMessage(181, value);
            }
        };
        this.mCallbackProxy.getVisitedHistory(callback);
    }

    protected void geolocationPermissionsShowPrompt(String origin) {
        this.mCallbackProxy.onGeolocationPermissionsShowPrompt(origin, new GeolocationPermissions.Callback(){

            public void invoke(String origin, boolean allow, boolean remember) {
                GeolocationPermissionsData data = new GeolocationPermissionsData();
                data.mOrigin = origin;
                data.mAllow = allow;
                data.mRemember = remember;
                WebViewCore.this.sendMessage(180, data);
            }
        });
    }

    protected void geolocationPermissionsHidePrompt() {
        this.mCallbackProxy.onGeolocationPermissionsHidePrompt();
    }

    protected boolean jsConfirm(String url, String message) {
        return this.mCallbackProxy.onJsConfirm(url, message);
    }

    protected String jsPrompt(String url, String message, String defaultValue) {
        return this.mCallbackProxy.onJsPrompt(url, message, defaultValue);
    }

    protected boolean jsUnload(String url, String message) {
        return this.mCallbackProxy.onJsBeforeUnload(url, message);
    }

    protected boolean jsInterrupt() {
        return this.mCallbackProxy.onJsTimeout();
    }

    protected void setInstallableWebApp() {
        this.mCallbackProxy.setInstallableWebApp();
    }

    protected void enterFullscreenForVideoLayer(int layerId, String url) {
        if (this.mWebViewClassic == null) {
            return;
        }
        Message message = Message.obtain(this.mWebViewClassic.mPrivateHandler, 137, layerId, 0);
        message.obj = url;
        message.sendToTarget();
    }

    protected void exitFullscreenVideo() {
        if (this.mWebViewClassic == null) {
            return;
        }
        Message message = Message.obtain(this.mWebViewClassic.mPrivateHandler, 140);
        message.sendToTarget();
    }

    void clearContent() {
        this.nativeClearContent(this.mNativeClass);
    }

    static String nativeFindAddress(String string2, boolean bl) {
        return (String)OverrideMethod.invokeA("android.webkit.WebViewCore#nativeFindAddress(Ljava/lang/String;Z)Ljava/lang/String;", true, null);
    }

    private void nativeClearContent(int n) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeClearContent(I)V", true, this);
    }

    private void nativeContentInvalidateAll(int n) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeContentInvalidateAll(I)V", true, this);
    }

    private int nativeRecordContent(int n, Point point) {
        return OverrideMethod.invokeI("android.webkit.WebViewCore#nativeRecordContent(ILandroid/graphics/Point;)I", true, this);
    }

    private void nativeNotifyAnimationStarted(int n) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeNotifyAnimationStarted(I)V", true, this);
    }

    private boolean nativeFocusBoundsChanged(int n) {
        return OverrideMethod.invokeI("android.webkit.WebViewCore#nativeFocusBoundsChanged(I)Z", true, this) != 0;
    }

    private boolean nativeKey(int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return OverrideMethod.invokeI("android.webkit.WebViewCore#nativeKey(IIIIZZZZ)Z", true, this) != 0;
    }

    private void nativeSendListBoxChoices(int n, boolean[] blArray, int n2) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeSendListBoxChoices(I[ZI)V", true, this);
    }

    private void nativeSendListBoxChoice(int n, int n2) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeSendListBoxChoice(II)V", true, this);
    }

    private void nativeCloseIdleConnections(int n) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeCloseIdleConnections(I)V", true, this);
    }

    private void nativeSetSize(int n, int n2, int n3, int n4, float f, int n5, int n6, int n7, int n8, boolean bl) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeSetSize(IIIIFIIIIZ)V", true, this);
    }

    private int nativeGetContentMinPrefWidth(int n) {
        return OverrideMethod.invokeI("android.webkit.WebViewCore#nativeGetContentMinPrefWidth(I)I", true, this);
    }

    private void nativeReplaceTextfieldText(int n, int n2, int n3, String string2, int n4, int n5, int n6) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeReplaceTextfieldText(IIILjava/lang/String;III)V", true, this);
    }

    private void passToJs(int n, int n2, String string2, int n3, int n4, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#passToJs(IILjava/lang/String;IIZZZZ)V", true, this);
    }

    private void nativeSetFocusControllerActive(int n, boolean bl) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeSetFocusControllerActive(IZ)V", true, this);
    }

    private void nativeSaveDocumentState(int n) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeSaveDocumentState(I)V", true, this);
    }

    private void nativeMoveMouse(int n, int n2, int n3) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeMoveMouse(III)V", true, this);
    }

    private String nativeRetrieveHref(int n, int n2, int n3) {
        return (String)OverrideMethod.invokeA("android.webkit.WebViewCore#nativeRetrieveHref(III)Ljava/lang/String;", true, this);
    }

    private String nativeRetrieveAnchorText(int n, int n2, int n3) {
        return (String)OverrideMethod.invokeA("android.webkit.WebViewCore#nativeRetrieveAnchorText(III)Ljava/lang/String;", true, this);
    }

    private String nativeRetrieveImageSource(int n, int n2, int n3) {
        return (String)OverrideMethod.invokeA("android.webkit.WebViewCore#nativeRetrieveImageSource(III)Ljava/lang/String;", true, this);
    }

    private boolean nativeMouseClick(int n) {
        return OverrideMethod.invokeI("android.webkit.WebViewCore#nativeMouseClick(I)Z", true, this) != 0;
    }

    private int nativeHandleTouchEvent(int n, int n2, int[] nArray, int[] nArray2, int[] nArray3, int n3, int n4, int n5) {
        return OverrideMethod.invokeI("android.webkit.WebViewCore#nativeHandleTouchEvent(II[I[I[IIII)I", true, this);
    }

    private void nativeSetBackgroundColor(int n, int n2) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeSetBackgroundColor(II)V", true, this);
    }

    private void nativeDumpDomTree(int n, boolean bl) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeDumpDomTree(IZ)V", true, this);
    }

    private void nativeDumpRenderTree(int n, boolean bl) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeDumpRenderTree(IZ)V", true, this);
    }

    private void nativeSetJsFlags(int n, String string2) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeSetJsFlags(ILjava/lang/String;)V", true, this);
    }

    private void nativeDeleteSelection(int n, int n2, int n3, int n4) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeDeleteSelection(IIII)V", true, this);
    }

    private void nativeSetSelection(int n, int n2, int n3) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeSetSelection(III)V", true, this);
    }

    private void nativeRegisterURLSchemeAsLocal(int n, String string2) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeRegisterURLSchemeAsLocal(ILjava/lang/String;)V", true, this);
    }

    private void nativeSetNewStorageLimit(int n, long l) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeSetNewStorageLimit(IJ)V", true, this);
    }

    private void nativeGeolocationPermissionsProvide(int n, String string2, boolean bl, boolean bl2) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeGeolocationPermissionsProvide(ILjava/lang/String;ZZ)V", true, this);
    }

    private void nativeProvideVisitedHistory(int n, String[] stringArray) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeProvideVisitedHistory(I[Ljava/lang/String;)V", true, this);
    }

    private String nativeModifySelection(int n, int n2, int n3) {
        return (String)OverrideMethod.invokeA("android.webkit.WebViewCore#nativeModifySelection(III)Ljava/lang/String;", true, this);
    }

    void stopLoading() {
        if (this.mBrowserFrame != null) {
            this.mBrowserFrame.stopLoading();
        }
    }

    public void sendMessage(Message msg) {
        this.mEventHub.sendMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendMessages(ArrayList<Message> messages) {
        EventHub eventHub = this.mEventHub;
        synchronized (eventHub) {
            for (int i = 0; i < messages.size(); ++i) {
                this.mEventHub.sendMessage(messages.get(i));
            }
        }
    }

    void sendMessage(int what) {
        this.mEventHub.sendMessage(Message.obtain(null, what));
    }

    void sendMessageAtFrontOfQueue(int what, int arg1, int arg2, Object obj) {
        this.mEventHub.sendMessageAtFrontOfQueue(Message.obtain(null, what, arg1, arg2, obj));
    }

    void sendMessage(int what, Object obj) {
        this.mEventHub.sendMessage(Message.obtain(null, what, obj));
    }

    void sendMessage(int what, int arg1) {
        this.mEventHub.sendMessage(Message.obtain(null, what, arg1, 0));
    }

    void sendMessage(int what, int arg1, int arg2) {
        this.mEventHub.sendMessage(Message.obtain(null, what, arg1, arg2));
    }

    void sendMessage(int what, int arg1, Object obj) {
        this.mEventHub.sendMessage(Message.obtain(null, what, arg1, 0, obj));
    }

    void sendMessage(int what, int arg1, int arg2, Object obj) {
        this.mEventHub.sendMessage(Message.obtain(null, what, arg1, arg2, obj));
    }

    void sendMessageAtFrontOfQueue(int what, Object obj) {
        this.mEventHub.sendMessageAtFrontOfQueue(Message.obtain(null, what, obj));
    }

    void sendMessageDelayed(int what, Object obj, long delay) {
        this.mEventHub.sendMessageDelayed(Message.obtain(null, what, obj), delay);
    }

    void removeMessages(int what) {
        this.mEventHub.removeMessages(what);
    }

    void removeMessages() {
        this.mEventHub.removeMessages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroy() {
        EventHub eventHub = this.mEventHub;
        synchronized (eventHub) {
            this.mEventHub.mDestroying = true;
            this.mEventHub.sendMessageAtFrontOfQueue(Message.obtain(null, 200));
            this.mEventHub.blockMessages();
            WebCoreThreadWatchdog.unregisterWebView(this.mWebViewClassic);
        }
    }

    private WebKitHitTest performHitTest(int x, int y, int slop, boolean moveMouse) {
        WebKitHitTest hit = this.nativeHitTest(this.mNativeClass, x, y, slop, moveMouse);
        hit.mHitTestX = x;
        hit.mHitTestY = y;
        hit.mHitTestSlop = slop;
        hit.mHitTestMovedMouse = moveMouse;
        return hit;
    }

    private void clearCache(boolean includeDiskFiles) {
        this.mBrowserFrame.clearCache();
        if (includeDiskFiles) {
            CacheManager.removeAllCacheFiles();
        }
    }

    private void loadUrl(String url, Map<String, String> extraHeaders) {
        this.mBrowserFrame.loadUrl(url, extraHeaders);
    }

    private String saveWebArchive(String filename, boolean autoname) {
        return this.mBrowserFrame.saveWebArchive(filename, autoname);
    }

    private void key(KeyEvent evt, int canTakeFocusDirection, boolean isDown) {
        this.mChromeCanFocusDirection = canTakeFocusDirection;
        int keyCode = evt.getKeyCode();
        int unicodeChar = evt.getUnicodeChar();
        if (keyCode == 0 && evt.getCharacters() != null && evt.getCharacters().length() > 0) {
            unicodeChar = evt.getCharacters().codePointAt(0);
        }
        boolean handled = this.nativeKey(this.mNativeClass, keyCode, unicodeChar, evt.getRepeatCount(), evt.isShiftPressed(), evt.isAltPressed(), evt.isSymPressed(), isDown);
        this.mChromeCanFocusDirection = 0;
        if (!handled && keyCode != 66) {
            if (keyCode >= 19 && keyCode <= 22) {
                if (canTakeFocusDirection != 0 && isDown) {
                    Message m = this.mWebViewClassic.mPrivateHandler.obtainMessage(110);
                    m.arg1 = canTakeFocusDirection;
                    m.sendToTarget();
                }
                return;
            }
            this.mCallbackProxy.onUnhandledKeyEvent(evt);
        }
    }

    private void keyPress(int unicodeChar) {
        this.nativeKey(this.mNativeClass, 0, unicodeChar, 0, false, false, false, true);
        this.nativeKey(this.mNativeClass, 0, unicodeChar, 0, false, false, false, false);
    }

    private void viewSizeChanged(WebViewClassic.ViewSizeData data) {
        int w = data.mWidth;
        int h = data.mHeight;
        int textwrapWidth = data.mTextWrapWidth;
        float scale = data.mScale;
        if (w == 0) {
            Log.w(LOGTAG, "skip viewSizeChanged as w is 0");
            return;
        }
        int width = this.calculateWindowWidth(w);
        int height = h;
        if (width != w) {
            float heightWidthRatio = data.mHeightWidthRatio;
            float ratio = heightWidthRatio > 0.0f ? heightWidthRatio : (float)h / (float)w;
            height = Math.round(ratio * (float)width);
        }
        int screenHeight = data.mActualViewHeight > 0 ? data.mActualViewHeight : h;
        this.nativeSetSize(this.mNativeClass, width, height, textwrapWidth, scale, w, screenHeight, data.mAnchorX, data.mAnchorY, data.mIgnoreHeight);
        boolean needInvalidate = this.mCurrentViewWidth == 0;
        this.mCurrentViewWidth = w;
        this.mCurrentViewHeight = h;
        this.mCurrentViewScale = scale;
        if (needInvalidate) {
            this.contentDraw();
        }
    }

    private int calculateWindowWidth(int viewWidth) {
        int width = viewWidth;
        if (this.mSettings.getUseWideViewPort()) {
            width = this.mViewportWidth == -1 ? 980 : (this.mViewportWidth > 0 ? this.mViewportWidth : Math.round((float)this.mWebViewClassic.getViewWidth() / this.mWebViewClassic.getDefaultZoomScale()));
        }
        return width;
    }

    private long getUsedQuota() {
        WebStorageClassic webStorage = WebStorageClassic.getInstance();
        Collection<WebStorage.Origin> origins = webStorage.getOriginsSync();
        if (origins == null) {
            return 0L;
        }
        long usedQuota = 0L;
        for (WebStorage.Origin website : origins) {
            usedQuota += website.getQuota();
        }
        return usedQuota;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pauseWebKitDraw() {
        Object object = this.m_skipDrawFlagLock;
        synchronized (object) {
            if (!this.m_skipDrawFlag) {
                this.m_skipDrawFlag = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resumeWebKitDraw() {
        Object object = this.m_skipDrawFlagLock;
        synchronized (object) {
            if (this.m_skipDrawFlag && this.m_drawWasSkipped) {
                this.m_drawWasSkipped = false;
                this.mEventHub.sendMessage(Message.obtain(null, 130));
            }
            this.m_skipDrawFlag = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void webkitDraw() {
        Object object = this.m_skipDrawFlagLock;
        synchronized (object) {
            if (this.m_skipDrawFlag) {
                this.m_drawWasSkipped = true;
                return;
            }
        }
        this.mDrawIsScheduled = false;
        DrawData draw = new DrawData();
        draw.mBaseLayer = this.nativeRecordContent(this.mNativeClass, draw.mContentSize);
        if (draw.mBaseLayer == 0) {
            if (this.mWebViewClassic != null && !this.mWebViewClassic.isPaused()) {
                this.mEventHub.sendMessageDelayed(Message.obtain(null, 130), 10L);
            }
            return;
        }
        this.mLastDrawData = draw;
        this.webkitDraw(draw);
    }

    private void webkitDraw(DrawData draw) {
        if (this.mWebViewClassic != null) {
            draw.mFocusSizeChanged = this.nativeFocusBoundsChanged(this.mNativeClass);
            draw.mViewSize = new Point(this.mCurrentViewWidth, this.mCurrentViewHeight);
            if (this.mSettings.getUseWideViewPort()) {
                draw.mMinPrefWidth = Math.max(this.mViewportWidth == -1 ? 980 : (this.mViewportWidth == 0 ? this.mCurrentViewWidth : this.mViewportWidth), this.nativeGetContentMinPrefWidth(this.mNativeClass));
            }
            if (this.mInitialViewState != null) {
                draw.mViewState = this.mInitialViewState;
                this.mInitialViewState = null;
            }
            if (this.mFirstLayoutForNonStandardLoad) {
                draw.mFirstLayoutForNonStandardLoad = true;
                this.mFirstLayoutForNonStandardLoad = false;
            }
            this.pauseWebKitDraw();
            Message.obtain(this.mWebViewClassic.mPrivateHandler, 105, draw).sendToTarget();
        }
    }

    private void saveViewState(OutputStream stream, ValueCallback<Boolean> callback) {
        DrawData draw = new DrawData();
        draw.mBaseLayer = this.nativeRecordContent(this.mNativeClass, draw.mContentSize);
        boolean result = false;
        try {
            result = ViewStateSerializer.serializeViewState(stream, draw);
        }
        catch (Throwable t) {
            Log.w(LOGTAG, "Failed to save view state", t);
        }
        callback.onReceiveValue(result);
        if (draw.mBaseLayer != 0) {
            if (this.mDrawIsScheduled) {
                this.mDrawIsScheduled = false;
                this.mEventHub.removeMessages(130);
            }
            this.mLastDrawData = draw;
            this.webkitDraw(draw);
        }
    }

    static void reducePriority() {
        sWebCoreHandler.removeMessages(1);
        sWebCoreHandler.removeMessages(2);
        sWebCoreHandler.sendMessageAtFrontOfQueue(sWebCoreHandler.obtainMessage(1));
    }

    static void resumePriority() {
        sWebCoreHandler.removeMessages(1);
        sWebCoreHandler.removeMessages(2);
        sWebCoreHandler.sendMessageAtFrontOfQueue(sWebCoreHandler.obtainMessage(2));
    }

    static void sendStaticMessage(int messageType, Object argument) {
        if (sWebCoreHandler == null) {
            return;
        }
        sWebCoreHandler.sendMessage(sWebCoreHandler.obtainMessage(messageType, argument));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void pauseUpdatePicture(WebViewCore core) {
        if (core != null) {
            if (!core.getSettings().enableSmoothTransition()) {
                return;
            }
            WebViewCore webViewCore = core;
            synchronized (webViewCore) {
                if (core.mNativeClass == 0) {
                    Log.w(LOGTAG, "Cannot pauseUpdatePicture, core destroyed or not initialized!");
                    return;
                }
                core.nativeSetIsPaused(core.mNativeClass, true);
                core.mDrawIsPaused = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void resumeUpdatePicture(WebViewCore core) {
        if (core != null) {
            if (!core.mDrawIsPaused) {
                return;
            }
            WebViewCore webViewCore = core;
            synchronized (webViewCore) {
                if (core.mNativeClass == 0) {
                    Log.w(LOGTAG, "Cannot resumeUpdatePicture, core destroyed!");
                    return;
                }
                core.nativeSetIsPaused(core.mNativeClass, false);
                core.mDrawIsPaused = false;
                core.mDrawIsScheduled = false;
            }
        }
    }

    static boolean isUpdatePicturePaused(WebViewCore core) {
        return core != null ? core.mDrawIsPaused : false;
    }

    private void restoreState(int index) {
        WebBackForwardList list = this.mCallbackProxy.getBackForwardList();
        int size = list.getSize();
        for (int i = 0; i < size; ++i) {
            list.getItemAtIndex(i).inflate(this.mBrowserFrame.mNativeFrame);
        }
        this.mBrowserFrame.mLoadInitFromJava = true;
        WebBackForwardList.restoreIndex(this.mBrowserFrame.mNativeFrame, index);
        this.mBrowserFrame.mLoadInitFromJava = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void contentDraw() {
        WebViewCore webViewCore = this;
        synchronized (webViewCore) {
            if (this.mWebViewClassic == null || this.mBrowserFrame == null) {
                return;
            }
            if (this.mCurrentViewWidth == 0 || !this.mBrowserFrame.firstLayoutDone()) {
                return;
            }
            if (this.mDrawIsScheduled) {
                return;
            }
            this.mDrawIsScheduled = true;
            this.mEventHub.sendMessage(Message.obtain(null, 130));
        }
    }

    private void contentScrollTo(int x, int y, boolean animate, boolean onlyIfImeIsShowing) {
        if (!this.mBrowserFrame.firstLayoutDone()) {
            this.mRestoredX = x;
            this.mRestoredY = y;
            return;
        }
        if (this.mWebViewClassic != null) {
            Message msg = Message.obtain(this.mWebViewClassic.mPrivateHandler, 101, animate ? 1 : 0, onlyIfImeIsShowing ? 1 : 0, new Point(x, y));
            if (this.mDrawIsScheduled) {
                this.mEventHub.sendMessage(Message.obtain(null, 125, msg));
            } else {
                msg.sendToTarget();
            }
        }
    }

    private void sendNotifyProgressFinished() {
        this.contentDraw();
    }

    private void sendViewInvalidate(int left, int top, int right, int bottom) {
        if (this.mWebViewClassic != null) {
            Message.obtain(this.mWebViewClassic.mPrivateHandler, 117, new Rect(left, top, right, bottom)).sendToTarget();
        }
    }

    void signalRepaintDone() {
        mRepaintScheduled = false;
    }

    WebViewClassic getWebViewClassic() {
        return this.mWebViewClassic;
    }

    private WebView getWebView() {
        return this.mWebViewClassic.getWebView();
    }

    private void sendPluginDrawMsg() {
        this.sendMessage(195);
    }

    private void setViewportSettingsFromNative(int n) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#setViewportSettingsFromNative(I)V", true, this);
    }

    private void didFirstLayout(boolean standardLoad) {
        this.mBrowserFrame.didFirstLayout();
        if (this.mWebViewClassic == null) {
            return;
        }
        boolean updateViewState = standardLoad || this.mIsRestored;
        this.setupViewport(updateViewState);
        if (!updateViewState) {
            this.mWebViewClassic.mViewManager.postReadyToDrawAll();
        }
        this.mWebViewClassic.mPrivateHandler.sendEmptyMessage(131);
        this.mRestoredY = 0;
        this.mRestoredX = 0;
        this.mIsRestored = false;
        this.mRestoredTextWrapScale = 0.0f;
        this.mRestoredScale = 0.0f;
    }

    private void updateViewport() {
        this.setupViewport(true);
    }

    private void setupViewport(boolean updateViewState) {
        int webViewWidth;
        if (this.mWebViewClassic == null || this.mSettings == null) {
            return;
        }
        this.setViewportSettingsFromNative(this.mNativeClass);
        if (this.mViewportInitialScale > 0) {
            if (this.mViewportMinimumScale > 0) {
                this.mViewportInitialScale = Math.max(this.mViewportInitialScale, this.mViewportMinimumScale);
            }
            if (this.mViewportMaximumScale > 0) {
                this.mViewportInitialScale = Math.min(this.mViewportInitialScale, this.mViewportMaximumScale);
            }
        }
        if (this.mSettings.forceUserScalable()) {
            this.mViewportUserScalable = true;
            if (this.mViewportInitialScale > 0) {
                if (this.mViewportMinimumScale > 0) {
                    this.mViewportMinimumScale = Math.min(this.mViewportMinimumScale, this.mViewportInitialScale / 2);
                }
                if (this.mViewportMaximumScale > 0) {
                    this.mViewportMaximumScale = Math.max(this.mViewportMaximumScale, this.mViewportInitialScale * 2);
                }
            } else {
                if (this.mViewportMinimumScale > 0) {
                    this.mViewportMinimumScale = Math.min(this.mViewportMinimumScale, 50);
                }
                if (this.mViewportMaximumScale > 0) {
                    this.mViewportMaximumScale = Math.max(this.mViewportMaximumScale, 200);
                }
            }
        }
        float adjust = 1.0f;
        if (this.mViewportDensityDpi == -1) {
            adjust = this.mContext.getResources().getDisplayMetrics().density;
        } else if (this.mViewportDensityDpi > 0) {
            adjust = (float)this.mContext.getResources().getDisplayMetrics().densityDpi / (float)this.mViewportDensityDpi;
        }
        this.mWebViewClassic.mPrivateHandler.removeMessages(139);
        if (adjust != this.mWebViewClassic.getDefaultZoomScale()) {
            Message.obtain(this.mWebViewClassic.mPrivateHandler, 139, Float.valueOf(adjust)).sendToTarget();
        }
        int defaultScale = (int)(adjust * 100.0f);
        if (this.mViewportInitialScale > 0) {
            this.mViewportInitialScale = (int)((float)this.mViewportInitialScale * adjust);
        }
        if (this.mViewportMinimumScale > 0) {
            this.mViewportMinimumScale = (int)((float)this.mViewportMinimumScale * adjust);
        }
        if (this.mViewportMaximumScale > 0) {
            this.mViewportMaximumScale = (int)((float)this.mViewportMaximumScale * adjust);
        }
        if (this.mViewportWidth == 0 && this.mViewportInitialScale == 0) {
            this.mViewportInitialScale = defaultScale;
        }
        if (!this.mViewportUserScalable) {
            this.mViewportInitialScale = defaultScale;
            this.mViewportMinimumScale = defaultScale;
            this.mViewportMaximumScale = defaultScale;
        }
        if (this.mViewportMinimumScale > this.mViewportInitialScale && this.mViewportInitialScale != 0) {
            this.mViewportMinimumScale = this.mViewportInitialScale;
        }
        if (this.mViewportMaximumScale > 0 && this.mViewportMaximumScale < this.mViewportInitialScale) {
            this.mViewportMaximumScale = this.mViewportInitialScale;
        }
        if (this.mViewportWidth < 0 && this.mViewportInitialScale == defaultScale) {
            this.mViewportWidth = 0;
        }
        if (this.mViewportWidth != 0 && !updateViewState) {
            this.mFirstLayoutForNonStandardLoad = true;
            ViewState viewState = new ViewState();
            viewState.mMinScale = (float)this.mViewportMinimumScale / 100.0f;
            viewState.mMaxScale = (float)this.mViewportMaximumScale / 100.0f;
            viewState.mDefaultScale = adjust;
            viewState.mMobileSite = false;
            viewState.mScrollX = 0;
            viewState.mShouldStartScrolledRight = false;
            Message.obtain(this.mWebViewClassic.mPrivateHandler, 109, viewState).sendToTarget();
            return;
        }
        int viewportWidth = this.mCurrentViewWidth;
        if (viewportWidth == 0) {
            webViewWidth = this.mWebViewClassic.getViewWidth();
            viewportWidth = (int)((float)webViewWidth / adjust);
            if (viewportWidth == 0) {
                // empty if block
            }
        } else {
            webViewWidth = Math.round((float)viewportWidth * this.mCurrentViewScale);
        }
        this.mInitialViewState = new ViewState();
        this.mInitialViewState.mMinScale = (float)this.mViewportMinimumScale / 100.0f;
        this.mInitialViewState.mMaxScale = (float)this.mViewportMaximumScale / 100.0f;
        this.mInitialViewState.mDefaultScale = adjust;
        this.mInitialViewState.mScrollX = this.mRestoredX;
        this.mInitialViewState.mScrollY = this.mRestoredY;
        this.mInitialViewState.mShouldStartScrolledRight = this.mRestoredX == 0 && this.mRestoredY == 0 && this.mBrowserFrame != null && this.mBrowserFrame.getShouldStartScrolledRight();
        boolean bl = this.mInitialViewState.mMobileSite = 0 == this.mViewportWidth;
        if (this.mIsRestored) {
            this.mInitialViewState.mIsRestored = true;
            this.mInitialViewState.mViewScale = this.mRestoredScale;
            this.mInitialViewState.mTextWrapScale = this.mRestoredTextWrapScale > 0.0f ? this.mRestoredTextWrapScale : this.mInitialViewState.mViewScale;
        } else if (this.mViewportInitialScale > 0) {
            this.mInitialViewState.mViewScale = this.mInitialViewState.mTextWrapScale = (float)this.mViewportInitialScale / 100.0f;
        } else if (this.mViewportWidth > 0 && this.mViewportWidth < webViewWidth && !this.getSettings().getUseFixedViewport()) {
            this.mInitialViewState.mViewScale = this.mInitialViewState.mTextWrapScale = (float)webViewWidth / (float)this.mViewportWidth;
        } else {
            this.mInitialViewState.mTextWrapScale = adjust;
            this.mInitialViewState.mViewScale = this.mSettings.getUseWideViewPort() ? 0.0f : adjust;
        }
        if (this.mWebViewClassic.mHeightCanMeasure) {
            this.mWebViewClassic.mLastHeightSent = 0;
            WebViewClassic.ViewSizeData data = new WebViewClassic.ViewSizeData();
            data.mWidth = this.mWebViewClassic.mLastWidthSent;
            data.mHeight = 0;
            data.mTextWrapWidth = data.mWidth;
            data.mScale = -1.0f;
            data.mIgnoreHeight = false;
            data.mAnchorY = 0;
            data.mAnchorX = 0;
            this.mEventHub.removeMessages(105);
            this.mEventHub.sendMessageAtFrontOfQueue(Message.obtain(null, 105, data));
        } else if (viewportWidth == 0) {
            this.mWebViewClassic.mLastWidthSent = 0;
        } else {
            WebViewClassic.ViewSizeData data = new WebViewClassic.ViewSizeData();
            float tentativeScale = this.mInitialViewState.mViewScale;
            if (tentativeScale == 0.0f) {
                tentativeScale = this.mInitialViewState.mTextWrapScale;
                int tentativeViewWidth = Math.round((float)webViewWidth / tentativeScale);
                int windowWidth = this.calculateWindowWidth(tentativeViewWidth);
                data.mScale = (float)webViewWidth / (float)windowWidth;
                if (!this.mSettings.getLoadWithOverviewMode()) {
                    data.mScale = Math.max(data.mScale, tentativeScale);
                }
                if (this.mSettings.isNarrowColumnLayout()) {
                    this.mInitialViewState.mTextWrapScale = this.mWebViewClassic.computeReadingLevelScale(data.mScale);
                }
            } else {
                data.mScale = tentativeScale;
            }
            data.mWidth = Math.round((float)webViewWidth / data.mScale);
            data.mHeight = this.mCurrentViewHeight == 0 ? Math.round((float)this.mWebViewClassic.getViewHeight() / data.mScale) : Math.round((float)this.mCurrentViewHeight * (float)data.mWidth / (float)viewportWidth);
            data.mTextWrapWidth = Math.round((float)webViewWidth / this.mInitialViewState.mTextWrapScale);
            data.mIgnoreHeight = false;
            data.mAnchorY = 0;
            data.mAnchorX = 0;
            this.mEventHub.removeMessages(105);
            this.viewSizeChanged(data);
        }
    }

    private void restoreScale(float scale, float textWrapScale) {
        if (!this.mBrowserFrame.firstLayoutDone()) {
            this.mIsRestored = true;
            this.mRestoredScale = scale;
            if (this.mSettings.getUseWideViewPort()) {
                this.mRestoredTextWrapScale = textWrapScale;
            }
        }
    }

    private void needTouchEvents(boolean need) {
        if (this.mWebViewClassic != null) {
            Message.obtain(this.mWebViewClassic.mPrivateHandler, 116, need ? 1 : 0, 0).sendToTarget();
        }
    }

    private void updateTextfield(int ptr, boolean changeToPassword, String text, int textGeneration) {
        if (this.mWebViewClassic != null) {
            Message msg = Message.obtain(this.mWebViewClassic.mPrivateHandler, 108, ptr, textGeneration, text);
            msg.getData().putBoolean("password", changeToPassword);
            msg.sendToTarget();
        }
    }

    private TextSelectionData createTextSelection(int start, int end, int selPtr) {
        TextSelectionData data = new TextSelectionData(start, end, selPtr);
        data.mSelectionReason = this.mTextSelectionChangeReason;
        return data;
    }

    private void updateTextSelection(int pointer, int start, int end, int textGeneration, int selectionPtr) {
        if (this.mWebViewClassic != null) {
            Message.obtain(this.mWebViewClassic.mPrivateHandler, 112, pointer, textGeneration, this.createTextSelection(start, end, selectionPtr)).sendToTarget();
        }
    }

    private void updateTextSizeAndScroll(int pointer, int width, int height, int scrollX, int scrollY) {
        if (this.mWebViewClassic != null) {
            Rect rect = new Rect(-scrollX, -scrollY, width - scrollX, height - scrollY);
            Message.obtain(this.mWebViewClassic.mPrivateHandler, 150, pointer, 0, rect).sendToTarget();
        }
    }

    private void clearTextEntry() {
        if (this.mWebViewClassic == null) {
            return;
        }
        Message.obtain(this.mWebViewClassic.mPrivateHandler, 111).sendToTarget();
    }

    private void initEditField(int start, int end, int selectionPtr, TextFieldInitData initData) {
        if (this.mWebViewClassic == null) {
            return;
        }
        Message.obtain(this.mWebViewClassic.mPrivateHandler, 142, initData).sendToTarget();
        Message.obtain(this.mWebViewClassic.mPrivateHandler, 112, initData.mFieldPointer, 0, this.createTextSelection(start, end, selectionPtr)).sendToTarget();
    }

    private void nativeRevealSelection(int n) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeRevealSelection(I)V", true, this);
    }

    private String nativeRequestLabel(int n, int n2, int n3) {
        return (String)OverrideMethod.invokeA("android.webkit.WebViewCore#nativeRequestLabel(III)Ljava/lang/String;", true, this);
    }

    private void nativeScrollFocusedTextInput(int n, float f, int n2, Rect rect) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeScrollFocusedTextInput(IFILandroid/graphics/Rect;)V", true, this);
    }

    private void nativeSetScrollOffset(int n, boolean bl, int n2, int n3) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeSetScrollOffset(IZII)V", true, this);
    }

    private void nativeSetGlobalBounds(int n, int n2, int n3, int n4, int n5) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeSetGlobalBounds(IIIII)V", true, this);
    }

    private void requestListBox(String[] array2, int[] enabledArray, int[] selectedArray) {
        if (this.mWebViewClassic != null) {
            this.mWebViewClassic.requestListBox(array2, enabledArray, selectedArray);
        }
    }

    private void requestListBox(String[] array2, int[] enabledArray, int selection) {
        if (this.mWebViewClassic != null) {
            this.mWebViewClassic.requestListBox(array2, enabledArray, selection);
        }
    }

    private void requestKeyboard(boolean showKeyboard) {
        if (this.mWebViewClassic != null) {
            Message.obtain(this.mWebViewClassic.mPrivateHandler, 118, showKeyboard ? 1 : 0, 0).sendToTarget();
        }
    }

    private void setWebTextViewAutoFillable(int queryId, String preview) {
        if (this.mWebViewClassic != null) {
            Message.obtain(this.mWebViewClassic.mPrivateHandler, 133, new AutoFillData(queryId, preview)).sendToTarget();
        }
    }

    Context getContext() {
        return this.mContext;
    }

    private void keepScreenOn(boolean screenOn) {
        if (this.mWebViewClassic != null) {
            Message message = this.mWebViewClassic.mPrivateHandler.obtainMessage(136);
            message.arg1 = screenOn ? 1 : 0;
            message.sendToTarget();
        }
    }

    private Class<?> getPluginClass(String libName, String clsName) {
        if (this.mWebViewClassic == null) {
            return null;
        }
        PluginManager pluginManager = PluginManager.getInstance(null);
        String pkgName = pluginManager.getPluginsAPKName(libName);
        if (pkgName == null) {
            Log.w(LOGTAG, "Unable to resolve " + libName + " to a plugin APK");
            return null;
        }
        try {
            return pluginManager.getPluginClass(pkgName, clsName);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e(LOGTAG, "Unable to find plugin classloader for the apk (" + pkgName + ")");
        }
        catch (ClassNotFoundException e) {
            Log.e(LOGTAG, "Unable to find plugin class (" + clsName + ") in the apk (" + pkgName + ")");
        }
        return null;
    }

    private void showFullScreenPlugin(ViewManager.ChildView childView, int orientation, int npp) {
        if (this.mWebViewClassic == null) {
            return;
        }
        Message message = this.mWebViewClassic.mPrivateHandler.obtainMessage(120);
        message.obj = childView.mView;
        message.arg1 = orientation;
        message.arg2 = npp;
        message.sendToTarget();
    }

    private void hideFullScreenPlugin() {
        if (this.mWebViewClassic == null) {
            return;
        }
        this.mWebViewClassic.mPrivateHandler.obtainMessage(121).sendToTarget();
    }

    private ViewManager.ChildView createSurface(View pluginView) {
        if (this.mWebViewClassic == null) {
            return null;
        }
        if (pluginView == null) {
            Log.e(LOGTAG, "Attempted to add an empty plugin view to the view hierarchy");
            return null;
        }
        pluginView.setWillNotDraw(false);
        if (pluginView instanceof SurfaceView) {
            ((SurfaceView)pluginView).setZOrderOnTop(true);
        }
        ViewManager.ChildView view = this.mWebViewClassic.mViewManager.createView();
        view.mView = pluginView;
        return view;
    }

    private ViewManager.ChildView addSurface(View pluginView, int x, int y, int width, int height) {
        ViewManager.ChildView view = this.createSurface(pluginView);
        view.attachView(x, y, width, height);
        return view;
    }

    private void updateSurface(ViewManager.ChildView childView, int x, int y, int width, int height) {
        childView.attachView(x, y, width, height);
    }

    private void destroySurface(ViewManager.ChildView childView) {
        childView.removeView();
    }

    private void showRect(int left, int top, int width, int height, int contentWidth, int contentHeight, float xPercentInDoc, float xPercentInView, float yPercentInDoc, float yPercentInView) {
        if (this.mWebViewClassic != null) {
            ShowRectData data = new ShowRectData();
            data.mLeft = left;
            data.mTop = top;
            data.mWidth = width;
            data.mHeight = height;
            data.mContentWidth = contentWidth;
            data.mContentHeight = contentHeight;
            data.mXPercentInDoc = xPercentInDoc;
            data.mXPercentInView = xPercentInView;
            data.mYPercentInDoc = yPercentInDoc;
            data.mYPercentInView = yPercentInView;
            Message.obtain(this.mWebViewClassic.mPrivateHandler, 113, data).sendToTarget();
        }
    }

    private void centerFitRect(int x, int y, int width, int height) {
        if (this.mWebViewClassic == null) {
            return;
        }
        this.mWebViewClassic.mPrivateHandler.obtainMessage(127, new Rect(x, y, x + width, y + height)).sendToTarget();
    }

    private void setScrollbarModes(int hMode, int vMode) {
        if (this.mWebViewClassic == null) {
            return;
        }
        this.mWebViewClassic.mPrivateHandler.obtainMessage(129, hMode, vMode).sendToTarget();
    }

    private void selectAt(int x, int y) {
    }

    private void setUseMockDeviceOrientation() {
        this.mDeviceMotionAndOrientationManager.setUseMock();
    }

    public void setMockDeviceOrientation(boolean canProvideAlpha, double alpha, boolean canProvideBeta, double beta, boolean canProvideGamma, double gamma) {
        this.mDeviceMotionAndOrientationManager.setMockOrientation(canProvideAlpha, alpha, canProvideBeta, beta, canProvideGamma, gamma);
    }

    protected DeviceMotionService getDeviceMotionService() {
        if (this.mDeviceMotionService == null) {
            this.mDeviceMotionService = new DeviceMotionService(this.mDeviceMotionAndOrientationManager, this.mContext);
        }
        return this.mDeviceMotionService;
    }

    protected DeviceOrientationService getDeviceOrientationService() {
        if (this.mDeviceOrientationService == null) {
            this.mDeviceOrientationService = new DeviceOrientationService(this.mDeviceMotionAndOrientationManager, this.mContext);
        }
        return this.mDeviceOrientationService;
    }

    static void setShouldMonitorWebCoreThread() {
        sShouldMonitorWebCoreThread = true;
    }

    private void nativeSetIsPaused(int n, boolean bl) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeSetIsPaused(IZ)V", true, this);
    }

    private void nativePause(int n) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativePause(I)V", true, this);
    }

    private void nativeResume(int n) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeResume(I)V", true, this);
    }

    private void nativeFreeMemory(int n) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeFreeMemory(I)V", true, this);
    }

    private void nativeFullScreenPluginHidden(int n, int n2) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeFullScreenPluginHidden(II)V", true, this);
    }

    private void nativePluginSurfaceReady(int n) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativePluginSurfaceReady(I)V", true, this);
    }

    private WebKitHitTest nativeHitTest(int n, int n2, int n3, int n4, boolean bl) {
        return (WebKitHitTest)OverrideMethod.invokeA("android.webkit.WebViewCore#nativeHitTest(IIIIZ)Landroid/webkit/WebViewCore$WebKitHitTest;", true, this);
    }

    private void nativeAutoFillForm(int n, int n2) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeAutoFillForm(II)V", true, this);
    }

    private void nativeScrollLayer(int n, int n2, Rect rect) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeScrollLayer(IILandroid/graphics/Rect;)V", true, this);
    }

    private int nativeFindAll(int n, String string2) {
        return OverrideMethod.invokeI("android.webkit.WebViewCore#nativeFindAll(ILjava/lang/String;)I", true, this);
    }

    private int nativeFindNext(int n, boolean bl) {
        return OverrideMethod.invokeI("android.webkit.WebViewCore#nativeFindNext(IZ)I", true, this);
    }

    private void nativeDeleteText(int n, int n2, int n3, int n4, int n5) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeDeleteText(IIIII)V", true, this);
    }

    private void nativeInsertText(int n, String string2) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeInsertText(ILjava/lang/String;)V", true, this);
    }

    private String nativeGetText(int n, int n2, int n3, int n4, int n5) {
        return (String)OverrideMethod.invokeA("android.webkit.WebViewCore#nativeGetText(IIIII)Ljava/lang/String;", true, this);
    }

    private void nativeSelectText(int n, int n2, int n3, int n4, int n5) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeSelectText(IIIII)V", true, this);
    }

    private void nativeClearTextSelection(int n) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeClearTextSelection(I)V", true, this);
    }

    private boolean nativeSelectWordAt(int n, int n2, int n3) {
        return OverrideMethod.invokeI("android.webkit.WebViewCore#nativeSelectWordAt(III)Z", true, this) != 0;
    }

    private void nativeSelectAll(int n) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeSelectAll(I)V", true, this);
    }

    private void nativeSetInitialFocus(int n, int n2) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeSetInitialFocus(II)V", true, this);
    }

    private static void nativeCertTrustChanged() {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeCertTrustChanged()V", true, null);
    }

    static {
        try {
            System.loadLibrary(LOGTAG);
            System.loadLibrary("chromium_net");
        }
        catch (UnsatisfiedLinkError e) {
            Log.e(LOGTAG, "Unable to load native support libraries.");
        }
        HandlerDebugString = new String[]{"REVEAL_SELECTION", "", "", "SCROLL_TEXT_INPUT", "LOAD_URL", "STOP_LOADING", "RELOAD", "KEY_DOWN", "KEY_UP", "VIEW_SIZE_CHANGED", "GO_BACK_FORWARD", "SET_SCROLL_OFFSET", "RESTORE_STATE", "PAUSE_TIMERS", "RESUME_TIMERS", "CLEAR_CACHE", "CLEAR_HISTORY", "SET_SELECTION", "REPLACE_TEXT", "PASS_TO_JS", "SET_GLOBAL_BOUNDS", "", "CLICK", "SET_NETWORK_STATE", "DOC_HAS_IMAGES", "FAKE_CLICK", "DELETE_SELECTION", "LISTBOX_CHOICES", "SINGLE_LISTBOX_CHOICE", "MESSAGE_RELAY", "SET_BACKGROUND_COLOR", "SET_MOVE_FOCUS", "SAVE_DOCUMENT_STATE", "129", "WEBKIT_DRAW", "131", "POST_URL", "", "CLEAR_CONTENT", "", "", "REQUEST_CURSOR_HREF", "ADD_JS_INTERFACE", "LOAD_DATA", "", "", "SET_ACTIVE", "ON_PAUSE", "ON_RESUME", "FREE_MEMORY", "VALID_NODE_BOUNDS", "SAVE_WEBARCHIVE", "WEBKIT_DRAW_LAYERS", "REMOVE_JS_INTERFACE"};
        mRepaintScheduled = false;
    }

    static class ShowRectData {
        int mLeft;
        int mTop;
        int mWidth;
        int mHeight;
        int mContentWidth;
        int mContentHeight;
        float mXPercentInDoc;
        float mXPercentInView;
        float mYPercentInDoc;
        float mYPercentInView;

        ShowRectData() {
        }
    }

    static class DrawData {
        int mBaseLayer = 0;
        Point mViewSize;
        Point mContentSize = new Point();
        int mMinPrefWidth;
        ViewState mViewState;
        boolean mFirstLayoutForNonStandardLoad;
        boolean mFocusSizeChanged;

        DrawData() {
        }
    }

    static class ViewState {
        float mMinScale;
        float mMaxScale;
        float mViewScale;
        float mTextWrapScale;
        float mDefaultScale;
        int mScrollX;
        int mScrollY;
        boolean mMobileSite;
        boolean mIsRestored;
        boolean mShouldStartScrolledRight;

        ViewState() {
        }
    }

    public class EventHub
    implements WebViewInputDispatcher.WebKitCallbacks {
        static final int REVEAL_SELECTION = 96;
        static final int SCROLL_TEXT_INPUT = 99;
        static final int LOAD_URL = 100;
        static final int STOP_LOADING = 101;
        static final int RELOAD = 102;
        static final int KEY_DOWN = 103;
        static final int KEY_UP = 104;
        static final int VIEW_SIZE_CHANGED = 105;
        static final int GO_BACK_FORWARD = 106;
        static final int SET_SCROLL_OFFSET = 107;
        static final int RESTORE_STATE = 108;
        static final int PAUSE_TIMERS = 109;
        static final int RESUME_TIMERS = 110;
        static final int CLEAR_CACHE = 111;
        static final int CLEAR_HISTORY = 112;
        static final int SET_SELECTION = 113;
        static final int REPLACE_TEXT = 114;
        static final int PASS_TO_JS = 115;
        static final int SET_GLOBAL_BOUNDS = 116;
        static final int SET_NETWORK_STATE = 119;
        static final int DOC_HAS_IMAGES = 120;
        static final int DELETE_SELECTION = 122;
        static final int LISTBOX_CHOICES = 123;
        static final int SINGLE_LISTBOX_CHOICE = 124;
        public static final int MESSAGE_RELAY = 125;
        static final int SET_BACKGROUND_COLOR = 126;
        static final int SAVE_DOCUMENT_STATE = 128;
        static final int DELETE_SURROUNDING_TEXT = 129;
        static final int WEBKIT_DRAW = 130;
        static final int POST_URL = 132;
        static final int CLEAR_CONTENT = 134;
        static final int SET_MOVE_MOUSE = 135;
        static final int REQUEST_CURSOR_HREF = 137;
        static final int ADD_JS_INTERFACE = 138;
        static final int LOAD_DATA = 139;
        static final int SET_ACTIVE = 142;
        static final int ON_PAUSE = 143;
        static final int ON_RESUME = 144;
        static final int FREE_MEMORY = 145;
        static final int SAVE_WEBARCHIVE = 147;
        static final int REMOVE_JS_INTERFACE = 149;
        static final int CLEAR_SSL_PREF_TABLE = 150;
        static final int REQUEST_EXT_REPRESENTATION = 160;
        static final int REQUEST_DOC_AS_TEXT = 161;
        static final int DUMP_DOMTREE = 170;
        static final int DUMP_RENDERTREE = 171;
        static final int SET_JS_FLAGS = 174;
        static final int CONTENT_INVALIDATE_ALL = 175;
        static final int GEOLOCATION_PERMISSIONS_PROVIDE = 180;
        static final int POPULATE_VISITED_LINKS = 181;
        static final int HIDE_FULLSCREEN = 182;
        static final int SET_NETWORK_TYPE = 183;
        static final int ADD_PACKAGE_NAMES = 184;
        static final int ADD_PACKAGE_NAME = 185;
        static final int REMOVE_PACKAGE_NAME = 186;
        static final int MODIFY_SELECTION = 190;
        static final int SET_USE_MOCK_DEVICE_ORIENTATION = 191;
        static final int AUTOFILL_FORM = 192;
        static final int PROXY_CHANGED = 193;
        static final int EXECUTE_JS = 194;
        static final int PLUGIN_SURFACE_READY = 195;
        static final int NOTIFY_ANIMATION_STARTED = 196;
        static final int HEARTBEAT = 197;
        static final int SCROLL_LAYER = 198;
        private static final int DESTROY = 200;
        static final int COPY_TEXT = 210;
        static final int DELETE_TEXT = 211;
        static final int INSERT_TEXT = 212;
        static final int SELECT_TEXT = 213;
        static final int SELECT_WORD_AT = 214;
        static final int SELECT_ALL = 215;
        static final int TRUST_STORAGE_UPDATED = 220;
        static final int FIND_ALL = 221;
        static final int FIND_NEXT = 222;
        static final int KEY_PRESS = 223;
        static final int SET_INITIAL_FOCUS = 224;
        static final int SAVE_VIEW_STATE = 225;
        private Handler mHandler;
        private LinkedList<Message> mMessages = new LinkedList();
        private boolean mBlockMessages;
        private boolean mDestroying;
        private int mTid;
        private int mSavedPriority;
        private static final int FIRST_PACKAGE_MSG_ID = 96;
        private static final int LAST_PACKAGE_MSG_ID = 149;

        private EventHub() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void transferMessages() {
            this.mTid = Process.myTid();
            this.mSavedPriority = Process.getThreadPriority(this.mTid);
            this.mHandler = new Handler(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void handleMessage(Message msg) {
                    switch (msg.what) {
                        case 109: {
                            EventHub.this.mSavedPriority = Process.getThreadPriority(EventHub.this.mTid);
                            Process.setThreadPriority(EventHub.this.mTid, 10);
                            WebViewCore.pauseTimers();
                            if (WebViewCore.this.mNativeClass != 0) {
                                WebViewCore.this.nativeCloseIdleConnections(WebViewCore.this.mNativeClass);
                            }
                            return;
                        }
                        case 110: {
                            Process.setThreadPriority(EventHub.this.mTid, EventHub.this.mSavedPriority);
                            WebViewCore.resumeTimers();
                            return;
                        }
                    }
                    if (WebViewCore.this.mWebViewClassic == null || WebViewCore.this.mNativeClass == 0) {
                        return;
                    }
                    if (EventHub.this.mDestroying && msg.what != 200) {
                        return;
                    }
                    switch (msg.what) {
                        case 130: {
                            WebViewCore.this.webkitDraw();
                            break;
                        }
                        case 200: {
                            WebViewCore webViewCore = WebViewCore.this;
                            synchronized (webViewCore) {
                                WebViewCore.this.mCallbackProxy.shutdown();
                                CallbackProxy callbackProxy = WebViewCore.this.mCallbackProxy;
                                synchronized (callbackProxy) {
                                    WebViewCore.this.mCallbackProxy.notify();
                                }
                                WebViewCore.this.mBrowserFrame.destroy();
                                WebViewCore.this.mBrowserFrame = null;
                                WebViewCore.this.mSettings.onDestroyed();
                                WebViewCore.this.mNativeClass = 0;
                                WebViewCore.this.mWebViewClassic = null;
                                break;
                            }
                        }
                        case 96: {
                            WebViewCore.this.nativeRevealSelection(WebViewCore.this.mNativeClass);
                            break;
                        }
                        case 99: {
                            float xPercent = msg.obj == null ? 0.0f : ((Float)msg.obj).floatValue();
                            Rect contentBounds = new Rect();
                            WebViewCore.this.nativeScrollFocusedTextInput(WebViewCore.this.mNativeClass, xPercent, msg.arg2, contentBounds);
                            Message.obtain(((WebViewCore)WebViewCore.this).mWebViewClassic.mPrivateHandler, 152, contentBounds).sendToTarget();
                            break;
                        }
                        case 100: {
                            CookieManagerClassic.getInstance().waitForCookieOperationsToComplete();
                            GetUrlData param = (GetUrlData)msg.obj;
                            WebViewCore.this.loadUrl(param.mUrl, param.mExtraHeaders);
                            break;
                        }
                        case 132: {
                            CookieManagerClassic.getInstance().waitForCookieOperationsToComplete();
                            PostUrlData param = (PostUrlData)msg.obj;
                            WebViewCore.this.mBrowserFrame.postUrl(param.mUrl, param.mPostData);
                            break;
                        }
                        case 139: {
                            String scheme;
                            int i;
                            CookieManagerClassic.getInstance().waitForCookieOperationsToComplete();
                            BaseUrlData loadParams = (BaseUrlData)msg.obj;
                            String baseUrl = loadParams.mBaseUrl;
                            if (!(baseUrl == null || (i = baseUrl.indexOf(58)) <= 0 || (scheme = baseUrl.substring(0, i)).startsWith("http") || scheme.startsWith("ftp") || scheme.startsWith("about") || scheme.startsWith("javascript"))) {
                                WebViewCore.this.nativeRegisterURLSchemeAsLocal(WebViewCore.this.mNativeClass, scheme);
                            }
                            WebViewCore.this.mBrowserFrame.loadData(baseUrl, loadParams.mData, loadParams.mMimeType, loadParams.mEncoding, loadParams.mHistoryUrl);
                            WebViewCore.this.nativeContentInvalidateAll(WebViewCore.this.mNativeClass);
                            break;
                        }
                        case 101: {
                            if (WebViewCore.this.mBrowserFrame.committed() && !WebViewCore.this.mBrowserFrame.firstLayoutDone()) {
                                WebViewCore.this.mBrowserFrame.didFirstLayout();
                            }
                            WebViewCore.this.stopLoading();
                            break;
                        }
                        case 102: {
                            WebViewCore.this.mBrowserFrame.reload(false);
                            break;
                        }
                        case 103: {
                            WebViewCore.this.key((KeyEvent)msg.obj, msg.arg1, true);
                            break;
                        }
                        case 104: {
                            WebViewCore.this.key((KeyEvent)msg.obj, msg.arg1, false);
                            break;
                        }
                        case 223: {
                            WebViewCore.this.keyPress(msg.arg1);
                            break;
                        }
                        case 105: {
                            WebViewCore.this.viewSizeChanged((WebViewClassic.ViewSizeData)msg.obj);
                            break;
                        }
                        case 107: {
                            Point pt = (Point)msg.obj;
                            WebViewCore.this.nativeSetScrollOffset(WebViewCore.this.mNativeClass, msg.arg1 == 1, pt.x, pt.y);
                            break;
                        }
                        case 116: {
                            Rect r = (Rect)msg.obj;
                            WebViewCore.this.nativeSetGlobalBounds(WebViewCore.this.mNativeClass, r.left, r.top, r.width(), r.height());
                            break;
                        }
                        case 106: {
                            if (!WebViewCore.this.mBrowserFrame.committed() && msg.arg1 == -1 && WebViewCore.this.mBrowserFrame.loadType() == 0) {
                                WebViewCore.this.mBrowserFrame.reload(true);
                                break;
                            }
                            WebViewCore.this.mBrowserFrame.goBackOrForward(msg.arg1);
                            break;
                        }
                        case 108: {
                            WebViewCore.this.stopLoading();
                            WebViewCore.this.restoreState(msg.arg1);
                            break;
                        }
                        case 143: {
                            WebViewCore.this.nativePause(WebViewCore.this.mNativeClass);
                            break;
                        }
                        case 144: {
                            WebViewCore.this.nativeResume(WebViewCore.this.mNativeClass);
                            break;
                        }
                        case 145: {
                            WebViewCore.this.clearCache(false);
                            WebViewCore.this.nativeFreeMemory(WebViewCore.this.mNativeClass);
                            break;
                        }
                        case 119: {
                            if (BrowserFrame.sJavaBridge == null) {
                                throw new IllegalStateException("No WebView has been created in this process!");
                            }
                            BrowserFrame.sJavaBridge.setNetworkOnLine(msg.arg1 == 1);
                            break;
                        }
                        case 183: {
                            if (BrowserFrame.sJavaBridge == null) {
                                throw new IllegalStateException("No WebView has been created in this process!");
                            }
                            Map map = (Map)msg.obj;
                            BrowserFrame.sJavaBridge.setNetworkType((String)map.get("type"), (String)map.get("subtype"));
                            break;
                        }
                        case 111: {
                            WebViewCore.this.clearCache(msg.arg1 == 1);
                            break;
                        }
                        case 112: {
                            WebViewCore.this.mCallbackProxy.getBackForwardList().close(((WebViewCore)WebViewCore.this).mBrowserFrame.mNativeFrame);
                            break;
                        }
                        case 114: {
                            ReplaceTextData rep = (ReplaceTextData)msg.obj;
                            WebViewCore.this.nativeReplaceTextfieldText(WebViewCore.this.mNativeClass, msg.arg1, msg.arg2, rep.mReplace, rep.mNewStart, rep.mNewEnd, rep.mTextGeneration);
                            break;
                        }
                        case 115: {
                            JSKeyData jsData = (JSKeyData)msg.obj;
                            KeyEvent evt = jsData.mEvent;
                            int keyCode = evt.getKeyCode();
                            int keyValue = evt.getUnicodeChar();
                            int generation = msg.arg1;
                            WebViewCore.this.passToJs(WebViewCore.this.mNativeClass, generation, jsData.mCurrentText, keyCode, keyValue, evt.isDown(), evt.isShiftPressed(), evt.isAltPressed(), evt.isSymPressed());
                            break;
                        }
                        case 128: {
                            WebViewCore.this.nativeSaveDocumentState(WebViewCore.this.mNativeClass);
                            break;
                        }
                        case 150: {
                            SslCertLookupTable.getInstance().clear();
                            WebViewCore.this.nativeCloseIdleConnections(WebViewCore.this.mNativeClass);
                            break;
                        }
                        case 142: {
                            WebViewCore.this.nativeSetFocusControllerActive(WebViewCore.this.mNativeClass, msg.arg1 == 1);
                            break;
                        }
                        case 138: {
                            JSInterfaceData jsData = (JSInterfaceData)msg.obj;
                            WebViewCore.this.mBrowserFrame.addJavascriptInterface(jsData.mObject, jsData.mInterfaceName, jsData.mRequireAnnotation);
                            break;
                        }
                        case 149: {
                            JSInterfaceData jsData = (JSInterfaceData)msg.obj;
                            WebViewCore.this.mBrowserFrame.removeJavascriptInterface(jsData.mInterfaceName);
                            break;
                        }
                        case 160: {
                            WebViewCore.this.mBrowserFrame.externalRepresentation((Message)msg.obj);
                            break;
                        }
                        case 161: {
                            WebViewCore.this.mBrowserFrame.documentAsText((Message)msg.obj);
                            break;
                        }
                        case 135: {
                            WebViewCore.this.nativeMoveMouse(WebViewCore.this.mNativeClass, msg.arg1, msg.arg2);
                            break;
                        }
                        case 137: {
                            WebKitHitTest hit = WebViewCore.this.performHitTest(msg.arg1, msg.arg2, 1, false);
                            Message hrefMsg = (Message)msg.obj;
                            Bundle data = hrefMsg.getData();
                            data.putString("url", hit.mLinkUrl);
                            data.putString("title", hit.mAnchorText);
                            data.putString("src", hit.mImageUrl);
                            hrefMsg.sendToTarget();
                            break;
                        }
                        case 120: {
                            Message imageResult = (Message)msg.obj;
                            imageResult.arg1 = WebViewCore.this.mBrowserFrame.documentHasImages() ? 1 : 0;
                            imageResult.sendToTarget();
                            break;
                        }
                        case 122: {
                            TextSelectionData deleteSelectionData = (TextSelectionData)msg.obj;
                            WebViewCore.this.nativeDeleteSelection(WebViewCore.this.mNativeClass, deleteSelectionData.mStart, deleteSelectionData.mEnd, msg.arg1);
                            break;
                        }
                        case 113: {
                            WebViewCore.this.nativeSetSelection(WebViewCore.this.mNativeClass, msg.arg1, msg.arg2);
                            break;
                        }
                        case 190: {
                            WebViewCore.this.mTextSelectionChangeReason = 1;
                            String modifiedSelectionString = WebViewCore.this.nativeModifySelection(WebViewCore.this.mNativeClass, msg.arg1, msg.arg2);
                            ((WebViewCore)WebViewCore.this).mWebViewClassic.mPrivateHandler.obtainMessage(130, modifiedSelectionString).sendToTarget();
                            WebViewCore.this.mTextSelectionChangeReason = 0;
                            break;
                        }
                        case 123: {
                            SparseBooleanArray choices = (SparseBooleanArray)msg.obj;
                            int choicesSize = msg.arg1;
                            boolean[] choicesArray = new boolean[choicesSize];
                            for (int c = 0; c < choicesSize; ++c) {
                                choicesArray[c] = choices.get(c);
                            }
                            WebViewCore.this.nativeSendListBoxChoices(WebViewCore.this.mNativeClass, choicesArray, choicesSize);
                            break;
                        }
                        case 124: {
                            WebViewCore.this.nativeSendListBoxChoice(WebViewCore.this.mNativeClass, msg.arg1);
                            break;
                        }
                        case 126: {
                            WebViewCore.this.nativeSetBackgroundColor(WebViewCore.this.mNativeClass, msg.arg1);
                            break;
                        }
                        case 170: {
                            WebViewCore.this.nativeDumpDomTree(WebViewCore.this.mNativeClass, msg.arg1 == 1);
                            break;
                        }
                        case 171: {
                            WebViewCore.this.nativeDumpRenderTree(WebViewCore.this.mNativeClass, msg.arg1 == 1);
                            break;
                        }
                        case 174: {
                            WebViewCore.this.nativeSetJsFlags(WebViewCore.this.mNativeClass, (String)msg.obj);
                            break;
                        }
                        case 175: {
                            WebViewCore.this.nativeContentInvalidateAll(WebViewCore.this.mNativeClass);
                            break;
                        }
                        case 147: {
                            WebViewClassic.SaveWebArchiveMessage saveMessage = (WebViewClassic.SaveWebArchiveMessage)msg.obj;
                            saveMessage.mResultFile = WebViewCore.this.saveWebArchive(saveMessage.mBasename, saveMessage.mAutoname);
                            ((WebViewCore)WebViewCore.this).mWebViewClassic.mPrivateHandler.obtainMessage(132, saveMessage).sendToTarget();
                            break;
                        }
                        case 180: {
                            GeolocationPermissionsData data = (GeolocationPermissionsData)msg.obj;
                            WebViewCore.this.nativeGeolocationPermissionsProvide(WebViewCore.this.mNativeClass, data.mOrigin, data.mAllow, data.mRemember);
                            break;
                        }
                        case 134: {
                            WebViewCore.this.clearContent();
                            break;
                        }
                        case 125: {
                            ((Message)msg.obj).sendToTarget();
                            break;
                        }
                        case 181: {
                            WebViewCore.this.nativeProvideVisitedHistory(WebViewCore.this.mNativeClass, (String[])msg.obj);
                            break;
                        }
                        case 182: {
                            WebViewCore.this.nativeFullScreenPluginHidden(WebViewCore.this.mNativeClass, msg.arg1);
                            break;
                        }
                        case 195: {
                            WebViewCore.this.nativePluginSurfaceReady(WebViewCore.this.mNativeClass);
                            break;
                        }
                        case 196: {
                            WebViewCore.this.nativeNotifyAnimationStarted(WebViewCore.this.mNativeClass);
                            break;
                        }
                        case 184: {
                            if (BrowserFrame.sJavaBridge == null) {
                                throw new IllegalStateException("No WebView has been created in this process!");
                            }
                            BrowserFrame.sJavaBridge.addPackageNames((Set)msg.obj);
                            break;
                        }
                        case 191: {
                            WebViewCore.this.setUseMockDeviceOrientation();
                            break;
                        }
                        case 192: {
                            WebViewCore.this.nativeAutoFillForm(WebViewCore.this.mNativeClass, msg.arg1);
                            ((WebViewCore)WebViewCore.this).mWebViewClassic.mPrivateHandler.obtainMessage(134, null).sendToTarget();
                            break;
                        }
                        case 194: {
                            if (!(msg.obj instanceof String)) break;
                            WebViewCore.this.mBrowserFrame.stringByEvaluatingJavaScriptFromString((String)msg.obj);
                            break;
                        }
                        case 198: {
                            int nativeLayer = msg.arg1;
                            Rect rect = (Rect)msg.obj;
                            WebViewCore.this.nativeScrollLayer(WebViewCore.this.mNativeClass, nativeLayer, rect);
                            break;
                        }
                        case 211: {
                            int[] handles = (int[])msg.obj;
                            WebViewCore.this.nativeDeleteText(WebViewCore.this.mNativeClass, handles[0], handles[1], handles[2], handles[3]);
                            break;
                        }
                        case 210: {
                            int[] handles = (int[])msg.obj;
                            String copiedText = WebViewCore.this.nativeGetText(WebViewCore.this.mNativeClass, handles[0], handles[1], handles[2], handles[3]);
                            if (copiedText == null) break;
                            ((WebViewCore)WebViewCore.this).mWebViewClassic.mPrivateHandler.obtainMessage(141, copiedText).sendToTarget();
                            break;
                        }
                        case 212: {
                            WebViewCore.this.nativeInsertText(WebViewCore.this.mNativeClass, (String)msg.obj);
                            break;
                        }
                        case 213: {
                            int[] args = (int[])msg.obj;
                            if (args == null) {
                                WebViewCore.this.nativeClearTextSelection(WebViewCore.this.mNativeClass);
                                break;
                            }
                            WebViewCore.this.nativeSelectText(WebViewCore.this.mNativeClass, args[0], args[1], args[2], args[3]);
                            break;
                        }
                        case 214: {
                            WebViewCore.this.mTextSelectionChangeReason = 2;
                            int x = msg.arg1;
                            int y = msg.arg2;
                            if (!WebViewCore.this.nativeSelectWordAt(WebViewCore.this.mNativeClass, x, y)) {
                                ((WebViewCore)WebViewCore.this).mWebViewClassic.mPrivateHandler.obtainMessage(151).sendToTarget();
                            }
                            WebViewCore.this.mTextSelectionChangeReason = 0;
                            break;
                        }
                        case 215: {
                            WebViewCore.this.nativeSelectAll(WebViewCore.this.mNativeClass);
                            break;
                        }
                        case 221: {
                            FindAllRequest request = (FindAllRequest)msg.obj;
                            if (request != null) {
                                int matchCount = WebViewCore.this.nativeFindAll(WebViewCore.this.mNativeClass, request.mSearchText);
                                int matchIndex = WebViewCore.this.nativeFindNext(WebViewCore.this.mNativeClass, true);
                                FindAllRequest findAllRequest = request;
                                synchronized (findAllRequest) {
                                    request.mMatchCount = matchCount;
                                    request.mMatchIndex = matchIndex;
                                    request.notify();
                                }
                            } else {
                                WebViewCore.this.nativeFindAll(WebViewCore.this.mNativeClass, null);
                            }
                            Message.obtain(((WebViewCore)WebViewCore.this).mWebViewClassic.mPrivateHandler, 126, request).sendToTarget();
                            break;
                        }
                        case 222: {
                            FindAllRequest request = (FindAllRequest)msg.obj;
                            int matchIndex = WebViewCore.this.nativeFindNext(WebViewCore.this.mNativeClass, msg.arg1 != 0);
                            FindAllRequest findAllRequest = request;
                            synchronized (findAllRequest) {
                                request.mMatchIndex = matchIndex;
                            }
                            Message.obtain(((WebViewCore)WebViewCore.this).mWebViewClassic.mPrivateHandler, 126, request).sendToTarget();
                            break;
                        }
                        case 224: {
                            WebViewCore.this.nativeSetInitialFocus(WebViewCore.this.mNativeClass, msg.arg1);
                            break;
                        }
                        case 225: {
                            SaveViewStateRequest request = (SaveViewStateRequest)msg.obj;
                            WebViewCore.this.saveViewState(request.mStream, request.mCallback);
                        }
                    }
                }
            };
            EventHub eventHub = this;
            synchronized (eventHub) {
                int size = this.mMessages.size();
                for (int i = 0; i < size; ++i) {
                    this.mHandler.sendMessage(this.mMessages.get(i));
                }
                this.mMessages = null;
            }
        }

        public Looper getWebKitLooper() {
            return this.mHandler.getLooper();
        }

        public boolean dispatchWebKitEvent(WebViewInputDispatcher dispatcher, MotionEvent event, int eventType, int flags) {
            if (WebViewCore.this.mNativeClass == 0) {
                return false;
            }
            switch (eventType) {
                case 6: {
                    int x = Math.round(event.getX());
                    int y = Math.round(event.getY());
                    WebKitHitTest hit = WebViewCore.this.performHitTest(x, y, WebViewCore.this.mWebViewClassic.getScaledNavSlop(), true);
                    ((WebViewCore)WebViewCore.this).mWebViewClassic.mPrivateHandler.obtainMessage(131, hit).sendToTarget();
                    return false;
                }
                case 4: {
                    return WebViewCore.this.nativeMouseClick(WebViewCore.this.mNativeClass);
                }
                case 0: {
                    int count = event.getPointerCount();
                    int[] idArray = new int[count];
                    int[] xArray = new int[count];
                    int[] yArray = new int[count];
                    for (int i = 0; i < count; ++i) {
                        idArray[i] = event.getPointerId(i);
                        xArray[i] = (int)event.getX(i);
                        yArray[i] = (int)event.getY(i);
                    }
                    int touchFlags = WebViewCore.this.nativeHandleTouchEvent(WebViewCore.this.mNativeClass, event.getActionMasked(), idArray, xArray, yArray, count, event.getActionIndex(), event.getMetaState());
                    if (touchFlags == 0 && event.getActionMasked() != 3 && (flags & 1) == 0) {
                        dispatcher.skipWebkitForRemainingTouchStream();
                    }
                    return (touchFlags & 2) > 0;
                }
            }
            return false;
        }

        private synchronized void sendMessage(Message msg) {
            if (this.mBlockMessages) {
                return;
            }
            if (this.mMessages != null) {
                this.mMessages.add(msg);
            } else {
                this.mHandler.sendMessage(msg);
            }
        }

        private synchronized void removeMessages(int what) {
            if (this.mBlockMessages) {
                return;
            }
            if (what == 130) {
                WebViewCore.this.mDrawIsScheduled = false;
            }
            if (this.mMessages != null) {
                Iterator iter = this.mMessages.iterator();
                while (iter.hasNext()) {
                    Message m = (Message)iter.next();
                    if (m.what != what) continue;
                    iter.remove();
                }
            } else {
                this.mHandler.removeMessages(what);
            }
        }

        private synchronized void sendMessageDelayed(Message msg, long delay) {
            if (this.mBlockMessages) {
                return;
            }
            this.mHandler.sendMessageDelayed(msg, delay);
        }

        private synchronized void sendMessageAtFrontOfQueue(Message msg) {
            if (this.mBlockMessages) {
                return;
            }
            if (this.mMessages != null) {
                this.mMessages.add(0, msg);
            } else {
                this.mHandler.sendMessageAtFrontOfQueue(msg);
            }
        }

        private synchronized void removeMessages() {
            WebViewCore.this.mDrawIsScheduled = false;
            if (this.mMessages != null) {
                this.mMessages.clear();
            } else {
                this.mHandler.removeCallbacksAndMessages(null);
            }
        }

        private synchronized void blockMessages() {
            this.mBlockMessages = true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SaveViewStateRequest {
        public OutputStream mStream;
        public ValueCallback<Boolean> mCallback;

        SaveViewStateRequest(OutputStream s, ValueCallback<Boolean> cb) {
            this.mStream = s;
            this.mCallback = cb;
        }
    }

    static class FindAllRequest {
        public final String mSearchText;
        public int mMatchCount;
        public int mMatchIndex;

        public FindAllRequest(String text) {
            this.mSearchText = text;
            this.mMatchCount = -1;
            this.mMatchIndex = -1;
        }
    }

    static class GeolocationPermissionsData {
        String mOrigin;
        boolean mAllow;
        boolean mRemember;

        GeolocationPermissionsData() {
        }
    }

    static class TouchEventData {
        int mAction;
        int[] mIds;
        Point[] mPoints;
        Point[] mPointsInView;
        int mActionIndex;
        int mMetaState;
        boolean mReprocess;
        MotionEvent mMotionEvent;
        int mNativeLayer;
        Rect mNativeLayerRect = new Rect();
        long mSequence;
        boolean mNativeResult;

        TouchEventData() {
        }
    }

    static class TextFieldInitData {
        public int mFieldPointer;
        public String mText;
        public int mType;
        public boolean mIsSpellCheckEnabled;
        public boolean mIsTextFieldNext;
        public boolean mIsTextFieldPrev;
        public boolean mIsAutoCompleteEnabled;
        public String mName;
        public String mLabel;
        public int mMaxLength;
        public Rect mContentBounds;
        public int mNodeLayerId;
        public Rect mContentRect;

        TextFieldInitData() {
        }
    }

    static class AutoFillData {
        private int mQueryId;
        private String mPreview;

        public AutoFillData() {
            this.mQueryId = -1;
            this.mPreview = "";
        }

        public AutoFillData(int queryId, String preview) {
            this.mQueryId = queryId;
            this.mPreview = preview;
        }

        public int getQueryId() {
            return this.mQueryId;
        }

        public String getPreviewString() {
            return this.mPreview;
        }
    }

    static class WebKitHitTest {
        String mLinkUrl;
        String mIntentUrl;
        String mAnchorText;
        String mImageUrl;
        String mAltDisplayString;
        String mTitle;
        Rect[] mTouchRects;
        boolean mEditable;
        int mTapHighlightColor = 1714664933;
        Rect[] mEnclosingParentRects;
        boolean mHasFocus;
        int mHitTestX;
        int mHitTestY;
        int mHitTestSlop;
        boolean mHitTestMovedMouse;

        WebKitHitTest() {
        }
    }

    static class TouchHighlightData {
        int mX;
        int mY;
        int mSlop;
        int mNativeLayer;
        Rect mNativeLayerRect;

        TouchHighlightData() {
        }
    }

    static class TouchUpData {
        int mMoveGeneration;
        int mFrame;
        int mNode;
        int mX;
        int mY;
        int mNativeLayer;
        Rect mNativeLayerRect = new Rect();

        TouchUpData() {
        }
    }

    static class TextSelectionData {
        static final int REASON_UNKNOWN = 0;
        static final int REASON_ACCESSIBILITY_INJECTOR = 1;
        static final int REASON_SELECT_WORD = 2;
        int mStart;
        int mEnd;
        int mSelectTextPtr;
        int mSelectionReason = 0;

        public TextSelectionData(int start, int end, int selectTextPtr) {
            this.mStart = start;
            this.mEnd = end;
            this.mSelectTextPtr = selectTextPtr;
        }
    }

    static class ReplaceTextData {
        String mReplace;
        int mNewStart;
        int mNewEnd;
        int mTextGeneration;

        ReplaceTextData() {
        }
    }

    static class PostUrlData {
        String mUrl;
        byte[] mPostData;

        PostUrlData() {
        }
    }

    static class GetUrlData {
        String mUrl;
        Map<String, String> mExtraHeaders;

        GetUrlData() {
        }
    }

    static class MotionUpData {
        int mFrame;
        int mNode;
        Rect mBounds;
        int mX;
        int mY;

        MotionUpData() {
        }
    }

    static class JSKeyData {
        String mCurrentText;
        KeyEvent mEvent;

        JSKeyData() {
        }
    }

    static class JSInterfaceData {
        Object mObject;
        String mInterfaceName;
        boolean mRequireAnnotation;

        JSInterfaceData() {
        }
    }

    static class BaseUrlData {
        String mBaseUrl;
        String mData;
        String mMimeType;
        String mEncoding;
        String mHistoryUrl;

        BaseUrlData() {
        }
    }

    private static class WebCoreThread
    implements Runnable {
        private static final int INITIALIZE = 0;
        private static final int REDUCE_PRIORITY = 1;
        private static final int RESUME_PRIORITY = 2;

        private WebCoreThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Looper.prepare();
            Assert.assertNull((Object)sWebCoreHandler);
            Class<WebViewCore> clazz = WebViewCore.class;
            synchronized (WebViewCore.class) {
                sWebCoreHandler = new Handler(){

                    public void handleMessage(Message msg) {
                        switch (msg.what) {
                            case 0: {
                                WebViewCore core = (WebViewCore)msg.obj;
                                core.initialize();
                                break;
                            }
                            case 1: {
                                Process.setThreadPriority(3);
                                break;
                            }
                            case 2: {
                                Process.setThreadPriority(0);
                                break;
                            }
                            case 185: {
                                if (BrowserFrame.sJavaBridge == null) {
                                    throw new IllegalStateException("No WebView has been created in this process!");
                                }
                                BrowserFrame.sJavaBridge.addPackageName((String)msg.obj);
                                break;
                            }
                            case 186: {
                                if (BrowserFrame.sJavaBridge == null) {
                                    throw new IllegalStateException("No WebView has been created in this process!");
                                }
                                BrowserFrame.sJavaBridge.removePackageName((String)msg.obj);
                                break;
                            }
                            case 193: {
                                if (BrowserFrame.sJavaBridge == null) {
                                    throw new IllegalStateException("No WebView has been created in this process!");
                                }
                                BrowserFrame.sJavaBridge.updateProxy((ProxyProperties)msg.obj);
                                break;
                            }
                            case 197: {
                                Message m = (Message)msg.obj;
                                m.sendToTarget();
                                break;
                            }
                            case 220: {
                                WebViewCore.nativeCertTrustChanged();
                                CertificateChainValidator.handleTrustStorageUpdate();
                            }
                        }
                    }
                };
                WebViewCore.class.notify();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                Looper.loop();
                return;
            }
        }
    }
}

