/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.util.Log;
import android.webkit.WebViewClassic;
import android.webkit.WebViewFactoryProvider;

class WebViewFactory {
    private static final String DEFAULT_WEB_VIEW_FACTORY = "android.webkit.WebViewClassic$Factory";
    private static final String LOGTAG = "WebViewFactory";
    private static final boolean DEBUG = false;
    private static WebViewFactoryProvider sProviderInstance;

    WebViewFactory() {
    }

    static synchronized WebViewFactoryProvider getProvider() {
        if (sProviderInstance != null) {
            return sProviderInstance;
        }
        sProviderInstance = WebViewFactory.getFactoryByName(DEFAULT_WEB_VIEW_FACTORY);
        if (sProviderInstance == null) {
            sProviderInstance = new WebViewClassic.Factory();
        }
        return sProviderInstance;
    }

    private static WebViewFactoryProvider getFactoryByName(String providerName) {
        try {
            Class<?> c = Class.forName(providerName);
            return (WebViewFactoryProvider)c.newInstance();
        }
        catch (ClassNotFoundException e) {
            Log.e(LOGTAG, "error loading " + providerName, e);
        }
        catch (IllegalAccessException e) {
            Log.e(LOGTAG, "error loading " + providerName, e);
        }
        catch (InstantiationException e) {
            Log.e(LOGTAG, "error loading " + providerName, e);
        }
        return null;
    }
}

