/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.content.Context;
import android.content.pm.PackageManager;
import android.graphics.Canvas;
import android.graphics.Point;
import android.os.Bundle;
import android.os.SystemClock;
import android.util.FloatMath;
import android.util.Log;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.webkit.CallbackProxy;
import android.webkit.WebSettings;
import android.webkit.WebSettingsClassic;
import android.webkit.WebViewClassic;
import android.webkit.WebViewCore;
import android.webkit.ZoomControlBase;
import android.webkit.ZoomControlEmbedded;
import android.webkit.ZoomControlExternal;

class ZoomManager {
    static final String LOGTAG = "webviewZoom";
    private final WebViewClassic mWebView;
    private final CallbackProxy mCallbackProxy;
    private ZoomControlEmbedded mEmbeddedZoomControl;
    private ZoomControlExternal mExternalZoomControl;
    protected static final float DEFAULT_MAX_ZOOM_SCALE_FACTOR = 4.0f;
    protected static final float DEFAULT_MIN_ZOOM_SCALE_FACTOR = 0.25f;
    private float mDefaultMaxZoomScale;
    private float mDefaultMinZoomScale;
    private float mMaxZoomScale;
    private float mMinZoomScale;
    private boolean mMinZoomScaleFixed = true;
    private boolean mInitialZoomOverview = false;
    private boolean mInZoomOverview = false;
    private int mZoomOverviewWidth;
    private float mInvZoomOverviewWidth;
    private float mZoomCenterX;
    private float mZoomCenterY;
    private float mFocusX;
    private float mFocusY;
    private FocusMovementQueue mFocusMovementQueue;
    private int mAnchorX;
    private int mAnchorY;
    private float mTextWrapScale;
    private float mDefaultScale;
    private float mInvDefaultScale;
    private float mDisplayDensity;
    private float mDoubleTapZoomFactor = 1.0f;
    private static float MIN_DOUBLE_TAP_SCALE_INCREMENT = 0.5f;
    private float mActualScale;
    private float mInvActualScale;
    private float mInitialScale;
    private static float MINIMUM_SCALE_INCREMENT = 0.007f;
    private static float MINIMUM_SCALE_WITHOUT_JITTER = 0.007f;
    private float mZoomScale;
    private float mInvInitialZoomScale;
    private float mInvFinalZoomScale;
    private int mInitialScrollX;
    private int mInitialScrollY;
    private long mZoomStart;
    private static final int ZOOM_ANIMATION_LENGTH = 175;
    private boolean mSupportMultiTouch;
    private boolean mAllowPanAndScale;
    private ScaleGestureDetector mScaleDetector;
    private boolean mPinchToZoomAnimating = false;
    private boolean mHardwareAccelerated = false;
    private boolean mInHWAcceleratedZoom = false;

    public ZoomManager(WebViewClassic webView, CallbackProxy callbackProxy) {
        this.mWebView = webView;
        this.mCallbackProxy = callbackProxy;
        this.setZoomOverviewWidth(980);
        this.mFocusMovementQueue = new FocusMovementQueue();
    }

    public void init(float density) {
        assert (density > 0.0f);
        this.mDisplayDensity = density;
        this.setDefaultZoomScale(density);
        this.mActualScale = density;
        this.mInvActualScale = 1.0f / density;
        this.mTextWrapScale = this.getReadingLevelScale();
    }

    public void updateDefaultZoomDensity(float density) {
        assert (density > 0.0f);
        if (Math.abs(density - this.mDefaultScale) > MINIMUM_SCALE_INCREMENT) {
            float originalDefault = this.mDefaultScale;
            this.mDisplayDensity = density;
            this.setDefaultZoomScale(density);
            float scaleChange = (double)originalDefault > 0.0 ? density / originalDefault : 1.0f;
            this.setZoomScale(this.mActualScale * scaleChange, true);
        }
    }

    private void setDefaultZoomScale(float defaultScale) {
        float originalDefault = this.mDefaultScale;
        this.mDefaultScale = defaultScale;
        this.mInvDefaultScale = 1.0f / defaultScale;
        this.mDefaultMaxZoomScale = defaultScale * 4.0f;
        this.mDefaultMinZoomScale = defaultScale * 0.25f;
        this.mMaxZoomScale = (double)originalDefault > 0.0 && (double)this.mMaxZoomScale > 0.0 ? defaultScale / originalDefault * this.mMaxZoomScale : this.mDefaultMaxZoomScale;
        this.mMinZoomScale = (double)originalDefault > 0.0 && (double)this.mMinZoomScale > 0.0 ? defaultScale / originalDefault * this.mMinZoomScale : this.mDefaultMinZoomScale;
        if (!ZoomManager.exceedsMinScaleIncrement(this.mMinZoomScale, this.mMaxZoomScale)) {
            this.mMaxZoomScale = this.mMinZoomScale;
        }
    }

    public float getScale() {
        return this.mActualScale;
    }

    public float getInvScale() {
        return this.mInvActualScale;
    }

    public float getTextWrapScale() {
        return this.mTextWrapScale;
    }

    public float getMaxZoomScale() {
        return this.mMaxZoomScale;
    }

    public float getMinZoomScale() {
        return this.mMinZoomScale;
    }

    public float getDefaultScale() {
        return this.mDefaultScale;
    }

    public float getReadingLevelScale() {
        return this.computeScaleWithLimits(this.computeReadingLevelScale(this.getZoomOverviewScale()));
    }

    float computeReadingLevelScale(float scale) {
        return Math.max(this.mDisplayDensity * this.mDoubleTapZoomFactor, scale + MIN_DOUBLE_TAP_SCALE_INCREMENT);
    }

    public float getInvDefaultScale() {
        return this.mInvDefaultScale;
    }

    public float getDefaultMaxZoomScale() {
        return this.mDefaultMaxZoomScale;
    }

    public float getDefaultMinZoomScale() {
        return this.mDefaultMinZoomScale;
    }

    public int getDocumentAnchorX() {
        return this.mAnchorX;
    }

    public int getDocumentAnchorY() {
        return this.mAnchorY;
    }

    public void clearDocumentAnchor() {
        this.mAnchorY = 0;
        this.mAnchorX = 0;
    }

    public void setZoomCenter(float x, float y) {
        this.mZoomCenterX = x;
        this.mZoomCenterY = y;
    }

    public void setInitialScaleInPercent(int scaleInPercent) {
        this.mInitialScale = (float)scaleInPercent * 0.01f;
    }

    public float computeScaleWithLimits(float scale) {
        if (scale < this.mMinZoomScale) {
            scale = this.mMinZoomScale;
        } else if (scale > this.mMaxZoomScale) {
            scale = this.mMaxZoomScale;
        }
        return scale;
    }

    public boolean isScaleOverLimits(float scale) {
        return scale <= this.mMinZoomScale || scale >= this.mMaxZoomScale;
    }

    public boolean isZoomScaleFixed() {
        return this.mMinZoomScale >= this.mMaxZoomScale;
    }

    public static boolean exceedsMinScaleIncrement(float scaleA, float scaleB) {
        return Math.abs(scaleA - scaleB) >= MINIMUM_SCALE_INCREMENT;
    }

    public boolean willScaleTriggerZoom(float scale) {
        return ZoomManager.exceedsMinScaleIncrement(scale, this.mActualScale);
    }

    public boolean canZoomIn() {
        return this.mMaxZoomScale - this.mActualScale > MINIMUM_SCALE_INCREMENT;
    }

    public boolean canZoomOut() {
        return this.mActualScale - this.mMinZoomScale > MINIMUM_SCALE_INCREMENT;
    }

    public boolean zoomIn() {
        return this.zoom(1.25f);
    }

    public boolean zoomOut() {
        return this.zoom(0.8f);
    }

    private boolean zoom(float zoomMultiplier) {
        this.mInitialZoomOverview = false;
        this.mWebView.switchOutDrawHistory();
        this.mZoomCenterX = (float)this.mWebView.getViewWidth() * 0.5f;
        this.mZoomCenterY = (float)this.mWebView.getViewHeight() * 0.5f;
        this.mAnchorX = this.mWebView.viewToContentX((int)this.mZoomCenterX + this.mWebView.getScrollX());
        this.mAnchorY = this.mWebView.viewToContentY((int)this.mZoomCenterY + this.mWebView.getScrollY());
        return this.startZoomAnimation(this.mActualScale * zoomMultiplier, !this.mWebView.getSettings().getUseFixedViewport());
    }

    public boolean startZoomAnimation(float scale, boolean reflowText) {
        this.mInitialZoomOverview = false;
        float oldScale = this.mActualScale;
        this.mInitialScrollX = this.mWebView.getScrollX();
        this.mInitialScrollY = this.mWebView.getScrollY();
        if (!ZoomManager.exceedsMinScaleIncrement(scale, this.getReadingLevelScale())) {
            scale = this.getReadingLevelScale();
        }
        this.setZoomScale(scale, reflowText);
        if (oldScale != this.mActualScale) {
            if (this.mHardwareAccelerated) {
                this.mInHWAcceleratedZoom = true;
            }
            this.mZoomStart = SystemClock.uptimeMillis();
            this.mInvInitialZoomScale = 1.0f / oldScale;
            this.mInvFinalZoomScale = 1.0f / this.mActualScale;
            this.mZoomScale = this.mActualScale;
            this.mWebView.onFixedLengthZoomAnimationStart();
            this.mWebView.invalidate();
            return true;
        }
        return false;
    }

    public void animateZoom(Canvas canvas) {
        float zoomScale;
        this.mInitialZoomOverview = false;
        if (this.mZoomScale == 0.0f) {
            Log.w(LOGTAG, "A WebView is attempting to perform a fixed length zoom animation when no zoom is in progress");
            this.mInHWAcceleratedZoom = false;
            return;
        }
        int interval = (int)(SystemClock.uptimeMillis() - this.mZoomStart);
        if (interval < 175) {
            float ratio = (float)interval / 175.0f;
            zoomScale = 1.0f / (this.mInvInitialZoomScale + (this.mInvFinalZoomScale - this.mInvInitialZoomScale) * ratio);
            this.mWebView.invalidate();
        } else {
            zoomScale = this.mZoomScale;
            this.mZoomScale = 0.0f;
            this.mWebView.onFixedLengthZoomAnimationEnd();
        }
        float scale = zoomScale * this.mInvInitialZoomScale;
        int tx = Math.round(scale * ((float)this.mInitialScrollX + this.mZoomCenterX) - this.mZoomCenterX);
        tx = -WebViewClassic.pinLoc(tx, this.mWebView.getViewWidth(), Math.round((float)this.mWebView.getContentWidth() * zoomScale)) + this.mWebView.getScrollX();
        int titleHeight = this.mWebView.getTitleHeight();
        int ty = Math.round(scale * ((float)this.mInitialScrollY + this.mZoomCenterY - (float)titleHeight) - (this.mZoomCenterY - (float)titleHeight));
        ty = -(ty <= titleHeight ? Math.max(ty, 0) : WebViewClassic.pinLoc(ty - titleHeight, this.mWebView.getViewHeight(), Math.round((float)this.mWebView.getContentHeight() * zoomScale)) + titleHeight) + this.mWebView.getScrollY();
        if (this.mHardwareAccelerated) {
            this.mWebView.updateScrollCoordinates(this.mWebView.getScrollX() - tx, this.mWebView.getScrollY() - ty);
            canvas.translate(tx, ty);
            this.setZoomScale(zoomScale, false);
            if (this.mZoomScale == 0.0f) {
                this.mInHWAcceleratedZoom = false;
                this.mWebView.sendViewSizeZoom(false);
            }
        } else {
            canvas.translate(tx, ty);
            canvas.scale(zoomScale, zoomScale);
        }
    }

    public boolean isZoomAnimating() {
        return this.isFixedLengthAnimationInProgress() || this.mPinchToZoomAnimating;
    }

    public boolean isFixedLengthAnimationInProgress() {
        return this.mZoomScale != 0.0f || this.mInHWAcceleratedZoom;
    }

    public void updateDoubleTapZoom(int doubleTapZoom) {
        boolean zoomIn = this.mTextWrapScale - this.mActualScale < 0.1f;
        this.mDoubleTapZoomFactor = (float)doubleTapZoom / 100.0f;
        this.mTextWrapScale = this.getReadingLevelScale();
        float newScale = zoomIn ? this.mTextWrapScale : Math.min(this.mTextWrapScale, this.mActualScale);
        this.setZoomScale(newScale, true, true);
    }

    public void refreshZoomScale(boolean reflowText) {
        this.setZoomScale(this.mActualScale, reflowText, true);
    }

    public void setZoomScale(float scale, boolean reflowText) {
        this.setZoomScale(scale, reflowText, false);
    }

    private void setZoomScale(float scale, boolean reflowText, boolean force) {
        boolean isScaleLessThanMinZoom = scale < this.mMinZoomScale;
        scale = this.computeScaleWithLimits(scale);
        if (isScaleLessThanMinZoom && this.mMinZoomScale < this.mDefaultScale) {
            this.mInZoomOverview = true;
        } else {
            boolean bl = this.mInZoomOverview = !ZoomManager.exceedsMinScaleIncrement(scale, this.getZoomOverviewScale());
        }
        if (reflowText && !this.mWebView.getSettings().getUseFixedViewport()) {
            this.mTextWrapScale = scale;
        }
        if (scale != this.mActualScale || force) {
            float oldScale = this.mActualScale;
            float oldInvScale = this.mInvActualScale;
            if (scale != this.mActualScale && !this.mPinchToZoomAnimating) {
                this.mCallbackProxy.onScaleChanged(this.mActualScale, scale);
            }
            this.mActualScale = scale;
            this.mInvActualScale = 1.0f / scale;
            if (!this.mWebView.drawHistory() && !this.mInHWAcceleratedZoom) {
                int oldX = this.mWebView.getScrollX();
                int oldY = this.mWebView.getScrollY();
                float ratio = scale * oldInvScale;
                float sx = ratio * (float)oldX + (ratio - 1.0f) * this.mZoomCenterX;
                float sy = ratio * (float)oldY + (ratio - 1.0f) * (this.mZoomCenterY - (float)this.mWebView.getTitleHeight());
                this.mWebView.mViewManager.scaleAll();
                int scrollX = this.mWebView.pinLocX(Math.round(sx));
                int scrollY = this.mWebView.pinLocY(Math.round(sy));
                if (!this.mWebView.updateScrollCoordinates(scrollX, scrollY)) {
                    this.mWebView.sendOurVisibleRect();
                }
            }
            this.mWebView.sendViewSizeZoom(reflowText);
        }
    }

    public boolean isDoubleTapEnabled() {
        WebSettingsClassic settings = this.mWebView.getSettings();
        return settings != null && ((WebSettings)settings).getUseWideViewPort();
    }

    public void handleDoubleTap(float lastTouchX, float lastTouchY) {
        boolean firstTimeReflow;
        this.mInitialZoomOverview = false;
        WebSettingsClassic settings = this.mWebView.getSettings();
        if (!this.isDoubleTapEnabled()) {
            return;
        }
        this.setZoomCenter(lastTouchX, lastTouchY);
        this.mAnchorX = this.mWebView.viewToContentX((int)lastTouchX + this.mWebView.getScrollX());
        this.mAnchorY = this.mWebView.viewToContentY((int)lastTouchY + this.mWebView.getScrollY());
        settings.setDoubleTapToastCount(0);
        this.dismissZoomPicker();
        float newTextWrapScale = settings.getUseFixedViewport() ? Math.max(this.mActualScale, this.getReadingLevelScale()) : this.mActualScale;
        boolean bl = firstTimeReflow = !ZoomManager.exceedsMinScaleIncrement(this.mActualScale, this.mTextWrapScale);
        if (firstTimeReflow || this.mInZoomOverview) {
            this.mTextWrapScale = newTextWrapScale;
        }
        if (settings.isNarrowColumnLayout() && ZoomManager.exceedsMinScaleIncrement(this.mTextWrapScale, newTextWrapScale) && !firstTimeReflow && !this.mInZoomOverview) {
            this.mTextWrapScale = newTextWrapScale;
            this.refreshZoomScale(true);
        } else if (!this.mInZoomOverview && this.willScaleTriggerZoom(this.getZoomOverviewScale())) {
            if (this.mTextWrapScale > this.getReadingLevelScale()) {
                this.mTextWrapScale = this.getReadingLevelScale();
                this.refreshZoomScale(true);
            }
            this.zoomToOverview();
        } else {
            this.zoomToReadingLevel();
        }
    }

    private void setZoomOverviewWidth(int width) {
        this.mZoomOverviewWidth = width == 0 ? 980 : width;
        this.mInvZoomOverviewWidth = 1.0f / (float)width;
    }

    float getZoomOverviewScale() {
        return (float)this.mWebView.getViewWidth() * this.mInvZoomOverviewWidth;
    }

    public boolean isInZoomOverview() {
        return this.mInZoomOverview;
    }

    private void zoomToOverview() {
        int scrollY = this.mWebView.getScrollY();
        if (scrollY < this.mWebView.getTitleHeight()) {
            this.mWebView.updateScrollCoordinates(this.mWebView.getScrollX(), 0);
        }
        this.startZoomAnimation(this.getZoomOverviewScale(), !this.mWebView.getSettings().getUseFixedViewport());
    }

    private void zoomToReadingLevel() {
        float readingScale = this.getReadingLevelScale();
        int left = this.mWebView.getBlockLeftEdge(this.mAnchorX, this.mAnchorY, readingScale);
        if (left != -1) {
            int viewLeft = this.mWebView.contentToViewX(left < 5 ? 0 : left - 5) - this.mWebView.getScrollX();
            if (viewLeft > 0) {
                this.mZoomCenterX = (float)viewLeft * readingScale / (readingScale - this.mActualScale);
            } else {
                this.mWebView.getWebView().scrollBy(viewLeft, 0);
                this.mZoomCenterX = 0.0f;
            }
        }
        this.startZoomAnimation(readingScale, !this.mWebView.getSettings().getUseFixedViewport());
    }

    public void updateMultiTouchSupport(Context context) {
        assert (this.mWebView.getSettings() != null);
        WebSettingsClassic settings = this.mWebView.getSettings();
        PackageManager pm = context.getPackageManager();
        this.mSupportMultiTouch = (pm.hasSystemFeature("android.hardware.touchscreen.multitouch") || pm.hasSystemFeature("android.hardware.faketouch.multitouch.distinct")) && ((WebSettings)settings).supportZoom() && ((WebSettings)settings).getBuiltInZoomControls();
        boolean bl = this.mAllowPanAndScale = pm.hasSystemFeature("android.hardware.touchscreen.multitouch.distinct") || pm.hasSystemFeature("android.hardware.faketouch.multitouch.distinct");
        if (this.mSupportMultiTouch && this.mScaleDetector == null) {
            this.mScaleDetector = new ScaleGestureDetector(context, new ScaleDetectorListener());
        } else if (!this.mSupportMultiTouch && this.mScaleDetector != null) {
            this.mScaleDetector = null;
        }
    }

    public boolean supportsMultiTouchZoom() {
        return this.mSupportMultiTouch;
    }

    public boolean supportsPanDuringZoom() {
        return this.mAllowPanAndScale;
    }

    public boolean isPreventingWebkitUpdates() {
        return this.isZoomAnimating();
    }

    public ScaleGestureDetector getScaleGestureDetector() {
        return this.mScaleDetector;
    }

    public void onSizeChanged(int w, int h, int ow, int oh) {
        if (!this.isFixedLengthAnimationInProgress()) {
            int visibleTitleHeight = this.mWebView.getVisibleTitleHeight();
            this.mZoomCenterX = 0.0f;
            this.mZoomCenterY = visibleTitleHeight;
            this.mAnchorX = this.mWebView.viewToContentX(this.mWebView.getScrollX());
            this.mAnchorY = this.mWebView.viewToContentY(visibleTitleHeight + this.mWebView.getScrollY());
        }
        if (!this.mMinZoomScaleFixed) {
            this.mMinZoomScale = Math.min(1.0f, (float)this.mWebView.getViewWidth() / (float)(this.mWebView.drawHistory() ? this.mWebView.getHistoryPictureWidth() : this.mZoomOverviewWidth));
            if (this.mInitialScale > 0.0f && this.mInitialScale < this.mMinZoomScale) {
                this.mMinZoomScale = this.mInitialScale;
            }
        }
        this.dismissZoomPicker();
        this.mWebView.getWebView().post(new PostScale(w != ow && !this.mWebView.getSettings().getUseFixedViewport(), this.mInZoomOverview, w < ow));
    }

    public void updateZoomRange(WebViewCore.ViewState viewState, int viewWidth, int minPrefWidth) {
        if (viewState.mMinScale == 0.0f) {
            if (viewState.mMobileSite) {
                if (minPrefWidth > Math.max(0, viewWidth)) {
                    this.mMinZoomScale = (float)viewWidth / (float)minPrefWidth;
                    this.mMinZoomScaleFixed = false;
                } else {
                    this.mMinZoomScale = viewState.mDefaultScale;
                    this.mMinZoomScaleFixed = true;
                }
            } else {
                this.mMinZoomScale = this.mDefaultMinZoomScale;
                this.mMinZoomScaleFixed = false;
            }
        } else {
            this.mMinZoomScale = viewState.mMinScale;
            this.mMinZoomScaleFixed = true;
        }
        this.mMaxZoomScale = viewState.mMaxScale == 0.0f ? this.mDefaultMaxZoomScale : viewState.mMaxScale;
    }

    public boolean onNewPicture(WebViewCore.DrawData drawData) {
        boolean mobileSiteInOverview;
        int viewWidth = this.mWebView.getViewWidth();
        boolean zoomOverviewWidthChanged = this.setupZoomOverviewWidth(drawData, viewWidth);
        float newZoomOverviewScale = this.getZoomOverviewScale();
        WebSettingsClassic settings = this.mWebView.getSettings();
        if (zoomOverviewWidthChanged && settings.isNarrowColumnLayout() && settings.getUseFixedViewport() && (this.mInitialZoomOverview || this.mInZoomOverview)) {
            this.mTextWrapScale = ZoomManager.exceedsMinScaleIncrement(this.mTextWrapScale, this.mDefaultScale) || ZoomManager.exceedsMinScaleIncrement(newZoomOverviewScale, this.mDefaultScale) ? this.getReadingLevelScale() : newZoomOverviewScale;
        }
        if (!this.mMinZoomScaleFixed || settings.getUseWideViewPort()) {
            this.mMinZoomScale = newZoomOverviewScale;
            this.mMaxZoomScale = Math.max(this.mMaxZoomScale, this.mMinZoomScale);
        }
        boolean scaleHasDiff = ZoomManager.exceedsMinScaleIncrement(newZoomOverviewScale, this.mActualScale);
        boolean scaleLessThanOverview = newZoomOverviewScale - this.mActualScale >= MINIMUM_SCALE_INCREMENT;
        boolean bl = mobileSiteInOverview = this.mInZoomOverview && !ZoomManager.exceedsMinScaleIncrement(newZoomOverviewScale, this.mDefaultScale);
        if (!this.mWebView.drawHistory() && (scaleLessThanOverview && settings.getUseWideViewPort() || (this.mInitialZoomOverview || mobileSiteInOverview) && scaleHasDiff && zoomOverviewWidthChanged)) {
            this.mInitialZoomOverview = false;
            this.setZoomScale(newZoomOverviewScale, !this.willScaleTriggerZoom(this.mTextWrapScale) && !this.mWebView.getSettings().getUseFixedViewport());
        } else {
            boolean bl2 = this.mInZoomOverview = !scaleHasDiff;
        }
        if (drawData.mFirstLayoutForNonStandardLoad && settings.getLoadWithOverviewMode()) {
            this.mInitialZoomOverview = this.mInZoomOverview;
        }
        return scaleHasDiff;
    }

    private boolean setupZoomOverviewWidth(WebViewCore.DrawData drawData, int viewWidth) {
        WebSettingsClassic settings = this.mWebView.getSettings();
        int newZoomOverviewWidth = this.mZoomOverviewWidth;
        if (((WebSettings)settings).getUseWideViewPort()) {
            if (drawData.mContentSize.x > 0) {
                newZoomOverviewWidth = Math.min(WebViewClassic.sMaxViewportWidth, drawData.mContentSize.x);
            }
        } else {
            newZoomOverviewWidth = Math.round((float)viewWidth / this.mDefaultScale);
        }
        if (newZoomOverviewWidth != this.mZoomOverviewWidth) {
            this.setZoomOverviewWidth(newZoomOverviewWidth);
            return true;
        }
        return false;
    }

    public void onFirstLayout(WebViewCore.DrawData drawData) {
        assert (drawData != null);
        assert (drawData.mViewState != null);
        assert (this.mWebView.getSettings() != null);
        WebViewCore.ViewState viewState = drawData.mViewState;
        Point viewSize = drawData.mViewSize;
        this.updateZoomRange(viewState, viewSize.x, drawData.mMinPrefWidth);
        this.setupZoomOverviewWidth(drawData, this.mWebView.getViewWidth());
        float overviewScale = this.getZoomOverviewScale();
        WebSettingsClassic settings = this.mWebView.getSettings();
        if (!this.mMinZoomScaleFixed || settings.getUseWideViewPort()) {
            this.mMinZoomScale = this.mInitialScale > 0.0f ? Math.min(this.mInitialScale, overviewScale) : overviewScale;
            this.mMaxZoomScale = Math.max(this.mMaxZoomScale, this.mMinZoomScale);
        }
        if (!this.mWebView.drawHistory()) {
            float scale;
            if (this.mInitialScale > 0.0f) {
                scale = this.mInitialScale;
            } else if (viewState.mIsRestored || viewState.mViewScale > 0.0f) {
                scale = viewState.mViewScale > 0.0f ? viewState.mViewScale : overviewScale;
                this.mTextWrapScale = viewState.mTextWrapScale > 0.0f ? viewState.mTextWrapScale : this.getReadingLevelScale();
            } else {
                scale = overviewScale;
                if (!settings.getUseWideViewPort() || !settings.getLoadWithOverviewMode()) {
                    scale = Math.max(this.mDefaultScale, scale);
                }
                if (settings.isNarrowColumnLayout() && settings.getUseFixedViewport()) {
                    this.mTextWrapScale = this.getReadingLevelScale();
                }
            }
            boolean reflowText = false;
            if (!viewState.mIsRestored) {
                if (settings.getUseFixedViewport()) {
                    scale = Math.max(scale, overviewScale);
                    this.mTextWrapScale = Math.max(this.mTextWrapScale, overviewScale);
                }
                reflowText = ZoomManager.exceedsMinScaleIncrement(this.mTextWrapScale, scale);
            }
            this.mInitialZoomOverview = settings.getLoadWithOverviewMode() && !ZoomManager.exceedsMinScaleIncrement(scale, overviewScale);
            this.setZoomScale(scale, reflowText);
            this.updateZoomPicker();
        }
    }

    public void saveZoomState(Bundle b) {
        b.putFloat("scale", this.mActualScale);
        b.putFloat("textwrapScale", this.mTextWrapScale);
        b.putBoolean("overview", this.mInZoomOverview);
    }

    public void restoreZoomState(Bundle b) {
        this.mActualScale = b.getFloat("scale", 1.0f);
        this.mInvActualScale = 1.0f / this.mActualScale;
        this.mTextWrapScale = b.getFloat("textwrapScale", this.mActualScale);
        this.mInZoomOverview = b.getBoolean("overview");
    }

    private ZoomControlBase getCurrentZoomControl() {
        if (this.mWebView.getSettings() != null && this.mWebView.getSettings().supportZoom()) {
            if (this.mWebView.getSettings().getBuiltInZoomControls()) {
                if (this.mEmbeddedZoomControl == null && this.mWebView.getSettings().getDisplayZoomControls()) {
                    this.mEmbeddedZoomControl = new ZoomControlEmbedded(this, this.mWebView);
                }
                return this.mEmbeddedZoomControl;
            }
            if (this.mExternalZoomControl == null) {
                this.mExternalZoomControl = new ZoomControlExternal(this.mWebView);
            }
            return this.mExternalZoomControl;
        }
        return null;
    }

    public void invokeZoomPicker() {
        ZoomControlBase control = this.getCurrentZoomControl();
        if (control != null) {
            control.show();
        }
    }

    public void dismissZoomPicker() {
        ZoomControlBase control = this.getCurrentZoomControl();
        if (control != null) {
            control.hide();
        }
    }

    public boolean isZoomPickerVisible() {
        ZoomControlBase control = this.getCurrentZoomControl();
        return control != null ? control.isVisible() : false;
    }

    public void updateZoomPicker() {
        ZoomControlBase control = this.getCurrentZoomControl();
        if (control != null) {
            control.update();
        }
    }

    public void keepZoomPickerVisible() {
        ZoomControlBase control = this.getCurrentZoomControl();
        if (control != null && control == this.mExternalZoomControl) {
            control.show();
        }
    }

    public View getExternalZoomPicker() {
        ZoomControlBase control = this.getCurrentZoomControl();
        if (control != null && control == this.mExternalZoomControl) {
            return this.mExternalZoomControl.getControls();
        }
        return null;
    }

    public void setHardwareAccelerated() {
        this.mHardwareAccelerated = true;
    }

    void onPageFinished(String url) {
        this.mInitialZoomOverview = false;
    }

    private class PostScale
    implements Runnable {
        final boolean mUpdateTextWrap;
        final boolean mInZoomOverviewBeforeSizeChange;
        final boolean mInPortraitMode;

        public PostScale(boolean updateTextWrap, boolean inZoomOverview, boolean inPortraitMode) {
            this.mUpdateTextWrap = updateTextWrap;
            this.mInZoomOverviewBeforeSizeChange = inZoomOverview;
            this.mInPortraitMode = inPortraitMode;
        }

        public void run() {
            if (ZoomManager.this.mWebView.getWebViewCore() != null) {
                float newScale = ZoomManager.this.mActualScale;
                if (ZoomManager.this.mWebView.getSettings().getUseWideViewPort() && this.mInPortraitMode && this.mInZoomOverviewBeforeSizeChange) {
                    newScale = ZoomManager.this.getZoomOverviewScale();
                }
                ZoomManager.this.setZoomScale(newScale, this.mUpdateTextWrap, true);
                ZoomManager.this.updateZoomPicker();
            }
        }
    }

    private class ScaleDetectorListener
    implements ScaleGestureDetector.OnScaleGestureListener {
        private float mAccumulatedSpan;

        private ScaleDetectorListener() {
        }

        public boolean onScaleBegin(ScaleGestureDetector detector) {
            ZoomManager.this.mInitialZoomOverview = false;
            ZoomManager.this.dismissZoomPicker();
            ZoomManager.this.mFocusMovementQueue.clear();
            ZoomManager.this.mFocusX = detector.getFocusX();
            ZoomManager.this.mFocusY = detector.getFocusY();
            ((ZoomManager)ZoomManager.this).mWebView.mViewManager.startZoom();
            ZoomManager.this.mWebView.onPinchToZoomAnimationStart();
            this.mAccumulatedSpan = 0.0f;
            return true;
        }

        public boolean isPanningOnly(ScaleGestureDetector detector) {
            boolean result;
            float prevFocusX = ZoomManager.this.mFocusX;
            float prevFocusY = ZoomManager.this.mFocusY;
            ZoomManager.this.mFocusX = detector.getFocusX();
            ZoomManager.this.mFocusY = detector.getFocusY();
            float focusDelta = prevFocusX == 0.0f && prevFocusY == 0.0f ? 0.0f : FloatMath.sqrt((ZoomManager.this.mFocusX - prevFocusX) * (ZoomManager.this.mFocusX - prevFocusX) + (ZoomManager.this.mFocusY - prevFocusY) * (ZoomManager.this.mFocusY - prevFocusY));
            ZoomManager.this.mFocusMovementQueue.add(focusDelta);
            float deltaSpan = detector.getCurrentSpan() - detector.getPreviousSpan() + this.mAccumulatedSpan;
            boolean bl = result = ZoomManager.this.mFocusMovementQueue.getSum() > Math.abs(deltaSpan);
            this.mAccumulatedSpan = result ? (this.mAccumulatedSpan += deltaSpan) : 0.0f;
            return result;
        }

        public boolean handleScale(ScaleGestureDetector detector) {
            float scale = detector.getScaleFactor() * ZoomManager.this.mActualScale;
            boolean isScaleLimited = ZoomManager.this.isScaleOverLimits(scale) || scale < ZoomManager.this.getZoomOverviewScale();
            scale = Math.max(ZoomManager.this.computeScaleWithLimits(scale), ZoomManager.this.getZoomOverviewScale());
            if (ZoomManager.this.mPinchToZoomAnimating || ZoomManager.this.willScaleTriggerZoom(scale)) {
                ZoomManager.this.mPinchToZoomAnimating = true;
                scale = scale > ZoomManager.this.mActualScale ? Math.min(scale, ZoomManager.this.mActualScale * 1.25f) : Math.max(scale, ZoomManager.this.mActualScale * 0.8f);
                scale = ZoomManager.this.computeScaleWithLimits(scale);
                if (Math.abs(scale - ZoomManager.this.mActualScale) < MINIMUM_SCALE_WITHOUT_JITTER) {
                    return isScaleLimited;
                }
                ZoomManager.this.setZoomCenter(detector.getFocusX(), detector.getFocusY());
                ZoomManager.this.setZoomScale(scale, false);
                ZoomManager.this.mWebView.invalidate();
                return true;
            }
            return isScaleLimited;
        }

        public boolean onScale(ScaleGestureDetector detector) {
            if (this.isPanningOnly(detector) || this.handleScale(detector)) {
                ZoomManager.this.mFocusMovementQueue.clear();
                return true;
            }
            return false;
        }

        public void onScaleEnd(ScaleGestureDetector detector) {
            if (ZoomManager.this.mPinchToZoomAnimating) {
                ZoomManager.this.mPinchToZoomAnimating = false;
                ZoomManager.this.mAnchorX = ZoomManager.this.mWebView.viewToContentX((int)ZoomManager.this.mZoomCenterX + ZoomManager.this.mWebView.getScrollX());
                ZoomManager.this.mAnchorY = ZoomManager.this.mWebView.viewToContentY((int)ZoomManager.this.mZoomCenterY + ZoomManager.this.mWebView.getScrollY());
                boolean reflowNow = !ZoomManager.this.canZoomOut() || (double)ZoomManager.this.mActualScale <= 0.8 * (double)ZoomManager.this.mTextWrapScale;
                ZoomManager.this.refreshZoomScale(reflowNow && !ZoomManager.this.mWebView.getSettings().getUseFixedViewport());
                ZoomManager.this.mWebView.invalidate();
            }
            ((ZoomManager)ZoomManager.this).mWebView.mViewManager.endZoom();
            ZoomManager.this.mWebView.onPinchToZoomAnimationEnd(detector);
        }
    }

    private class FocusMovementQueue {
        private static final int QUEUE_CAPACITY = 5;
        private float[] mQueue = new float[5];
        private float mSum = 0.0f;
        private int mSize = 0;
        private int mIndex = 0;

        FocusMovementQueue() {
        }

        private void clear() {
            this.mSize = 0;
            this.mSum = 0.0f;
            this.mIndex = 0;
            for (int i = 0; i < 5; ++i) {
                this.mQueue[i] = 0.0f;
            }
        }

        private void add(float focusDelta) {
            this.mSum += focusDelta;
            if (this.mSize < 5) {
                ++this.mSize;
            } else {
                this.mSum -= this.mQueue[this.mIndex];
            }
            this.mQueue[this.mIndex] = focusDelta;
            this.mIndex = (this.mIndex + 1) % 5;
        }

        private float getSum() {
            return this.mSum;
        }
    }
}

