/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageParser;
import android.content.pm.PermissionGroupInfo;
import android.content.pm.PermissionInfo;
import android.graphics.drawable.Drawable;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppSecurityPermissions
implements View.OnClickListener {
    private static final String TAG = "AppSecurityPermissions";
    private boolean localLOGV = false;
    private Context mContext;
    private LayoutInflater mInflater;
    private PackageManager mPm;
    private LinearLayout mPermsView;
    private Map<String, String> mDangerousMap;
    private Map<String, String> mNormalMap;
    private List<PermissionInfo> mPermsList;
    private String mDefaultGrpLabel;
    private String mDefaultGrpName = "DefaultGrp";
    private String mPermFormat;
    private Drawable mNormalIcon;
    private Drawable mDangerousIcon;
    private boolean mExpanded;
    private Drawable mShowMaxIcon;
    private Drawable mShowMinIcon;
    private View mShowMore;
    private TextView mShowMoreText;
    private ImageView mShowMoreIcon;
    private State mCurrentState;
    private LinearLayout mNonDangerousList;
    private LinearLayout mDangerousList;
    private HashMap<String, CharSequence> mGroupLabelCache;
    private View mNoPermsView;

    public AppSecurityPermissions(Context context, List<PermissionInfo> permList) {
        this.mContext = context;
        this.mPm = this.mContext.getPackageManager();
        this.mPermsList = permList;
    }

    public AppSecurityPermissions(Context context, String packageName) {
        PackageInfo pkgInfo;
        this.mContext = context;
        this.mPm = this.mContext.getPackageManager();
        this.mPermsList = new ArrayList<PermissionInfo>();
        HashSet<PermissionInfo> permSet = new HashSet<PermissionInfo>();
        try {
            pkgInfo = this.mPm.getPackageInfo(packageName, 4096);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.w(TAG, "Could'nt retrieve permissions for package:" + packageName);
            return;
        }
        if (pkgInfo.applicationInfo != null && pkgInfo.applicationInfo.uid != -1) {
            this.getAllUsedPermissions(pkgInfo.applicationInfo.uid, permSet);
        }
        for (PermissionInfo tmpInfo : permSet) {
            this.mPermsList.add(tmpInfo);
        }
    }

    public AppSecurityPermissions(Context context, PackageParser.Package pkg) {
        ArrayList<String> strList;
        int size;
        this.mContext = context;
        this.mPm = this.mContext.getPackageManager();
        this.mPermsList = new ArrayList<PermissionInfo>();
        HashSet<PermissionInfo> permSet = new HashSet<PermissionInfo>();
        if (pkg == null) {
            return;
        }
        if (pkg.requestedPermissions != null && (size = (strList = pkg.requestedPermissions).size()) > 0) {
            this.extractPerms(strList.toArray(new String[size]), permSet);
        }
        if (pkg.mSharedUserId != null) {
            try {
                int sharedUid = this.mPm.getUidForSharedUser(pkg.mSharedUserId);
                this.getAllUsedPermissions(sharedUid, permSet);
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.w(TAG, "Could'nt retrieve shared user id for:" + pkg.packageName);
            }
        }
        for (PermissionInfo tmpInfo : permSet) {
            this.mPermsList.add(tmpInfo);
        }
    }

    public static View getPermissionItemView(Context context, CharSequence grpName, CharSequence description, boolean dangerous) {
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        Drawable icon = context.getResources().getDrawable(dangerous ? 17302191 : 17302360);
        return AppSecurityPermissions.getPermissionItemView(context, inflater, grpName, description, dangerous, icon);
    }

    private void getAllUsedPermissions(int sharedUid, Set<PermissionInfo> permSet) {
        String[] sharedPkgList = this.mPm.getPackagesForUid(sharedUid);
        if (sharedPkgList == null || sharedPkgList.length == 0) {
            return;
        }
        for (String sharedPkg : sharedPkgList) {
            this.getPermissionsForPackage(sharedPkg, permSet);
        }
    }

    private void getPermissionsForPackage(String packageName, Set<PermissionInfo> permSet) {
        PackageInfo pkgInfo;
        try {
            pkgInfo = this.mPm.getPackageInfo(packageName, 4096);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.w(TAG, "Could'nt retrieve permissions for package:" + packageName);
            return;
        }
        if (pkgInfo != null && pkgInfo.requestedPermissions != null) {
            this.extractPerms(pkgInfo.requestedPermissions, permSet);
        }
    }

    private void extractPerms(String[] strList, Set<PermissionInfo> permSet) {
        if (strList == null || strList.length == 0) {
            return;
        }
        for (String permName : strList) {
            try {
                PermissionInfo tmpPermInfo = this.mPm.getPermissionInfo(permName, 0);
                if (tmpPermInfo == null) continue;
                permSet.add(tmpPermInfo);
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.i(TAG, "Ignoring unknown permission:" + permName);
            }
        }
    }

    public int getPermissionCount() {
        return this.mPermsList.size();
    }

    public View getPermissionsView() {
        this.mInflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
        this.mPermsView = (LinearLayout)this.mInflater.inflate(17367083, null);
        this.mShowMore = this.mPermsView.findViewById(16908898);
        this.mShowMoreIcon = (ImageView)this.mShowMore.findViewById(16908900);
        this.mShowMoreText = (TextView)this.mShowMore.findViewById(16908899);
        this.mDangerousList = (LinearLayout)this.mPermsView.findViewById(16908897);
        this.mNonDangerousList = (LinearLayout)this.mPermsView.findViewById(16908901);
        this.mNoPermsView = this.mPermsView.findViewById(16908896);
        this.mShowMore.setClickable(true);
        this.mShowMore.setOnClickListener(this);
        this.mShowMore.setFocusable(true);
        this.mDefaultGrpLabel = this.mContext.getString(17040420);
        this.mPermFormat = this.mContext.getString(17040421);
        this.mNormalIcon = this.mContext.getResources().getDrawable(17302360);
        this.mDangerousIcon = this.mContext.getResources().getDrawable(17302191);
        this.mShowMaxIcon = this.mContext.getResources().getDrawable(17302123);
        this.mShowMinIcon = this.mContext.getResources().getDrawable(17302130);
        this.setPermissions(this.mPermsList);
        return this.mPermsView;
    }

    private String canonicalizeGroupDesc(String groupDesc) {
        if (groupDesc == null || groupDesc.length() == 0) {
            return null;
        }
        int len = groupDesc.length();
        if (groupDesc.charAt(len - 1) == '.') {
            groupDesc = groupDesc.substring(0, len - 1);
        }
        return groupDesc;
    }

    private String formatPermissions(String groupDesc, CharSequence permDesc) {
        if (groupDesc == null) {
            if (permDesc == null) {
                return null;
            }
            return ((Object)permDesc).toString();
        }
        groupDesc = this.canonicalizeGroupDesc(groupDesc);
        if (permDesc == null) {
            return groupDesc;
        }
        return String.format(this.mPermFormat, groupDesc, ((Object)permDesc).toString());
    }

    private CharSequence getGroupLabel(String grpName) {
        PermissionGroupInfo pgi;
        if (grpName == null) {
            return this.mDefaultGrpLabel;
        }
        CharSequence cachedLabel = this.mGroupLabelCache.get(grpName);
        if (cachedLabel != null) {
            return cachedLabel;
        }
        try {
            pgi = this.mPm.getPermissionGroupInfo(grpName, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.i(TAG, "Invalid group name:" + grpName);
            return null;
        }
        String label = ((Object)pgi.loadLabel(this.mPm)).toString();
        this.mGroupLabelCache.put(grpName, label);
        return label;
    }

    private void displayPermissions(boolean dangerous) {
        Map<String, String> permInfoMap = dangerous ? this.mDangerousMap : this.mNormalMap;
        LinearLayout permListView = dangerous ? this.mDangerousList : this.mNonDangerousList;
        permListView.removeAllViews();
        Set<String> permInfoStrSet = permInfoMap.keySet();
        for (String loopPermGrpInfoStr : permInfoStrSet) {
            CharSequence grpLabel = this.getGroupLabel(loopPermGrpInfoStr);
            if (this.localLOGV) {
                Log.i(TAG, "Adding view group:" + grpLabel + ", desc:" + permInfoMap.get(loopPermGrpInfoStr));
            }
            permListView.addView(this.getPermissionItemView(grpLabel, permInfoMap.get(loopPermGrpInfoStr), dangerous));
        }
    }

    private void displayNoPermissions() {
        this.mNoPermsView.setVisibility(0);
    }

    private View getPermissionItemView(CharSequence grpName, CharSequence permList, boolean dangerous) {
        return AppSecurityPermissions.getPermissionItemView(this.mContext, this.mInflater, grpName, permList, dangerous, dangerous ? this.mDangerousIcon : this.mNormalIcon);
    }

    private static View getPermissionItemView(Context context, LayoutInflater inflater, CharSequence grpName, CharSequence permList, boolean dangerous, Drawable icon) {
        View permView = inflater.inflate(17367081, null);
        TextView permGrpView = (TextView)permView.findViewById(16908894);
        TextView permDescView = (TextView)permView.findViewById(16908895);
        ImageView imgView = (ImageView)permView.findViewById(16908893);
        imgView.setImageDrawable(icon);
        if (grpName != null) {
            permGrpView.setText(grpName);
            permDescView.setText(permList);
        } else {
            permGrpView.setText(permList);
            permDescView.setVisibility(8);
        }
        return permView;
    }

    private void showPermissions() {
        switch (this.mCurrentState) {
            case NO_PERMS: {
                this.displayNoPermissions();
                break;
            }
            case DANGEROUS_ONLY: {
                this.displayPermissions(true);
                break;
            }
            case NORMAL_ONLY: {
                this.displayPermissions(false);
                break;
            }
            case BOTH: {
                this.displayPermissions(true);
                if (this.mExpanded) {
                    this.displayPermissions(false);
                    this.mShowMoreIcon.setImageDrawable(this.mShowMaxIcon);
                    this.mShowMoreText.setText(17040423);
                    this.mNonDangerousList.setVisibility(0);
                } else {
                    this.mShowMoreIcon.setImageDrawable(this.mShowMinIcon);
                    this.mShowMoreText.setText(17040424);
                    this.mNonDangerousList.setVisibility(8);
                }
                this.mShowMore.setVisibility(0);
            }
        }
    }

    private boolean isDisplayablePermission(PermissionInfo pInfo) {
        return pInfo.protectionLevel == 1 || pInfo.protectionLevel == 0;
    }

    private void aggregateGroupDescs(Map<String, List<PermissionInfo>> map, Map<String, String> retMap) {
        if (map == null) {
            return;
        }
        if (retMap == null) {
            return;
        }
        Set<String> grpNames = map.keySet();
        Iterator<String> grpNamesIter = grpNames.iterator();
        while (grpNamesIter.hasNext()) {
            String grpDesc = null;
            String grpNameKey = grpNamesIter.next();
            List<PermissionInfo> grpPermsList = map.get(grpNameKey);
            if (grpPermsList == null) continue;
            for (PermissionInfo permInfo : grpPermsList) {
                CharSequence permDesc = permInfo.loadLabel(this.mPm);
                grpDesc = this.formatPermissions(grpDesc, permDesc);
            }
            if (grpDesc == null) continue;
            if (this.localLOGV) {
                Log.i(TAG, "Group:" + grpNameKey + " description:" + grpDesc.toString());
            }
            retMap.put(grpNameKey, grpDesc.toString());
        }
    }

    private void setPermissions(List<PermissionInfo> permList) {
        this.mGroupLabelCache = new HashMap();
        this.mGroupLabelCache.put(this.mDefaultGrpName, this.mDefaultGrpLabel);
        this.mDangerousMap = new HashMap<String, String>();
        this.mNormalMap = new HashMap<String, String>();
        HashMap<String, List<PermissionInfo>> dangerousMap = new HashMap<String, List<PermissionInfo>>();
        HashMap<String, List<PermissionInfo>> normalMap = new HashMap<String, List<PermissionInfo>>();
        PermissionInfoComparator permComparator = new PermissionInfoComparator(this.mPm);
        if (permList != null) {
            for (PermissionInfo pInfo : permList) {
                ArrayList<PermissionInfo> grpPermsList;
                String grpName;
                if (this.localLOGV) {
                    Log.i(TAG, "Processing permission:" + pInfo.name);
                }
                if (!this.isDisplayablePermission(pInfo)) {
                    if (!this.localLOGV) continue;
                    Log.i(TAG, "Permission:" + pInfo.name + " is not displayable");
                    continue;
                }
                HashMap<String, List<PermissionInfo>> permInfoMap = pInfo.protectionLevel == 1 ? dangerousMap : normalMap;
                String string2 = grpName = pInfo.group == null ? this.mDefaultGrpName : pInfo.group;
                if (this.localLOGV) {
                    Log.i(TAG, "Permission:" + pInfo.name + " belongs to group:" + grpName);
                }
                if ((grpPermsList = (ArrayList<PermissionInfo>)permInfoMap.get(grpName)) == null) {
                    grpPermsList = new ArrayList<PermissionInfo>();
                    permInfoMap.put(grpName, grpPermsList);
                    grpPermsList.add(pInfo);
                    continue;
                }
                int idx = Collections.binarySearch(grpPermsList, pInfo, permComparator);
                if (this.localLOGV) {
                    Log.i(TAG, "idx=" + idx + ", list.size=" + grpPermsList.size());
                }
                if (idx >= 0) continue;
                idx = -idx - 1;
                grpPermsList.add(idx, pInfo);
            }
            this.aggregateGroupDescs(dangerousMap, this.mDangerousMap);
            this.aggregateGroupDescs(normalMap, this.mNormalMap);
        }
        this.mCurrentState = State.NO_PERMS;
        if (this.mDangerousMap.size() > 0) {
            this.mCurrentState = this.mNormalMap.size() > 0 ? State.BOTH : State.DANGEROUS_ONLY;
        } else if (this.mNormalMap.size() > 0) {
            this.mCurrentState = State.NORMAL_ONLY;
        }
        if (this.localLOGV) {
            Log.i(TAG, "mCurrentState=" + (Object)((Object)this.mCurrentState));
        }
        this.showPermissions();
    }

    @Override
    public void onClick(View v) {
        if (this.localLOGV) {
            Log.i(TAG, "mExpanded=" + this.mExpanded);
        }
        this.mExpanded = !this.mExpanded;
        this.showPermissions();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PermissionInfoComparator
    implements Comparator<PermissionInfo> {
        private PackageManager mPm;
        private final Collator sCollator = Collator.getInstance();

        PermissionInfoComparator(PackageManager pm) {
            this.mPm = pm;
        }

        @Override
        public int compare(PermissionInfo a, PermissionInfo b) {
            CharSequence sa = a.loadLabel(this.mPm);
            CharSequence sb = b.loadLabel(this.mPm);
            return this.sCollator.compare(sa, sb);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        NO_PERMS,
        DANGEROUS_ONLY,
        NORMAL_ONLY,
        BOTH;

    }
}

