/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.format.DateUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.NumberPicker;
import android.widget.TextView;
import com.android.internal.R;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Locale;

public class TimePicker
extends FrameLayout {
    private static final boolean DEFAULT_ENABLED_STATE = true;
    private static final int HOURS_IN_HALF_DAY = 12;
    private static final OnTimeChangedListener NO_OP_CHANGE_LISTENER = new OnTimeChangedListener(){

        public void onTimeChanged(TimePicker view, int hourOfDay, int minute) {
        }
    };
    private boolean mIs24HourView;
    private boolean mIsAm;
    private final NumberPicker mHourSpinner;
    private final NumberPicker mMinuteSpinner;
    private final NumberPicker mAmPmSpinner;
    private final EditText mHourSpinnerInput;
    private final EditText mMinuteSpinnerInput;
    private final EditText mAmPmSpinnerInput;
    private final TextView mDivider;
    private final Button mAmPmButton;
    private final String[] mAmPmStrings;
    private boolean mIsEnabled = true;
    private OnTimeChangedListener mOnTimeChangedListener;
    private Calendar mTempCalendar;
    private Locale mCurrentLocale;

    public TimePicker(Context context) {
        this(context, null);
    }

    public TimePicker(Context context, AttributeSet attrs) {
        this(context, attrs, 16843715);
    }

    public TimePicker(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setCurrentLocale(Locale.getDefault());
        TypedArray attributesArray = context.obtainStyledAttributes(attrs, R.styleable.TimePicker, defStyle, 0);
        int layoutResourceId = attributesArray.getResourceId(0, 17367228);
        attributesArray.recycle();
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        inflater.inflate(layoutResourceId, (ViewGroup)this, true);
        this.mHourSpinner = (NumberPicker)this.findViewById(16909129);
        this.mHourSpinner.setOnValueChangedListener(new NumberPicker.OnValueChangeListener(){

            public void onValueChange(NumberPicker spinner, int oldVal, int newVal) {
                TimePicker.this.updateInputState();
                if (!TimePicker.this.is24HourView() && (oldVal == 11 && newVal == 12 || oldVal == 12 && newVal == 11)) {
                    TimePicker.this.mIsAm = !TimePicker.this.mIsAm;
                    TimePicker.this.updateAmPmControl();
                }
                TimePicker.this.onTimeChanged();
            }
        });
        this.mHourSpinnerInput = (EditText)this.mHourSpinner.findViewById(16909047);
        this.mHourSpinnerInput.setImeOptions(5);
        this.mDivider = (TextView)this.findViewById(16909133);
        if (this.mDivider != null) {
            this.mDivider.setText(17039548);
        }
        this.mMinuteSpinner = (NumberPicker)this.findViewById(16909130);
        this.mMinuteSpinner.setMinValue(0);
        this.mMinuteSpinner.setMaxValue(59);
        this.mMinuteSpinner.setOnLongPressUpdateInterval(100L);
        this.mMinuteSpinner.setFormatter(NumberPicker.TWO_DIGIT_FORMATTER);
        this.mMinuteSpinner.setOnValueChangedListener(new NumberPicker.OnValueChangeListener(){

            public void onValueChange(NumberPicker spinner, int oldVal, int newVal) {
                TimePicker.this.updateInputState();
                int minValue = TimePicker.this.mMinuteSpinner.getMinValue();
                int maxValue = TimePicker.this.mMinuteSpinner.getMaxValue();
                if (oldVal == maxValue && newVal == minValue) {
                    int newHour = TimePicker.this.mHourSpinner.getValue() + 1;
                    if (!TimePicker.this.is24HourView() && newHour == 12) {
                        TimePicker.this.mIsAm = !TimePicker.this.mIsAm;
                        TimePicker.this.updateAmPmControl();
                    }
                    TimePicker.this.mHourSpinner.setValue(newHour);
                } else if (oldVal == minValue && newVal == maxValue) {
                    int newHour = TimePicker.this.mHourSpinner.getValue() - 1;
                    if (!TimePicker.this.is24HourView() && newHour == 11) {
                        TimePicker.this.mIsAm = !TimePicker.this.mIsAm;
                        TimePicker.this.updateAmPmControl();
                    }
                    TimePicker.this.mHourSpinner.setValue(newHour);
                }
                TimePicker.this.onTimeChanged();
            }
        });
        this.mMinuteSpinnerInput = (EditText)this.mMinuteSpinner.findViewById(16909047);
        this.mMinuteSpinnerInput.setImeOptions(5);
        this.mAmPmStrings = new DateFormatSymbols().getAmPmStrings();
        View amPmView = this.findViewById(16909131);
        if (amPmView instanceof Button) {
            this.mAmPmSpinner = null;
            this.mAmPmSpinnerInput = null;
            this.mAmPmButton = (Button)amPmView;
            this.mAmPmButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View button) {
                    button.requestFocus();
                    TimePicker.this.mIsAm = !TimePicker.this.mIsAm;
                    TimePicker.this.updateAmPmControl();
                    TimePicker.this.onTimeChanged();
                }
            });
        } else {
            this.mAmPmButton = null;
            this.mAmPmSpinner = (NumberPicker)amPmView;
            this.mAmPmSpinner.setMinValue(0);
            this.mAmPmSpinner.setMaxValue(1);
            this.mAmPmSpinner.setDisplayedValues(this.mAmPmStrings);
            this.mAmPmSpinner.setOnValueChangedListener(new NumberPicker.OnValueChangeListener(){

                public void onValueChange(NumberPicker picker, int oldVal, int newVal) {
                    TimePicker.this.updateInputState();
                    picker.requestFocus();
                    TimePicker.this.mIsAm = !TimePicker.this.mIsAm;
                    TimePicker.this.updateAmPmControl();
                    TimePicker.this.onTimeChanged();
                }
            });
            this.mAmPmSpinnerInput = (EditText)this.mAmPmSpinner.findViewById(16909047);
            this.mAmPmSpinnerInput.setImeOptions(6);
        }
        this.updateHourControl();
        this.updateAmPmControl();
        this.setOnTimeChangedListener(NO_OP_CHANGE_LISTENER);
        this.setCurrentHour(this.mTempCalendar.get(11));
        this.setCurrentMinute(this.mTempCalendar.get(12));
        if (!this.isEnabled()) {
            this.setEnabled(false);
        }
        this.setContentDescriptions();
        if (this.getImportantForAccessibility() == 0) {
            this.setImportantForAccessibility(1);
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.mIsEnabled == enabled) {
            return;
        }
        super.setEnabled(enabled);
        this.mMinuteSpinner.setEnabled(enabled);
        if (this.mDivider != null) {
            this.mDivider.setEnabled(enabled);
        }
        this.mHourSpinner.setEnabled(enabled);
        if (this.mAmPmSpinner != null) {
            this.mAmPmSpinner.setEnabled(enabled);
        } else {
            this.mAmPmButton.setEnabled(enabled);
        }
        this.mIsEnabled = enabled;
    }

    public boolean isEnabled() {
        return this.mIsEnabled;
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.setCurrentLocale(newConfig.locale);
    }

    private void setCurrentLocale(Locale locale) {
        if (locale.equals(this.mCurrentLocale)) {
            return;
        }
        this.mCurrentLocale = locale;
        this.mTempCalendar = Calendar.getInstance(locale);
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        return new SavedState(superState, this.getCurrentHour(), this.getCurrentMinute());
    }

    protected void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.setCurrentHour(ss.getHour());
        this.setCurrentMinute(ss.getMinute());
    }

    public void setOnTimeChangedListener(OnTimeChangedListener onTimeChangedListener) {
        this.mOnTimeChangedListener = onTimeChangedListener;
    }

    public Integer getCurrentHour() {
        int currentHour = this.mHourSpinner.getValue();
        if (this.is24HourView()) {
            return currentHour;
        }
        if (this.mIsAm) {
            return currentHour % 12;
        }
        return currentHour % 12 + 12;
    }

    public void setCurrentHour(Integer currentHour) {
        if (currentHour == null || currentHour == this.getCurrentHour()) {
            return;
        }
        if (!this.is24HourView()) {
            if (currentHour >= 12) {
                this.mIsAm = false;
                if (currentHour > 12) {
                    currentHour = currentHour - 12;
                }
            } else {
                this.mIsAm = true;
                if (currentHour == 0) {
                    currentHour = 12;
                }
            }
            this.updateAmPmControl();
        }
        this.mHourSpinner.setValue(currentHour);
        this.onTimeChanged();
    }

    public void setIs24HourView(Boolean is24HourView) {
        if (this.mIs24HourView == is24HourView) {
            return;
        }
        this.mIs24HourView = is24HourView;
        int currentHour = this.getCurrentHour();
        this.updateHourControl();
        this.setCurrentHour(currentHour);
        this.updateAmPmControl();
    }

    public boolean is24HourView() {
        return this.mIs24HourView;
    }

    public Integer getCurrentMinute() {
        return this.mMinuteSpinner.getValue();
    }

    public void setCurrentMinute(Integer currentMinute) {
        if (currentMinute == this.getCurrentMinute()) {
            return;
        }
        this.mMinuteSpinner.setValue(currentMinute);
        this.onTimeChanged();
    }

    public int getBaseline() {
        return this.mHourSpinner.getBaseline();
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        this.onPopulateAccessibilityEvent(event);
        return true;
    }

    public void onPopulateAccessibilityEvent(AccessibilityEvent event) {
        super.onPopulateAccessibilityEvent(event);
        int flags = 1;
        flags = this.mIs24HourView ? (flags |= 0x80) : (flags |= 0x40);
        this.mTempCalendar.set(11, this.getCurrentHour());
        this.mTempCalendar.set(12, this.getCurrentMinute());
        String selectedDateUtterance = DateUtils.formatDateTime(this.mContext, this.mTempCalendar.getTimeInMillis(), flags);
        event.getText().add(selectedDateUtterance);
    }

    public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        event.setClassName(TimePicker.class.getName());
    }

    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        info.setClassName(TimePicker.class.getName());
    }

    private void updateHourControl() {
        if (this.is24HourView()) {
            this.mHourSpinner.setMinValue(0);
            this.mHourSpinner.setMaxValue(23);
            this.mHourSpinner.setFormatter(NumberPicker.TWO_DIGIT_FORMATTER);
        } else {
            this.mHourSpinner.setMinValue(1);
            this.mHourSpinner.setMaxValue(12);
            this.mHourSpinner.setFormatter(null);
        }
    }

    private void updateAmPmControl() {
        if (this.is24HourView()) {
            if (this.mAmPmSpinner != null) {
                this.mAmPmSpinner.setVisibility(8);
            } else {
                this.mAmPmButton.setVisibility(8);
            }
        } else {
            int index;
            int n = index = this.mIsAm ? 0 : 1;
            if (this.mAmPmSpinner != null) {
                this.mAmPmSpinner.setValue(index);
                this.mAmPmSpinner.setVisibility(0);
            } else {
                this.mAmPmButton.setText(this.mAmPmStrings[index]);
                this.mAmPmButton.setVisibility(0);
            }
        }
        this.sendAccessibilityEvent(4);
    }

    private void onTimeChanged() {
        this.sendAccessibilityEvent(4);
        if (this.mOnTimeChangedListener != null) {
            this.mOnTimeChangedListener.onTimeChanged(this, this.getCurrentHour(), this.getCurrentMinute());
        }
    }

    private void setContentDescriptions() {
        this.trySetContentDescription(this.mMinuteSpinner, 16909046, 17040557);
        this.trySetContentDescription(this.mMinuteSpinner, 16909048, 17040558);
        this.trySetContentDescription(this.mHourSpinner, 16909046, 17040559);
        this.trySetContentDescription(this.mHourSpinner, 16909048, 17040560);
        if (this.mAmPmSpinner != null) {
            this.trySetContentDescription(this.mAmPmSpinner, 16909046, 17040561);
            this.trySetContentDescription(this.mAmPmSpinner, 16909048, 17040562);
        }
    }

    private void trySetContentDescription(View root, int viewId, int contDescResId) {
        View target = root.findViewById(viewId);
        if (target != null) {
            target.setContentDescription(this.mContext.getString(contDescResId));
        }
    }

    private void updateInputState() {
        InputMethodManager inputMethodManager = InputMethodManager.peekInstance();
        if (inputMethodManager != null) {
            if (inputMethodManager.isActive(this.mHourSpinnerInput)) {
                this.mHourSpinnerInput.clearFocus();
                inputMethodManager.hideSoftInputFromWindow(this.getWindowToken(), 0);
            } else if (inputMethodManager.isActive(this.mMinuteSpinnerInput)) {
                this.mMinuteSpinnerInput.clearFocus();
                inputMethodManager.hideSoftInputFromWindow(this.getWindowToken(), 0);
            } else if (inputMethodManager.isActive(this.mAmPmSpinnerInput)) {
                this.mAmPmSpinnerInput.clearFocus();
                inputMethodManager.hideSoftInputFromWindow(this.getWindowToken(), 0);
            }
        }
    }

    private static class SavedState
    extends View.BaseSavedState {
        private final int mHour;
        private final int mMinute;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        private SavedState(Parcelable superState, int hour, int minute) {
            super(superState);
            this.mHour = hour;
            this.mMinute = minute;
        }

        private SavedState(Parcel in) {
            super(in);
            this.mHour = in.readInt();
            this.mMinute = in.readInt();
        }

        public int getHour() {
            return this.mHour;
        }

        public int getMinute() {
            return this.mMinute;
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.mHour);
            dest.writeInt(this.mMinute);
        }
    }

    public static interface OnTimeChangedListener {
        public void onTimeChanged(TimePicker var1, int var2, int var3);
    }
}

