/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.util.Log;
import com.android.internal.telephony.ApnSetting;
import com.android.internal.telephony.DataConnection;
import com.android.internal.telephony.DataConnectionAc;
import com.android.internal.telephony.DataConnectionTracker;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApnContext {
    public final String LOG_TAG;
    protected static final boolean DBG = true;
    private final String mApnType;
    private DataConnectionTracker.State mState;
    private ArrayList<ApnSetting> mWaitingApns = null;
    private AtomicInteger mWaitingApnsPermanentFailureCountDown;
    private ApnSetting mApnSetting;
    DataConnection mDataConnection;
    DataConnectionAc mDataConnectionAc;
    String mReason;
    int mRetryCount;
    AtomicBoolean mDataEnabled;
    AtomicBoolean mDependencyMet;

    public ApnContext(String apnType, String logTag) {
        this.mApnType = apnType;
        this.mState = DataConnectionTracker.State.IDLE;
        this.setReason("dataEnabled");
        this.setRetryCount(0);
        this.mDataEnabled = new AtomicBoolean(false);
        this.mDependencyMet = new AtomicBoolean(true);
        this.mWaitingApnsPermanentFailureCountDown = new AtomicInteger(0);
        this.LOG_TAG = logTag;
    }

    public String getApnType() {
        return this.mApnType;
    }

    public synchronized DataConnection getDataConnection() {
        return this.mDataConnection;
    }

    public synchronized void setDataConnection(DataConnection dc) {
        this.log("setDataConnection: old dc=" + this.mDataConnection + " new dc=" + dc + " this=" + this);
        this.mDataConnection = dc;
    }

    public synchronized DataConnectionAc getDataConnectionAc() {
        return this.mDataConnectionAc;
    }

    public synchronized void setDataConnectionAc(DataConnectionAc dcac) {
        this.log("setDataConnectionAc: old dcac=" + this.mDataConnectionAc + " new dcac=" + dcac);
        if (dcac != null) {
            dcac.addApnContextSync(this);
        } else if (this.mDataConnectionAc != null) {
            this.mDataConnectionAc.removeApnContextSync(this);
        }
        this.mDataConnectionAc = dcac;
    }

    public synchronized ApnSetting getApnSetting() {
        return this.mApnSetting;
    }

    public synchronized void setApnSetting(ApnSetting apnSetting) {
        this.mApnSetting = apnSetting;
    }

    public synchronized void setWaitingApns(ArrayList<ApnSetting> waitingApns) {
        this.mWaitingApns = waitingApns;
        this.mWaitingApnsPermanentFailureCountDown.set(this.mWaitingApns.size());
    }

    public int getWaitingApnsPermFailCount() {
        return this.mWaitingApnsPermanentFailureCountDown.get();
    }

    public void decWaitingApnsPermFailCount() {
        this.mWaitingApnsPermanentFailureCountDown.decrementAndGet();
    }

    public synchronized ApnSetting getNextWaitingApn() {
        ArrayList<ApnSetting> list = this.mWaitingApns;
        ApnSetting apn = null;
        if (list != null && !list.isEmpty()) {
            apn = list.get(0);
        }
        return apn;
    }

    public synchronized void removeWaitingApn(ApnSetting apn) {
        if (this.mWaitingApns != null) {
            this.mWaitingApns.remove(apn);
        }
    }

    public synchronized ArrayList<ApnSetting> getWaitingApns() {
        return this.mWaitingApns;
    }

    public synchronized void setState(DataConnectionTracker.State s) {
        this.log("setState: " + (Object)((Object)s) + ", previous state:" + (Object)((Object)this.mState));
        this.mState = s;
        if (this.mState == DataConnectionTracker.State.FAILED && this.mWaitingApns != null) {
            this.mWaitingApns.clear();
        }
    }

    public synchronized DataConnectionTracker.State getState() {
        return this.mState;
    }

    public boolean isDisconnected() {
        DataConnectionTracker.State currentState = this.getState();
        return currentState == DataConnectionTracker.State.IDLE || currentState == DataConnectionTracker.State.FAILED;
    }

    public synchronized void setReason(String reason) {
        this.log("set reason as " + reason + ",current state " + (Object)((Object)this.mState));
        this.mReason = reason;
    }

    public synchronized String getReason() {
        return this.mReason;
    }

    public synchronized void setRetryCount(int retryCount) {
        this.log("setRetryCount: " + retryCount);
        this.mRetryCount = retryCount;
        DataConnection dc = this.mDataConnection;
        if (dc != null) {
            dc.setRetryCount(retryCount);
        }
    }

    public synchronized int getRetryCount() {
        return this.mRetryCount;
    }

    public boolean isReady() {
        return this.mDataEnabled.get() && this.mDependencyMet.get();
    }

    public void setEnabled(boolean enabled) {
        this.log("set enabled as " + enabled + ", current state is " + this.mDataEnabled.get());
        this.mDataEnabled.set(enabled);
    }

    public boolean isEnabled() {
        return this.mDataEnabled.get();
    }

    public void setDependencyMet(boolean met) {
        this.log("set mDependencyMet as " + met + " current state is " + this.mDependencyMet.get());
        this.mDependencyMet.set(met);
    }

    public boolean getDependencyMet() {
        return this.mDependencyMet.get();
    }

    public String toString() {
        return "{mApnType=" + this.mApnType + " mState=" + (Object)((Object)this.getState()) + " mWaitingApns=" + this.mWaitingApns + " mWaitingApnsPermanentFailureCountDown=" + this.mWaitingApnsPermanentFailureCountDown + " mApnSetting=" + this.mApnSetting + " mDataConnectionAc=" + this.mDataConnectionAc + " mReason=" + this.mReason + " mRetryCount=" + this.mRetryCount + " mDataEnabled=" + this.mDataEnabled + " mDependencyMet=" + this.mDependencyMet + "}";
    }

    protected void log(String s) {
        Log.d(this.LOG_TAG, "[ApnContext:" + this.mApnType + "] " + s);
    }

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("ApnContext: " + this.toString());
    }
}

