/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.PendingIntent;
import android.net.LinkCapabilities;
import android.net.LinkProperties;
import android.net.ProxyProperties;
import android.os.Message;
import android.util.Log;
import com.android.internal.telephony.ApnContext;
import com.android.internal.telephony.ApnSetting;
import com.android.internal.telephony.DataCallState;
import com.android.internal.telephony.DataConnection;
import com.android.internal.util.AsyncChannel;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataConnectionAc
extends AsyncChannel {
    private static final boolean DBG = false;
    private String mLogTag;
    public DataConnection dataConnection;
    public static final int BASE = 266240;
    public static final int REQ_IS_INACTIVE = 266240;
    public static final int RSP_IS_INACTIVE = 266241;
    public static final int REQ_GET_CID = 266242;
    public static final int RSP_GET_CID = 266243;
    public static final int REQ_GET_APNSETTING = 266244;
    public static final int RSP_GET_APNSETTING = 266245;
    public static final int REQ_GET_LINK_PROPERTIES = 266246;
    public static final int RSP_GET_LINK_PROPERTIES = 266247;
    public static final int REQ_SET_LINK_PROPERTIES_HTTP_PROXY = 266248;
    public static final int RSP_SET_LINK_PROPERTIES_HTTP_PROXY = 266249;
    public static final int REQ_GET_LINK_CAPABILITIES = 266250;
    public static final int RSP_GET_LINK_CAPABILITIES = 266251;
    public static final int REQ_UPDATE_LINK_PROPERTIES_DATA_CALL_STATE = 266252;
    public static final int RSP_UPDATE_LINK_PROPERTIES_DATA_CALL_STATE = 266253;
    public static final int REQ_RESET = 266254;
    public static final int RSP_RESET = 266255;
    public static final int REQ_GET_REFCOUNT = 266256;
    public static final int RSP_GET_REFCOUNT = 266257;
    public static final int REQ_ADD_APNCONTEXT = 266258;
    public static final int RSP_ADD_APNCONTEXT = 266259;
    public static final int REQ_REMOVE_APNCONTEXT = 266260;
    public static final int RSP_REMOVE_APNCONTEXT = 266261;
    public static final int REQ_GET_APNCONTEXT_LIST = 266262;
    public static final int RSP_GET_APNCONTEXT_LIST = 266263;
    public static final int REQ_SET_RECONNECT_INTENT = 266264;
    public static final int RSP_SET_RECONNECT_INTENT = 266265;
    public static final int REQ_GET_RECONNECT_INTENT = 266266;
    public static final int RSP_GET_RECONNECT_INTENT = 266267;
    private static final int CMD_TO_STRING_COUNT = 28;
    private static String[] sCmdToString = new String[28];

    protected static String cmdToString(int cmd) {
        if ((cmd -= 266240) >= 0 && cmd < sCmdToString.length) {
            return sCmdToString[cmd];
        }
        return AsyncChannel.cmdToString(cmd + 266240);
    }

    public DataConnectionAc(DataConnection dc, String logTag) {
        this.dataConnection = dc;
        this.mLogTag = logTag;
    }

    public void reqIsInactive() {
        this.sendMessage(266240);
    }

    public boolean rspIsInactive(Message response) {
        boolean retVal = response.arg1 == 1;
        return retVal;
    }

    public boolean isInactiveSync() {
        Message response = this.sendMessageSynchronously(266240);
        if (response != null && response.what == 266241) {
            return this.rspIsInactive(response);
        }
        this.log("rspIsInactive error response=" + response);
        return false;
    }

    public void reqCid() {
        this.sendMessage(266242);
    }

    public int rspCid(Message response) {
        int retVal = response.arg1;
        return retVal;
    }

    public int getCidSync() {
        Message response = this.sendMessageSynchronously(266242);
        if (response != null && response.what == 266243) {
            return this.rspCid(response);
        }
        this.log("rspCid error response=" + response);
        return -1;
    }

    public void reqRefCount() {
        this.sendMessage(266256);
    }

    public int rspRefCount(Message response) {
        int retVal = response.arg1;
        return retVal;
    }

    public int getRefCountSync() {
        Message response = this.sendMessageSynchronously(266256);
        if (response != null && response.what == 266257) {
            return this.rspRefCount(response);
        }
        this.log("rspRefCount error response=" + response);
        return -1;
    }

    public void reqApnSetting() {
        this.sendMessage(266244);
    }

    public ApnSetting rspApnSetting(Message response) {
        ApnSetting retVal = (ApnSetting)response.obj;
        return retVal;
    }

    public ApnSetting getApnSettingSync() {
        Message response = this.sendMessageSynchronously(266244);
        if (response != null && response.what == 266245) {
            return this.rspApnSetting(response);
        }
        this.log("getApnSetting error response=" + response);
        return null;
    }

    public void reqLinkProperties() {
        this.sendMessage(266246);
    }

    public LinkProperties rspLinkProperties(Message response) {
        LinkProperties retVal = (LinkProperties)response.obj;
        return retVal;
    }

    public LinkProperties getLinkPropertiesSync() {
        Message response = this.sendMessageSynchronously(266246);
        if (response != null && response.what == 266247) {
            return this.rspLinkProperties(response);
        }
        this.log("getLinkProperties error response=" + response);
        return null;
    }

    public void reqSetLinkPropertiesHttpProxy(ProxyProperties proxy) {
        this.sendMessage(266248, proxy);
    }

    public void setLinkPropertiesHttpProxySync(ProxyProperties proxy) {
        Message response = this.sendMessageSynchronously(266248, proxy);
        if (response == null || response.what != 266249) {
            this.log("setLinkPropertiesHttpPoxy error response=" + response);
        }
    }

    public void reqUpdateLinkPropertiesDataCallState(DataCallState newState) {
        this.sendMessage(266252, newState);
    }

    public DataConnection.UpdateLinkPropertyResult rspUpdateLinkPropertiesDataCallState(Message response) {
        DataConnection.UpdateLinkPropertyResult retVal = (DataConnection.UpdateLinkPropertyResult)response.obj;
        return retVal;
    }

    public DataConnection.UpdateLinkPropertyResult updateLinkPropertiesDataCallStateSync(DataCallState newState) {
        Message response = this.sendMessageSynchronously(266252, newState);
        if (response != null && response.what == 266253) {
            return this.rspUpdateLinkPropertiesDataCallState(response);
        }
        this.log("getLinkProperties error response=" + response);
        return new DataConnection.UpdateLinkPropertyResult(new LinkProperties());
    }

    public void reqLinkCapabilities() {
        this.sendMessage(266250);
    }

    public LinkCapabilities rspLinkCapabilities(Message response) {
        LinkCapabilities retVal = (LinkCapabilities)response.obj;
        return retVal;
    }

    public LinkCapabilities getLinkCapabilitiesSync() {
        Message response = this.sendMessageSynchronously(266250);
        if (response != null && response.what == 266251) {
            return this.rspLinkCapabilities(response);
        }
        this.log("getLinkCapabilities error response=" + response);
        return null;
    }

    public void reqReset() {
        this.sendMessage(266254);
    }

    public void resetSync() {
        Message response = this.sendMessageSynchronously(266254);
        if (response == null || response.what != 266255) {
            this.log("restSync error response=" + response);
        }
    }

    public void reqAddApnContext(ApnContext apnContext) {
        Message response = this.sendMessageSynchronously(266258, apnContext);
    }

    public void addApnContextSync(ApnContext apnContext) {
        Message response = this.sendMessageSynchronously(266258, apnContext);
        if (response == null || response.what != 266259) {
            this.log("addApnContext error response=" + response);
        }
    }

    public void reqRemomveApnContext(ApnContext apnContext) {
        Message response = this.sendMessageSynchronously(266260, apnContext);
    }

    public void removeApnContextSync(ApnContext apnContext) {
        Message response = this.sendMessageSynchronously(266260, apnContext);
        if (response == null || response.what != 266261) {
            this.log("removeApnContext error response=" + response);
        }
    }

    public void reqGetApnList(ApnContext apnContext) {
        Message response = this.sendMessageSynchronously(266262);
    }

    public Collection<ApnContext> rspApnList(Message response) {
        ArrayList retVal = (ArrayList)response.obj;
        if (retVal == null) {
            retVal = new ArrayList();
        }
        return retVal;
    }

    public Collection<ApnContext> getApnListSync() {
        Message response = this.sendMessageSynchronously(266262);
        if (response != null && response.what == 266263) {
            return this.rspApnList(response);
        }
        this.log("getApnList error response=" + response);
        return new ArrayList<ApnContext>();
    }

    public void reqSetReconnectIntent(PendingIntent intent) {
        Message response = this.sendMessageSynchronously(266264, intent);
    }

    public void setReconnectIntentSync(PendingIntent intent) {
        Message response = this.sendMessageSynchronously(266264, intent);
        if (response == null || response.what != 266265) {
            this.log("setReconnectIntent error response=" + response);
        }
    }

    public void reqGetReconnectIntent() {
        Message response = this.sendMessageSynchronously(266266);
    }

    public PendingIntent rspReconnectIntent(Message response) {
        PendingIntent retVal = (PendingIntent)response.obj;
        return retVal;
    }

    public PendingIntent getReconnectIntentSync() {
        Message response = this.sendMessageSynchronously(266266);
        if (response != null && response.what == 266267) {
            return this.rspReconnectIntent(response);
        }
        this.log("getReconnectIntent error response=" + response);
        return null;
    }

    public String toString() {
        return this.dataConnection.getName();
    }

    private void log(String s) {
        Log.d(this.mLogTag, "DataConnectionAc " + s);
    }

    static {
        DataConnectionAc.sCmdToString[0] = "REQ_IS_INACTIVE";
        DataConnectionAc.sCmdToString[1] = "RSP_IS_INACTIVE";
        DataConnectionAc.sCmdToString[2] = "REQ_GET_CID";
        DataConnectionAc.sCmdToString[3] = "RSP_GET_CID";
        DataConnectionAc.sCmdToString[4] = "REQ_GET_APNSETTING";
        DataConnectionAc.sCmdToString[5] = "RSP_GET_APNSETTING";
        DataConnectionAc.sCmdToString[6] = "REQ_GET_LINK_PROPERTIES";
        DataConnectionAc.sCmdToString[7] = "RSP_GET_LINK_PROPERTIES";
        DataConnectionAc.sCmdToString[8] = "REQ_SET_LINK_PROPERTIES_HTTP_PROXY";
        DataConnectionAc.sCmdToString[9] = "RSP_SET_LINK_PROPERTIES_HTTP_PROXY";
        DataConnectionAc.sCmdToString[10] = "REQ_GET_LINK_CAPABILITIES";
        DataConnectionAc.sCmdToString[11] = "RSP_GET_LINK_CAPABILITIES";
        DataConnectionAc.sCmdToString[12] = "REQ_UPDATE_LINK_PROPERTIES_DATA_CALL_STATE";
        DataConnectionAc.sCmdToString[13] = "RSP_UPDATE_LINK_PROPERTIES_DATA_CALL_STATE";
        DataConnectionAc.sCmdToString[14] = "REQ_RESET";
        DataConnectionAc.sCmdToString[15] = "RSP_RESET";
        DataConnectionAc.sCmdToString[16] = "REQ_GET_REFCOUNT";
        DataConnectionAc.sCmdToString[17] = "RSP_GET_REFCOUNT";
        DataConnectionAc.sCmdToString[18] = "REQ_ADD_APNCONTEXT";
        DataConnectionAc.sCmdToString[19] = "RSP_ADD_APNCONTEXT";
        DataConnectionAc.sCmdToString[20] = "REQ_REMOVE_APNCONTEXT";
        DataConnectionAc.sCmdToString[21] = "RSP_REMOVE_APNCONTEXT";
        DataConnectionAc.sCmdToString[22] = "REQ_GET_APNCONTEXT_LIST";
        DataConnectionAc.sCmdToString[23] = "RSP_GET_APNCONTEXT_LIST";
        DataConnectionAc.sCmdToString[24] = "REQ_SET_RECONNECT_INTENT";
        DataConnectionAc.sCmdToString[25] = "RSP_SET_RECONNECT_INTENT";
        DataConnectionAc.sCmdToString[26] = "REQ_GET_RECONNECT_INTENT";
        DataConnectionAc.sCmdToString[27] = "RSP_GET_RECONNECT_INTENT";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LinkPropertyChangeAction {
        NONE,
        CHANGED,
        RESET;


        public static LinkPropertyChangeAction fromInt(int value) {
            if (value == NONE.ordinal()) {
                return NONE;
            }
            if (value == CHANGED.ordinal()) {
                return CHANGED;
            }
            if (value == RESET.ordinal()) {
                return RESET;
            }
            throw new RuntimeException("LinkPropertyChangeAction.fromInt: bad value=" + value);
        }
    }
}

