/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.ActivityManagerNative;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.PowerManager;
import android.os.Registrant;
import android.os.RegistrantList;
import android.util.Log;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.IccCardApplication;
import com.android.internal.telephony.IccCardStatus;
import com.android.internal.telephony.IccFileHandler;
import com.android.internal.telephony.IccRecords;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.cat.CatService;
import com.android.internal.telephony.cdma.CDMALTEPhone;
import com.android.internal.telephony.cdma.CdmaLteUiccFileHandler;
import com.android.internal.telephony.cdma.CdmaLteUiccRecords;
import com.android.internal.telephony.cdma.CdmaSubscriptionSourceManager;
import com.android.internal.telephony.cdma.RuimFileHandler;
import com.android.internal.telephony.cdma.RuimRecords;
import com.android.internal.telephony.gsm.SIMFileHandler;
import com.android.internal.telephony.gsm.SIMRecords;

public class IccCard {
    protected String mLogTag;
    protected boolean mDbg;
    protected IccCardStatus mIccCardStatus = null;
    protected State mState = null;
    private final Object mStateMonitor = new Object();
    protected boolean is3gpp = true;
    protected boolean isSubscriptionFromIccCard = true;
    protected CdmaSubscriptionSourceManager mCdmaSSM = null;
    protected PhoneBase mPhone;
    private IccRecords mIccRecords;
    private IccFileHandler mIccFileHandler;
    private CatService mCatService;
    private RegistrantList mAbsentRegistrants = new RegistrantList();
    private RegistrantList mPinLockedRegistrants = new RegistrantList();
    private RegistrantList mNetworkLockedRegistrants = new RegistrantList();
    protected RegistrantList mReadyRegistrants = new RegistrantList();
    protected RegistrantList mRuimReadyRegistrants = new RegistrantList();
    private boolean mDesiredPinLocked;
    private boolean mDesiredFdnEnabled;
    private boolean mIccPinLocked = true;
    private boolean mIccFdnEnabled = false;
    public static final boolean CARD_IS_3GPP = true;
    public static final boolean CARD_IS_NOT_3GPP = false;
    public static final String INTENT_KEY_ICC_STATE = "ss";
    public static final String INTENT_VALUE_ICC_NOT_READY = "NOT_READY";
    public static final String INTENT_VALUE_ICC_ABSENT = "ABSENT";
    public static final String INTENT_VALUE_ICC_LOCKED = "LOCKED";
    public static final String INTENT_VALUE_ICC_READY = "READY";
    public static final String INTENT_VALUE_ICC_IMSI = "IMSI";
    public static final String INTENT_VALUE_ICC_LOADED = "LOADED";
    public static final String INTENT_KEY_LOCKED_REASON = "reason";
    public static final String INTENT_VALUE_LOCKED_ON_PIN = "PIN";
    public static final String INTENT_VALUE_LOCKED_ON_PUK = "PUK";
    public static final String INTENT_VALUE_LOCKED_NETWORK = "NETWORK";
    public static final String INTENT_VALUE_ABSENT_ON_PERM_DISABLED = "PERM_DISABLED";
    protected static final int EVENT_ICC_LOCKED = 1;
    private static final int EVENT_GET_ICC_STATUS_DONE = 2;
    protected static final int EVENT_RADIO_OFF_OR_NOT_AVAILABLE = 3;
    private static final int EVENT_PINPUK_DONE = 4;
    private static final int EVENT_REPOLL_STATUS_DONE = 5;
    protected static final int EVENT_ICC_READY = 6;
    private static final int EVENT_QUERY_FACILITY_LOCK_DONE = 7;
    private static final int EVENT_CHANGE_FACILITY_LOCK_DONE = 8;
    private static final int EVENT_CHANGE_ICC_PASSWORD_DONE = 9;
    private static final int EVENT_QUERY_FACILITY_FDN_DONE = 10;
    private static final int EVENT_CHANGE_FACILITY_FDN_DONE = 11;
    private static final int EVENT_ICC_STATUS_CHANGED = 12;
    private static final int EVENT_CARD_REMOVED = 13;
    private static final int EVENT_CARD_ADDED = 14;
    protected static final int EVENT_CDMA_SUBSCRIPTION_SOURCE_CHANGED = 15;
    protected static final int EVENT_RADIO_ON = 16;
    protected Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            int serviceClassX = 7;
            if (!IccCard.this.mPhone.mIsTheCurrentActivePhone) {
                Log.e(IccCard.this.mLogTag, "Received message " + msg + "[" + msg.what + "] while being destroyed. Ignoring.");
                return;
            }
            switch (msg.what) {
                case 3: {
                    IccCard.this.mState = null;
                    IccCard.this.updateStateProperty();
                    IccCard.this.broadcastIccStateChangedIntent(IccCard.INTENT_VALUE_ICC_NOT_READY, null);
                    break;
                }
                case 16: {
                    if (!IccCard.this.is3gpp) {
                        IccCard.this.handleCdmaSubscriptionSource();
                    }
                    IccCard.this.mPhone.mCM.getIccCardStatus(this.obtainMessage(2));
                    break;
                }
                case 15: {
                    IccCard.this.handleCdmaSubscriptionSource();
                    break;
                }
                case 6: {
                    if (!IccCard.this.isSubscriptionFromIccCard) break;
                    IccCard.this.mPhone.mCM.queryFacilityLock("SC", "", serviceClassX, this.obtainMessage(7));
                    IccCard.this.mPhone.mCM.queryFacilityLock("FD", "", serviceClassX, this.obtainMessage(10));
                    break;
                }
                case 1: {
                    IccCard.this.mPhone.mCM.queryFacilityLock("SC", "", serviceClassX, this.obtainMessage(7));
                    break;
                }
                case 2: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    IccCard.this.getIccCardStatusDone(ar);
                    break;
                }
                case 4: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    AsyncResult.forMessage((Message)((Message)ar.userObj)).exception = ar.exception;
                    IccCard.this.mPhone.mCM.getIccCardStatus(this.obtainMessage(5, ar.userObj));
                    break;
                }
                case 5: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    IccCard.this.getIccCardStatusDone(ar);
                    ((Message)ar.userObj).sendToTarget();
                    break;
                }
                case 7: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    IccCard.this.onQueryFacilityLock(ar);
                    break;
                }
                case 10: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    IccCard.this.onQueryFdnEnabled(ar);
                    break;
                }
                case 8: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception == null) {
                        IccCard.this.mIccPinLocked = IccCard.this.mDesiredPinLocked;
                        if (IccCard.this.mDbg) {
                            IccCard.this.log("EVENT_CHANGE_FACILITY_LOCK_DONE: mIccPinLocked= " + IccCard.this.mIccPinLocked);
                        }
                    } else {
                        Log.e(IccCard.this.mLogTag, "Error change facility lock with exception " + ar.exception);
                    }
                    AsyncResult.forMessage((Message)((Message)ar.userObj)).exception = ar.exception;
                    ((Message)ar.userObj).sendToTarget();
                    break;
                }
                case 11: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception == null) {
                        IccCard.this.mIccFdnEnabled = IccCard.this.mDesiredFdnEnabled;
                        if (IccCard.this.mDbg) {
                            IccCard.this.log("EVENT_CHANGE_FACILITY_FDN_DONE: mIccFdnEnabled=" + IccCard.this.mIccFdnEnabled);
                        }
                    } else {
                        Log.e(IccCard.this.mLogTag, "Error change facility fdn with exception " + ar.exception);
                    }
                    AsyncResult.forMessage((Message)((Message)ar.userObj)).exception = ar.exception;
                    ((Message)ar.userObj).sendToTarget();
                    break;
                }
                case 9: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception != null) {
                        Log.e(IccCard.this.mLogTag, "Error in change sim password with exception" + ar.exception);
                    }
                    AsyncResult.forMessage((Message)((Message)ar.userObj)).exception = ar.exception;
                    ((Message)ar.userObj).sendToTarget();
                    break;
                }
                case 12: {
                    Log.d(IccCard.this.mLogTag, "Received Event EVENT_ICC_STATUS_CHANGED");
                    IccCard.this.mPhone.mCM.getIccCardStatus(this.obtainMessage(2));
                    break;
                }
                case 13: {
                    IccCard.this.onIccSwap(false);
                    break;
                }
                case 14: {
                    IccCard.this.onIccSwap(true);
                    break;
                }
                default: {
                    Log.e(IccCard.this.mLogTag, "[IccCard] Unknown Event " + msg.what);
                }
            }
        }
    };

    public State getState() {
        if (this.mState == null) {
            switch (this.mPhone.mCM.getRadioState()) {
                case RADIO_OFF: 
                case RADIO_UNAVAILABLE: {
                    return State.UNKNOWN;
                }
            }
            if (!this.is3gpp && !this.isSubscriptionFromIccCard) {
                return State.READY;
            }
        } else {
            return this.mState;
        }
        return State.UNKNOWN;
    }

    public IccCard(PhoneBase phone, String logTag, Boolean is3gpp, Boolean dbg) {
        this.mLogTag = logTag;
        this.mDbg = dbg;
        if (this.mDbg) {
            this.log("[IccCard] Creating card type " + (is3gpp != false ? "3gpp" : "3gpp2"));
        }
        this.mPhone = phone;
        this.is3gpp = is3gpp;
        this.mCdmaSSM = CdmaSubscriptionSourceManager.getInstance(this.mPhone.getContext(), this.mPhone.mCM, this.mHandler, 15, null);
        if (phone.mCM.getLteOnCdmaMode() == 1 && phone instanceof CDMALTEPhone) {
            this.mIccFileHandler = new CdmaLteUiccFileHandler(this, "", this.mPhone.mCM);
            this.mIccRecords = new CdmaLteUiccRecords(this, this.mPhone.mContext, this.mPhone.mCM);
        } else {
            this.mIccFileHandler = is3gpp != false ? new SIMFileHandler(this, "", this.mPhone.mCM) : new RuimFileHandler(this, "", this.mPhone.mCM);
            this.mIccRecords = is3gpp != false ? new SIMRecords(this, this.mPhone.mContext, this.mPhone.mCM) : new RuimRecords(this, this.mPhone.mContext, this.mPhone.mCM);
        }
        this.mCatService = CatService.getInstance(this.mPhone.mCM, this.mIccRecords, this.mPhone.mContext, this.mIccFileHandler, this);
        this.mPhone.mCM.registerForOffOrNotAvailable(this.mHandler, 3, null);
        this.mPhone.mCM.registerForOn(this.mHandler, 16, null);
        this.mPhone.mCM.registerForIccStatusChanged(this.mHandler, 12, null);
    }

    public void dispose() {
        if (this.mDbg) {
            this.log("[IccCard] Disposing card type " + (this.is3gpp ? "3gpp" : "3gpp2"));
        }
        this.mPhone.mCM.unregisterForIccStatusChanged(this.mHandler);
        this.mPhone.mCM.unregisterForOffOrNotAvailable(this.mHandler);
        this.mPhone.mCM.unregisterForOn(this.mHandler);
        this.mCatService.dispose();
        this.mCdmaSSM.dispose(this.mHandler);
        this.mIccRecords.dispose();
        this.mIccFileHandler.dispose();
    }

    protected void finalize() {
        if (this.mDbg) {
            this.log("[IccCard] Finalized card type " + (this.is3gpp ? "3gpp" : "3gpp2"));
        }
    }

    public IccRecords getIccRecords() {
        return this.mIccRecords;
    }

    public IccFileHandler getIccFileHandler() {
        return this.mIccFileHandler;
    }

    public void registerForAbsent(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mAbsentRegistrants.add(r);
        if (this.getState() == State.ABSENT) {
            r.notifyRegistrant();
        }
    }

    public void unregisterForAbsent(Handler h) {
        this.mAbsentRegistrants.remove(h);
    }

    public void registerForNetworkLocked(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mNetworkLockedRegistrants.add(r);
        if (this.getState() == State.NETWORK_LOCKED) {
            r.notifyRegistrant();
        }
    }

    public void unregisterForNetworkLocked(Handler h) {
        this.mNetworkLockedRegistrants.remove(h);
    }

    public void registerForLocked(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mPinLockedRegistrants.add(r);
        if (this.getState().isPinLocked()) {
            r.notifyRegistrant();
        }
    }

    public void unregisterForLocked(Handler h) {
        this.mPinLockedRegistrants.remove(h);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerForReady(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        Object object = this.mStateMonitor;
        synchronized (object) {
            this.mReadyRegistrants.add(r);
            if (this.getState() == State.READY) {
                r.notifyRegistrant(new AsyncResult(null, null, null));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterForReady(Handler h) {
        Object object = this.mStateMonitor;
        synchronized (object) {
            this.mReadyRegistrants.remove(h);
        }
    }

    public State getRuimState() {
        if (this.mIccCardStatus != null) {
            return this.getAppState(this.mIccCardStatus.getCdmaSubscriptionAppIndex());
        }
        return State.UNKNOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerForRuimReady(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        Object object = this.mStateMonitor;
        synchronized (object) {
            this.mRuimReadyRegistrants.add(r);
            if (this.getState() == State.READY && this.getRuimState() == State.READY) {
                r.notifyRegistrant(new AsyncResult(null, null, null));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterForRuimReady(Handler h) {
        Object object = this.mStateMonitor;
        synchronized (object) {
            this.mRuimReadyRegistrants.remove(h);
        }
    }

    public void supplyPin(String pin, Message onComplete) {
        this.mPhone.mCM.supplyIccPin(pin, this.mHandler.obtainMessage(4, onComplete));
    }

    public void supplyPuk(String puk, String newPin, Message onComplete) {
        this.mPhone.mCM.supplyIccPuk(puk, newPin, this.mHandler.obtainMessage(4, onComplete));
    }

    public void supplyPin2(String pin2, Message onComplete) {
        this.mPhone.mCM.supplyIccPin2(pin2, this.mHandler.obtainMessage(4, onComplete));
    }

    public void supplyPuk2(String puk2, String newPin2, Message onComplete) {
        this.mPhone.mCM.supplyIccPuk2(puk2, newPin2, this.mHandler.obtainMessage(4, onComplete));
    }

    public void supplyNetworkDepersonalization(String pin, Message onComplete) {
        this.mPhone.mCM.supplyNetworkDepersonalization(pin, this.mHandler.obtainMessage(4, onComplete));
    }

    public boolean getIccLockEnabled() {
        return this.mIccPinLocked;
    }

    public boolean getIccFdnEnabled() {
        return this.mIccFdnEnabled;
    }

    public void setIccLockEnabled(boolean enabled, String password, Message onComplete) {
        int serviceClassX = 7;
        this.mDesiredPinLocked = enabled;
        this.mPhone.mCM.setFacilityLock("SC", enabled, password, serviceClassX, this.mHandler.obtainMessage(8, onComplete));
    }

    public void setIccFdnEnabled(boolean enabled, String password, Message onComplete) {
        int serviceClassX = 15;
        this.mDesiredFdnEnabled = enabled;
        this.mPhone.mCM.setFacilityLock("FD", enabled, password, serviceClassX, this.mHandler.obtainMessage(11, onComplete));
    }

    public void changeIccLockPassword(String oldPassword, String newPassword, Message onComplete) {
        this.mPhone.mCM.changeIccPin(oldPassword, newPassword, this.mHandler.obtainMessage(9, onComplete));
    }

    public void changeIccFdnPassword(String oldPassword, String newPassword, Message onComplete) {
        this.mPhone.mCM.changeIccPin2(oldPassword, newPassword, this.mHandler.obtainMessage(9, onComplete));
    }

    public String getServiceProviderName() {
        return this.mPhone.mIccRecords.getServiceProviderName();
    }

    protected void updateStateProperty() {
        this.mPhone.setSystemProperty("gsm.sim.state", this.getState().toString());
    }

    private void getIccCardStatusDone(AsyncResult ar) {
        if (ar.exception != null) {
            Log.e(this.mLogTag, "Error getting ICC status. RIL_REQUEST_GET_ICC_STATUS should never return an error", ar.exception);
            return;
        }
        this.handleIccCardStatus((IccCardStatus)ar.result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleIccCardStatus(IccCardStatus newCardStatus) {
        boolean isIccCardAdded;
        State oldRuimState = this.getRuimState();
        State oldState = this.mState;
        this.mIccCardStatus = newCardStatus;
        State newState = this.getIccCardState();
        Object object = this.mStateMonitor;
        synchronized (object) {
            this.mState = newState;
            this.updateStateProperty();
            if (oldState != State.READY && newState == State.READY) {
                this.mHandler.sendMessage(this.mHandler.obtainMessage(6));
                this.mReadyRegistrants.notifyRegistrants();
            } else if (newState.isPinLocked()) {
                this.mHandler.sendMessage(this.mHandler.obtainMessage(1));
            }
            if (oldRuimState != State.READY && this.getRuimState() == State.READY) {
                this.mRuimReadyRegistrants.notifyRegistrants();
            }
        }
        boolean transitionedIntoPinLocked = oldState != State.PIN_REQUIRED && newState == State.PIN_REQUIRED || oldState != State.PUK_REQUIRED && newState == State.PUK_REQUIRED;
        boolean transitionedIntoAbsent = oldState != State.ABSENT && newState == State.ABSENT;
        boolean transitionedIntoNetworkLocked = oldState != State.NETWORK_LOCKED && newState == State.NETWORK_LOCKED;
        boolean transitionedIntoPermBlocked = oldState != State.PERM_DISABLED && newState == State.PERM_DISABLED;
        boolean isIccCardRemoved = oldState != null && oldState.iccCardExist() && newState == State.ABSENT;
        boolean bl = isIccCardAdded = oldState == State.ABSENT && newState != null && newState.iccCardExist();
        if (transitionedIntoPinLocked) {
            if (this.mDbg) {
                this.log("Notify SIM pin or puk locked.");
            }
            this.mPinLockedRegistrants.notifyRegistrants();
            this.broadcastIccStateChangedIntent(INTENT_VALUE_ICC_LOCKED, newState == State.PIN_REQUIRED ? INTENT_VALUE_LOCKED_ON_PIN : INTENT_VALUE_LOCKED_ON_PUK);
        } else if (transitionedIntoAbsent) {
            if (this.mDbg) {
                this.log("Notify SIM missing.");
            }
            this.mAbsentRegistrants.notifyRegistrants();
            this.broadcastIccStateChangedIntent(INTENT_VALUE_ICC_ABSENT, null);
        } else if (transitionedIntoNetworkLocked) {
            if (this.mDbg) {
                this.log("Notify SIM network locked.");
            }
            this.mNetworkLockedRegistrants.notifyRegistrants();
            this.broadcastIccStateChangedIntent(INTENT_VALUE_ICC_LOCKED, INTENT_VALUE_LOCKED_NETWORK);
        } else if (transitionedIntoPermBlocked) {
            if (this.mDbg) {
                this.log("Notify SIM permanently disabled.");
            }
            this.broadcastIccStateChangedIntent(INTENT_VALUE_ICC_ABSENT, INTENT_VALUE_ABSENT_ON_PERM_DISABLED);
        }
        if (isIccCardRemoved) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(13, null));
        } else if (isIccCardAdded) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(14, null));
        }
        if (oldState != State.READY && newState == State.READY && (this.is3gpp || this.isSubscriptionFromIccCard)) {
            if (!(this.mIccFileHandler instanceof CdmaLteUiccFileHandler)) {
                this.mIccFileHandler.setAid(this.getAid());
            }
            this.mIccRecords.onReady();
        }
    }

    private void onIccSwap(boolean isAdded) {
        DialogInterface.OnClickListener listener = null;
        listener = new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (which == -1) {
                    if (IccCard.this.mDbg) {
                        IccCard.this.log("Reboot due to SIM swap");
                    }
                    PowerManager pm = (PowerManager)IccCard.this.mPhone.getContext().getSystemService("power");
                    pm.reboot("SIM is added.");
                }
            }
        };
        Resources r = Resources.getSystem();
        String title = isAdded ? r.getString(17040413) : r.getString(17040410);
        String message = isAdded ? r.getString(17040414) : r.getString(17040411);
        String buttonTxt = r.getString(17040415);
        AlertDialog dialog = new AlertDialog.Builder(this.mPhone.getContext()).setTitle(title).setMessage(message).setPositiveButton(buttonTxt, listener).create();
        dialog.getWindow().setType(2003);
        dialog.show();
    }

    private void onQueryFdnEnabled(AsyncResult ar) {
        if (ar.exception != null) {
            if (this.mDbg) {
                this.log("Error in querying facility lock:" + ar.exception);
            }
            return;
        }
        int[] ints = (int[])ar.result;
        if (ints.length != 0) {
            boolean bl = this.mIccFdnEnabled = 0 != ints[0];
            if (this.mDbg) {
                this.log("Query facility lock : " + this.mIccFdnEnabled);
            }
        } else {
            Log.e(this.mLogTag, "[IccCard] Bogus facility lock response");
        }
    }

    private void onQueryFacilityLock(AsyncResult ar) {
        if (ar.exception != null) {
            if (this.mDbg) {
                this.log("Error in querying facility lock:" + ar.exception);
            }
            return;
        }
        int[] ints = (int[])ar.result;
        if (ints.length != 0) {
            boolean bl = this.mIccPinLocked = 0 != ints[0];
            if (this.mDbg) {
                this.log("Query facility lock : " + this.mIccPinLocked);
            }
        } else {
            Log.e(this.mLogTag, "[IccCard] Bogus facility lock response");
        }
    }

    public void broadcastIccStateChangedIntent(String value, String reason) {
        Intent intent = new Intent("android.intent.action.SIM_STATE_CHANGED");
        intent.addFlags(0x20000000);
        intent.putExtra("phoneName", this.mPhone.getPhoneName());
        intent.putExtra(INTENT_KEY_ICC_STATE, value);
        intent.putExtra(INTENT_KEY_LOCKED_REASON, reason);
        if (this.mDbg) {
            this.log("Broadcasting intent ACTION_SIM_STATE_CHANGED " + value + " reason " + reason);
        }
        ActivityManagerNative.broadcastStickyIntent(intent, "android.permission.READ_PHONE_STATE");
    }

    private void handleCdmaSubscriptionSource() {
        if (this.mCdmaSSM != null) {
            boolean isNewSubFromRuim;
            int newSubscriptionSource = this.mCdmaSSM.getCdmaSubscriptionSource();
            Log.d(this.mLogTag, "Received Cdma subscription source: " + newSubscriptionSource);
            boolean bl = isNewSubFromRuim = newSubscriptionSource == 0;
            if (isNewSubFromRuim != this.isSubscriptionFromIccCard) {
                this.isSubscriptionFromIccCard = isNewSubFromRuim;
                this.handleIccCardStatus(this.mIccCardStatus);
            }
        }
    }

    public State getIccCardState() {
        if (!this.is3gpp && !this.isSubscriptionFromIccCard) {
            return State.READY;
        }
        if (this.mIccCardStatus == null) {
            Log.e(this.mLogTag, "[IccCard] IccCardStatus is null");
            return State.ABSENT;
        }
        if (!this.mIccCardStatus.getCardState().isCardPresent()) {
            return State.ABSENT;
        }
        CommandsInterface.RadioState currentRadioState = this.mPhone.mCM.getRadioState();
        if (currentRadioState == CommandsInterface.RadioState.RADIO_OFF || currentRadioState == CommandsInterface.RadioState.RADIO_UNAVAILABLE) {
            return State.NOT_READY;
        }
        if (currentRadioState == CommandsInterface.RadioState.RADIO_ON) {
            State csimState = this.getAppState(this.mIccCardStatus.getCdmaSubscriptionAppIndex());
            State usimState = this.getAppState(this.mIccCardStatus.getGsmUmtsSubscriptionAppIndex());
            if (this.mDbg) {
                this.log("USIM=" + (Object)((Object)usimState) + " CSIM=" + (Object)((Object)csimState));
            }
            if (this.mPhone.getLteOnCdmaMode() == 1) {
                return this.getConsolidatedState(csimState, usimState, csimState);
            }
            if (!this.is3gpp) {
                return csimState;
            }
            return usimState;
        }
        return State.ABSENT;
    }

    private State getAppState(int appIndex) {
        if (appIndex < 0 || appIndex >= 8) {
            Log.e(this.mLogTag, "[IccCard] Invalid Subscription Application index:" + appIndex);
            return State.ABSENT;
        }
        IccCardApplication app = this.mIccCardStatus.getApplication(appIndex);
        if (app == null) {
            Log.e(this.mLogTag, "[IccCard] Subscription Application in not present");
            return State.ABSENT;
        }
        if (app.pin1.isPermBlocked()) {
            return State.PERM_DISABLED;
        }
        if (app.app_state.isPinRequired()) {
            return State.PIN_REQUIRED;
        }
        if (app.app_state.isPukRequired()) {
            return State.PUK_REQUIRED;
        }
        if (app.app_state.isSubscriptionPersoEnabled()) {
            return State.NETWORK_LOCKED;
        }
        if (app.app_state.isAppReady()) {
            return State.READY;
        }
        if (app.app_state.isAppNotReady()) {
            return State.NOT_READY;
        }
        return State.NOT_READY;
    }

    private State getConsolidatedState(State left, State right, State preferredState) {
        if (right == State.ABSENT) {
            return left;
        }
        if (left == State.ABSENT) {
            return right;
        }
        if (left == State.READY && right == State.READY) {
            return State.READY;
        }
        if (right == State.NOT_READY && left == State.READY || left == State.NOT_READY && right == State.READY) {
            return State.NOT_READY;
        }
        if (right == State.NOT_READY) {
            return left;
        }
        if (left == State.NOT_READY) {
            return right;
        }
        return preferredState;
    }

    public boolean isApplicationOnIcc(IccCardApplication.AppType type) {
        if (this.mIccCardStatus == null) {
            return false;
        }
        for (int i = 0; i < this.mIccCardStatus.getNumApplications(); ++i) {
            IccCardApplication app = this.mIccCardStatus.getApplication(i);
            if (app == null || app.app_type != type) continue;
            return true;
        }
        return false;
    }

    public boolean hasIccCard() {
        if (this.mIccCardStatus == null) {
            return false;
        }
        return this.mIccCardStatus.getCardState().isCardPresent();
    }

    private void log(String msg) {
        Log.d(this.mLogTag, "[IccCard] " + msg);
    }

    protected int getCurrentApplicationIndex() {
        if (this.is3gpp) {
            return this.mIccCardStatus.getGsmUmtsSubscriptionAppIndex();
        }
        return this.mIccCardStatus.getCdmaSubscriptionAppIndex();
    }

    public String getAid() {
        String aid = "";
        if (this.mIccCardStatus == null) {
            return aid;
        }
        int appIndex = this.getCurrentApplicationIndex();
        if (appIndex >= 0 && appIndex < 8) {
            IccCardApplication app = this.mIccCardStatus.getApplication(appIndex);
            if (app != null) {
                aid = app.aid;
            } else {
                Log.e(this.mLogTag, "[IccCard] getAid: no current application index=" + appIndex);
            }
        } else {
            Log.e(this.mLogTag, "[IccCard] getAid: Invalid Subscription Application index=" + appIndex);
        }
        return aid;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        UNKNOWN,
        ABSENT,
        PIN_REQUIRED,
        PUK_REQUIRED,
        NETWORK_LOCKED,
        READY,
        NOT_READY,
        PERM_DISABLED;


        public boolean isPinLocked() {
            return this == PIN_REQUIRED || this == PUK_REQUIRED;
        }

        public boolean iccCardExist() {
            return this == PIN_REQUIRED || this == PUK_REQUIRED || this == NETWORK_LOCKED || this == READY || this == PERM_DISABLED;
        }
    }
}

