/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.os.AsyncResult;
import android.os.Message;
import android.os.SystemProperties;
import android.provider.Settings;
import android.telephony.ServiceState;
import android.telephony.SignalStrength;
import android.telephony.cdma.CdmaCellLocation;
import android.text.TextUtils;
import android.util.EventLog;
import android.util.Log;
import com.android.internal.telephony.IccCard;
import com.android.internal.telephony.MccTable;
import com.android.internal.telephony.cdma.CDMALTEPhone;
import com.android.internal.telephony.cdma.CdmaDataConnectionTracker;
import com.android.internal.telephony.cdma.CdmaLteUiccRecords;
import com.android.internal.telephony.cdma.CdmaServiceStateTracker;
import com.android.internal.telephony.gsm.GsmDataConnectionTracker;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public class CdmaLteServiceStateTracker
extends CdmaServiceStateTracker {
    CDMALTEPhone mCdmaLtePhone;
    private ServiceState mLteSS;

    public CdmaLteServiceStateTracker(CDMALTEPhone phone) {
        super(phone);
        this.mCdmaLtePhone = phone;
        this.mLteSS = new ServiceState();
        this.log("CdmaLteServiceStateTracker Constructors");
    }

    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 5: {
                this.log("handleMessage EVENT_POLL_STATE_GPRS");
                AsyncResult ar = (AsyncResult)msg.obj;
                this.handlePollStateResult(msg.what, ar);
                break;
            }
            case 27: {
                CdmaLteUiccRecords sim = (CdmaLteUiccRecords)this.phone.mIccRecords;
                if (sim != null && sim.isProvisioned()) {
                    this.mMdn = sim.getMdn();
                    this.mMin = sim.getMin();
                    this.parseSidNid(sim.getSid(), sim.getNid());
                    this.mPrlVersion = sim.getPrlVersion();
                    this.mIsMinInfoReady = true;
                    this.updateOtaspState();
                }
                this.pollState();
                break;
            }
            default: {
                super.handleMessage(msg);
            }
        }
    }

    protected void setCdmaTechnology(int radioTechnology) {
        this.newSS.setRadioTechnology(radioTechnology);
    }

    protected void handlePollStateResultMessage(int what, AsyncResult ar) {
        if (what == 5) {
            this.log("handlePollStateResultMessage: EVENT_POLL_STATE_GPRS");
            String[] states = (String[])ar.result;
            int type = 0;
            int regState = -1;
            if (states.length > 0) {
                try {
                    regState = Integer.parseInt(states[0]);
                    if (states.length >= 4 && states[3] != null) {
                        type = Integer.parseInt(states[3]);
                    }
                }
                catch (NumberFormatException ex) {
                    this.loge("handlePollStateResultMessage: error parsing GprsRegistrationState: " + ex);
                }
            }
            this.mLteSS.setRadioTechnology(type);
            this.mLteSS.setState(this.regCodeToServiceState(regState));
        } else {
            super.handlePollStateResultMessage(what, ar);
        }
    }

    protected void setSignalStrengthDefaultValues() {
        this.mSignalStrength = new SignalStrength(99, -1, -1, -1, -1, -1, -1, -1, -1, -1, Integer.MAX_VALUE, -1, false);
    }

    protected void pollState() {
        this.pollingContext = new int[1];
        this.pollingContext[0] = 0;
        switch (this.cm.getRadioState()) {
            case RADIO_UNAVAILABLE: {
                this.newSS.setStateOutOfService();
                this.newCellLoc.setStateInvalid();
                this.setSignalStrengthDefaultValues();
                this.mGotCountryCode = false;
                this.pollStateDone();
                break;
            }
            case RADIO_OFF: {
                this.newSS.setStateOff();
                this.newCellLoc.setStateInvalid();
                this.setSignalStrengthDefaultValues();
                this.mGotCountryCode = false;
                this.pollStateDone();
                break;
            }
            default: {
                this.pollingContext[0] = this.pollingContext[0] + 1;
                this.cm.getOperator(this.obtainMessage(25, this.pollingContext));
                this.pollingContext[0] = this.pollingContext[0] + 1;
                this.cm.getVoiceRegistrationState(this.obtainMessage(24, this.pollingContext));
                int networkMode = Settings.Secure.getInt(this.phone.getContext().getContentResolver(), "preferred_network_mode", 0);
                this.log("pollState: network mode here is = " + networkMode);
                if (networkMode != 7 && networkMode != 11) break;
                this.pollingContext[0] = this.pollingContext[0] + 1;
                this.cm.getDataRegistrationState(this.obtainMessage(5, this.pollingContext));
            }
        }
    }

    protected void pollStateDone() {
        int networkMode;
        if (this.mLteSS.getState() == 0) {
            this.mNewRilRadioTechnology = this.mLteSS.getRilRadioTechnology();
            this.mNewDataConnectionState = this.mLteSS.getState();
            this.newSS.setRadioTechnology(this.mNewRilRadioTechnology);
            this.log("pollStateDone LTE/eHRPD STATE_IN_SERVICE mNewRilRadioTechnology = " + this.mNewRilRadioTechnology);
        } else {
            this.mNewRilRadioTechnology = this.newSS.getRilRadioTechnology();
            this.mNewDataConnectionState = this.radioTechnologyToDataServiceState(this.mNewRilRadioTechnology);
            this.log("pollStateDone CDMA STATE_IN_SERVICE mNewRilRadioTechnology = " + this.mNewRilRadioTechnology + " mNewDataConnectionState = " + this.mNewDataConnectionState);
        }
        if (this.newSS.getState() == 1 && (networkMode = Settings.Secure.getInt(this.phone.getContext().getContentResolver(), "preferred_network_mode", 0)) == 11) {
            this.log("pollState: LTE Only mode");
            this.newSS.setState(this.mLteSS.getState());
        }
        this.log("pollStateDone: oldSS=[" + this.ss + "] newSS=[" + this.newSS + "]");
        boolean hasRegistered = this.ss.getState() != 0 && this.newSS.getState() == 0;
        boolean hasDeregistered = this.ss.getState() == 0 && this.newSS.getState() != 0;
        boolean hasCdmaDataConnectionAttached = this.mDataConnectionState != 0 && this.mNewDataConnectionState == 0;
        boolean hasCdmaDataConnectionDetached = this.mDataConnectionState == 0 && this.mNewDataConnectionState != 0;
        boolean hasCdmaDataConnectionChanged = this.mDataConnectionState != this.mNewDataConnectionState;
        boolean hasRadioTechnologyChanged = this.mRilRadioTechnology != this.mNewRilRadioTechnology;
        boolean hasChanged = !this.newSS.equals(this.ss);
        boolean hasRoamingOn = !this.ss.getRoaming() && this.newSS.getRoaming();
        boolean hasRoamingOff = this.ss.getRoaming() && !this.newSS.getRoaming();
        boolean hasLocationChanged = !this.newCellLoc.equals(this.cellLoc);
        boolean has4gHandoff = this.mNewDataConnectionState == 0 && (this.mRilRadioTechnology == 14 && this.mNewRilRadioTechnology == 13 || this.mRilRadioTechnology == 13 && this.mNewRilRadioTechnology == 14);
        boolean hasMultiApnSupport = (this.mNewRilRadioTechnology == 14 || this.mNewRilRadioTechnology == 13) && this.mRilRadioTechnology != 14 && this.mRilRadioTechnology != 13;
        boolean hasLostMultiApnSupport = this.mNewRilRadioTechnology >= 4 && this.mNewRilRadioTechnology <= 8;
        this.log("pollStateDone: hasRegistered=" + hasRegistered + " hasDeegistered=" + hasDeregistered + " hasCdmaDataConnectionAttached=" + hasCdmaDataConnectionAttached + " hasCdmaDataConnectionDetached=" + hasCdmaDataConnectionDetached + " hasCdmaDataConnectionChanged=" + hasCdmaDataConnectionChanged + " hasRadioTechnologyChanged = " + hasRadioTechnologyChanged + " hasChanged=" + hasChanged + " hasRoamingOn=" + hasRoamingOn + " hasRoamingOff=" + hasRoamingOff + " hasLocationChanged=" + hasLocationChanged + " has4gHandoff = " + has4gHandoff + " hasMultiApnSupport=" + hasMultiApnSupport + " hasLostMultiApnSupport=" + hasLostMultiApnSupport);
        if (this.ss.getState() != this.newSS.getState() || this.mDataConnectionState != this.mNewDataConnectionState) {
            EventLog.writeEvent(50116, this.ss.getState(), this.mDataConnectionState, this.newSS.getState(), this.mNewDataConnectionState);
        }
        ServiceState tss = this.ss;
        this.ss = this.newSS;
        this.newSS = tss;
        this.newSS.setStateOutOfService();
        this.mLteSS.setStateOutOfService();
        if (hasMultiApnSupport && this.phone.mDataConnectionTracker instanceof CdmaDataConnectionTracker) {
            this.log("GsmDataConnectionTracker Created");
            this.phone.mDataConnectionTracker.dispose();
            this.phone.mDataConnectionTracker = new GsmDataConnectionTracker(this.mCdmaLtePhone);
        }
        if (hasLostMultiApnSupport && this.phone.mDataConnectionTracker instanceof GsmDataConnectionTracker) {
            this.log("GsmDataConnectionTracker disposed");
            this.phone.mDataConnectionTracker.dispose();
            this.phone.mDataConnectionTracker = new CdmaDataConnectionTracker(this.phone);
        }
        CdmaCellLocation tcl = this.cellLoc;
        this.cellLoc = this.newCellLoc;
        this.newCellLoc = tcl;
        this.mDataConnectionState = this.mNewDataConnectionState;
        this.mRilRadioTechnology = this.mNewRilRadioTechnology;
        this.mNewRilRadioTechnology = 0;
        this.newSS.setStateOutOfService();
        if (hasRadioTechnologyChanged) {
            this.phone.setSystemProperty("gsm.network.type", ServiceState.rilRadioTechnologyToString(this.mRilRadioTechnology));
        }
        if (hasRegistered) {
            this.mNetworkAttachedRegistrants.notifyRegistrants();
        }
        if (hasChanged) {
            if (this.phone.isEriFileLoaded()) {
                String eriText;
                if (this.ss.getState() == 0) {
                    eriText = this.phone.getCdmaEriText();
                } else if (this.ss.getState() == 3) {
                    eriText = this.phone.mIccRecords.getServiceProviderName();
                    if (TextUtils.isEmpty(eriText)) {
                        eriText = SystemProperties.get("ro.cdma.home.operator.alpha");
                    }
                } else {
                    eriText = ((Object)this.phone.getContext().getText(17039625)).toString();
                }
                this.ss.setOperatorAlphaLong(eriText);
            }
            if (this.phone.getIccCard().getState() == IccCard.State.READY) {
                boolean showSpn = ((CdmaLteUiccRecords)this.phone.mIccRecords).getCsimSpnDisplayCondition();
                int iconIndex = this.ss.getCdmaEriIconIndex();
                if (showSpn && iconIndex == 1 && this.isInHomeSidNid(this.ss.getSystemId(), this.ss.getNetworkId())) {
                    this.ss.setOperatorAlphaLong(this.phone.mIccRecords.getServiceProviderName());
                }
            }
            this.phone.setSystemProperty("gsm.operator.alpha", this.ss.getOperatorAlphaLong());
            String prevOperatorNumeric = SystemProperties.get("gsm.operator.numeric", "");
            String operatorNumeric = this.ss.getOperatorNumeric();
            this.phone.setSystemProperty("gsm.operator.numeric", operatorNumeric);
            if (operatorNumeric == null) {
                this.log("operatorNumeric is null");
                this.phone.setSystemProperty("gsm.operator.iso-country", "");
                this.mGotCountryCode = false;
            } else {
                String isoCountryCode = "";
                String mcc = operatorNumeric.substring(0, 3);
                try {
                    isoCountryCode = MccTable.countryCodeForMcc(Integer.parseInt(operatorNumeric.substring(0, 3)));
                }
                catch (NumberFormatException ex) {
                    this.loge("countryCodeForMcc error" + ex);
                }
                catch (StringIndexOutOfBoundsException ex) {
                    this.loge("countryCodeForMcc error" + ex);
                }
                this.phone.setSystemProperty("gsm.operator.iso-country", isoCountryCode);
                this.mGotCountryCode = true;
                if (this.shouldFixTimeZoneNow(this.phone, operatorNumeric, prevOperatorNumeric, this.mNeedFixZone)) {
                    this.fixTimeZone(isoCountryCode);
                }
            }
            this.phone.setSystemProperty("gsm.operator.isroaming", this.ss.getRoaming() ? "true" : "false");
            this.updateSpnDisplay();
            this.phone.notifyServiceStateChanged(this.ss);
        }
        if (hasCdmaDataConnectionAttached || has4gHandoff) {
            this.mAttachedRegistrants.notifyRegistrants();
        }
        if (hasCdmaDataConnectionDetached) {
            this.mDetachedRegistrants.notifyRegistrants();
        }
        if (hasCdmaDataConnectionChanged || hasRadioTechnologyChanged) {
            this.phone.notifyDataConnection(null);
        }
        if (hasRoamingOn) {
            this.mRoamingOnRegistrants.notifyRegistrants();
        }
        if (hasRoamingOff) {
            this.mRoamingOffRegistrants.notifyRegistrants();
        }
        if (hasLocationChanged) {
            this.phone.notifyLocationChanged();
        }
    }

    protected void onSignalStrengthResult(AsyncResult ar) {
        SignalStrength oldSignalStrength = this.mSignalStrength;
        if (ar.exception != null) {
            this.setSignalStrengthDefaultValues();
        } else {
            int evdoSnr;
            int[] ints = (int[])ar.result;
            int lteRssi = -1;
            int lteRsrp = -1;
            int lteRsrq = -1;
            int lteRssnr = Integer.MAX_VALUE;
            int lteCqi = -1;
            int offset = 2;
            int cdmaDbm = ints[offset] > 0 ? -ints[offset] : -120;
            int cdmaEcio = ints[offset + 1] > 0 ? -ints[offset + 1] : -160;
            int evdoRssi = ints[offset + 2] > 0 ? -ints[offset + 2] : -120;
            int evdoEcio = ints[offset + 3] > 0 ? -ints[offset + 3] : -1;
            int n = evdoSnr = ints[offset + 4] > 0 && ints[offset + 4] <= 8 ? ints[offset + 4] : -1;
            if (this.mRilRadioTechnology == 14) {
                lteRssi = ints[offset + 5];
                lteRsrp = ints[offset + 6];
                lteRsrq = ints[offset + 7];
                lteRssnr = ints[offset + 8];
                lteCqi = ints[offset + 9];
            }
            this.mSignalStrength = this.mRilRadioTechnology != 14 ? new SignalStrength(99, -1, cdmaDbm, cdmaEcio, evdoRssi, evdoEcio, evdoSnr, false) : new SignalStrength(99, -1, cdmaDbm, cdmaEcio, evdoRssi, evdoEcio, evdoSnr, lteRssi, lteRsrp, lteRsrq, lteRssnr, lteCqi, true);
        }
        try {
            this.phone.notifySignalStrength();
        }
        catch (NullPointerException ex) {
            this.loge("onSignalStrengthResult() Phone already destroyed: " + ex + "SignalStrength not notified");
        }
    }

    public boolean isConcurrentVoiceAndDataAllowed() {
        return this.mRilRadioTechnology == 14;
    }

    private boolean isInHomeSidNid(int sid, int nid) {
        if (this.isSidsAllZeros()) {
            return true;
        }
        if (this.mHomeSystemId.length != this.mHomeNetworkId.length) {
            return true;
        }
        if (sid == 0) {
            return true;
        }
        for (int i = 0; i < this.mHomeSystemId.length; ++i) {
            if (this.mHomeSystemId[i] != sid || this.mHomeNetworkId[i] != 0 && this.mHomeNetworkId[i] != 65535 && nid != 0 && nid != 65535 && this.mHomeNetworkId[i] != nid) continue;
            return true;
        }
        return false;
    }

    protected void log(String s) {
        Log.d("CDMA", "[CdmaLteSST] " + s);
    }

    protected void loge(String s) {
        Log.e("CDMA", "[CdmaLteSST] " + s);
    }

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("CdmaLteServiceStateTracker extends:");
        super.dump(fd, pw, args);
        pw.println(" mCdmaLtePhone=" + this.mCdmaLtePhone);
        pw.println(" mLteSS=" + this.mLteSS);
    }
}

