/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.telephony.SmsCbCmasInfo;
import android.telephony.SmsCbEtwsInfo;
import java.util.Arrays;

class SmsCbHeader {
    static final int PDU_HEADER_LENGTH = 6;
    static final int FORMAT_GSM = 1;
    static final int FORMAT_UMTS = 2;
    static final int FORMAT_ETWS_PRIMARY = 3;
    private static final int MESSAGE_TYPE_CBS_MESSAGE = 1;
    private static final int PDU_LENGTH_GSM = 88;
    private static final int PDU_LENGTH_ETWS = 56;
    private final int geographicalScope;
    private final int serialNumber;
    private final int messageIdentifier;
    private final int dataCodingScheme;
    private final int pageIndex;
    private final int nrOfPages;
    private final int format;
    private final SmsCbEtwsInfo mEtwsInfo;
    private final SmsCbCmasInfo mCmasInfo;

    public SmsCbHeader(byte[] pdu) throws IllegalArgumentException {
        if (pdu == null || pdu.length < 6) {
            throw new IllegalArgumentException("Illegal PDU");
        }
        if (pdu.length <= 56) {
            this.format = 3;
            this.geographicalScope = (pdu[0] & 0xC0) >> 6;
            this.serialNumber = (pdu[0] & 0xFF) << 8 | pdu[1] & 0xFF;
            this.messageIdentifier = (pdu[2] & 0xFF) << 8 | pdu[3] & 0xFF;
            this.dataCodingScheme = -1;
            this.pageIndex = -1;
            this.nrOfPages = -1;
            boolean emergencyUserAlert = (pdu[4] & 1) != 0;
            boolean activatePopup = (pdu[5] & 0x80) != 0;
            int warningType = (pdu[4] & 0xFE) >> 1;
            byte[] warningSecurityInfo = pdu.length > 6 ? Arrays.copyOfRange(pdu, 6, pdu.length) : null;
            this.mEtwsInfo = new SmsCbEtwsInfo(warningType, emergencyUserAlert, activatePopup, warningSecurityInfo);
            this.mCmasInfo = null;
            return;
        }
        if (pdu.length <= 88) {
            this.format = 1;
            this.geographicalScope = (pdu[0] & 0xC0) >> 6;
            this.serialNumber = (pdu[0] & 0xFF) << 8 | pdu[1] & 0xFF;
            this.messageIdentifier = (pdu[2] & 0xFF) << 8 | pdu[3] & 0xFF;
            this.dataCodingScheme = pdu[4] & 0xFF;
            int pageIndex = (pdu[5] & 0xF0) >> 4;
            int nrOfPages = pdu[5] & 0xF;
            if (pageIndex == 0 || nrOfPages == 0 || pageIndex > nrOfPages) {
                pageIndex = 1;
                nrOfPages = 1;
            }
            this.pageIndex = pageIndex;
            this.nrOfPages = nrOfPages;
        } else {
            this.format = 2;
            byte messageType = pdu[0];
            if (messageType != 1) {
                throw new IllegalArgumentException("Unsupported message type " + messageType);
            }
            this.messageIdentifier = (pdu[1] & 0xFF) << 8 | pdu[2] & 0xFF;
            this.geographicalScope = (pdu[3] & 0xC0) >> 6;
            this.serialNumber = (pdu[3] & 0xFF) << 8 | pdu[4] & 0xFF;
            this.dataCodingScheme = pdu[5] & 0xFF;
            this.pageIndex = 1;
            this.nrOfPages = 1;
        }
        if (this.isEtwsMessage()) {
            boolean emergencyUserAlert = this.isEtwsEmergencyUserAlert();
            boolean activatePopup = this.isEtwsPopupAlert();
            int warningType = this.getEtwsWarningType();
            this.mEtwsInfo = new SmsCbEtwsInfo(warningType, emergencyUserAlert, activatePopup, null);
            this.mCmasInfo = null;
        } else if (this.isCmasMessage()) {
            int messageClass = this.getCmasMessageClass();
            int severity = this.getCmasSeverity();
            int urgency = this.getCmasUrgency();
            int certainty = this.getCmasCertainty();
            this.mEtwsInfo = null;
            this.mCmasInfo = new SmsCbCmasInfo(messageClass, -1, -1, severity, urgency, certainty);
        } else {
            this.mEtwsInfo = null;
            this.mCmasInfo = null;
        }
    }

    int getGeographicalScope() {
        return this.geographicalScope;
    }

    int getSerialNumber() {
        return this.serialNumber;
    }

    int getServiceCategory() {
        return this.messageIdentifier;
    }

    int getDataCodingScheme() {
        return this.dataCodingScheme;
    }

    int getPageIndex() {
        return this.pageIndex;
    }

    int getNumberOfPages() {
        return this.nrOfPages;
    }

    SmsCbEtwsInfo getEtwsInfo() {
        return this.mEtwsInfo;
    }

    SmsCbCmasInfo getCmasInfo() {
        return this.mCmasInfo;
    }

    boolean isEmergencyMessage() {
        return this.messageIdentifier >= 4352 && this.messageIdentifier <= 6399;
    }

    private boolean isEtwsMessage() {
        return (this.messageIdentifier & 0xFFF8) == 4352;
    }

    boolean isEtwsPrimaryNotification() {
        return this.format == 3;
    }

    boolean isUmtsFormat() {
        return this.format == 2;
    }

    private boolean isCmasMessage() {
        return this.messageIdentifier >= 4370 && this.messageIdentifier <= 4399;
    }

    private boolean isEtwsPopupAlert() {
        return (this.serialNumber & 0x1000) != 0;
    }

    private boolean isEtwsEmergencyUserAlert() {
        return (this.serialNumber & 0x2000) != 0;
    }

    private int getEtwsWarningType() {
        return this.messageIdentifier - 4352;
    }

    private int getCmasMessageClass() {
        switch (this.messageIdentifier) {
            case 4370: {
                return 0;
            }
            case 4371: 
            case 4372: 
            case 4373: 
            case 4374: {
                return 1;
            }
            case 4375: 
            case 4376: 
            case 4377: 
            case 4378: {
                return 2;
            }
            case 4379: {
                return 3;
            }
            case 4380: {
                return 4;
            }
            case 4381: {
                return 5;
            }
            case 4382: {
                return 6;
            }
        }
        return -1;
    }

    private int getCmasSeverity() {
        switch (this.messageIdentifier) {
            case 4371: 
            case 4372: 
            case 4373: 
            case 4374: {
                return 0;
            }
            case 4375: 
            case 4376: 
            case 4377: 
            case 4378: {
                return 1;
            }
        }
        return -1;
    }

    private int getCmasUrgency() {
        switch (this.messageIdentifier) {
            case 4371: 
            case 4372: 
            case 4375: 
            case 4376: {
                return 0;
            }
            case 4373: 
            case 4374: 
            case 4377: 
            case 4378: {
                return 1;
            }
        }
        return -1;
    }

    private int getCmasCertainty() {
        switch (this.messageIdentifier) {
            case 4371: 
            case 4373: 
            case 4375: 
            case 4377: {
                return 0;
            }
            case 4372: 
            case 4374: 
            case 4376: 
            case 4378: {
                return 1;
            }
        }
        return -1;
    }

    public String toString() {
        return "SmsCbHeader{GS=" + this.geographicalScope + ", serialNumber=0x" + Integer.toHexString(this.serialNumber) + ", messageIdentifier=0x" + Integer.toHexString(this.messageIdentifier) + ", DCS=0x" + Integer.toHexString(this.dataCodingScheme) + ", page " + this.pageIndex + " of " + this.nrOfPages + '}';
    }
}

