/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.util.IState;
import com.android.internal.util.State;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Vector;

public class StateMachine {
    private static final String TAG = "StateMachine";
    private String mName;
    public static final int SM_QUIT_CMD = -1;
    public static final int SM_INIT_CMD = -2;
    public static final boolean HANDLED = true;
    public static final boolean NOT_HANDLED = false;
    private SmHandler mSmHandler;
    private HandlerThread mSmThread;

    private void initStateMachine(String name, Looper looper) {
        this.mName = name;
        this.mSmHandler = new SmHandler(looper, this);
    }

    protected StateMachine(String name) {
        this.mSmThread = new HandlerThread(name);
        this.mSmThread.start();
        Looper looper = this.mSmThread.getLooper();
        this.initStateMachine(name, looper);
    }

    protected StateMachine(String name, Looper looper) {
        this.initStateMachine(name, looper);
    }

    protected void addState(State state, State parent) {
        this.mSmHandler.addState(state, parent);
    }

    protected Message getCurrentMessage() {
        return this.mSmHandler.getCurrentMessage();
    }

    protected IState getCurrentState() {
        return this.mSmHandler.getCurrentState();
    }

    protected void addState(State state) {
        this.mSmHandler.addState(state, null);
    }

    protected void setInitialState(State initialState) {
        this.mSmHandler.setInitialState(initialState);
    }

    protected void transitionTo(IState destState) {
        this.mSmHandler.transitionTo(destState);
    }

    protected void transitionToHaltingState() {
        this.mSmHandler.transitionTo(this.mSmHandler.mHaltingState);
    }

    protected void deferMessage(Message msg) {
        this.mSmHandler.deferMessage(msg);
    }

    protected void unhandledMessage(Message msg) {
        if (this.mSmHandler.mDbg) {
            Log.e(TAG, this.mName + " - unhandledMessage: msg.what=" + msg.what);
        }
    }

    protected void haltedProcessMessage(Message msg) {
    }

    protected void halting() {
    }

    protected void quitting() {
    }

    public String getName() {
        return this.mName;
    }

    public void setProcessedMessagesSize(int maxSize) {
        this.mSmHandler.setProcessedMessagesSize(maxSize);
    }

    public int getProcessedMessagesSize() {
        return this.mSmHandler.getProcessedMessagesSize();
    }

    public int getProcessedMessagesCount() {
        return this.mSmHandler.getProcessedMessagesCount();
    }

    public ProcessedMessageInfo getProcessedMessageInfo(int index) {
        return this.mSmHandler.getProcessedMessageInfo(index);
    }

    public Handler getHandler() {
        return this.mSmHandler;
    }

    public Message obtainMessage() {
        if (this.mSmHandler == null) {
            return null;
        }
        return Message.obtain(this.mSmHandler);
    }

    public Message obtainMessage(int what) {
        if (this.mSmHandler == null) {
            return null;
        }
        return Message.obtain((Handler)this.mSmHandler, what);
    }

    public Message obtainMessage(int what, Object obj) {
        if (this.mSmHandler == null) {
            return null;
        }
        return Message.obtain(this.mSmHandler, what, obj);
    }

    public Message obtainMessage(int what, int arg1, int arg2) {
        if (this.mSmHandler == null) {
            return null;
        }
        return Message.obtain(this.mSmHandler, what, arg1, arg2);
    }

    public Message obtainMessage(int what, int arg1, int arg2, Object obj) {
        if (this.mSmHandler == null) {
            return null;
        }
        return Message.obtain(this.mSmHandler, what, arg1, arg2, obj);
    }

    public void sendMessage(int what) {
        if (this.mSmHandler == null) {
            return;
        }
        this.mSmHandler.sendMessage(this.obtainMessage(what));
    }

    public void sendMessage(int what, Object obj) {
        if (this.mSmHandler == null) {
            return;
        }
        this.mSmHandler.sendMessage(this.obtainMessage(what, obj));
    }

    public void sendMessage(Message msg) {
        if (this.mSmHandler == null) {
            return;
        }
        this.mSmHandler.sendMessage(msg);
    }

    public void sendMessageDelayed(int what, long delayMillis) {
        if (this.mSmHandler == null) {
            return;
        }
        this.mSmHandler.sendMessageDelayed(this.obtainMessage(what), delayMillis);
    }

    public void sendMessageDelayed(int what, Object obj, long delayMillis) {
        if (this.mSmHandler == null) {
            return;
        }
        this.mSmHandler.sendMessageDelayed(this.obtainMessage(what, obj), delayMillis);
    }

    public void sendMessageDelayed(Message msg, long delayMillis) {
        if (this.mSmHandler == null) {
            return;
        }
        this.mSmHandler.sendMessageDelayed(msg, delayMillis);
    }

    protected void sendMessageAtFrontOfQueue(int what, Object obj) {
        this.mSmHandler.sendMessageAtFrontOfQueue(this.obtainMessage(what, obj));
    }

    protected void sendMessageAtFrontOfQueue(int what) {
        this.mSmHandler.sendMessageAtFrontOfQueue(this.obtainMessage(what));
    }

    protected void sendMessageAtFrontOfQueue(Message msg) {
        this.mSmHandler.sendMessageAtFrontOfQueue(msg);
    }

    protected void removeMessages(int what) {
        this.mSmHandler.removeMessages(what);
    }

    public void quit() {
        if (this.mSmHandler == null) {
            return;
        }
        this.mSmHandler.quit();
    }

    protected boolean isQuit(Message msg) {
        return this.mSmHandler.isQuit(msg);
    }

    protected boolean recordProcessedMessage(Message msg) {
        return true;
    }

    protected String getMessageInfo(Message msg) {
        return "";
    }

    public boolean isDbg() {
        if (this.mSmHandler == null) {
            return false;
        }
        return this.mSmHandler.isDbg();
    }

    public void setDbg(boolean dbg) {
        if (this.mSmHandler == null) {
            return;
        }
        this.mSmHandler.setDbg(dbg);
    }

    public void start() {
        if (this.mSmHandler == null) {
            return;
        }
        this.mSmHandler.completeConstruction();
    }

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println(this.getName() + ":");
        pw.println(" total messages=" + this.getProcessedMessagesCount());
        for (int i = 0; i < this.getProcessedMessagesSize(); ++i) {
            pw.printf(" msg[%d]: %s\n", i, this.getProcessedMessageInfo(i));
            pw.flush();
        }
        pw.println("curState=" + this.getCurrentState().getName());
    }

    private static class SmHandler
    extends Handler {
        private boolean mDbg = false;
        private static final Object mSmHandlerObj = new Object();
        private Message mMsg;
        private ProcessedMessages mProcessedMessages = new ProcessedMessages();
        private boolean mIsConstructionCompleted;
        private StateInfo[] mStateStack;
        private int mStateStackTopIndex = -1;
        private StateInfo[] mTempStateStack;
        private int mTempStateStackCount;
        private HaltingState mHaltingState = new HaltingState();
        private QuittingState mQuittingState = new QuittingState();
        private StateMachine mSm;
        private HashMap<State, StateInfo> mStateInfo = new HashMap();
        private State mInitialState;
        private State mDestState;
        private ArrayList<Message> mDeferredMessages = new ArrayList();

        public void handleMessage(Message msg) {
            if (this.mDbg) {
                Log.d(StateMachine.TAG, "handleMessage: E msg.what=" + msg.what);
            }
            this.mMsg = msg;
            if (this.mIsConstructionCompleted) {
                this.processMsg(msg);
            } else if (!this.mIsConstructionCompleted && this.mMsg.what == -2 && this.mMsg.obj == mSmHandlerObj) {
                this.mIsConstructionCompleted = true;
                this.invokeEnterMethods(0);
            } else {
                throw new RuntimeException("StateMachine.handleMessage: The start method not called, received msg: " + msg);
            }
            this.performTransitions();
            if (this.mDbg) {
                Log.d(StateMachine.TAG, "handleMessage: X");
            }
        }

        private void performTransitions() {
            State destState = null;
            while (this.mDestState != null) {
                if (this.mDbg) {
                    Log.d(StateMachine.TAG, "handleMessage: new destination call exit");
                }
                destState = this.mDestState;
                this.mDestState = null;
                StateInfo commonStateInfo = this.setupTempStateStackWithStatesToEnter(destState);
                this.invokeExitMethods(commonStateInfo);
                int stateStackEnteringIndex = this.moveTempStateStackToStateStack();
                this.invokeEnterMethods(stateStackEnteringIndex);
                this.moveDeferredMessageAtFrontOfQueue();
            }
            if (destState != null) {
                if (destState == this.mQuittingState) {
                    this.cleanupAfterQuitting();
                } else if (destState == this.mHaltingState) {
                    this.mSm.halting();
                }
            }
        }

        private void cleanupAfterQuitting() {
            this.mSm.quitting();
            if (this.mSm.mSmThread != null) {
                this.getLooper().quit();
                this.mSm.mSmThread = null;
            }
            this.mSm.mSmHandler = null;
            this.mSm = null;
            this.mMsg = null;
            this.mProcessedMessages.cleanup();
            this.mStateStack = null;
            this.mTempStateStack = null;
            this.mStateInfo.clear();
            this.mInitialState = null;
            this.mDestState = null;
            this.mDeferredMessages.clear();
        }

        private void completeConstruction() {
            if (this.mDbg) {
                Log.d(StateMachine.TAG, "completeConstruction: E");
            }
            int maxDepth = 0;
            for (StateInfo si : this.mStateInfo.values()) {
                int depth = 0;
                StateInfo i = si;
                while (i != null) {
                    i = i.parentStateInfo;
                    ++depth;
                }
                if (maxDepth >= depth) continue;
                maxDepth = depth;
            }
            if (this.mDbg) {
                Log.d(StateMachine.TAG, "completeConstruction: maxDepth=" + maxDepth);
            }
            this.mStateStack = new StateInfo[maxDepth];
            this.mTempStateStack = new StateInfo[maxDepth];
            this.setupInitialStateStack();
            this.sendMessageAtFrontOfQueue(this.obtainMessage(-2, mSmHandlerObj));
            if (this.mDbg) {
                Log.d(StateMachine.TAG, "completeConstruction: X");
            }
        }

        private void processMsg(Message msg) {
            StateInfo curStateInfo = this.mStateStack[this.mStateStackTopIndex];
            if (this.mDbg) {
                Log.d(StateMachine.TAG, "processMsg: " + curStateInfo.state.getName());
            }
            while (!curStateInfo.state.processMessage(msg)) {
                curStateInfo = curStateInfo.parentStateInfo;
                if (curStateInfo == null) {
                    this.mSm.unhandledMessage(msg);
                    if (!this.isQuit(msg)) break;
                    this.transitionTo(this.mQuittingState);
                    break;
                }
                if (!this.mDbg) continue;
                Log.d(StateMachine.TAG, "processMsg: " + curStateInfo.state.getName());
            }
            if (this.mSm.recordProcessedMessage(msg)) {
                if (curStateInfo != null) {
                    State orgState = this.mStateStack[this.mStateStackTopIndex].state;
                    this.mProcessedMessages.add(msg, this.mSm.getMessageInfo(msg), curStateInfo.state, orgState);
                } else {
                    this.mProcessedMessages.add(msg, this.mSm.getMessageInfo(msg), null, null);
                }
            }
        }

        private void invokeExitMethods(StateInfo commonStateInfo) {
            while (this.mStateStackTopIndex >= 0 && this.mStateStack[this.mStateStackTopIndex] != commonStateInfo) {
                State curState = this.mStateStack[this.mStateStackTopIndex].state;
                if (this.mDbg) {
                    Log.d(StateMachine.TAG, "invokeExitMethods: " + curState.getName());
                }
                curState.exit();
                this.mStateStack[this.mStateStackTopIndex].active = false;
                --this.mStateStackTopIndex;
            }
        }

        private void invokeEnterMethods(int stateStackEnteringIndex) {
            for (int i = stateStackEnteringIndex; i <= this.mStateStackTopIndex; ++i) {
                if (this.mDbg) {
                    Log.d(StateMachine.TAG, "invokeEnterMethods: " + this.mStateStack[i].state.getName());
                }
                this.mStateStack[i].state.enter();
                this.mStateStack[i].active = true;
            }
        }

        private void moveDeferredMessageAtFrontOfQueue() {
            for (int i = this.mDeferredMessages.size() - 1; i >= 0; --i) {
                Message curMsg = this.mDeferredMessages.get(i);
                if (this.mDbg) {
                    Log.d(StateMachine.TAG, "moveDeferredMessageAtFrontOfQueue; what=" + curMsg.what);
                }
                this.sendMessageAtFrontOfQueue(curMsg);
            }
            this.mDeferredMessages.clear();
        }

        private int moveTempStateStackToStateStack() {
            int startingIndex = this.mStateStackTopIndex + 1;
            int j = startingIndex;
            for (int i = this.mTempStateStackCount - 1; i >= 0; --i) {
                if (this.mDbg) {
                    Log.d(StateMachine.TAG, "moveTempStackToStateStack: i=" + i + ",j=" + j);
                }
                this.mStateStack[j] = this.mTempStateStack[i];
                ++j;
            }
            this.mStateStackTopIndex = j - 1;
            if (this.mDbg) {
                Log.d(StateMachine.TAG, "moveTempStackToStateStack: X mStateStackTop=" + this.mStateStackTopIndex + ",startingIndex=" + startingIndex + ",Top=" + this.mStateStack[this.mStateStackTopIndex].state.getName());
            }
            return startingIndex;
        }

        private StateInfo setupTempStateStackWithStatesToEnter(State destState) {
            this.mTempStateStackCount = 0;
            StateInfo curStateInfo = this.mStateInfo.get(destState);
            do {
                this.mTempStateStack[this.mTempStateStackCount++] = curStateInfo;
            } while ((curStateInfo = curStateInfo.parentStateInfo) != null && !curStateInfo.active);
            if (this.mDbg) {
                Log.d(StateMachine.TAG, "setupTempStateStackWithStatesToEnter: X mTempStateStackCount=" + this.mTempStateStackCount + ",curStateInfo: " + curStateInfo);
            }
            return curStateInfo;
        }

        private void setupInitialStateStack() {
            if (this.mDbg) {
                Log.d(StateMachine.TAG, "setupInitialStateStack: E mInitialState=" + this.mInitialState.getName());
            }
            StateInfo curStateInfo = this.mStateInfo.get(this.mInitialState);
            this.mTempStateStackCount = 0;
            while (curStateInfo != null) {
                this.mTempStateStack[this.mTempStateStackCount] = curStateInfo;
                curStateInfo = curStateInfo.parentStateInfo;
                ++this.mTempStateStackCount;
            }
            this.mStateStackTopIndex = -1;
            this.moveTempStateStackToStateStack();
        }

        private Message getCurrentMessage() {
            return this.mMsg;
        }

        private IState getCurrentState() {
            return this.mStateStack[this.mStateStackTopIndex].state;
        }

        private StateInfo addState(State state, State parent) {
            StateInfo stateInfo;
            if (this.mDbg) {
                Log.d(StateMachine.TAG, "addStateInternal: E state=" + state.getName() + ",parent=" + (parent == null ? "" : parent.getName()));
            }
            StateInfo parentStateInfo = null;
            if (parent != null && (parentStateInfo = this.mStateInfo.get(parent)) == null) {
                parentStateInfo = this.addState(parent, null);
            }
            if ((stateInfo = this.mStateInfo.get(state)) == null) {
                stateInfo = new StateInfo();
                this.mStateInfo.put(state, stateInfo);
            }
            if (stateInfo.parentStateInfo != null && stateInfo.parentStateInfo != parentStateInfo) {
                throw new RuntimeException("state already added");
            }
            stateInfo.state = state;
            stateInfo.parentStateInfo = parentStateInfo;
            stateInfo.active = false;
            if (this.mDbg) {
                Log.d(StateMachine.TAG, "addStateInternal: X stateInfo: " + stateInfo);
            }
            return stateInfo;
        }

        private SmHandler(Looper looper, StateMachine sm) {
            super(looper);
            this.mSm = sm;
            this.addState(this.mHaltingState, null);
            this.addState(this.mQuittingState, null);
        }

        private void setInitialState(State initialState) {
            if (this.mDbg) {
                Log.d(StateMachine.TAG, "setInitialState: initialState=" + initialState.getName());
            }
            this.mInitialState = initialState;
        }

        private void transitionTo(IState destState) {
            this.mDestState = (State)destState;
            if (this.mDbg) {
                Log.d(StateMachine.TAG, "transitionTo: destState=" + this.mDestState.getName());
            }
        }

        private void deferMessage(Message msg) {
            if (this.mDbg) {
                Log.d(StateMachine.TAG, "deferMessage: msg=" + msg.what);
            }
            Message newMsg = this.obtainMessage();
            newMsg.copyFrom(msg);
            this.mDeferredMessages.add(newMsg);
        }

        private void quit() {
            if (this.mDbg) {
                Log.d(StateMachine.TAG, "quit:");
            }
            this.sendMessage(this.obtainMessage(-1, mSmHandlerObj));
        }

        private boolean isQuit(Message msg) {
            return msg.what == -1 && msg.obj == mSmHandlerObj;
        }

        private boolean isDbg() {
            return this.mDbg;
        }

        private void setDbg(boolean dbg) {
            this.mDbg = dbg;
        }

        private void setProcessedMessagesSize(int maxSize) {
            this.mProcessedMessages.setSize(maxSize);
        }

        private int getProcessedMessagesSize() {
            return this.mProcessedMessages.size();
        }

        private int getProcessedMessagesCount() {
            return this.mProcessedMessages.count();
        }

        private ProcessedMessageInfo getProcessedMessageInfo(int index) {
            return this.mProcessedMessages.get(index);
        }

        private class QuittingState
        extends State {
            private QuittingState() {
            }

            public boolean processMessage(Message msg) {
                return false;
            }
        }

        private class HaltingState
        extends State {
            private HaltingState() {
            }

            public boolean processMessage(Message msg) {
                SmHandler.this.mSm.haltedProcessMessage(msg);
                return true;
            }
        }

        private class StateInfo {
            State state;
            StateInfo parentStateInfo;
            boolean active;

            private StateInfo() {
            }

            public String toString() {
                return "state=" + this.state.getName() + ",active=" + this.active + ",parent=" + (this.parentStateInfo == null ? "null" : this.parentStateInfo.state.getName());
            }
        }
    }

    private static class ProcessedMessages {
        private static final int DEFAULT_SIZE = 20;
        private Vector<ProcessedMessageInfo> mMessages = new Vector();
        private int mMaxSize = 20;
        private int mOldestIndex = 0;
        private int mCount = 0;

        private ProcessedMessages() {
        }

        void setSize(int maxSize) {
            this.mMaxSize = maxSize;
            this.mCount = 0;
            this.mMessages.clear();
        }

        int size() {
            return this.mMessages.size();
        }

        int count() {
            return this.mCount;
        }

        void cleanup() {
            this.mMessages.clear();
        }

        ProcessedMessageInfo get(int index) {
            int nextIndex = this.mOldestIndex + index;
            if (nextIndex >= this.mMaxSize) {
                nextIndex -= this.mMaxSize;
            }
            if (nextIndex >= this.size()) {
                return null;
            }
            return this.mMessages.get(nextIndex);
        }

        void add(Message msg, String messageInfo, State state, State orgState) {
            ++this.mCount;
            if (this.mMessages.size() < this.mMaxSize) {
                this.mMessages.add(new ProcessedMessageInfo(msg, messageInfo, state, orgState));
            } else {
                ProcessedMessageInfo pmi = this.mMessages.get(this.mOldestIndex);
                ++this.mOldestIndex;
                if (this.mOldestIndex >= this.mMaxSize) {
                    this.mOldestIndex = 0;
                }
                pmi.update(msg, messageInfo, state, orgState);
            }
        }
    }

    public static class ProcessedMessageInfo {
        private long mTime;
        private int mWhat;
        private String mInfo;
        private State mState;
        private State mOrgState;

        ProcessedMessageInfo(Message msg, String info, State state, State orgState) {
            this.update(msg, info, state, orgState);
        }

        public void update(Message msg, String info, State state, State orgState) {
            this.mTime = System.currentTimeMillis();
            this.mWhat = msg.what;
            this.mInfo = info;
            this.mState = state;
            this.mOrgState = orgState;
        }

        public long getTime() {
            return this.mTime;
        }

        public long getWhat() {
            return this.mWhat;
        }

        public String getInfo() {
            return this.mInfo;
        }

        public State getState() {
            return this.mState;
        }

        public State getOriginalState() {
            return this.mOrgState;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("time=");
            Calendar c = Calendar.getInstance();
            c.setTimeInMillis(this.mTime);
            sb.append(String.format("%tm-%td %tH:%tM:%tS.%tL", c, c, c, c, c, c));
            sb.append(" state=");
            sb.append(this.mState == null ? "<null>" : this.mState.getName());
            sb.append(" orgState=");
            sb.append(this.mOrgState == null ? "<null>" : this.mOrgState.getName());
            sb.append(" what=");
            sb.append(this.mWhat);
            sb.append("(0x");
            sb.append(Integer.toHexString(this.mWhat));
            sb.append(")");
            if (!TextUtils.isEmpty(this.mInfo)) {
                sb.append(" ");
                sb.append(this.mInfo);
            }
            return sb.toString();
        }
    }
}

