/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view.menu;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.widget.LinearLayout;
import com.android.internal.R;
import com.android.internal.view.menu.ActionMenuItemView;
import com.android.internal.view.menu.ActionMenuPresenter;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.view.menu.MenuItemImpl;
import com.android.internal.view.menu.MenuView;

public class ActionMenuView
extends LinearLayout
implements MenuBuilder.ItemInvoker,
MenuView {
    private static final String TAG = "ActionMenuView";
    static final int MIN_CELL_SIZE = 56;
    static final int GENERATED_ITEM_PADDING = 4;
    private MenuBuilder mMenu;
    private boolean mReserveOverflow;
    private ActionMenuPresenter mPresenter;
    private boolean mFormatItems;
    private int mFormatItemsWidth;
    private int mMinCellSize;
    private int mGeneratedItemPadding;
    private int mMeasuredExtraWidth;
    private int mMaxItemHeight;

    public ActionMenuView(Context context) {
        this(context, null);
    }

    public ActionMenuView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setBaselineAligned(false);
        float density = context.getResources().getDisplayMetrics().density;
        this.mMinCellSize = (int)(56.0f * density);
        this.mGeneratedItemPadding = (int)(4.0f * density);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ActionBar, 16843470, 0);
        this.mMaxItemHeight = a.getDimensionPixelSize(4, 0);
        a.recycle();
    }

    public void setPresenter(ActionMenuPresenter presenter) {
        this.mPresenter = presenter;
    }

    public boolean isExpandedFormat() {
        return this.mFormatItems;
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.mPresenter.updateMenuView(false);
        if (this.mPresenter != null && this.mPresenter.isOverflowMenuShowing()) {
            this.mPresenter.hideOverflowMenu();
            this.mPresenter.showOverflowMenu();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        boolean wasFormatted = this.mFormatItems;
        boolean bl = this.mFormatItems = View.MeasureSpec.getMode(widthMeasureSpec) == 0x40000000;
        if (wasFormatted != this.mFormatItems) {
            this.mFormatItemsWidth = 0;
        }
        int widthSize = View.MeasureSpec.getMode(widthMeasureSpec);
        if (this.mFormatItems && this.mMenu != null && widthSize != this.mFormatItemsWidth) {
            this.mFormatItemsWidth = widthSize;
            this.mMenu.onItemsChanged(true);
        }
        if (this.mFormatItems) {
            this.onMeasureExactFormat(widthMeasureSpec, heightMeasureSpec);
        } else {
            int childCount = this.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View child = this.getChildAt(i);
                LayoutParams lp = (LayoutParams)child.getLayoutParams();
                lp.rightMargin = 0;
                lp.leftMargin = 0;
            }
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    private void onMeasureExactFormat(int widthMeasureSpec, int heightMeasureSpec) {
        boolean singleItem;
        int heightMode = View.MeasureSpec.getMode(heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize(widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize(heightMeasureSpec);
        int widthPadding = this.getPaddingLeft() + this.getPaddingRight();
        int heightPadding = this.getPaddingTop() + this.getPaddingBottom();
        int itemHeightSpec = heightMode == 0x40000000 ? View.MeasureSpec.makeMeasureSpec(heightSize - heightPadding, 0x40000000) : View.MeasureSpec.makeMeasureSpec(Math.min(this.mMaxItemHeight, heightSize - heightPadding), Integer.MIN_VALUE);
        int cellCount = (widthSize -= widthPadding) / this.mMinCellSize;
        int cellSizeRemaining = widthSize % this.mMinCellSize;
        if (cellCount == 0) {
            this.setMeasuredDimension(widthSize, 0);
            return;
        }
        int cellSize = this.mMinCellSize + cellSizeRemaining / cellCount;
        int cellsRemaining = cellCount;
        int maxChildHeight = 0;
        int maxCellsUsed = 0;
        int expandableItemCount = 0;
        int visibleItemCount = 0;
        boolean hasOverflow = false;
        long smallestItemsAt = 0L;
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            boolean isGeneratedItem = child instanceof ActionMenuItemView;
            ++visibleItemCount;
            if (isGeneratedItem) {
                child.setPadding(this.mGeneratedItemPadding, 0, this.mGeneratedItemPadding, 0);
            }
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            lp.expanded = false;
            lp.extraPixels = 0;
            lp.cellsUsed = 0;
            lp.expandable = false;
            lp.leftMargin = 0;
            lp.rightMargin = 0;
            lp.preventEdgeOffset = isGeneratedItem && ((ActionMenuItemView)child).hasText();
            int cellsAvailable = lp.isOverflowButton ? 1 : cellsRemaining;
            int cellsUsed = ActionMenuView.measureChildForCells(child, cellSize, cellsAvailable, itemHeightSpec, heightPadding);
            maxCellsUsed = Math.max(maxCellsUsed, cellsUsed);
            if (lp.expandable) {
                ++expandableItemCount;
            }
            if (lp.isOverflowButton) {
                hasOverflow = true;
            }
            cellsRemaining -= cellsUsed;
            maxChildHeight = Math.max(maxChildHeight, child.getMeasuredHeight());
            if (cellsUsed != 1) continue;
            smallestItemsAt |= (long)(1 << i);
        }
        boolean centerSingleExpandedItem = hasOverflow && visibleItemCount == 2;
        boolean needsExpansion = false;
        while (expandableItemCount > 0 && cellsRemaining > 0) {
            LayoutParams lp;
            View child;
            int i;
            int minCells = Integer.MAX_VALUE;
            long minCellsAt = 0L;
            int minCellsItemCount = 0;
            for (i = 0; i < childCount; ++i) {
                child = this.getChildAt(i);
                lp = (LayoutParams)child.getLayoutParams();
                if (!lp.expandable) continue;
                if (lp.cellsUsed < minCells) {
                    minCells = lp.cellsUsed;
                    minCellsAt = 1 << i;
                    minCellsItemCount = 1;
                    continue;
                }
                if (lp.cellsUsed != minCells) continue;
                minCellsAt |= (long)(1 << i);
                ++minCellsItemCount;
            }
            smallestItemsAt |= minCellsAt;
            if (minCellsItemCount > cellsRemaining) break;
            ++minCells;
            for (i = 0; i < childCount; ++i) {
                child = this.getChildAt(i);
                lp = (LayoutParams)child.getLayoutParams();
                if ((minCellsAt & (long)(1 << i)) == 0L) {
                    if (lp.cellsUsed != minCells) continue;
                    smallestItemsAt |= (long)(1 << i);
                    continue;
                }
                if (centerSingleExpandedItem && lp.preventEdgeOffset && cellsRemaining == 1) {
                    child.setPadding(this.mGeneratedItemPadding + cellSize, 0, this.mGeneratedItemPadding, 0);
                }
                ++lp.cellsUsed;
                lp.expanded = true;
                --cellsRemaining;
            }
            needsExpansion = true;
        }
        boolean bl = singleItem = !hasOverflow && visibleItemCount == 1;
        if (cellsRemaining > 0 && smallestItemsAt != 0L && (cellsRemaining < visibleItemCount - 1 || singleItem || maxCellsUsed > 1)) {
            float expandCount = Long.bitCount(smallestItemsAt);
            if (!singleItem) {
                if ((smallestItemsAt & 1L) != 0L) {
                    LayoutParams lp = (LayoutParams)this.getChildAt(0).getLayoutParams();
                    if (!lp.preventEdgeOffset) {
                        expandCount -= 0.5f;
                    }
                }
                if ((smallestItemsAt & (long)(1 << childCount - 1)) != 0L) {
                    LayoutParams lp = (LayoutParams)this.getChildAt(childCount - 1).getLayoutParams();
                    if (!lp.preventEdgeOffset) {
                        expandCount -= 0.5f;
                    }
                }
            }
            int extraPixels = expandCount > 0.0f ? (int)((float)(cellsRemaining * cellSize) / expandCount) : 0;
            for (int i = 0; i < childCount; ++i) {
                if ((smallestItemsAt & (long)(1 << i)) == 0L) continue;
                View child = this.getChildAt(i);
                LayoutParams lp = (LayoutParams)child.getLayoutParams();
                if (child instanceof ActionMenuItemView) {
                    lp.extraPixels = extraPixels;
                    lp.expanded = true;
                    if (i == 0 && !lp.preventEdgeOffset) {
                        lp.leftMargin = -extraPixels / 2;
                    }
                    needsExpansion = true;
                    continue;
                }
                if (lp.isOverflowButton) {
                    lp.extraPixels = extraPixels;
                    lp.expanded = true;
                    lp.rightMargin = -extraPixels / 2;
                    needsExpansion = true;
                    continue;
                }
                if (i != 0) {
                    lp.leftMargin = extraPixels / 2;
                }
                if (i == childCount - 1) continue;
                lp.rightMargin = extraPixels / 2;
            }
            cellsRemaining = 0;
        }
        if (needsExpansion) {
            for (int i = 0; i < childCount; ++i) {
                View child = this.getChildAt(i);
                LayoutParams lp = (LayoutParams)child.getLayoutParams();
                if (!lp.expanded) continue;
                int width = lp.cellsUsed * cellSize + lp.extraPixels;
                child.measure(View.MeasureSpec.makeMeasureSpec(width, 0x40000000), itemHeightSpec);
            }
        }
        if (heightMode != 0x40000000) {
            heightSize = maxChildHeight;
        }
        this.setMeasuredDimension(widthSize, heightSize);
        this.mMeasuredExtraWidth = cellsRemaining * cellSize;
    }

    static int measureChildForCells(View child, int cellSize, int cellsRemaining, int parentHeightMeasureSpec, int parentHeightPadding) {
        boolean expandable;
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        int childHeightSize = View.MeasureSpec.getSize(parentHeightMeasureSpec) - parentHeightPadding;
        int childHeightMode = View.MeasureSpec.getMode(parentHeightMeasureSpec);
        int childHeightSpec = View.MeasureSpec.makeMeasureSpec(childHeightSize, childHeightMode);
        ActionMenuItemView itemView = child instanceof ActionMenuItemView ? (ActionMenuItemView)child : null;
        boolean hasText = itemView != null && itemView.hasText();
        int cellsUsed = 0;
        if (!(cellsRemaining <= 0 || hasText && cellsRemaining < 2)) {
            int childWidthSpec = View.MeasureSpec.makeMeasureSpec(cellSize * cellsRemaining, Integer.MIN_VALUE);
            child.measure(childWidthSpec, childHeightSpec);
            int measuredWidth = child.getMeasuredWidth();
            cellsUsed = measuredWidth / cellSize;
            if (measuredWidth % cellSize != 0) {
                ++cellsUsed;
            }
            if (hasText && cellsUsed < 2) {
                cellsUsed = 2;
            }
        }
        lp.expandable = expandable = !lp.isOverflowButton && hasText;
        lp.cellsUsed = cellsUsed;
        int targetWidth = cellsUsed * cellSize;
        child.measure(View.MeasureSpec.makeMeasureSpec(targetWidth, 0x40000000), childHeightSpec);
        return cellsUsed;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        if (!this.mFormatItems) {
            super.onLayout(changed, left, top, right, bottom);
            return;
        }
        int childCount = this.getChildCount();
        int midVertical = (top + bottom) / 2;
        int dividerWidth = this.getDividerWidth();
        int overflowWidth = 0;
        int nonOverflowWidth = 0;
        int nonOverflowCount = 0;
        int widthRemaining = right - left - this.getPaddingRight() - this.getPaddingLeft();
        boolean hasOverflow = false;
        for (int i = 0; i < childCount; ++i) {
            View v = this.getChildAt(i);
            if (v.getVisibility() == 8) continue;
            LayoutParams p = (LayoutParams)v.getLayoutParams();
            if (p.isOverflowButton) {
                overflowWidth = v.getMeasuredWidth();
                if (this.hasDividerBeforeChildAt(i)) {
                    overflowWidth += dividerWidth;
                }
                int height = v.getMeasuredHeight();
                int r = this.getWidth() - this.getPaddingRight() - p.rightMargin;
                int l = r - overflowWidth;
                int t = midVertical - height / 2;
                int b = t + height;
                v.layout(l, t, r, b);
                widthRemaining -= overflowWidth;
                hasOverflow = true;
                continue;
            }
            int size = v.getMeasuredWidth() + p.leftMargin + p.rightMargin;
            nonOverflowWidth += size;
            widthRemaining -= size;
            if (this.hasDividerBeforeChildAt(i)) {
                nonOverflowWidth += dividerWidth;
            }
            ++nonOverflowCount;
        }
        if (childCount == 1 && !hasOverflow) {
            View v = this.getChildAt(0);
            int width = v.getMeasuredWidth();
            int height = v.getMeasuredHeight();
            int midHorizontal = (right - left) / 2;
            int l = midHorizontal - width / 2;
            int t = midVertical - height / 2;
            v.layout(l, t, l + width, t + height);
            return;
        }
        int spacerCount = nonOverflowCount - (hasOverflow ? 0 : 1);
        int spacerSize = Math.max(0, spacerCount > 0 ? widthRemaining / spacerCount : 0);
        int startLeft = this.getPaddingLeft();
        for (int i = 0; i < childCount; ++i) {
            View v = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)v.getLayoutParams();
            if (v.getVisibility() == 8 || lp.isOverflowButton) continue;
            int width = v.getMeasuredWidth();
            int height = v.getMeasuredHeight();
            int t = midVertical - height / 2;
            v.layout(startLeft += lp.leftMargin, t, startLeft + width, t + height);
            startLeft += width + lp.rightMargin + spacerSize;
        }
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mPresenter.dismissPopupMenus();
    }

    public boolean isOverflowReserved() {
        return this.mReserveOverflow;
    }

    public void setOverflowReserved(boolean reserveOverflow) {
        this.mReserveOverflow = reserveOverflow;
    }

    protected LayoutParams generateDefaultLayoutParams() {
        LayoutParams params = new LayoutParams(-2, -2);
        params.gravity = 16;
        return params;
    }

    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        if (p instanceof LayoutParams) {
            LayoutParams result = new LayoutParams((LayoutParams)p);
            if (result.gravity <= 0) {
                result.gravity = 16;
            }
            return result;
        }
        return this.generateDefaultLayoutParams();
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p != null && p instanceof LayoutParams;
    }

    public LayoutParams generateOverflowButtonLayoutParams() {
        LayoutParams result = this.generateDefaultLayoutParams();
        result.isOverflowButton = true;
        return result;
    }

    public boolean invokeItem(MenuItemImpl item) {
        return this.mMenu.performItemAction(item, 0);
    }

    public int getWindowAnimations() {
        return 0;
    }

    public void initialize(MenuBuilder menu2) {
        this.mMenu = menu2;
    }

    protected boolean hasDividerBeforeChildAt(int childIndex) {
        View childBefore = this.getChildAt(childIndex - 1);
        View child = this.getChildAt(childIndex);
        boolean result = false;
        if (childIndex < this.getChildCount() && childBefore instanceof ActionMenuChildView) {
            result |= ((ActionMenuChildView)((Object)childBefore)).needsDividerAfter();
        }
        if (childIndex > 0 && child instanceof ActionMenuChildView) {
            result |= ((ActionMenuChildView)((Object)child)).needsDividerBefore();
        }
        return result;
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        return false;
    }

    public static class LayoutParams
    extends LinearLayout.LayoutParams {
        @ViewDebug.ExportedProperty(category="layout")
        public boolean isOverflowButton;
        @ViewDebug.ExportedProperty(category="layout")
        public int cellsUsed;
        @ViewDebug.ExportedProperty(category="layout")
        public int extraPixels;
        @ViewDebug.ExportedProperty(category="layout")
        public boolean expandable;
        @ViewDebug.ExportedProperty(category="layout")
        public boolean preventEdgeOffset;
        public boolean expanded;

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
        }

        public LayoutParams(LayoutParams other) {
            super(other);
            this.isOverflowButton = other.isOverflowButton;
        }

        public LayoutParams(int width, int height) {
            super(width, height);
            this.isOverflowButton = false;
        }

        public LayoutParams(int width, int height, boolean isOverflowButton) {
            super(width, height);
            this.isOverflowButton = isOverflowButton;
        }
    }

    public static interface ActionMenuChildView {
        public boolean needsDividerBefore();

        public boolean needsDividerAfter();
    }
}

