/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.app.ActionBar;
import android.app.Activity;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.CollapsibleActionView;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.TouchDelegate;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.view.accessibility.AccessibilityEvent;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import com.android.internal.R;
import com.android.internal.view.menu.ActionMenuItem;
import com.android.internal.view.menu.ActionMenuPresenter;
import com.android.internal.view.menu.ActionMenuView;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.view.menu.MenuItemImpl;
import com.android.internal.view.menu.MenuPresenter;
import com.android.internal.view.menu.MenuView;
import com.android.internal.view.menu.SubMenuBuilder;
import com.android.internal.widget.AbsActionBarView;
import com.android.internal.widget.ActionBarContextView;
import com.android.internal.widget.ScrollingTabContainerView;

public class ActionBarView
extends AbsActionBarView {
    private static final String TAG = "ActionBarView";
    public static final int DISPLAY_DEFAULT = 0;
    private static final int DISPLAY_RELAYOUT_MASK = 31;
    private static final int DEFAULT_CUSTOM_GRAVITY = 19;
    private int mNavigationMode;
    private int mDisplayOptions = -1;
    private CharSequence mTitle;
    private CharSequence mSubtitle;
    private Drawable mIcon;
    private Drawable mLogo;
    private HomeView mHomeLayout;
    private HomeView mExpandedHomeLayout;
    private LinearLayout mTitleLayout;
    private TextView mTitleView;
    private TextView mSubtitleView;
    private View mTitleUpView;
    private Spinner mSpinner;
    private LinearLayout mListNavLayout;
    private ScrollingTabContainerView mTabScrollView;
    private View mCustomNavView;
    private ProgressBar mProgressView;
    private ProgressBar mIndeterminateProgressView;
    private int mProgressBarPadding;
    private int mItemPadding;
    private int mTitleStyleRes;
    private int mSubtitleStyleRes;
    private int mProgressStyle;
    private int mIndeterminateProgressStyle;
    private boolean mUserTitle;
    private boolean mIncludeTabs;
    private boolean mIsCollapsable;
    private boolean mIsCollapsed;
    private MenuBuilder mOptionsMenu;
    private ActionBarContextView mContextView;
    private ActionMenuItem mLogoNavItem;
    private SpinnerAdapter mSpinnerAdapter;
    private ActionBar.OnNavigationListener mCallback;
    private Runnable mTabSelector;
    private ExpandedActionViewMenuPresenter mExpandedMenuPresenter;
    View mExpandedActionView;
    Window.Callback mWindowCallback;
    private final Rect mTempRect = new Rect();
    private int mMaxHomeSlop;
    private static final int MAX_HOME_SLOP = 32;
    private final AdapterView.OnItemSelectedListener mNavItemSelectedListener = new AdapterView.OnItemSelectedListener(){

        public void onItemSelected(AdapterView parent, View view, int position, long id2) {
            if (ActionBarView.this.mCallback != null) {
                ActionBarView.this.mCallback.onNavigationItemSelected(position, id2);
            }
        }

        public void onNothingSelected(AdapterView parent) {
        }
    };
    private final View.OnClickListener mExpandedActionViewUpListener = new View.OnClickListener(){

        public void onClick(View v) {
            MenuItemImpl item = ((ActionBarView)ActionBarView.this).mExpandedMenuPresenter.mCurrentExpandedItem;
            if (item != null) {
                item.collapseActionView();
            }
        }
    };
    private final View.OnClickListener mUpClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            ActionBarView.this.mWindowCallback.onMenuItemSelected(0, ActionBarView.this.mLogoNavItem);
        }
    };

    public ActionBarView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setBackgroundResource(0);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ActionBar, 16843470, 0);
        ApplicationInfo appInfo = context.getApplicationInfo();
        PackageManager pm = context.getPackageManager();
        this.mNavigationMode = a.getInt(7, 0);
        this.mTitle = a.getText(5);
        this.mSubtitle = a.getText(9);
        this.mLogo = a.getDrawable(6);
        if (this.mLogo == null) {
            if (context instanceof Activity) {
                try {
                    this.mLogo = pm.getActivityLogo(((Activity)context).getComponentName());
                }
                catch (PackageManager.NameNotFoundException e) {
                    Log.e(TAG, "Activity component name not found!", e);
                }
            }
            if (this.mLogo == null) {
                this.mLogo = appInfo.loadLogo(pm);
            }
        }
        this.mIcon = a.getDrawable(0);
        if (this.mIcon == null) {
            if (context instanceof Activity) {
                try {
                    this.mIcon = pm.getActivityIcon(((Activity)context).getComponentName());
                }
                catch (PackageManager.NameNotFoundException e) {
                    Log.e(TAG, "Activity component name not found!", e);
                }
            }
            if (this.mIcon == null) {
                this.mIcon = appInfo.loadIcon(pm);
            }
        }
        LayoutInflater inflater = LayoutInflater.from(context);
        int homeResId = a.getResourceId(15, 17367064);
        this.mHomeLayout = (HomeView)inflater.inflate(homeResId, (ViewGroup)this, false);
        this.mExpandedHomeLayout = (HomeView)inflater.inflate(homeResId, (ViewGroup)this, false);
        this.mExpandedHomeLayout.setUp(true);
        this.mExpandedHomeLayout.setOnClickListener(this.mExpandedActionViewUpListener);
        this.mExpandedHomeLayout.setContentDescription(this.getResources().getText(17040593));
        this.mTitleStyleRes = a.getResourceId(11, 0);
        this.mSubtitleStyleRes = a.getResourceId(12, 0);
        this.mProgressStyle = a.getResourceId(1, 0);
        this.mIndeterminateProgressStyle = a.getResourceId(13, 0);
        this.mProgressBarPadding = a.getDimensionPixelOffset(14, 0);
        this.mItemPadding = a.getDimensionPixelOffset(16, 0);
        this.setDisplayOptions(a.getInt(8, 0));
        int customNavId = a.getResourceId(10, 0);
        if (customNavId != 0) {
            this.mCustomNavView = inflater.inflate(customNavId, (ViewGroup)this, false);
            this.mNavigationMode = 0;
            this.setDisplayOptions(this.mDisplayOptions | 0x10);
        }
        this.mContentHeight = a.getLayoutDimension(4, 0);
        a.recycle();
        this.mLogoNavItem = new ActionMenuItem(context, 0, 16908332, 0, 0, this.mTitle);
        this.mHomeLayout.setOnClickListener(this.mUpClickListener);
        this.mHomeLayout.setClickable(true);
        this.mHomeLayout.setFocusable(true);
        if (this.getImportantForAccessibility() == 0) {
            this.setImportantForAccessibility(1);
        }
        this.mMaxHomeSlop = (int)(32.0f * context.getResources().getDisplayMetrics().density + 0.5f);
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.mTitleView = null;
        this.mSubtitleView = null;
        this.mTitleUpView = null;
        if (this.mTitleLayout != null && this.mTitleLayout.getParent() == this) {
            this.removeView(this.mTitleLayout);
        }
        this.mTitleLayout = null;
        if ((this.mDisplayOptions & 8) != 0) {
            this.initTitle();
        }
        if (this.mTabScrollView != null && this.mIncludeTabs) {
            ViewGroup.LayoutParams lp = this.mTabScrollView.getLayoutParams();
            if (lp != null) {
                lp.width = -2;
                lp.height = -1;
            }
            this.mTabScrollView.setAllowCollapse(true);
        }
    }

    public void setWindowCallback(Window.Callback cb) {
        this.mWindowCallback = cb;
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.removeCallbacks(this.mTabSelector);
        if (this.mActionMenuPresenter != null) {
            this.mActionMenuPresenter.hideOverflowMenu();
            this.mActionMenuPresenter.hideSubMenus();
        }
    }

    public boolean shouldDelayChildPressedState() {
        return false;
    }

    public void initProgress() {
        this.mProgressView = new ProgressBar(this.mContext, null, 0, this.mProgressStyle);
        this.mProgressView.setId(16909080);
        this.mProgressView.setMax(10000);
        this.mProgressView.setVisibility(8);
        this.addView(this.mProgressView);
    }

    public void initIndeterminateProgress() {
        this.mIndeterminateProgressView = new ProgressBar(this.mContext, null, 0, this.mIndeterminateProgressStyle);
        this.mIndeterminateProgressView.setId(16909079);
        this.mIndeterminateProgressView.setVisibility(8);
        this.addView(this.mIndeterminateProgressView);
    }

    public void setSplitActionBar(boolean splitActionBar) {
        if (this.mSplitActionBar != splitActionBar) {
            if (this.mMenuView != null) {
                ViewGroup oldParent = (ViewGroup)this.mMenuView.getParent();
                if (oldParent != null) {
                    oldParent.removeView(this.mMenuView);
                }
                if (splitActionBar) {
                    if (this.mSplitView != null) {
                        this.mSplitView.addView(this.mMenuView);
                    }
                    this.mMenuView.getLayoutParams().width = -1;
                } else {
                    this.addView(this.mMenuView);
                    this.mMenuView.getLayoutParams().width = -2;
                }
                this.mMenuView.requestLayout();
            }
            if (this.mSplitView != null) {
                this.mSplitView.setVisibility(splitActionBar ? 0 : 8);
            }
            if (this.mActionMenuPresenter != null) {
                if (!splitActionBar) {
                    this.mActionMenuPresenter.setExpandedActionViewsExclusive(this.getResources().getBoolean(0x1110005));
                } else {
                    this.mActionMenuPresenter.setExpandedActionViewsExclusive(false);
                    this.mActionMenuPresenter.setWidthLimit(this.getContext().getResources().getDisplayMetrics().widthPixels, true);
                    this.mActionMenuPresenter.setItemLimit(Integer.MAX_VALUE);
                }
            }
            super.setSplitActionBar(splitActionBar);
        }
    }

    public boolean isSplitActionBar() {
        return this.mSplitActionBar;
    }

    public boolean hasEmbeddedTabs() {
        return this.mIncludeTabs;
    }

    public void setEmbeddedTabView(ScrollingTabContainerView tabs) {
        if (this.mTabScrollView != null) {
            this.removeView(this.mTabScrollView);
        }
        this.mTabScrollView = tabs;
        boolean bl = this.mIncludeTabs = tabs != null;
        if (this.mIncludeTabs && this.mNavigationMode == 2) {
            this.addView(this.mTabScrollView);
            ViewGroup.LayoutParams lp = this.mTabScrollView.getLayoutParams();
            lp.width = -2;
            lp.height = -1;
            tabs.setAllowCollapse(true);
        }
    }

    public void setCallback(ActionBar.OnNavigationListener callback) {
        this.mCallback = callback;
    }

    public void setMenu(Menu menu2, MenuPresenter.Callback cb) {
        ActionMenuView menuView;
        ViewGroup oldParent;
        MenuBuilder builder;
        if (menu2 == this.mOptionsMenu) {
            return;
        }
        if (this.mOptionsMenu != null) {
            this.mOptionsMenu.removeMenuPresenter(this.mActionMenuPresenter);
            this.mOptionsMenu.removeMenuPresenter(this.mExpandedMenuPresenter);
        }
        this.mOptionsMenu = builder = (MenuBuilder)menu2;
        if (this.mMenuView != null && (oldParent = (ViewGroup)this.mMenuView.getParent()) != null) {
            oldParent.removeView(this.mMenuView);
        }
        if (this.mActionMenuPresenter == null) {
            this.mActionMenuPresenter = new ActionMenuPresenter(this.mContext);
            this.mActionMenuPresenter.setCallback(cb);
            this.mActionMenuPresenter.setId(16908863);
            this.mExpandedMenuPresenter = new ExpandedActionViewMenuPresenter();
        }
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-2, -1);
        if (!this.mSplitActionBar) {
            this.mActionMenuPresenter.setExpandedActionViewsExclusive(this.getResources().getBoolean(0x1110005));
            this.configPresenters(builder);
            menuView = (ActionMenuView)this.mActionMenuPresenter.getMenuView(this);
            ViewGroup oldParent2 = (ViewGroup)menuView.getParent();
            if (oldParent2 != null && oldParent2 != this) {
                oldParent2.removeView(menuView);
            }
            this.addView((View)menuView, layoutParams);
        } else {
            this.mActionMenuPresenter.setExpandedActionViewsExclusive(false);
            this.mActionMenuPresenter.setWidthLimit(this.getContext().getResources().getDisplayMetrics().widthPixels, true);
            this.mActionMenuPresenter.setItemLimit(Integer.MAX_VALUE);
            layoutParams.width = -1;
            this.configPresenters(builder);
            menuView = (ActionMenuView)this.mActionMenuPresenter.getMenuView(this);
            if (this.mSplitView != null) {
                ViewGroup oldParent3 = (ViewGroup)menuView.getParent();
                if (oldParent3 != null && oldParent3 != this.mSplitView) {
                    oldParent3.removeView(menuView);
                }
                menuView.setVisibility(this.getAnimatedVisibility());
                this.mSplitView.addView((View)menuView, layoutParams);
            } else {
                menuView.setLayoutParams(layoutParams);
            }
        }
        this.mMenuView = menuView;
    }

    private void configPresenters(MenuBuilder builder) {
        if (builder != null) {
            builder.addMenuPresenter(this.mActionMenuPresenter);
            builder.addMenuPresenter(this.mExpandedMenuPresenter);
        } else {
            this.mActionMenuPresenter.initForMenu(this.mContext, null);
            this.mExpandedMenuPresenter.initForMenu(this.mContext, null);
            this.mActionMenuPresenter.updateMenuView(true);
            this.mExpandedMenuPresenter.updateMenuView(true);
        }
    }

    public boolean hasExpandedActionView() {
        return this.mExpandedMenuPresenter != null && this.mExpandedMenuPresenter.mCurrentExpandedItem != null;
    }

    public void collapseActionView() {
        MenuItemImpl item;
        MenuItemImpl menuItemImpl = item = this.mExpandedMenuPresenter == null ? null : this.mExpandedMenuPresenter.mCurrentExpandedItem;
        if (item != null) {
            item.collapseActionView();
        }
    }

    public void setCustomNavigationView(View view) {
        boolean showCustom;
        boolean bl = showCustom = (this.mDisplayOptions & 0x10) != 0;
        if (this.mCustomNavView != null && showCustom) {
            this.removeView(this.mCustomNavView);
        }
        this.mCustomNavView = view;
        if (this.mCustomNavView != null && showCustom) {
            this.addView(this.mCustomNavView);
        }
    }

    public CharSequence getTitle() {
        return this.mTitle;
    }

    public void setTitle(CharSequence title) {
        this.mUserTitle = true;
        this.setTitleImpl(title);
    }

    public void setWindowTitle(CharSequence title) {
        if (!this.mUserTitle) {
            this.setTitleImpl(title);
        }
    }

    private void setTitleImpl(CharSequence title) {
        this.mTitle = title;
        if (this.mTitleView != null) {
            this.mTitleView.setText(title);
            boolean visible = this.mExpandedActionView == null && (this.mDisplayOptions & 8) != 0 && (!TextUtils.isEmpty(this.mTitle) || !TextUtils.isEmpty(this.mSubtitle));
            this.mTitleLayout.setVisibility(visible ? 0 : 8);
        }
        if (this.mLogoNavItem != null) {
            this.mLogoNavItem.setTitle(title);
        }
    }

    public CharSequence getSubtitle() {
        return this.mSubtitle;
    }

    public void setSubtitle(CharSequence subtitle) {
        this.mSubtitle = subtitle;
        if (this.mSubtitleView != null) {
            this.mSubtitleView.setText(subtitle);
            this.mSubtitleView.setVisibility(subtitle != null ? 0 : 8);
            boolean visible = this.mExpandedActionView == null && (this.mDisplayOptions & 8) != 0 && (!TextUtils.isEmpty(this.mTitle) || !TextUtils.isEmpty(this.mSubtitle));
            this.mTitleLayout.setVisibility(visible ? 0 : 8);
        }
    }

    public void setHomeButtonEnabled(boolean enable) {
        this.mHomeLayout.setEnabled(enable);
        this.mHomeLayout.setFocusable(enable);
        if (!enable) {
            this.mHomeLayout.setContentDescription(null);
        } else if ((this.mDisplayOptions & 4) != 0) {
            this.mHomeLayout.setContentDescription(this.mContext.getResources().getText(17040593));
        } else {
            this.mHomeLayout.setContentDescription(this.mContext.getResources().getText(17040592));
        }
    }

    public void setDisplayOptions(int options) {
        int flagsChanged = this.mDisplayOptions == -1 ? -1 : options ^ this.mDisplayOptions;
        this.mDisplayOptions = options;
        if ((flagsChanged & 0x1F) != 0) {
            boolean showHome = (options & 2) != 0;
            int vis = showHome && this.mExpandedActionView == null ? 0 : 8;
            this.mHomeLayout.setVisibility(vis);
            if ((flagsChanged & 4) != 0) {
                boolean setUp = (options & 4) != 0;
                this.mHomeLayout.setUp(setUp);
                if (setUp) {
                    this.setHomeButtonEnabled(true);
                }
            }
            if ((flagsChanged & 1) != 0) {
                boolean logoVis = this.mLogo != null && (options & 1) != 0;
                this.mHomeLayout.setIcon(logoVis ? this.mLogo : this.mIcon);
            }
            if ((flagsChanged & 8) != 0) {
                if ((options & 8) != 0) {
                    this.initTitle();
                } else {
                    this.removeView(this.mTitleLayout);
                }
            }
            if (this.mTitleLayout != null && (flagsChanged & 6) != 0) {
                boolean homeAsUp;
                boolean bl = homeAsUp = (this.mDisplayOptions & 4) != 0;
                this.mTitleUpView.setVisibility(!showHome ? (homeAsUp ? 0 : 4) : 8);
                this.mTitleLayout.setEnabled(!showHome && homeAsUp);
                this.mTitleLayout.setClickable(!showHome && homeAsUp);
            }
            if ((flagsChanged & 0x10) != 0 && this.mCustomNavView != null) {
                if ((options & 0x10) != 0) {
                    this.addView(this.mCustomNavView);
                } else {
                    this.removeView(this.mCustomNavView);
                }
            }
            this.requestLayout();
        } else {
            this.invalidate();
        }
        if (!this.mHomeLayout.isEnabled()) {
            this.mHomeLayout.setContentDescription(null);
        } else if ((options & 4) != 0) {
            this.mHomeLayout.setContentDescription(this.mContext.getResources().getText(17040593));
        } else {
            this.mHomeLayout.setContentDescription(this.mContext.getResources().getText(17040592));
        }
    }

    public void setIcon(Drawable icon) {
        this.mIcon = icon;
        if (icon != null && ((this.mDisplayOptions & 1) == 0 || this.mLogo == null)) {
            this.mHomeLayout.setIcon(icon);
        }
        if (this.mExpandedActionView != null) {
            this.mExpandedHomeLayout.setIcon(this.mIcon.getConstantState().newDrawable(this.getResources()));
        }
    }

    public void setIcon(int resId) {
        this.setIcon(this.mContext.getResources().getDrawable(resId));
    }

    public void setLogo(Drawable logo) {
        this.mLogo = logo;
        if (logo != null && (this.mDisplayOptions & 1) != 0) {
            this.mHomeLayout.setIcon(logo);
        }
    }

    public void setLogo(int resId) {
        this.setLogo(this.mContext.getResources().getDrawable(resId));
    }

    public void setNavigationMode(int mode) {
        int oldMode = this.mNavigationMode;
        if (mode != oldMode) {
            switch (oldMode) {
                case 1: {
                    if (this.mListNavLayout == null) break;
                    this.removeView(this.mListNavLayout);
                    break;
                }
                case 2: {
                    if (this.mTabScrollView == null || !this.mIncludeTabs) break;
                    this.removeView(this.mTabScrollView);
                }
            }
            switch (mode) {
                case 1: {
                    if (this.mSpinner == null) {
                        this.mSpinner = new Spinner(this.mContext, null, 16843479);
                        this.mListNavLayout = new LinearLayout(this.mContext, null, 16843508);
                        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -1);
                        params.gravity = 17;
                        this.mListNavLayout.addView((View)this.mSpinner, params);
                    }
                    if (this.mSpinner.getAdapter() != this.mSpinnerAdapter) {
                        this.mSpinner.setAdapter(this.mSpinnerAdapter);
                    }
                    this.mSpinner.setOnItemSelectedListener(this.mNavItemSelectedListener);
                    this.addView(this.mListNavLayout);
                    break;
                }
                case 2: {
                    if (this.mTabScrollView == null || !this.mIncludeTabs) break;
                    this.addView(this.mTabScrollView);
                }
            }
            this.mNavigationMode = mode;
            this.requestLayout();
        }
    }

    public void setDropdownAdapter(SpinnerAdapter adapter) {
        this.mSpinnerAdapter = adapter;
        if (this.mSpinner != null) {
            this.mSpinner.setAdapter(adapter);
        }
    }

    public SpinnerAdapter getDropdownAdapter() {
        return this.mSpinnerAdapter;
    }

    public void setDropdownSelectedPosition(int position) {
        this.mSpinner.setSelection(position);
    }

    public int getDropdownSelectedPosition() {
        return this.mSpinner.getSelectedItemPosition();
    }

    public View getCustomNavigationView() {
        return this.mCustomNavView;
    }

    public int getNavigationMode() {
        return this.mNavigationMode;
    }

    public int getDisplayOptions() {
        return this.mDisplayOptions;
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new ActionBar.LayoutParams(19);
    }

    protected void onFinishInflate() {
        ViewParent parent;
        super.onFinishInflate();
        this.addView(this.mHomeLayout);
        if (this.mCustomNavView != null && (this.mDisplayOptions & 0x10) != 0 && (parent = this.mCustomNavView.getParent()) != this) {
            if (parent instanceof ViewGroup) {
                ((ViewGroup)parent).removeView(this.mCustomNavView);
            }
            this.addView(this.mCustomNavView);
        }
    }

    private void initTitle() {
        if (this.mTitleLayout == null) {
            boolean showTitleUp;
            LayoutInflater inflater = LayoutInflater.from(this.getContext());
            this.mTitleLayout = (LinearLayout)inflater.inflate(0x1090019, (ViewGroup)this, false);
            this.mTitleView = (TextView)this.mTitleLayout.findViewById(16908866);
            this.mSubtitleView = (TextView)this.mTitleLayout.findViewById(16908867);
            this.mTitleUpView = this.mTitleLayout.findViewById(16908859);
            this.mTitleLayout.setOnClickListener(this.mUpClickListener);
            if (this.mTitleStyleRes != 0) {
                this.mTitleView.setTextAppearance(this.mContext, this.mTitleStyleRes);
            }
            if (this.mTitle != null) {
                this.mTitleView.setText(this.mTitle);
            }
            if (this.mSubtitleStyleRes != 0) {
                this.mSubtitleView.setTextAppearance(this.mContext, this.mSubtitleStyleRes);
            }
            if (this.mSubtitle != null) {
                this.mSubtitleView.setText(this.mSubtitle);
                this.mSubtitleView.setVisibility(0);
            }
            boolean homeAsUp = (this.mDisplayOptions & 4) != 0;
            boolean showHome = (this.mDisplayOptions & 2) != 0;
            boolean bl = showTitleUp = !showHome;
            this.mTitleUpView.setVisibility(showTitleUp ? (homeAsUp ? 0 : 4) : 8);
            this.mTitleLayout.setEnabled(homeAsUp && showTitleUp);
            this.mTitleLayout.setClickable(homeAsUp && showTitleUp);
        }
        this.addView(this.mTitleLayout);
        if (this.mExpandedActionView != null || TextUtils.isEmpty(this.mTitle) && TextUtils.isEmpty(this.mSubtitle)) {
            this.mTitleLayout.setVisibility(8);
        }
    }

    public void setContextView(ActionBarContextView view) {
        this.mContextView = view;
    }

    public void setCollapsable(boolean collapsable) {
        this.mIsCollapsable = collapsable;
    }

    public boolean isCollapsed() {
        return this.mIsCollapsed;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        boolean showTitle;
        HomeView homeLayout;
        int leftOfCenter;
        int childCount = this.getChildCount();
        if (this.mIsCollapsable) {
            int visibleChildren = 0;
            for (int i = 0; i < childCount; ++i) {
                View child = this.getChildAt(i);
                if (child.getVisibility() == 8 || child == this.mMenuView && this.mMenuView.getChildCount() == 0) continue;
                ++visibleChildren;
            }
            if (visibleChildren == 0) {
                this.setMeasuredDimension(0, 0);
                this.mIsCollapsed = true;
                return;
            }
        }
        this.mIsCollapsed = false;
        int widthMode = View.MeasureSpec.getMode(widthMeasureSpec);
        if (widthMode != 0x40000000) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " can only be used " + "with android:layout_width=\"match_parent\" (or fill_parent)");
        }
        int heightMode = View.MeasureSpec.getMode(heightMeasureSpec);
        if (heightMode != Integer.MIN_VALUE) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " can only be used " + "with android:layout_height=\"wrap_content\"");
        }
        int contentWidth = View.MeasureSpec.getSize(widthMeasureSpec);
        int maxHeight = this.mContentHeight > 0 ? this.mContentHeight : View.MeasureSpec.getSize(heightMeasureSpec);
        int verticalPadding = this.getPaddingTop() + this.getPaddingBottom();
        int paddingLeft = this.getPaddingLeft();
        int paddingRight = this.getPaddingRight();
        int height = maxHeight - verticalPadding;
        int childSpecHeight = View.MeasureSpec.makeMeasureSpec(height, Integer.MIN_VALUE);
        int availableWidth = contentWidth - paddingLeft - paddingRight;
        int rightOfCenter = leftOfCenter = availableWidth / 2;
        HomeView homeView = homeLayout = this.mExpandedActionView != null ? this.mExpandedHomeLayout : this.mHomeLayout;
        if (homeLayout.getVisibility() != 8) {
            ViewGroup.LayoutParams lp = homeLayout.getLayoutParams();
            int homeWidthSpec = lp.width < 0 ? View.MeasureSpec.makeMeasureSpec(availableWidth, Integer.MIN_VALUE) : View.MeasureSpec.makeMeasureSpec(lp.width, 0x40000000);
            homeLayout.measure(homeWidthSpec, View.MeasureSpec.makeMeasureSpec(height, 0x40000000));
            int homeWidth = homeLayout.getMeasuredWidth() + homeLayout.getLeftOffset();
            availableWidth = Math.max(0, availableWidth - homeWidth);
            leftOfCenter = Math.max(0, availableWidth - homeWidth);
        }
        if (this.mMenuView != null && this.mMenuView.getParent() == this) {
            availableWidth = this.measureChildView(this.mMenuView, availableWidth, childSpecHeight, 0);
            rightOfCenter = Math.max(0, rightOfCenter - this.mMenuView.getMeasuredWidth());
        }
        if (this.mIndeterminateProgressView != null && this.mIndeterminateProgressView.getVisibility() != 8) {
            availableWidth = this.measureChildView(this.mIndeterminateProgressView, availableWidth, childSpecHeight, 0);
            rightOfCenter = Math.max(0, rightOfCenter - this.mIndeterminateProgressView.getMeasuredWidth());
        }
        boolean bl = showTitle = this.mTitleLayout != null && this.mTitleLayout.getVisibility() != 8 && (this.mDisplayOptions & 8) != 0;
        if (this.mExpandedActionView == null) {
            switch (this.mNavigationMode) {
                case 1: {
                    if (this.mListNavLayout == null) break;
                    int itemPaddingSize = showTitle ? this.mItemPadding * 2 : this.mItemPadding;
                    availableWidth = Math.max(0, availableWidth - itemPaddingSize);
                    leftOfCenter = Math.max(0, leftOfCenter - itemPaddingSize);
                    this.mListNavLayout.measure(View.MeasureSpec.makeMeasureSpec(availableWidth, Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec(height, 0x40000000));
                    int listNavWidth = this.mListNavLayout.getMeasuredWidth();
                    availableWidth = Math.max(0, availableWidth - listNavWidth);
                    leftOfCenter = Math.max(0, leftOfCenter - listNavWidth);
                    break;
                }
                case 2: {
                    if (this.mTabScrollView == null) break;
                    int itemPaddingSize = showTitle ? this.mItemPadding * 2 : this.mItemPadding;
                    availableWidth = Math.max(0, availableWidth - itemPaddingSize);
                    leftOfCenter = Math.max(0, leftOfCenter - itemPaddingSize);
                    this.mTabScrollView.measure(View.MeasureSpec.makeMeasureSpec(availableWidth, Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec(height, 0x40000000));
                    int tabWidth = this.mTabScrollView.getMeasuredWidth();
                    availableWidth = Math.max(0, availableWidth - tabWidth);
                    leftOfCenter = Math.max(0, leftOfCenter - tabWidth);
                }
            }
        }
        View customView = null;
        if (this.mExpandedActionView != null) {
            customView = this.mExpandedActionView;
        } else if ((this.mDisplayOptions & 0x10) != 0 && this.mCustomNavView != null) {
            customView = this.mCustomNavView;
        }
        if (customView != null) {
            ViewGroup.LayoutParams lp = this.generateLayoutParams(customView.getLayoutParams());
            ActionBar.LayoutParams ablp = lp instanceof ActionBar.LayoutParams ? (ActionBar.LayoutParams)lp : null;
            int horizontalMargin = 0;
            int verticalMargin = 0;
            if (ablp != null) {
                horizontalMargin = ablp.leftMargin + ablp.rightMargin;
                verticalMargin = ablp.topMargin + ablp.bottomMargin;
            }
            int customNavHeightMode = this.mContentHeight <= 0 ? Integer.MIN_VALUE : (lp.height != -2 ? 0x40000000 : Integer.MIN_VALUE);
            int customNavHeight = Math.max(0, (lp.height >= 0 ? Math.min(lp.height, height) : height) - verticalMargin);
            int customNavWidthMode = lp.width != -2 ? 0x40000000 : Integer.MIN_VALUE;
            int customNavWidth = Math.max(0, (lp.width >= 0 ? Math.min(lp.width, availableWidth) : availableWidth) - horizontalMargin);
            int hgrav = (ablp != null ? ablp.gravity : 19) & 7;
            if (hgrav == 1 && lp.width == -1) {
                customNavWidth = Math.min(leftOfCenter, rightOfCenter) * 2;
            }
            customView.measure(View.MeasureSpec.makeMeasureSpec(customNavWidth, customNavWidthMode), View.MeasureSpec.makeMeasureSpec(customNavHeight, customNavHeightMode));
            availableWidth -= horizontalMargin + customView.getMeasuredWidth();
        }
        if (this.mExpandedActionView == null && showTitle) {
            availableWidth = this.measureChildView(this.mTitleLayout, availableWidth, View.MeasureSpec.makeMeasureSpec(this.mContentHeight, 0x40000000), 0);
            leftOfCenter = Math.max(0, leftOfCenter - this.mTitleLayout.getMeasuredWidth());
        }
        if (this.mContentHeight <= 0) {
            int measuredHeight = 0;
            for (int i = 0; i < childCount; ++i) {
                View v = this.getChildAt(i);
                int paddedViewHeight = v.getMeasuredHeight() + verticalPadding;
                if (paddedViewHeight <= measuredHeight) continue;
                measuredHeight = paddedViewHeight;
            }
            this.setMeasuredDimension(contentWidth, measuredHeight);
        } else {
            this.setMeasuredDimension(contentWidth, maxHeight);
        }
        if (this.mContextView != null) {
            this.mContextView.setContentHeight(this.getMeasuredHeight());
        }
        if (this.mProgressView != null && this.mProgressView.getVisibility() != 8) {
            this.mProgressView.measure(View.MeasureSpec.makeMeasureSpec(contentWidth - this.mProgressBarPadding * 2, 0x40000000), View.MeasureSpec.makeMeasureSpec(this.getMeasuredHeight(), Integer.MIN_VALUE));
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int x = this.getPaddingLeft();
        int y = this.getPaddingTop();
        int contentHeight = b - t - this.getPaddingTop() - this.getPaddingBottom();
        if (contentHeight <= 0) {
            return;
        }
        HomeView homeLayout = this.mExpandedActionView != null ? this.mExpandedHomeLayout : this.mHomeLayout;
        boolean needsTouchDelegate = false;
        int homeSlop = this.mMaxHomeSlop;
        int homeRight = 0;
        if (homeLayout.getVisibility() != 8) {
            int leftOffset = homeLayout.getLeftOffset();
            x += this.positionChild(homeLayout, x + leftOffset, y, contentHeight) + leftOffset;
            needsTouchDelegate = homeLayout == this.mHomeLayout;
            homeRight = x;
        }
        if (this.mExpandedActionView == null) {
            boolean showTitle;
            boolean bl = showTitle = this.mTitleLayout != null && this.mTitleLayout.getVisibility() != 8 && (this.mDisplayOptions & 8) != 0;
            if (showTitle) {
                x += this.positionChild(this.mTitleLayout, x, y, contentHeight);
            }
            switch (this.mNavigationMode) {
                case 0: {
                    break;
                }
                case 1: {
                    if (this.mListNavLayout == null) break;
                    if (showTitle) {
                        x += this.mItemPadding;
                    }
                    homeSlop = Math.min(homeSlop, Math.max(x - homeRight, 0));
                    x += this.positionChild(this.mListNavLayout, x, y, contentHeight) + this.mItemPadding;
                    break;
                }
                case 2: {
                    if (this.mTabScrollView == null) break;
                    if (showTitle) {
                        x += this.mItemPadding;
                    }
                    homeSlop = Math.min(homeSlop, Math.max(x - homeRight, 0));
                    x += this.positionChild(this.mTabScrollView, x, y, contentHeight) + this.mItemPadding;
                }
            }
        }
        int menuLeft = r - l - this.getPaddingRight();
        if (this.mMenuView != null && this.mMenuView.getParent() == this) {
            this.positionChildInverse(this.mMenuView, menuLeft, y, contentHeight);
            menuLeft -= this.mMenuView.getMeasuredWidth();
        }
        if (this.mIndeterminateProgressView != null && this.mIndeterminateProgressView.getVisibility() != 8) {
            this.positionChildInverse(this.mIndeterminateProgressView, menuLeft, y, contentHeight);
            menuLeft -= this.mIndeterminateProgressView.getMeasuredWidth();
        }
        View customView = null;
        if (this.mExpandedActionView != null) {
            customView = this.mExpandedActionView;
        } else if ((this.mDisplayOptions & 0x10) != 0 && this.mCustomNavView != null) {
            customView = this.mCustomNavView;
        }
        if (customView != null) {
            int hgravity;
            ViewGroup.LayoutParams lp = customView.getLayoutParams();
            ActionBar.LayoutParams ablp = lp instanceof ActionBar.LayoutParams ? (ActionBar.LayoutParams)lp : null;
            int gravity = ablp != null ? ablp.gravity : 19;
            int navWidth = customView.getMeasuredWidth();
            int topMargin = 0;
            int bottomMargin = 0;
            if (ablp != null) {
                x += ablp.leftMargin;
                menuLeft -= ablp.rightMargin;
                topMargin = ablp.topMargin;
                bottomMargin = ablp.bottomMargin;
            }
            if ((hgravity = gravity & 7) == 1) {
                int centeredLeft = (this.mRight - this.mLeft - navWidth) / 2;
                if (centeredLeft < x) {
                    hgravity = 3;
                } else if (centeredLeft + navWidth > menuLeft) {
                    hgravity = 5;
                }
            } else if (gravity == -1) {
                hgravity = 3;
            }
            int xpos = 0;
            switch (hgravity) {
                case 1: {
                    xpos = (this.mRight - this.mLeft - navWidth) / 2;
                    break;
                }
                case 3: {
                    xpos = x;
                    break;
                }
                case 5: {
                    xpos = menuLeft - navWidth;
                }
            }
            int vgravity = gravity & 0x70;
            if (gravity == -1) {
                vgravity = 16;
            }
            int ypos = 0;
            switch (vgravity) {
                case 16: {
                    int paddedTop = this.getPaddingTop();
                    int paddedBottom = this.mBottom - this.mTop - this.getPaddingBottom();
                    ypos = (paddedBottom - paddedTop - customView.getMeasuredHeight()) / 2;
                    break;
                }
                case 48: {
                    ypos = this.getPaddingTop() + topMargin;
                    break;
                }
                case 80: {
                    ypos = this.getHeight() - this.getPaddingBottom() - customView.getMeasuredHeight() - bottomMargin;
                }
            }
            int customWidth = customView.getMeasuredWidth();
            customView.layout(xpos, ypos, xpos + customWidth, ypos + customView.getMeasuredHeight());
            homeSlop = Math.min(homeSlop, Math.max(xpos - homeRight, 0));
            x += customWidth;
        }
        if (this.mProgressView != null) {
            this.mProgressView.bringToFront();
            int halfProgressHeight = this.mProgressView.getMeasuredHeight() / 2;
            this.mProgressView.layout(this.mProgressBarPadding, -halfProgressHeight, this.mProgressBarPadding + this.mProgressView.getMeasuredWidth(), halfProgressHeight);
        }
        if (needsTouchDelegate) {
            this.mTempRect.set(homeLayout.getLeft(), homeLayout.getTop(), homeLayout.getRight() + homeSlop, homeLayout.getBottom());
            this.setTouchDelegate(new TouchDelegate(this.mTempRect, homeLayout));
        } else {
            this.setTouchDelegate(null);
        }
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new ActionBar.LayoutParams(this.getContext(), attrs);
    }

    public ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams lp) {
        if (lp == null) {
            lp = this.generateDefaultLayoutParams();
        }
        return lp;
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState state = new SavedState(superState);
        if (this.mExpandedMenuPresenter != null && this.mExpandedMenuPresenter.mCurrentExpandedItem != null) {
            state.expandedMenuItemId = this.mExpandedMenuPresenter.mCurrentExpandedItem.getItemId();
        }
        state.isOverflowOpen = this.isOverflowMenuShowing();
        return state;
    }

    public void onRestoreInstanceState(Parcelable p) {
        MenuItem item;
        SavedState state = (SavedState)p;
        super.onRestoreInstanceState(state.getSuperState());
        if (state.expandedMenuItemId != 0 && this.mExpandedMenuPresenter != null && this.mOptionsMenu != null && (item = this.mOptionsMenu.findItem(state.expandedMenuItemId)) != null) {
            item.expandActionView();
        }
        if (state.isOverflowOpen) {
            this.postShowOverflowMenu();
        }
    }

    private class ExpandedActionViewMenuPresenter
    implements MenuPresenter {
        MenuBuilder mMenu;
        MenuItemImpl mCurrentExpandedItem;

        private ExpandedActionViewMenuPresenter() {
        }

        public void initForMenu(Context context, MenuBuilder menu2) {
            if (this.mMenu != null && this.mCurrentExpandedItem != null) {
                this.mMenu.collapseItemActionView(this.mCurrentExpandedItem);
            }
            this.mMenu = menu2;
        }

        public MenuView getMenuView(ViewGroup root) {
            return null;
        }

        public void updateMenuView(boolean cleared) {
            if (this.mCurrentExpandedItem != null) {
                boolean found = false;
                if (this.mMenu != null) {
                    int count = this.mMenu.size();
                    for (int i = 0; i < count; ++i) {
                        MenuItem item = this.mMenu.getItem(i);
                        if (item != this.mCurrentExpandedItem) continue;
                        found = true;
                        break;
                    }
                }
                if (!found) {
                    this.collapseItemActionView(this.mMenu, this.mCurrentExpandedItem);
                }
            }
        }

        public void setCallback(MenuPresenter.Callback cb) {
        }

        public boolean onSubMenuSelected(SubMenuBuilder subMenu) {
            return false;
        }

        public void onCloseMenu(MenuBuilder menu2, boolean allMenusAreClosing) {
        }

        public boolean flagActionItems() {
            return false;
        }

        public boolean expandItemActionView(MenuBuilder menu2, MenuItemImpl item) {
            ActionBarView.this.mExpandedActionView = item.getActionView();
            ActionBarView.this.mExpandedHomeLayout.setIcon(ActionBarView.this.mIcon.getConstantState().newDrawable(ActionBarView.this.getResources()));
            this.mCurrentExpandedItem = item;
            if (ActionBarView.this.mExpandedActionView.getParent() != ActionBarView.this) {
                ActionBarView.this.addView(ActionBarView.this.mExpandedActionView);
            }
            if (ActionBarView.this.mExpandedHomeLayout.getParent() != ActionBarView.this) {
                ActionBarView.this.addView(ActionBarView.this.mExpandedHomeLayout);
            }
            ActionBarView.this.mHomeLayout.setVisibility(8);
            if (ActionBarView.this.mTitleLayout != null) {
                ActionBarView.this.mTitleLayout.setVisibility(8);
            }
            if (ActionBarView.this.mTabScrollView != null) {
                ActionBarView.this.mTabScrollView.setVisibility(8);
            }
            if (ActionBarView.this.mSpinner != null) {
                ActionBarView.this.mSpinner.setVisibility(8);
            }
            if (ActionBarView.this.mCustomNavView != null) {
                ActionBarView.this.mCustomNavView.setVisibility(8);
            }
            ActionBarView.this.requestLayout();
            item.setActionViewExpanded(true);
            if (ActionBarView.this.mExpandedActionView instanceof CollapsibleActionView) {
                ((CollapsibleActionView)((Object)ActionBarView.this.mExpandedActionView)).onActionViewExpanded();
            }
            return true;
        }

        public boolean collapseItemActionView(MenuBuilder menu2, MenuItemImpl item) {
            if (ActionBarView.this.mExpandedActionView instanceof CollapsibleActionView) {
                ((CollapsibleActionView)((Object)ActionBarView.this.mExpandedActionView)).onActionViewCollapsed();
            }
            ActionBarView.this.removeView(ActionBarView.this.mExpandedActionView);
            ActionBarView.this.removeView(ActionBarView.this.mExpandedHomeLayout);
            ActionBarView.this.mExpandedActionView = null;
            if ((ActionBarView.this.mDisplayOptions & 2) != 0) {
                ActionBarView.this.mHomeLayout.setVisibility(0);
            }
            if ((ActionBarView.this.mDisplayOptions & 8) != 0) {
                if (ActionBarView.this.mTitleLayout == null) {
                    ActionBarView.this.initTitle();
                } else {
                    ActionBarView.this.mTitleLayout.setVisibility(0);
                }
            }
            if (ActionBarView.this.mTabScrollView != null && ActionBarView.this.mNavigationMode == 2) {
                ActionBarView.this.mTabScrollView.setVisibility(0);
            }
            if (ActionBarView.this.mSpinner != null && ActionBarView.this.mNavigationMode == 1) {
                ActionBarView.this.mSpinner.setVisibility(0);
            }
            if (ActionBarView.this.mCustomNavView != null && (ActionBarView.this.mDisplayOptions & 0x10) != 0) {
                ActionBarView.this.mCustomNavView.setVisibility(0);
            }
            ActionBarView.this.mExpandedHomeLayout.setIcon(null);
            this.mCurrentExpandedItem = null;
            ActionBarView.this.requestLayout();
            item.setActionViewExpanded(false);
            return true;
        }

        public int getId() {
            return 0;
        }

        public Parcelable onSaveInstanceState() {
            return null;
        }

        public void onRestoreInstanceState(Parcelable state) {
        }
    }

    private static class HomeView
    extends FrameLayout {
        private View mUpView;
        private ImageView mIconView;
        private int mUpWidth;

        public HomeView(Context context) {
            this(context, null);
        }

        public HomeView(Context context, AttributeSet attrs) {
            super(context, attrs);
        }

        public void setUp(boolean isUp) {
            this.mUpView.setVisibility(isUp ? 0 : 8);
        }

        public void setIcon(Drawable icon) {
            this.mIconView.setImageDrawable(icon);
        }

        public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
            this.onPopulateAccessibilityEvent(event);
            return true;
        }

        public void onPopulateAccessibilityEvent(AccessibilityEvent event) {
            super.onPopulateAccessibilityEvent(event);
            CharSequence cdesc = this.getContentDescription();
            if (!TextUtils.isEmpty(cdesc)) {
                event.getText().add(cdesc);
            }
        }

        public boolean dispatchHoverEvent(MotionEvent event) {
            return this.onHoverEvent(event);
        }

        protected void onFinishInflate() {
            this.mUpView = this.findViewById(16908859);
            this.mIconView = (ImageView)this.findViewById(16908332);
        }

        public int getLeftOffset() {
            return this.mUpView.getVisibility() == 8 ? this.mUpWidth : 0;
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            this.measureChildWithMargins(this.mUpView, widthMeasureSpec, 0, heightMeasureSpec, 0);
            FrameLayout.LayoutParams upLp = (FrameLayout.LayoutParams)this.mUpView.getLayoutParams();
            this.mUpWidth = upLp.leftMargin + this.mUpView.getMeasuredWidth() + upLp.rightMargin;
            int width = this.mUpView.getVisibility() == 8 ? 0 : this.mUpWidth;
            int height = upLp.topMargin + this.mUpView.getMeasuredHeight() + upLp.bottomMargin;
            this.measureChildWithMargins(this.mIconView, widthMeasureSpec, width, heightMeasureSpec, 0);
            FrameLayout.LayoutParams iconLp = (FrameLayout.LayoutParams)this.mIconView.getLayoutParams();
            width += iconLp.leftMargin + this.mIconView.getMeasuredWidth() + iconLp.rightMargin;
            height = Math.max(height, iconLp.topMargin + this.mIconView.getMeasuredHeight() + iconLp.bottomMargin);
            int widthMode = View.MeasureSpec.getMode(widthMeasureSpec);
            int heightMode = View.MeasureSpec.getMode(heightMeasureSpec);
            int widthSize = View.MeasureSpec.getSize(widthMeasureSpec);
            int heightSize = View.MeasureSpec.getSize(heightMeasureSpec);
            switch (widthMode) {
                case -2147483648: {
                    width = Math.min(width, widthSize);
                    break;
                }
                case 0x40000000: {
                    width = widthSize;
                    break;
                }
            }
            switch (heightMode) {
                case -2147483648: {
                    height = Math.min(height, heightSize);
                    break;
                }
                case 0x40000000: {
                    height = heightSize;
                    break;
                }
            }
            this.setMeasuredDimension(width, height);
        }

        protected void onLayout(boolean changed, int l, int t, int r, int b) {
            int vCenter = (b - t) / 2;
            int width = r - l;
            int upOffset = 0;
            if (this.mUpView.getVisibility() != 8) {
                FrameLayout.LayoutParams upLp = (FrameLayout.LayoutParams)this.mUpView.getLayoutParams();
                int upHeight = this.mUpView.getMeasuredHeight();
                int upWidth = this.mUpView.getMeasuredWidth();
                int upTop = vCenter - upHeight / 2;
                this.mUpView.layout(0, upTop, upWidth, upTop + upHeight);
                upOffset = upLp.leftMargin + upWidth + upLp.rightMargin;
                width -= upOffset;
                l += upOffset;
            }
            FrameLayout.LayoutParams iconLp = (FrameLayout.LayoutParams)this.mIconView.getLayoutParams();
            int iconHeight = this.mIconView.getMeasuredHeight();
            int iconWidth = this.mIconView.getMeasuredWidth();
            int hCenter = (r - l) / 2;
            int iconLeft = upOffset + Math.max(iconLp.leftMargin, hCenter - iconWidth / 2);
            int iconTop = Math.max(iconLp.topMargin, vCenter - iconHeight / 2);
            this.mIconView.layout(iconLeft, iconTop, iconLeft + iconWidth, iconTop + iconHeight);
        }
    }

    static class SavedState
    extends View.BaseSavedState {
        int expandedMenuItemId;
        boolean isOverflowOpen;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.expandedMenuItemId = in.readInt();
            this.isOverflowOpen = in.readInt() != 0;
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.expandedMenuItemId);
            out.writeInt(this.isOverflowOpen ? 1 : 0);
        }
    }
}

