/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.graphics.Typeface;
import android.os.Handler;
import android.provider.Settings;
import android.text.format.DateFormat;
import android.util.AttributeSet;
import android.view.View;
import android.widget.RelativeLayout;
import android.widget.TextView;
import java.lang.ref.WeakReference;
import java.text.DateFormatSymbols;
import java.util.Calendar;

public class DigitalClock
extends RelativeLayout {
    private static final String SYSTEM = "/system/fonts/";
    private static final String SYSTEM_FONT_TIME_BACKGROUND = "/system/fonts/AndroidClock.ttf";
    private static final String SYSTEM_FONT_TIME_FOREGROUND = "/system/fonts/AndroidClock_Highlight.ttf";
    private static final String M12 = "h:mm";
    private static final String M24 = "kk:mm";
    private Calendar mCalendar;
    private String mFormat;
    private TextView mTimeDisplayBackground;
    private TextView mTimeDisplayForeground;
    private AmPm mAmPm;
    private ContentObserver mFormatChangeObserver;
    private int mAttached = 0;
    private final Handler mHandler = new Handler();
    private BroadcastReceiver mIntentReceiver;
    private static final Typeface sBackgroundFont = Typeface.createFromFile("/system/fonts/AndroidClock.ttf");
    private static final Typeface sForegroundFont = Typeface.createFromFile("/system/fonts/AndroidClock_Highlight.ttf");

    public DigitalClock(Context context) {
        this(context, null);
    }

    public DigitalClock(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mTimeDisplayBackground = (TextView)this.findViewById(16908969);
        this.mTimeDisplayBackground.setTypeface(sBackgroundFont);
        this.mTimeDisplayBackground.setVisibility(4);
        this.mTimeDisplayForeground = (TextView)this.findViewById(16908970);
        this.mTimeDisplayForeground.setTypeface(sForegroundFont);
        this.mAmPm = new AmPm(this, null);
        this.mCalendar = Calendar.getInstance();
        this.setDateFormat();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        ++this.mAttached;
        if (this.mIntentReceiver == null) {
            this.mIntentReceiver = new TimeChangedReceiver(this);
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.intent.action.TIME_TICK");
            filter.addAction("android.intent.action.TIME_SET");
            filter.addAction("android.intent.action.TIMEZONE_CHANGED");
            this.mContext.registerReceiver(this.mIntentReceiver, filter);
        }
        if (this.mFormatChangeObserver == null) {
            this.mFormatChangeObserver = new FormatChangeObserver(this);
            this.mContext.getContentResolver().registerContentObserver(Settings.System.CONTENT_URI, true, this.mFormatChangeObserver);
        }
        this.updateTime();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        --this.mAttached;
        if (this.mIntentReceiver != null) {
            this.mContext.unregisterReceiver(this.mIntentReceiver);
        }
        if (this.mFormatChangeObserver != null) {
            this.mContext.getContentResolver().unregisterContentObserver(this.mFormatChangeObserver);
        }
        this.mFormatChangeObserver = null;
        this.mIntentReceiver = null;
    }

    void updateTime(Calendar c) {
        this.mCalendar = c;
        this.updateTime();
    }

    public void updateTime() {
        this.mCalendar.setTimeInMillis(System.currentTimeMillis());
        CharSequence newTime = DateFormat.format((CharSequence)this.mFormat, this.mCalendar);
        this.mTimeDisplayBackground.setText(newTime);
        this.mTimeDisplayForeground.setText(newTime);
        this.mAmPm.setIsMorning(this.mCalendar.get(9) == 0);
    }

    private void setDateFormat() {
        this.mFormat = DateFormat.is24HourFormat(this.getContext()) ? M24 : M12;
        this.mAmPm.setShowAmPm(this.mFormat.equals(M12));
    }

    private static class FormatChangeObserver
    extends ContentObserver {
        private WeakReference<DigitalClock> mClock;
        private Context mContext;

        public FormatChangeObserver(DigitalClock clock) {
            super(new Handler());
            this.mClock = new WeakReference<DigitalClock>(clock);
            this.mContext = clock.getContext();
        }

        public void onChange(boolean selfChange) {
            DigitalClock digitalClock = (DigitalClock)this.mClock.get();
            if (digitalClock != null) {
                digitalClock.setDateFormat();
                digitalClock.updateTime();
            } else {
                try {
                    this.mContext.getContentResolver().unregisterContentObserver(this);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        }
    }

    static class AmPm {
        private TextView mAmPmTextView;
        private String mAmString;
        private String mPmString;

        AmPm(View parent, Typeface tf) {
            if (this.mAmPmTextView != null && tf != null) {
                this.mAmPmTextView.setTypeface(tf);
            }
            String[] ampm = new DateFormatSymbols().getAmPmStrings();
            this.mAmString = ampm[0];
            this.mPmString = ampm[1];
        }

        void setShowAmPm(boolean show) {
            if (this.mAmPmTextView != null) {
                this.mAmPmTextView.setVisibility(show ? 0 : 8);
            }
        }

        void setIsMorning(boolean isMorning) {
            if (this.mAmPmTextView != null) {
                this.mAmPmTextView.setText(isMorning ? this.mAmString : this.mPmString);
            }
        }
    }

    private static class TimeChangedReceiver
    extends BroadcastReceiver {
        private WeakReference<DigitalClock> mClock;
        private Context mContext;

        public TimeChangedReceiver(DigitalClock clock) {
            this.mClock = new WeakReference<DigitalClock>(clock);
            this.mContext = clock.getContext();
        }

        public void onReceive(Context context, Intent intent) {
            final boolean timezoneChanged = intent.getAction().equals("android.intent.action.TIMEZONE_CHANGED");
            final DigitalClock clock = (DigitalClock)this.mClock.get();
            if (clock != null) {
                clock.mHandler.post(new Runnable(){

                    public void run() {
                        if (timezoneChanged) {
                            clock.mCalendar = Calendar.getInstance();
                        }
                        clock.updateTime();
                    }
                });
            } else {
                try {
                    this.mContext.unregisterReceiver(this);
                }
                catch (RuntimeException e) {
                    // empty catch block
                }
            }
        }
    }
}

