/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.multiwaveview;

import android.R;
import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Vibrator;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import android.view.Gravity;
import android.view.MotionEvent;
import android.view.View;
import android.view.accessibility.AccessibilityManager;
import com.android.internal.R;
import com.android.internal.widget.multiwaveview.Ease;
import com.android.internal.widget.multiwaveview.PointCloud;
import com.android.internal.widget.multiwaveview.TargetDrawable;
import com.android.internal.widget.multiwaveview.Tweener;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlowPadView
extends View {
    private static final String TAG = "GlowPadView";
    private static final boolean DEBUG = false;
    private static final int STATE_IDLE = 0;
    private static final int STATE_START = 1;
    private static final int STATE_FIRST_TOUCH = 2;
    private static final int STATE_TRACKING = 3;
    private static final int STATE_SNAP = 4;
    private static final int STATE_FINISH = 5;
    private static final float SNAP_MARGIN_DEFAULT = 20.0f;
    private static final int WAVE_ANIMATION_DURATION = 1350;
    private static final int RETURN_TO_HOME_DELAY = 1200;
    private static final int RETURN_TO_HOME_DURATION = 200;
    private static final int HIDE_ANIMATION_DELAY = 200;
    private static final int HIDE_ANIMATION_DURATION = 200;
    private static final int SHOW_ANIMATION_DURATION = 200;
    private static final int SHOW_ANIMATION_DELAY = 50;
    private static final int INITIAL_SHOW_HANDLE_DURATION = 200;
    private static final int REVEAL_GLOW_DELAY = 0;
    private static final int REVEAL_GLOW_DURATION = 0;
    private static final float TAP_RADIUS_SCALE_ACCESSIBILITY_ENABLED = 1.3f;
    private static final float TARGET_SCALE_EXPANDED = 1.0f;
    private static final float TARGET_SCALE_COLLAPSED = 0.8f;
    private static final float RING_SCALE_EXPANDED = 1.0f;
    private static final float RING_SCALE_COLLAPSED = 0.5f;
    private ArrayList<TargetDrawable> mTargetDrawables = new ArrayList();
    private AnimationBundle mWaveAnimations = new AnimationBundle();
    private AnimationBundle mTargetAnimations = new AnimationBundle();
    private AnimationBundle mGlowAnimations = new AnimationBundle();
    private ArrayList<String> mTargetDescriptions;
    private ArrayList<String> mDirectionDescriptions;
    private OnTriggerListener mOnTriggerListener;
    private TargetDrawable mHandleDrawable;
    private TargetDrawable mOuterRing;
    private Vibrator mVibrator;
    private int mFeedbackCount = 3;
    private int mVibrationDuration = 0;
    private int mGrabbedState;
    private int mActiveTarget = -1;
    private float mGlowRadius;
    private float mWaveCenterX;
    private float mWaveCenterY;
    private int mMaxTargetHeight;
    private int mMaxTargetWidth;
    private float mOuterRadius = 0.0f;
    private float mSnapMargin = 0.0f;
    private boolean mDragging;
    private int mNewTargetResources;
    private Animator.AnimatorListener mResetListener = new AnimatorListenerAdapter(){

        public void onAnimationEnd(Animator animator2) {
            GlowPadView.this.switchToState(0, GlowPadView.this.mWaveCenterX, GlowPadView.this.mWaveCenterY);
            GlowPadView.this.dispatchOnFinishFinalAnimation();
        }
    };
    private Animator.AnimatorListener mResetListenerWithPing = new AnimatorListenerAdapter(){

        public void onAnimationEnd(Animator animator2) {
            GlowPadView.this.ping();
            GlowPadView.this.switchToState(0, GlowPadView.this.mWaveCenterX, GlowPadView.this.mWaveCenterY);
            GlowPadView.this.dispatchOnFinishFinalAnimation();
        }
    };
    private ValueAnimator.AnimatorUpdateListener mUpdateListener = new ValueAnimator.AnimatorUpdateListener(){

        public void onAnimationUpdate(ValueAnimator animation) {
            GlowPadView.this.invalidate();
        }
    };
    private boolean mAnimatingTargets;
    private Animator.AnimatorListener mTargetUpdateListener = new AnimatorListenerAdapter(){

        public void onAnimationEnd(Animator animator2) {
            if (GlowPadView.this.mNewTargetResources != 0) {
                GlowPadView.this.internalSetTargetResources(GlowPadView.this.mNewTargetResources);
                GlowPadView.this.mNewTargetResources = 0;
                GlowPadView.this.hideTargets(false, false);
            }
            GlowPadView.this.mAnimatingTargets = false;
        }
    };
    private int mTargetResourceId;
    private int mTargetDescriptionsResourceId;
    private int mDirectionDescriptionsResourceId;
    private boolean mAlwaysTrackFinger;
    private int mHorizontalInset;
    private int mVerticalInset;
    private int mGravity = 48;
    private boolean mInitialLayout = true;
    private Tweener mBackgroundAnimator;
    private PointCloud mPointCloud;
    private float mInnerRadius;

    public GlowPadView(Context context) {
        this(context, null);
    }

    public GlowPadView(Context context, AttributeSet attrs) {
        super(context, attrs);
        int resourceId;
        Resources res = context.getResources();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.GlowPadView);
        this.mInnerRadius = a.getDimension(0, this.mInnerRadius);
        this.mOuterRadius = a.getDimension(8, this.mOuterRadius);
        this.mSnapMargin = a.getDimension(10, this.mSnapMargin);
        this.mVibrationDuration = a.getInt(9, this.mVibrationDuration);
        this.mFeedbackCount = a.getInt(11, this.mFeedbackCount);
        this.mHandleDrawable = new TargetDrawable(res, a.peekValue((int)7).resourceId);
        this.mHandleDrawable.setState(TargetDrawable.STATE_INACTIVE);
        this.mOuterRing = new TargetDrawable(res, this.getResourceId(a, 3));
        this.mAlwaysTrackFinger = a.getBoolean(12, false);
        int pointId = this.getResourceId(a, 4);
        Drawable pointDrawable = pointId != 0 ? res.getDrawable(pointId) : null;
        this.mGlowRadius = a.getDimension(5, 0.0f);
        TypedValue outValue = new TypedValue();
        if (a.getValue(6, outValue)) {
            this.internalSetTargetResources(outValue.resourceId);
        }
        if (this.mTargetDrawables == null || this.mTargetDrawables.size() == 0) {
            throw new IllegalStateException("Must specify at least one target drawable");
        }
        if (a.getValue(1, outValue)) {
            resourceId = outValue.resourceId;
            if (resourceId == 0) {
                throw new IllegalStateException("Must specify target descriptions");
            }
            this.setTargetDescriptionsResourceId(resourceId);
        }
        if (a.getValue(2, outValue)) {
            resourceId = outValue.resourceId;
            if (resourceId == 0) {
                throw new IllegalStateException("Must specify direction descriptions");
            }
            this.setDirectionDescriptionsResourceId(resourceId);
        }
        a.recycle();
        a = context.obtainStyledAttributes(attrs, R.styleable.LinearLayout);
        this.mGravity = a.getInt(0, 48);
        a.recycle();
        this.setVibrateEnabled(this.mVibrationDuration > 0);
        this.assignDefaultsIfNeeded();
        this.mPointCloud = new PointCloud(pointDrawable);
        this.mPointCloud.makePointCloud(this.mInnerRadius, this.mOuterRadius);
        this.mPointCloud.glowManager.setRadius(this.mGlowRadius);
    }

    private int getResourceId(TypedArray a, int id2) {
        TypedValue tv = a.peekValue(id2);
        return tv == null ? 0 : tv.resourceId;
    }

    private void dump() {
        Log.v(TAG, "Outer Radius = " + this.mOuterRadius);
        Log.v(TAG, "SnapMargin = " + this.mSnapMargin);
        Log.v(TAG, "FeedbackCount = " + this.mFeedbackCount);
        Log.v(TAG, "VibrationDuration = " + this.mVibrationDuration);
        Log.v(TAG, "GlowRadius = " + this.mGlowRadius);
        Log.v(TAG, "WaveCenterX = " + this.mWaveCenterX);
        Log.v(TAG, "WaveCenterY = " + this.mWaveCenterY);
    }

    public void suspendAnimations() {
        this.mWaveAnimations.setSuspended(true);
        this.mTargetAnimations.setSuspended(true);
        this.mGlowAnimations.setSuspended(true);
    }

    public void resumeAnimations() {
        this.mWaveAnimations.setSuspended(false);
        this.mTargetAnimations.setSuspended(false);
        this.mGlowAnimations.setSuspended(false);
        this.mWaveAnimations.start();
        this.mTargetAnimations.start();
        this.mGlowAnimations.start();
    }

    @Override
    protected int getSuggestedMinimumWidth() {
        return (int)(Math.max((float)this.mOuterRing.getWidth(), 2.0f * this.mOuterRadius) + (float)this.mMaxTargetWidth);
    }

    @Override
    protected int getSuggestedMinimumHeight() {
        return (int)(Math.max((float)this.mOuterRing.getHeight(), 2.0f * this.mOuterRadius) + (float)this.mMaxTargetHeight);
    }

    private int resolveMeasured(int measureSpec, int desired) {
        int result = 0;
        int specSize = View.MeasureSpec.getSize(measureSpec);
        switch (View.MeasureSpec.getMode(measureSpec)) {
            case 0: {
                result = desired;
                break;
            }
            case -2147483648: {
                result = Math.min(specSize, desired);
                break;
            }
            default: {
                result = specSize;
            }
        }
        return result;
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int minimumWidth = this.getSuggestedMinimumWidth();
        int minimumHeight = this.getSuggestedMinimumHeight();
        int computedWidth = this.resolveMeasured(widthMeasureSpec, minimumWidth);
        int computedHeight = this.resolveMeasured(heightMeasureSpec, minimumHeight);
        this.computeInsets(computedWidth - minimumWidth, computedHeight - minimumHeight);
        this.setMeasuredDimension(computedWidth, computedHeight);
    }

    private void switchToState(int state, float x, float y) {
        switch (state) {
            case 0: {
                this.deactivateTargets();
                this.hideGlow(0, 0, 0.0f, null);
                this.startBackgroundAnimation(0, 0.0f);
                this.mHandleDrawable.setState(TargetDrawable.STATE_INACTIVE);
                this.mHandleDrawable.setAlpha(1.0f);
                break;
            }
            case 1: {
                this.startBackgroundAnimation(0, 0.0f);
                break;
            }
            case 2: {
                this.mHandleDrawable.setAlpha(0.0f);
                this.deactivateTargets();
                this.showTargets(true);
                this.startBackgroundAnimation(200, 1.0f);
                this.setGrabbedState(1);
                if (!AccessibilityManager.getInstance(this.mContext).isEnabled()) break;
                this.announceTargets();
                break;
            }
            case 3: {
                this.mHandleDrawable.setAlpha(0.0f);
                this.showGlow(0, 0, 1.0f, null);
                break;
            }
            case 4: {
                this.mHandleDrawable.setAlpha(0.0f);
                this.showGlow(0, 0, 0.0f, null);
                break;
            }
            case 5: {
                this.doFinish();
            }
        }
    }

    private void showGlow(int duration, int delay, float finalAlpha, Animator.AnimatorListener finishListener) {
        this.mGlowAnimations.cancel();
        this.mGlowAnimations.add(Tweener.to(this.mPointCloud.glowManager, duration, "ease", Ease.Cubic.easeIn, "delay", delay, "alpha", Float.valueOf(finalAlpha), "onUpdate", this.mUpdateListener, "onComplete", finishListener));
        this.mGlowAnimations.start();
    }

    private void hideGlow(int duration, int delay, float finalAlpha, Animator.AnimatorListener finishListener) {
        this.mGlowAnimations.cancel();
        this.mGlowAnimations.add(Tweener.to(this.mPointCloud.glowManager, duration, "ease", Ease.Quart.easeOut, "delay", delay, "alpha", Float.valueOf(finalAlpha), "x", Float.valueOf(0.0f), "y", Float.valueOf(0.0f), "onUpdate", this.mUpdateListener, "onComplete", finishListener));
        this.mGlowAnimations.start();
    }

    private void deactivateTargets() {
        int count = this.mTargetDrawables.size();
        for (int i = 0; i < count; ++i) {
            TargetDrawable target = this.mTargetDrawables.get(i);
            target.setState(TargetDrawable.STATE_INACTIVE);
        }
        this.mActiveTarget = -1;
    }

    private void dispatchTriggerEvent(int whichTarget) {
        this.vibrate();
        if (this.mOnTriggerListener != null) {
            this.mOnTriggerListener.onTrigger(this, whichTarget);
        }
    }

    private void dispatchOnFinishFinalAnimation() {
        if (this.mOnTriggerListener != null) {
            this.mOnTriggerListener.onFinishFinalAnimation();
        }
    }

    private void doFinish() {
        boolean targetHit;
        int activeTarget = this.mActiveTarget;
        boolean bl = targetHit = activeTarget != -1;
        if (targetHit) {
            this.highlightSelected(activeTarget);
            this.hideGlow(200, 1200, 0.0f, this.mResetListener);
            this.dispatchTriggerEvent(activeTarget);
            if (!this.mAlwaysTrackFinger) {
                this.mTargetAnimations.stop();
            }
        } else {
            this.hideGlow(200, 0, 0.0f, this.mResetListenerWithPing);
            this.hideTargets(true, false);
        }
        this.setGrabbedState(0);
    }

    private void highlightSelected(int activeTarget) {
        this.mTargetDrawables.get(activeTarget).setState(TargetDrawable.STATE_ACTIVE);
        this.hideUnselected(activeTarget);
    }

    private void hideUnselected(int active) {
        for (int i = 0; i < this.mTargetDrawables.size(); ++i) {
            if (i == active) continue;
            this.mTargetDrawables.get(i).setAlpha(0.0f);
        }
    }

    private void hideTargets(boolean animate, boolean expanded) {
        this.mTargetAnimations.cancel();
        this.mAnimatingTargets = animate;
        int duration = animate ? 200 : 0;
        int delay = animate ? 200 : 0;
        float targetScale = expanded ? 1.0f : 0.8f;
        int length = this.mTargetDrawables.size();
        TimeInterpolator interpolator2 = Ease.Cubic.easeOut;
        for (int i = 0; i < length; ++i) {
            TargetDrawable target = this.mTargetDrawables.get(i);
            target.setState(TargetDrawable.STATE_INACTIVE);
            this.mTargetAnimations.add(Tweener.to(target, duration, "ease", interpolator2, "alpha", Float.valueOf(0.0f), "scaleX", Float.valueOf(targetScale), "scaleY", Float.valueOf(targetScale), "delay", delay, "onUpdate", this.mUpdateListener));
        }
        float ringScaleTarget = expanded ? 1.0f : 0.5f;
        this.mTargetAnimations.add(Tweener.to(this.mOuterRing, duration, "ease", interpolator2, "alpha", Float.valueOf(0.0f), "scaleX", Float.valueOf(ringScaleTarget), "scaleY", Float.valueOf(ringScaleTarget), "delay", delay, "onUpdate", this.mUpdateListener, "onComplete", this.mTargetUpdateListener));
        this.mTargetAnimations.start();
    }

    private void showTargets(boolean animate) {
        this.mTargetAnimations.stop();
        this.mAnimatingTargets = animate;
        int delay = animate ? 50 : 0;
        int duration = animate ? 200 : 0;
        int length = this.mTargetDrawables.size();
        for (int i = 0; i < length; ++i) {
            TargetDrawable target = this.mTargetDrawables.get(i);
            target.setState(TargetDrawable.STATE_INACTIVE);
            this.mTargetAnimations.add(Tweener.to(target, duration, "ease", Ease.Cubic.easeOut, "alpha", Float.valueOf(1.0f), "scaleX", Float.valueOf(1.0f), "scaleY", Float.valueOf(1.0f), "delay", delay, "onUpdate", this.mUpdateListener));
        }
        this.mTargetAnimations.add(Tweener.to(this.mOuterRing, duration, "ease", Ease.Cubic.easeOut, "alpha", Float.valueOf(1.0f), "scaleX", Float.valueOf(1.0f), "scaleY", Float.valueOf(1.0f), "delay", delay, "onUpdate", this.mUpdateListener, "onComplete", this.mTargetUpdateListener));
        this.mTargetAnimations.start();
    }

    private void vibrate() {
        if (this.mVibrator != null) {
            this.mVibrator.vibrate(this.mVibrationDuration);
        }
    }

    private ArrayList<TargetDrawable> loadDrawableArray(int resourceId) {
        Resources res = this.getContext().getResources();
        TypedArray array2 = res.obtainTypedArray(resourceId);
        int count = array2.length();
        ArrayList<TargetDrawable> drawables = new ArrayList<TargetDrawable>(count);
        for (int i = 0; i < count; ++i) {
            TypedValue value = array2.peekValue(i);
            TargetDrawable target = new TargetDrawable(res, value != null ? value.resourceId : 0);
            drawables.add(target);
        }
        array2.recycle();
        return drawables;
    }

    private void internalSetTargetResources(int resourceId) {
        ArrayList<TargetDrawable> targets = this.loadDrawableArray(resourceId);
        this.mTargetDrawables = targets;
        this.mTargetResourceId = resourceId;
        int maxWidth = this.mHandleDrawable.getWidth();
        int maxHeight = this.mHandleDrawable.getHeight();
        int count = targets.size();
        for (int i = 0; i < count; ++i) {
            TargetDrawable target = targets.get(i);
            maxWidth = Math.max(maxWidth, target.getWidth());
            maxHeight = Math.max(maxHeight, target.getHeight());
        }
        if (this.mMaxTargetWidth != maxWidth || this.mMaxTargetHeight != maxHeight) {
            this.mMaxTargetWidth = maxWidth;
            this.mMaxTargetHeight = maxHeight;
            this.requestLayout();
        } else {
            this.updateTargetPositions(this.mWaveCenterX, this.mWaveCenterY);
            this.updatePointCloudPosition(this.mWaveCenterX, this.mWaveCenterY);
        }
    }

    public void setTargetResources(int resourceId) {
        if (this.mAnimatingTargets) {
            this.mNewTargetResources = resourceId;
        } else {
            this.internalSetTargetResources(resourceId);
        }
    }

    public int getTargetResourceId() {
        return this.mTargetResourceId;
    }

    public void setTargetDescriptionsResourceId(int resourceId) {
        this.mTargetDescriptionsResourceId = resourceId;
        if (this.mTargetDescriptions != null) {
            this.mTargetDescriptions.clear();
        }
    }

    public int getTargetDescriptionsResourceId() {
        return this.mTargetDescriptionsResourceId;
    }

    public void setDirectionDescriptionsResourceId(int resourceId) {
        this.mDirectionDescriptionsResourceId = resourceId;
        if (this.mDirectionDescriptions != null) {
            this.mDirectionDescriptions.clear();
        }
    }

    public int getDirectionDescriptionsResourceId() {
        return this.mDirectionDescriptionsResourceId;
    }

    public void setVibrateEnabled(boolean enabled) {
        this.mVibrator = enabled && this.mVibrator == null ? (Vibrator)this.getContext().getSystemService("vibrator") : null;
    }

    public void ping() {
        if (this.mFeedbackCount > 0) {
            long t;
            boolean doWaveAnimation = true;
            AnimationBundle waveAnimations = this.mWaveAnimations;
            if (waveAnimations.size() > 0 && ((Tweener)waveAnimations.get((int)0)).animator.isRunning() && (t = ((Tweener)waveAnimations.get((int)0)).animator.getCurrentPlayTime()) < 675L) {
                doWaveAnimation = false;
            }
            if (doWaveAnimation) {
                this.startWaveAnimation();
            }
        }
    }

    private void stopAndHideWaveAnimation() {
        this.mWaveAnimations.cancel();
        this.mPointCloud.waveManager.setAlpha(0.0f);
    }

    private void startWaveAnimation() {
        this.mWaveAnimations.cancel();
        this.mPointCloud.waveManager.setAlpha(1.0f);
        this.mPointCloud.waveManager.setRadius((float)this.mHandleDrawable.getWidth() / 2.0f);
        this.mWaveAnimations.add(Tweener.to(this.mPointCloud.waveManager, 1350L, "ease", Ease.Quad.easeOut, "delay", 0, "radius", Float.valueOf(2.0f * this.mOuterRadius), "onUpdate", this.mUpdateListener, "onComplete", new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animator2) {
                ((GlowPadView)GlowPadView.this).mPointCloud.waveManager.setRadius(0.0f);
                ((GlowPadView)GlowPadView.this).mPointCloud.waveManager.setAlpha(0.0f);
            }
        }));
        this.mWaveAnimations.start();
    }

    public void reset(boolean animate) {
        this.mGlowAnimations.stop();
        this.mTargetAnimations.stop();
        this.startBackgroundAnimation(0, 0.0f);
        this.stopAndHideWaveAnimation();
        this.hideTargets(animate, false);
        this.hideGlow(0, 0, 1.0f, null);
        Tweener.reset();
    }

    private void startBackgroundAnimation(int duration, float alpha) {
        Drawable background = this.getBackground();
        if (this.mAlwaysTrackFinger && background != null) {
            if (this.mBackgroundAnimator != null) {
                this.mBackgroundAnimator.animator.cancel();
            }
            this.mBackgroundAnimator = Tweener.to(background, duration, "ease", Ease.Cubic.easeIn, "alpha", (int)(255.0f * alpha), "delay", 50);
            this.mBackgroundAnimator.animator.start();
        }
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        int action = event.getAction();
        boolean handled = false;
        switch (action) {
            case 0: {
                this.handleDown(event);
                this.handleMove(event);
                handled = true;
                break;
            }
            case 2: {
                this.handleMove(event);
                handled = true;
                break;
            }
            case 1: {
                this.handleMove(event);
                this.handleUp(event);
                handled = true;
                break;
            }
            case 3: {
                this.handleMove(event);
                this.handleCancel(event);
                handled = true;
            }
        }
        this.invalidate();
        return handled ? true : super.onTouchEvent(event);
    }

    private void updateGlowPosition(float x, float y) {
        this.mPointCloud.glowManager.setX(x);
        this.mPointCloud.glowManager.setY(y);
    }

    private void handleDown(MotionEvent event) {
        float eventX = event.getX();
        float eventY = event.getY();
        this.switchToState(1, eventX, eventY);
        if (!this.trySwitchToFirstTouchState(eventX, eventY)) {
            this.mDragging = false;
        } else {
            this.updateGlowPosition(eventX, eventY);
        }
    }

    private void handleUp(MotionEvent event) {
        this.switchToState(5, event.getX(), event.getY());
    }

    private void handleCancel(MotionEvent event) {
        this.switchToState(5, event.getX(), event.getY());
    }

    private void handleMove(MotionEvent event) {
        int activeTarget = -1;
        int historySize = event.getHistorySize();
        ArrayList<TargetDrawable> targets = this.mTargetDrawables;
        int ntargets = targets.size();
        float x = 0.0f;
        float y = 0.0f;
        for (int k = 0; k < historySize + 1; ++k) {
            float eventX = k < historySize ? event.getHistoricalX(k) : event.getX();
            float eventY = k < historySize ? event.getHistoricalY(k) : event.getY();
            float tx = eventX - this.mWaveCenterX;
            float ty = eventY - this.mWaveCenterY;
            float touchRadius = (float)Math.sqrt(this.dist2(tx, ty));
            float scale = touchRadius > this.mOuterRadius ? this.mOuterRadius / touchRadius : 1.0f;
            float limitX = tx * scale;
            float limitY = ty * scale;
            double angleRad = Math.atan2(-ty, tx);
            if (!this.mDragging) {
                this.trySwitchToFirstTouchState(eventX, eventY);
            }
            if (this.mDragging) {
                float snapRadius = this.mOuterRadius - this.mSnapMargin;
                float snapDistance2 = snapRadius * snapRadius;
                for (int i = 0; i < ntargets; ++i) {
                    boolean angleMatches;
                    TargetDrawable target = targets.get(i);
                    double targetMinRad = ((double)i - 0.5) * 2.0 * Math.PI / (double)ntargets;
                    double targetMaxRad = ((double)i + 0.5) * 2.0 * Math.PI / (double)ntargets;
                    if (!target.isEnabled()) continue;
                    boolean bl = angleMatches = angleRad > targetMinRad && angleRad <= targetMaxRad || angleRad + Math.PI * 2 > targetMinRad && angleRad + Math.PI * 2 <= targetMaxRad;
                    if (!angleMatches || !(this.dist2(tx, ty) > snapDistance2)) continue;
                    activeTarget = i;
                }
            }
            x = limitX;
            y = limitY;
        }
        if (!this.mDragging) {
            return;
        }
        if (activeTarget != -1) {
            this.switchToState(4, x, y);
            this.updateGlowPosition(x, y);
        } else {
            this.switchToState(3, x, y);
            this.updateGlowPosition(x, y);
        }
        if (this.mActiveTarget != activeTarget) {
            TargetDrawable target;
            if (this.mActiveTarget != -1 && (target = targets.get(this.mActiveTarget)).hasState(TargetDrawable.STATE_FOCUSED)) {
                target.setState(TargetDrawable.STATE_INACTIVE);
            }
            if (activeTarget != -1) {
                target = targets.get(activeTarget);
                if (target.hasState(TargetDrawable.STATE_FOCUSED)) {
                    target.setState(TargetDrawable.STATE_FOCUSED);
                }
                if (AccessibilityManager.getInstance(this.mContext).isEnabled()) {
                    String targetContentDescription = this.getTargetDescription(activeTarget);
                    this.announceForAccessibility(targetContentDescription);
                }
            }
        }
        this.mActiveTarget = activeTarget;
    }

    @Override
    public boolean onHoverEvent(MotionEvent event) {
        if (AccessibilityManager.getInstance(this.mContext).isTouchExplorationEnabled()) {
            int action = event.getAction();
            switch (action) {
                case 9: {
                    event.setAction(0);
                    break;
                }
                case 7: {
                    event.setAction(2);
                    break;
                }
                case 10: {
                    event.setAction(1);
                }
            }
            this.onTouchEvent(event);
            event.setAction(action);
        }
        return super.onHoverEvent(event);
    }

    private void setGrabbedState(int newState) {
        if (newState != this.mGrabbedState) {
            if (newState != 0) {
                this.vibrate();
            }
            this.mGrabbedState = newState;
            if (this.mOnTriggerListener != null) {
                if (newState == 0) {
                    this.mOnTriggerListener.onReleased(this, 1);
                } else {
                    this.mOnTriggerListener.onGrabbed(this, 1);
                }
                this.mOnTriggerListener.onGrabbedStateChange(this, newState);
            }
        }
    }

    private boolean trySwitchToFirstTouchState(float x, float y) {
        float tx = x - this.mWaveCenterX;
        float ty = y - this.mWaveCenterY;
        if (this.mAlwaysTrackFinger || this.dist2(tx, ty) <= this.getScaledGlowRadiusSquared()) {
            this.switchToState(2, x, y);
            this.updateGlowPosition(tx, ty);
            this.mDragging = true;
            return true;
        }
        return false;
    }

    private void assignDefaultsIfNeeded() {
        if (this.mOuterRadius == 0.0f) {
            this.mOuterRadius = (float)Math.max(this.mOuterRing.getWidth(), this.mOuterRing.getHeight()) / 2.0f;
        }
        if (this.mSnapMargin == 0.0f) {
            this.mSnapMargin = TypedValue.applyDimension(1, 20.0f, this.getContext().getResources().getDisplayMetrics());
        }
        if (this.mInnerRadius == 0.0f) {
            this.mInnerRadius = (float)this.mHandleDrawable.getWidth() / 10.0f;
        }
    }

    private void computeInsets(int dx, int dy) {
        int layoutDirection = this.getResolvedLayoutDirection();
        int absoluteGravity = Gravity.getAbsoluteGravity(this.mGravity, layoutDirection);
        switch (absoluteGravity & 7) {
            case 3: {
                this.mHorizontalInset = 0;
                break;
            }
            case 5: {
                this.mHorizontalInset = dx;
                break;
            }
            default: {
                this.mHorizontalInset = dx / 2;
            }
        }
        switch (absoluteGravity & 0x70) {
            case 48: {
                this.mVerticalInset = 0;
                break;
            }
            case 80: {
                this.mVerticalInset = dy;
                break;
            }
            default: {
                this.mVerticalInset = dy / 2;
            }
        }
    }

    @Override
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        int width = right - left;
        int height = bottom - top;
        float placementWidth = Math.max((float)this.mOuterRing.getWidth(), 2.0f * this.mOuterRadius);
        float placementHeight = Math.max((float)this.mOuterRing.getHeight(), 2.0f * this.mOuterRadius);
        float newWaveCenterX = (float)this.mHorizontalInset + Math.max((float)width, (float)this.mMaxTargetWidth + placementWidth) / 2.0f;
        float newWaveCenterY = (float)this.mVerticalInset + Math.max((float)height, (float)this.mMaxTargetHeight + placementHeight) / 2.0f;
        if (this.mInitialLayout) {
            this.stopAndHideWaveAnimation();
            this.hideTargets(false, false);
            this.mInitialLayout = false;
        }
        this.mOuterRing.setPositionX(newWaveCenterX);
        this.mOuterRing.setPositionY(newWaveCenterY);
        this.mHandleDrawable.setPositionX(newWaveCenterX);
        this.mHandleDrawable.setPositionY(newWaveCenterY);
        this.updateTargetPositions(newWaveCenterX, newWaveCenterY);
        this.updatePointCloudPosition(newWaveCenterX, newWaveCenterY);
        this.updateGlowPosition(newWaveCenterX, newWaveCenterY);
        this.mWaveCenterX = newWaveCenterX;
        this.mWaveCenterY = newWaveCenterY;
    }

    private void updateTargetPositions(float centerX, float centerY) {
        ArrayList<TargetDrawable> targets = this.mTargetDrawables;
        int size = targets.size();
        float alpha = (float)(Math.PI * -2 / (double)size);
        for (int i = 0; i < size; ++i) {
            TargetDrawable targetIcon = targets.get(i);
            float angle = alpha * (float)i;
            targetIcon.setPositionX(centerX);
            targetIcon.setPositionY(centerY);
            targetIcon.setX(this.mOuterRadius * (float)Math.cos(angle));
            targetIcon.setY(this.mOuterRadius * (float)Math.sin(angle));
        }
    }

    private void updatePointCloudPosition(float centerX, float centerY) {
        this.mPointCloud.setCenter(centerX, centerY);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        this.mPointCloud.draw(canvas);
        this.mOuterRing.draw(canvas);
        int ntargets = this.mTargetDrawables.size();
        for (int i = 0; i < ntargets; ++i) {
            TargetDrawable target = this.mTargetDrawables.get(i);
            if (target == null) continue;
            target.draw(canvas);
        }
        this.mHandleDrawable.draw(canvas);
    }

    public void setOnTriggerListener(OnTriggerListener listener) {
        this.mOnTriggerListener = listener;
    }

    private float square(float d) {
        return d * d;
    }

    private float dist2(float dx, float dy) {
        return dx * dx + dy * dy;
    }

    private float getScaledGlowRadiusSquared() {
        float scaledTapRadius = AccessibilityManager.getInstance(this.mContext).isEnabled() ? 1.3f * this.mGlowRadius : this.mGlowRadius;
        return this.square(scaledTapRadius);
    }

    private void announceTargets() {
        StringBuilder utterance = new StringBuilder();
        int targetCount = this.mTargetDrawables.size();
        for (int i = 0; i < targetCount; ++i) {
            String targetDescription = this.getTargetDescription(i);
            String directionDescription = this.getDirectionDescription(i);
            if (TextUtils.isEmpty(targetDescription) || TextUtils.isEmpty(directionDescription)) continue;
            String text = String.format(directionDescription, targetDescription);
            utterance.append(text);
        }
        if (utterance.length() > 0) {
            this.announceForAccessibility(utterance.toString());
        }
    }

    private String getTargetDescription(int index) {
        if (this.mTargetDescriptions == null || this.mTargetDescriptions.isEmpty()) {
            this.mTargetDescriptions = this.loadDescriptions(this.mTargetDescriptionsResourceId);
            if (this.mTargetDrawables.size() != this.mTargetDescriptions.size()) {
                Log.w(TAG, "The number of target drawables must be equal to the number of target descriptions.");
                return null;
            }
        }
        return this.mTargetDescriptions.get(index);
    }

    private String getDirectionDescription(int index) {
        if (this.mDirectionDescriptions == null || this.mDirectionDescriptions.isEmpty()) {
            this.mDirectionDescriptions = this.loadDescriptions(this.mDirectionDescriptionsResourceId);
            if (this.mTargetDrawables.size() != this.mDirectionDescriptions.size()) {
                Log.w(TAG, "The number of target drawables must be equal to the number of direction descriptions.");
                return null;
            }
        }
        return this.mDirectionDescriptions.get(index);
    }

    private ArrayList<String> loadDescriptions(int resourceId) {
        TypedArray array2 = this.getContext().getResources().obtainTypedArray(resourceId);
        int count = array2.length();
        ArrayList<String> targetContentDescriptions = new ArrayList<String>(count);
        for (int i = 0; i < count; ++i) {
            String contentDescription = array2.getString(i);
            targetContentDescriptions.add(contentDescription);
        }
        array2.recycle();
        return targetContentDescriptions;
    }

    public int getResourceIdForTarget(int index) {
        TargetDrawable drawable2 = this.mTargetDrawables.get(index);
        return drawable2 == null ? 0 : drawable2.getResourceId();
    }

    public void setEnableTarget(int resourceId, boolean enabled) {
        for (int i = 0; i < this.mTargetDrawables.size(); ++i) {
            TargetDrawable target = this.mTargetDrawables.get(i);
            if (target.getResourceId() != resourceId) continue;
            target.setEnabled(enabled);
            break;
        }
    }

    public int getTargetPosition(int resourceId) {
        for (int i = 0; i < this.mTargetDrawables.size(); ++i) {
            TargetDrawable target = this.mTargetDrawables.get(i);
            if (target.getResourceId() != resourceId) continue;
            return i;
        }
        return -1;
    }

    private boolean replaceTargetDrawables(Resources res, int existingResourceId, int newResourceId) {
        if (existingResourceId == 0 || newResourceId == 0) {
            return false;
        }
        boolean result = false;
        ArrayList<TargetDrawable> drawables = this.mTargetDrawables;
        int size = drawables.size();
        for (int i = 0; i < size; ++i) {
            TargetDrawable target = drawables.get(i);
            if (target == null || target.getResourceId() != existingResourceId) continue;
            target.setDrawable(res, newResourceId);
            result = true;
        }
        if (result) {
            this.requestLayout();
        }
        return result;
    }

    public boolean replaceTargetDrawablesIfPresent(ComponentName component, String name, int existingResId) {
        if (existingResId == 0) {
            return false;
        }
        boolean replaced = false;
        if (component != null) {
            try {
                int iconResId;
                PackageManager packageManager = this.mContext.getPackageManager();
                Bundle metaData = packageManager.getActivityInfo((ComponentName)component, (int)128).metaData;
                if (metaData != null && (iconResId = metaData.getInt(name)) != 0) {
                    Resources res = packageManager.getResourcesForActivity(component);
                    replaced = this.replaceTargetDrawables(res, existingResId, iconResId);
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.w(TAG, "Failed to swap drawable; " + component.flattenToShortString() + " not found", e);
            }
            catch (Resources.NotFoundException nfe) {
                Log.w(TAG, "Failed to swap drawable from " + component.flattenToShortString(), nfe);
            }
        }
        if (!replaced) {
            this.replaceTargetDrawables(this.mContext.getResources(), existingResId, existingResId);
        }
        return replaced;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AnimationBundle
    extends ArrayList<Tweener> {
        private static final long serialVersionUID = -6319262269245852568L;
        private boolean mSuspended;

        private AnimationBundle() {
        }

        public void start() {
            if (this.mSuspended) {
                return;
            }
            int count = this.size();
            for (int i = 0; i < count; ++i) {
                Tweener anim2 = (Tweener)this.get(i);
                anim2.animator.start();
            }
        }

        public void cancel() {
            int count = this.size();
            for (int i = 0; i < count; ++i) {
                Tweener anim2 = (Tweener)this.get(i);
                anim2.animator.cancel();
            }
            this.clear();
        }

        public void stop() {
            int count = this.size();
            for (int i = 0; i < count; ++i) {
                Tweener anim2 = (Tweener)this.get(i);
                anim2.animator.end();
            }
            this.clear();
        }

        public void setSuspended(boolean suspend) {
            this.mSuspended = suspend;
        }
    }

    public static interface OnTriggerListener {
        public static final int NO_HANDLE = 0;
        public static final int CENTER_HANDLE = 1;

        public void onGrabbed(View var1, int var2);

        public void onReleased(View var1, int var2);

        public void onTrigger(View var1, int var2);

        public void onGrabbedStateChange(View var1, int var2);

        public void onFinishFinalAnimation();
    }
}

