/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.impl;

import android.content.res.Configuration;
import android.os.HandlerThread_Delegate;
import android.os.Looper;
import android.util.DisplayMetrics;
import android.view.ViewConfiguration_Accessor;
import android.view.inputmethod.InputMethodManager;
import android.view.inputmethod.InputMethodManager_Accessor;
import com.android.ide.common.rendering.api.HardwareConfig;
import com.android.ide.common.rendering.api.LayoutLog;
import com.android.ide.common.rendering.api.RenderParams;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.Result;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.resources.Density;
import com.android.resources.ResourceType;
import com.android.resources.ScreenSize;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RenderAction<T extends RenderParams>
extends RenderResources.FrameworkResourceIdProvider {
    private static BridgeContext sCurrentContext = null;
    private final T mParams;
    private BridgeContext mContext;

    protected RenderAction(T t) {
        this.mParams = t;
    }

    public Result init(long l) {
        Result result = this.acquireLock(l);
        if (result != null) {
            return result;
        }
        HardwareConfig hardwareConfig = this.mParams.getHardwareConfig();
        DisplayMetrics displayMetrics = new DisplayMetrics();
        displayMetrics.densityDpi = hardwareConfig.getDensity().getDpiValue();
        displayMetrics.scaledDensity = displayMetrics.noncompatScaledDensity = (displayMetrics.density = (displayMetrics.noncompatDensity = (float)displayMetrics.densityDpi / 160.0f));
        displayMetrics.widthPixels = displayMetrics.noncompatWidthPixels = hardwareConfig.getScreenWidth();
        displayMetrics.heightPixels = displayMetrics.noncompatHeightPixels = hardwareConfig.getScreenHeight();
        displayMetrics.xdpi = displayMetrics.noncompatXdpi = hardwareConfig.getXdpi();
        displayMetrics.ydpi = displayMetrics.noncompatYdpi = hardwareConfig.getYdpi();
        RenderResources renderResources = this.mParams.getResources();
        this.mContext = new BridgeContext(this.mParams.getProjectKey(), displayMetrics, renderResources, this.mParams.getProjectCallback(), this.getConfiguration(), this.mParams.getTargetSdkVersion());
        this.setUp();
        return Result.Status.SUCCESS.createResult();
    }

    public Result acquire(long l) {
        if (this.mContext == null) {
            throw new IllegalStateException("After scene creation, #init() must be called");
        }
        Result result = this.acquireLock(l);
        if (result != null) {
            return result;
        }
        this.setUp();
        return Result.Status.SUCCESS.createResult();
    }

    private Result acquireLock(long l) {
        block5: {
            ReentrantLock reentrantLock = Bridge.getLock();
            if (!reentrantLock.isHeldByCurrentThread()) {
                try {
                    boolean bl = reentrantLock.tryLock(l, TimeUnit.MILLISECONDS);
                    if (!bl) {
                        return Result.Status.ERROR_TIMEOUT.createResult();
                    }
                    break block5;
                }
                catch (InterruptedException interruptedException) {
                    return Result.Status.ERROR_LOCK_INTERRUPTED.createResult();
                }
            }
            if (this.mContext != sCurrentContext) {
                throw new IllegalStateException("Acquiring different scenes from same thread without releases");
            }
            return Result.Status.SUCCESS.createResult();
        }
        return null;
    }

    public void release() {
        ReentrantLock reentrantLock = Bridge.getLock();
        if (reentrantLock.isHeldByCurrentThread()) {
            this.tearDown();
            reentrantLock.unlock();
        }
    }

    private void setUp() {
        this.mContext.initResources();
        sCurrentContext = this.mContext;
        InputMethodManager.getInstance(Looper.myLooper());
        LayoutLog layoutLog = this.mParams.getLog();
        Bridge.setLog(layoutLog);
        this.mContext.getRenderResources().setFrameworkResourceIdProvider((RenderResources.FrameworkResourceIdProvider)this);
        this.mContext.getRenderResources().setLogger(layoutLog);
    }

    private void tearDown() {
        this.mContext.disposeResources();
        HandlerThread_Delegate.cleanUp(sCurrentContext);
        ViewConfiguration_Accessor.clearConfigurations();
        InputMethodManager_Accessor.resetInstance();
        sCurrentContext = null;
        Bridge.setLog(null);
        this.mContext.getRenderResources().setFrameworkResourceIdProvider(null);
        this.mContext.getRenderResources().setLogger(null);
    }

    public static BridgeContext getCurrentContext() {
        return sCurrentContext;
    }

    protected T getParams() {
        return this.mParams;
    }

    protected BridgeContext getContext() {
        return this.mContext;
    }

    public LayoutLog getLog() {
        if (this.mParams != null) {
            return this.mParams.getLog();
        }
        return null;
    }

    protected void checkLock() {
        ReentrantLock reentrantLock = Bridge.getLock();
        if (!reentrantLock.isHeldByCurrentThread()) {
            throw new IllegalStateException("scene must be acquired first. see #acquire(long)");
        }
        if (sCurrentContext != this.mContext) {
            throw new IllegalStateException("Thread acquired a scene but is rendering a different one");
        }
    }

    private Configuration getConfiguration() {
        Density density;
        Configuration configuration = new Configuration();
        HardwareConfig hardwareConfig = this.mParams.getHardwareConfig();
        ScreenSize screenSize = hardwareConfig.getScreenSize();
        if (screenSize != null) {
            switch (screenSize) {
                case SMALL: {
                    configuration.screenLayout |= 1;
                    break;
                }
                case NORMAL: {
                    configuration.screenLayout |= 2;
                    break;
                }
                case LARGE: {
                    configuration.screenLayout |= 3;
                    break;
                }
                case XLARGE: {
                    configuration.screenLayout |= 4;
                }
            }
        }
        if ((density = hardwareConfig.getDensity()) == null) {
            density = Density.MEDIUM;
        }
        configuration.screenWidthDp = hardwareConfig.getScreenWidth() / density.getDpiValue();
        configuration.screenHeightDp = hardwareConfig.getScreenHeight() / density.getDpiValue();
        configuration.smallestScreenWidthDp = configuration.screenHeightDp < configuration.screenWidthDp ? configuration.screenHeightDp : configuration.screenWidthDp;
        configuration.compatScreenWidthDp = configuration.screenWidthDp;
        configuration.compatScreenHeightDp = configuration.screenHeightDp;
        return configuration;
    }

    public Integer getId(ResourceType resourceType, String string2) {
        return Bridge.getResourceId(resourceType, string2);
    }
}

