/*
 * Decompiled with CFR 0.152.
 */
package libcore.icu;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import libcore.icu.ICU;

public class LocaleData {
    private static final HashMap<String, LocaleData> localeDataCache = new HashMap();
    public Integer firstDayOfWeek;
    public Integer minimalDaysInFirstWeek;
    public String[] amPm;
    public String[] eras;
    public String[] longMonthNames;
    public String[] shortMonthNames;
    public String[] longStandAloneMonthNames;
    public String[] shortStandAloneMonthNames;
    public String[] longWeekdayNames;
    public String[] shortWeekdayNames;
    public String[] longStandAloneWeekdayNames;
    public String[] shortStandAloneWeekdayNames;
    public String fullTimeFormat;
    public String longTimeFormat;
    public String mediumTimeFormat;
    public String shortTimeFormat;
    public String fullDateFormat;
    public String longDateFormat;
    public String mediumDateFormat;
    public String shortDateFormat;
    public char zeroDigit;
    public char decimalSeparator;
    public char groupingSeparator;
    public char patternSeparator;
    public char percent;
    public char perMill;
    public char monetarySeparator;
    public char minusSign;
    public String exponentSeparator;
    public String infinity;
    public String NaN;
    public String currencySymbol;
    public String internationalCurrencySymbol;
    public String numberPattern;
    public String integerPattern;
    public String currencyPattern;
    public String percentPattern;

    private LocaleData() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LocaleData get(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        String localeName = locale.toString();
        HashMap<String, LocaleData> hashMap = localeDataCache;
        synchronized (hashMap) {
            LocaleData localeData = localeDataCache.get(localeName);
            if (localeData != null) {
                return localeData;
            }
        }
        LocaleData newLocaleData = LocaleData.initLocaleData(locale);
        HashMap<String, LocaleData> hashMap2 = localeDataCache;
        synchronized (hashMap2) {
            LocaleData localeData = localeDataCache.get(localeName);
            if (localeData != null) {
                return localeData;
            }
            localeDataCache.put(localeName, newLocaleData);
            return newLocaleData;
        }
    }

    public String toString() {
        return "LocaleData[firstDayOfWeek=" + this.firstDayOfWeek + "," + "minimalDaysInFirstWeek=" + this.minimalDaysInFirstWeek + "," + "amPm=" + Arrays.toString(this.amPm) + "," + "eras=" + Arrays.toString(this.eras) + "," + "longMonthNames=" + Arrays.toString(this.longMonthNames) + "," + "shortMonthNames=" + Arrays.toString(this.shortMonthNames) + "," + "longStandAloneMonthNames=" + Arrays.toString(this.longStandAloneMonthNames) + "," + "shortStandAloneMonthNames=" + Arrays.toString(this.shortStandAloneMonthNames) + "," + "longWeekdayNames=" + Arrays.toString(this.longWeekdayNames) + "," + "shortWeekdayNames=" + Arrays.toString(this.shortWeekdayNames) + "," + "longStandAloneWeekdayNames=" + Arrays.toString(this.longStandAloneWeekdayNames) + "," + "shortStandAloneWeekdayNames=" + Arrays.toString(this.shortStandAloneWeekdayNames) + "," + "fullTimeFormat=" + this.fullTimeFormat + "," + "longTimeFormat=" + this.longTimeFormat + "," + "mediumTimeFormat=" + this.mediumTimeFormat + "," + "shortTimeFormat=" + this.shortTimeFormat + "," + "fullDateFormat=" + this.fullDateFormat + "," + "longDateFormat=" + this.longDateFormat + "," + "mediumDateFormat=" + this.mediumDateFormat + "," + "shortDateFormat=" + this.shortDateFormat + "," + "zeroDigit=" + this.zeroDigit + "," + "decimalSeparator=" + this.decimalSeparator + "," + "groupingSeparator=" + this.groupingSeparator + "," + "patternSeparator=" + this.patternSeparator + "," + "percent=" + this.percent + "," + "perMill=" + this.perMill + "," + "monetarySeparator=" + this.monetarySeparator + "," + "minusSign=" + this.minusSign + "," + "exponentSeparator=" + this.exponentSeparator + "," + "infinity=" + this.infinity + "," + "NaN=" + this.NaN + "," + "currencySymbol=" + this.currencySymbol + "," + "internationalCurrencySymbol=" + this.internationalCurrencySymbol + "," + "numberPattern=" + this.numberPattern + "," + "integerPattern=" + this.integerPattern + "," + "currencyPattern=" + this.currencyPattern + "," + "percentPattern=" + this.percentPattern + "]";
    }

    public String getDateFormat(int style2) {
        switch (style2) {
            case 3: {
                return this.shortDateFormat;
            }
            case 2: {
                return this.mediumDateFormat;
            }
            case 1: {
                return this.longDateFormat;
            }
            case 0: {
                return this.fullDateFormat;
            }
        }
        throw new AssertionError();
    }

    public String getTimeFormat(int style2) {
        switch (style2) {
            case 3: {
                return this.shortTimeFormat;
            }
            case 2: {
                return this.mediumTimeFormat;
            }
            case 1: {
                return this.longTimeFormat;
            }
            case 0: {
                return this.fullTimeFormat;
            }
        }
        throw new AssertionError();
    }

    private static LocaleData initLocaleData(Locale locale) {
        LocaleData localeData = new LocaleData();
        if (!ICU.initLocaleDataImpl(locale.toString(), localeData)) {
            throw new AssertionError((Object)("couldn't initialize LocaleData for locale " + locale));
        }
        if (localeData.fullTimeFormat != null) {
            localeData.fullTimeFormat = localeData.fullTimeFormat.replace('v', 'z');
        }
        if (localeData.numberPattern != null) {
            localeData.integerPattern = localeData.numberPattern.replaceAll("\\.[#,]*", "");
        }
        return localeData;
    }

    static {
        LocaleData.get(Locale.ROOT);
        LocaleData.get(Locale.US);
        LocaleData.get(Locale.getDefault());
    }
}

