/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.xnet.provider.jsse;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.InvalidKeySpecException;
import org.apache.harmony.xnet.provider.jsse.NativeCrypto;
import org.apache.harmony.xnet.provider.jsse.OpenSSLDSAParams;
import org.apache.harmony.xnet.provider.jsse.OpenSSLKey;

public class OpenSSLDSAPrivateKey
implements DSAPrivateKey {
    private static final long serialVersionUID = 6524734576187424628L;
    private final OpenSSLKey key;
    private OpenSSLDSAParams params;

    OpenSSLDSAPrivateKey(OpenSSLKey key) {
        this.key = key;
    }

    OpenSSLKey getOpenSSLKey() {
        return this.key;
    }

    OpenSSLDSAPrivateKey(DSAPrivateKeySpec dsaKeySpec) throws InvalidKeySpecException {
        try {
            this.key = new OpenSSLKey(NativeCrypto.EVP_PKEY_new_DSA(dsaKeySpec.getP().toByteArray(), dsaKeySpec.getQ().toByteArray(), dsaKeySpec.getG().toByteArray(), null, dsaKeySpec.getX().toByteArray()));
        }
        catch (Exception e) {
            throw new InvalidKeySpecException(e);
        }
    }

    private void ensureReadParams() {
        if (this.params == null) {
            this.params = new OpenSSLDSAParams(this.key);
        }
    }

    static OpenSSLKey getInstance(DSAPrivateKey dsaPrivateKey) throws InvalidKeyException {
        try {
            DSAParams dsaParams = dsaPrivateKey.getParams();
            return new OpenSSLKey(NativeCrypto.EVP_PKEY_new_DSA(dsaParams.getP().toByteArray(), dsaParams.getQ().toByteArray(), dsaParams.getG().toByteArray(), null, dsaPrivateKey.getX().toByteArray()));
        }
        catch (Exception e) {
            throw new InvalidKeyException(e);
        }
    }

    public DSAParams getParams() {
        this.ensureReadParams();
        return this.params;
    }

    public String getAlgorithm() {
        return "DSA";
    }

    public String getFormat() {
        if (this.key.isEngineBased()) {
            return null;
        }
        return "PKCS#8";
    }

    public byte[] getEncoded() {
        if (this.key.isEngineBased()) {
            return null;
        }
        return NativeCrypto.i2d_PKCS8_PRIV_KEY_INFO(this.key.getPkeyContext());
    }

    public BigInteger getX() {
        this.ensureReadParams();
        return this.params.getX();
    }

    public int getPkeyContext() {
        return this.key.getPkeyContext();
    }

    public boolean equals(Object o) {
        OpenSSLDSAPrivateKey other;
        if (o == this) {
            return true;
        }
        if (o instanceof OpenSSLDSAPrivateKey && this.key.equals((other = (OpenSSLDSAPrivateKey)o).getOpenSSLKey())) {
            return true;
        }
        if (!(o instanceof DSAPrivateKey)) {
            return false;
        }
        this.ensureReadParams();
        BigInteger x = this.params.getX();
        if (x == null) {
            return false;
        }
        DSAPrivateKey other2 = (DSAPrivateKey)o;
        return x.equals(other2.getX()) && this.params.equals(other2.getParams());
    }

    public int hashCode() {
        this.ensureReadParams();
        int hash = 1;
        BigInteger x = this.getX();
        if (x != null) {
            hash = hash * 3 + x.hashCode();
        }
        hash = hash * 7 + this.params.hashCode();
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("OpenSSLDSAPrivateKey{");
        if (this.key.isEngineBased()) {
            sb.append("key=");
            sb.append(this.key);
            sb.append('}');
            return sb.toString();
        }
        this.ensureReadParams();
        sb.append("X=");
        sb.append(this.params.getX().toString(16));
        sb.append(',');
        sb.append("params=");
        sb.append(this.params.toString());
        sb.append('}');
        return sb.toString();
    }
}

