/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.xnet.provider.jsse;

import java.security.InvalidKeyException;
import java.security.PrivateKey;
import org.apache.harmony.xnet.provider.jsse.NativeCrypto;
import org.apache.harmony.xnet.provider.jsse.OpenSSLDSAPrivateKey;
import org.apache.harmony.xnet.provider.jsse.OpenSSLKey;
import org.apache.harmony.xnet.provider.jsse.OpenSSLRSAPrivateKey;

public class OpenSSLEngine {
    private final int ctx;

    public static OpenSSLEngine getInstance(String engine) throws IllegalArgumentException {
        if (engine == null) {
            throw new NullPointerException("engine == null");
        }
        int engineCtx = NativeCrypto.ENGINE_by_id(engine);
        if (engineCtx == 0) {
            throw new IllegalArgumentException("Unknown ENGINE id: " + engine);
        }
        return new OpenSSLEngine(engineCtx);
    }

    private OpenSSLEngine(int engineCtx) {
        this.ctx = engineCtx;
        if (NativeCrypto.ENGINE_init(engineCtx) == 0) {
            throw new IllegalArgumentException("Could not initialize engine");
        }
    }

    public PrivateKey getPrivateKeyById(String id2) throws InvalidKeyException {
        if (id2 == null) {
            throw new NullPointerException("id == null");
        }
        int keyRef = NativeCrypto.ENGINE_load_private_key(this.ctx, id2);
        if (keyRef == 0) {
            return null;
        }
        int keyType = NativeCrypto.EVP_PKEY_type(keyRef);
        switch (keyType) {
            case 6: {
                return OpenSSLRSAPrivateKey.getInstance(new OpenSSLKey(keyRef, this));
            }
            case 116: {
                return new OpenSSLDSAPrivateKey(new OpenSSLKey(keyRef, this));
            }
        }
        throw new InvalidKeyException("Unknown key type: " + keyType);
    }

    int getEngineContext() {
        return this.ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            NativeCrypto.ENGINE_finish(this.ctx);
            NativeCrypto.ENGINE_free(this.ctx);
        }
        finally {
            super.finalize();
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenSSLEngine)) {
            return false;
        }
        OpenSSLEngine other = (OpenSSLEngine)o;
        return other.getEngineContext() == this.ctx;
    }

    public int hashCode() {
        return this.ctx;
    }

    static {
        NativeCrypto.ENGINE_load_dynamic();
    }
}

