/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.xnet.provider.jsse;

import org.apache.harmony.xnet.provider.jsse.NativeCrypto;
import org.apache.harmony.xnet.provider.jsse.OpenSSLEngine;

class OpenSSLKey {
    private final int ctx;
    private final OpenSSLEngine engine;

    OpenSSLKey(int ctx) {
        this.ctx = ctx;
        this.engine = null;
    }

    OpenSSLKey(int ctx, OpenSSLEngine engine) {
        this.ctx = ctx;
        this.engine = engine;
    }

    int getPkeyContext() {
        return this.ctx;
    }

    OpenSSLEngine getEngine() {
        return this.engine;
    }

    boolean isEngineBased() {
        return this.engine != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.ctx != 0) {
                NativeCrypto.EVP_PKEY_free(this.ctx);
            }
        }
        finally {
            super.finalize();
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenSSLKey)) {
            return false;
        }
        OpenSSLKey other = (OpenSSLKey)o;
        if (this.ctx != other.getPkeyContext()) {
            return false;
        }
        if (this.engine == null) {
            return other.getEngine() == null;
        }
        return this.engine.equals(other.getEngine());
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 17 + this.ctx;
        hash = hash * 31 + (this.engine == null ? 0 : this.engine.getEngineContext());
        return hash;
    }
}

