/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.xnet.provider.jsse;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateKeySpec;
import org.apache.harmony.xnet.provider.jsse.NativeCrypto;
import org.apache.harmony.xnet.provider.jsse.OpenSSLKey;
import org.apache.harmony.xnet.provider.jsse.OpenSSLRSAPrivateCrtKey;

public class OpenSSLRSAPrivateKey
implements RSAPrivateKey {
    private static final long serialVersionUID = 4872170254439578735L;
    private final OpenSSLKey key;
    private boolean fetchedParams;
    private BigInteger modulus;
    private BigInteger privateExponent;

    OpenSSLRSAPrivateKey(OpenSSLKey key) {
        this.key = key;
    }

    OpenSSLRSAPrivateKey(OpenSSLKey key, byte[][] params) {
        this(key);
        this.readParams(params);
        this.fetchedParams = true;
    }

    OpenSSLKey getOpenSSLKey() {
        return this.key;
    }

    public OpenSSLRSAPrivateKey(RSAPrivateKeySpec rsaKeySpec) throws InvalidKeySpecException {
        this(OpenSSLRSAPrivateKey.init(rsaKeySpec));
    }

    private static OpenSSLKey init(RSAPrivateKeySpec rsaKeySpec) throws InvalidKeySpecException {
        BigInteger modulus = rsaKeySpec.getModulus();
        BigInteger privateExponent = rsaKeySpec.getPrivateExponent();
        if (modulus == null) {
            throw new InvalidKeySpecException("modulus == null");
        }
        if (privateExponent == null) {
            throw new InvalidKeySpecException("privateExponent == null");
        }
        try {
            return new OpenSSLKey(NativeCrypto.EVP_PKEY_new_RSA(modulus.toByteArray(), null, privateExponent.toByteArray(), null, null, null, null, null));
        }
        catch (Exception e) {
            throw new InvalidKeySpecException(e);
        }
    }

    static OpenSSLRSAPrivateKey getInstance(OpenSSLKey key) {
        byte[][] params = NativeCrypto.get_RSA_private_params(key.getPkeyContext());
        if (params[1] != null) {
            return new OpenSSLRSAPrivateCrtKey(key, params);
        }
        return new OpenSSLRSAPrivateKey(key, params);
    }

    static OpenSSLKey getInstance(RSAPrivateKey rsaPrivateKey) throws InvalidKeyException {
        BigInteger modulus = rsaPrivateKey.getModulus();
        BigInteger privateExponent = rsaPrivateKey.getPrivateExponent();
        if (modulus == null) {
            throw new InvalidKeyException("modulus == null");
        }
        if (privateExponent == null) {
            throw new InvalidKeyException("privateExponent == null");
        }
        try {
            return new OpenSSLKey(NativeCrypto.EVP_PKEY_new_RSA(modulus.toByteArray(), null, privateExponent.toByteArray(), null, null, null, null, null));
        }
        catch (Exception e) {
            throw new InvalidKeyException(e);
        }
    }

    synchronized void ensureReadParams() {
        if (this.fetchedParams) {
            return;
        }
        this.readParams(NativeCrypto.get_RSA_private_params(this.key.getPkeyContext()));
        this.fetchedParams = true;
    }

    void readParams(byte[][] params) {
        if (params[0] == null) {
            throw new NullPointerException("modulus == null");
        }
        if (params[2] == null && !this.key.isEngineBased()) {
            throw new NullPointerException("privateExponent == null");
        }
        this.modulus = new BigInteger(params[0]);
        if (params[2] != null) {
            this.privateExponent = new BigInteger(params[2]);
        }
    }

    public BigInteger getPrivateExponent() {
        this.ensureReadParams();
        return this.privateExponent;
    }

    public BigInteger getModulus() {
        this.ensureReadParams();
        return this.modulus;
    }

    public byte[] getEncoded() {
        if (this.key.isEngineBased()) {
            return null;
        }
        return NativeCrypto.i2d_PKCS8_PRIV_KEY_INFO(this.key.getPkeyContext());
    }

    public String getFormat() {
        if (this.key.isEngineBased()) {
            return null;
        }
        return "PKCS#8";
    }

    public String getAlgorithm() {
        return "RSA";
    }

    public int getPkeyContext() {
        return this.key.getPkeyContext();
    }

    public boolean equals(Object o) {
        RSAPrivateKey other;
        if (o == this) {
            return true;
        }
        if (o instanceof OpenSSLRSAPrivateKey && this.key.equals(((OpenSSLRSAPrivateKey)(other = (OpenSSLRSAPrivateKey)o)).getOpenSSLKey())) {
            return true;
        }
        if (o instanceof RSAPrivateKey) {
            this.ensureReadParams();
            other = (RSAPrivateKey)o;
            return this.modulus.equals(other.getModulus()) && this.privateExponent.equals(other.getPrivateExponent());
        }
        return false;
    }

    public int hashCode() {
        this.ensureReadParams();
        int hash = 1;
        hash = hash * 3 + this.modulus.hashCode();
        if (this.privateExponent != null) {
            hash = hash * 7 + this.privateExponent.hashCode();
        }
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("OpenSSLRSAPrivateKey{");
        if (this.key.isEngineBased()) {
            sb.append("key=");
            sb.append(this.key);
            sb.append('}');
            return sb.toString();
        }
        this.ensureReadParams();
        sb.append("modulus=");
        sb.append(this.modulus.toString(16));
        sb.append(',');
        sb.append("privateExponent=");
        sb.append(this.privateExponent.toString(16));
        sb.append(',');
        return sb.toString();
    }
}

