/*
 * Decompiled with CFR 0.152.
 */
package android.animation;

import android.os.Handler;
import android.os.Handler_Delegate;
import android.os.Message;
import com.android.ide.common.rendering.api.IAnimationListener;
import com.android.ide.common.rendering.api.RenderSession;
import com.android.ide.common.rendering.api.Result;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.impl.RenderSessionImpl;
import java.util.PriorityQueue;
import java.util.Queue;

public abstract class AnimationThread
extends Thread {
    private final RenderSessionImpl mSession;
    private Queue<MessageBundle> mQueue = new PriorityQueue<MessageBundle>();
    private final IAnimationListener mListener;

    public AnimationThread(RenderSessionImpl renderSessionImpl, String string2, IAnimationListener iAnimationListener) {
        super(string2);
        this.mSession = renderSessionImpl;
        this.mListener = iAnimationListener;
    }

    public abstract Result preAnimation();

    public abstract void postAnimation();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Bridge.prepareThread();
        try {
            MessageBundle messageBundle;
            Result result = this.preAnimation();
            if (!result.isSuccess()) {
                this.mListener.done(result);
            }
            RenderSession renderSession = this.mSession.getSession();
            while (!this.mListener.isCanceled() && (messageBundle = this.mQueue.poll()) != null) {
                long l = System.currentTimeMillis();
                if (l < messageBundle.mUptimeMillis) {
                    try {
                        AnimationThread.sleep(messageBundle.mUptimeMillis - l);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
                if (this.mListener.isCanceled()) break;
                result = this.mSession.acquire(250L);
                if (!result.isSuccess()) {
                    this.mListener.done(result);
                    return;
                }
                try {
                    if (this.mListener.isCanceled()) break;
                    messageBundle.mTarget.handleMessage(messageBundle.mMessage);
                    if (this.mSession.render(false).isSuccess()) {
                        this.mListener.onNewFrame(renderSession);
                    }
                }
                finally {
                    this.mSession.release();
                }
                if (!this.mListener.isCanceled() && this.mQueue.size() > 0) continue;
            }
            this.mListener.done(Result.Status.SUCCESS.createResult());
        }
        catch (Throwable throwable) {
            this.mListener.done(Result.Status.ERROR_UNKNOWN.createResult("Error playing animation", throwable));
        }
        finally {
            this.postAnimation();
            Handler_Delegate.setCallback(null);
            Bridge.cleanupThread();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MessageBundle
    implements Comparable<MessageBundle> {
        final Handler mTarget;
        final Message mMessage;
        final long mUptimeMillis;

        MessageBundle(Handler handler, Message message, long l) {
            this.mTarget = handler;
            this.mMessage = message;
            this.mUptimeMillis = l;
        }

        @Override
        public int compareTo(MessageBundle messageBundle) {
            if (this.mUptimeMillis < messageBundle.mUptimeMillis) {
                return -1;
            }
            return 1;
        }
    }
}

