/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.accounts.AccountManager;
import android.accounts.IAccountManager;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.ActivityManagerNative;
import android.app.ActivityThread;
import android.app.AlarmManager;
import android.app.ApplicationPackageManager;
import android.app.DownloadManager;
import android.app.IAlarmManager;
import android.app.IServiceConnection;
import android.app.Instrumentation;
import android.app.KeyguardManager;
import android.app.LoadedApk;
import android.app.NotificationManager;
import android.app.ReceiverRestrictedContext;
import android.app.SearchManager;
import android.app.SharedPreferencesImpl;
import android.app.StatusBarManager;
import android.app.UiModeManager;
import android.app.WallpaperManager;
import android.app.admin.DevicePolicyManager;
import android.bluetooth.BluetoothAdapter;
import android.content.BroadcastReceiver;
import android.content.ClipboardManager;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.IContentProvider;
import android.content.IIntentReceiver;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.ServiceConnection;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageManager;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.database.DatabaseErrorHandler;
import android.database.sqlite.SQLiteDatabase;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.hardware.ISerialManager;
import android.hardware.SerialManager;
import android.hardware.SystemSensorManager;
import android.hardware.display.DisplayManager;
import android.hardware.input.InputManager;
import android.hardware.usb.IUsbManager;
import android.hardware.usb.UsbManager;
import android.location.CountryDetector;
import android.location.ICountryDetector;
import android.location.ILocationManager;
import android.location.LocationManager;
import android.media.AudioManager;
import android.media.MediaRouter;
import android.net.ConnectivityManager;
import android.net.IConnectivityManager;
import android.net.INetworkPolicyManager;
import android.net.IThrottleManager;
import android.net.NetworkPolicyManager;
import android.net.ThrottleManager;
import android.net.Uri;
import android.net.nsd.INsdManager;
import android.net.nsd.NsdManager;
import android.net.wifi.IWifiManager;
import android.net.wifi.WifiManager;
import android.net.wifi.p2p.IWifiP2pManager;
import android.net.wifi.p2p.WifiP2pManager;
import android.nfc.NfcManager;
import android.os.Binder;
import android.os.Bundle;
import android.os.Debug;
import android.os.DropBoxManager;
import android.os.Environment;
import android.os.FileUtils;
import android.os.Handler;
import android.os.IBinder;
import android.os.IPowerManager;
import android.os.IUserManager;
import android.os.Looper;
import android.os.PowerManager;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemVibrator;
import android.os.UserHandle;
import android.os.UserManager;
import android.os.storage.StorageManager;
import android.telephony.TelephonyManager;
import android.util.AndroidRuntimeException;
import android.util.Log;
import android.util.Slog;
import android.view.CompatibilityInfoHolder;
import android.view.ContextThemeWrapper;
import android.view.Display;
import android.view.WindowManagerImpl;
import android.view.accessibility.AccessibilityManager;
import android.view.inputmethod.InputMethodManager;
import android.view.textservice.TextServicesManager;
import com.android.internal.os.IDropBoxManagerService;
import com.android.internal.policy.PolicyManager;
import com.android.internal.util.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;

class ContextImpl
extends Context {
    private static final String TAG = "ContextImpl";
    private static final boolean DEBUG = false;
    private static final HashMap<String, SharedPreferencesImpl> sSharedPrefs = new HashMap();
    LoadedApk mPackageInfo;
    private String mBasePackageName;
    private Resources mResources;
    ActivityThread mMainThread;
    private Context mOuterContext;
    private IBinder mActivityToken = null;
    private ApplicationContentResolver mContentResolver;
    private int mThemeResource = 0;
    private Resources.Theme mTheme = null;
    private PackageManager mPackageManager;
    private Display mDisplay;
    private Context mReceiverRestrictedContext = null;
    private boolean mRestricted;
    private UserHandle mUser;
    private final Object mSync = new Object();
    private File mDatabasesDir;
    private File mPreferencesDir;
    private File mFilesDir;
    private File mCacheDir;
    private File mObbDir;
    private File mExternalFilesDir;
    private File mExternalCacheDir;
    private static final String[] EMPTY_FILE_LIST = new String[0];
    private static final HashMap<String, ServiceFetcher> SYSTEM_SERVICE_MAP = new HashMap();
    private static int sNextPerContextServiceCacheIndex = 0;
    private static ServiceFetcher WALLPAPER_FETCHER = new ServiceFetcher(){

        public Object createService(ContextImpl ctx) {
            return new WallpaperManager(ctx.getOuterContext(), ctx.mMainThread.getHandler());
        }
    };
    final ArrayList<Object> mServiceCache = new ArrayList();

    private static void registerService(String serviceName, ServiceFetcher fetcher) {
        if (!(fetcher instanceof StaticServiceFetcher)) {
            fetcher.mContextCacheIndex = sNextPerContextServiceCacheIndex++;
        }
        SYSTEM_SERVICE_MAP.put(serviceName, fetcher);
    }

    static ContextImpl getImpl(Context context) {
        Context nextContext;
        while (context instanceof ContextWrapper && (nextContext = ((ContextWrapper)context).getBaseContext()) != null) {
            context = nextContext;
        }
        return (ContextImpl)context;
    }

    public AssetManager getAssets() {
        return this.getResources().getAssets();
    }

    public Resources getResources() {
        return this.mResources;
    }

    public PackageManager getPackageManager() {
        if (this.mPackageManager != null) {
            return this.mPackageManager;
        }
        IPackageManager pm = ActivityThread.getPackageManager();
        if (pm != null) {
            this.mPackageManager = new ApplicationPackageManager(this, pm);
            return this.mPackageManager;
        }
        return null;
    }

    public ContentResolver getContentResolver() {
        return this.mContentResolver;
    }

    public Looper getMainLooper() {
        return this.mMainThread.getLooper();
    }

    public Context getApplicationContext() {
        return this.mPackageInfo != null ? this.mPackageInfo.getApplication() : this.mMainThread.getApplication();
    }

    public void setTheme(int resid) {
        this.mThemeResource = resid;
    }

    public int getThemeResId() {
        return this.mThemeResource;
    }

    public Resources.Theme getTheme() {
        if (this.mTheme == null) {
            this.mThemeResource = Resources.selectDefaultTheme(this.mThemeResource, this.getOuterContext().getApplicationInfo().targetSdkVersion);
            this.mTheme = this.mResources.newTheme();
            this.mTheme.applyStyle(this.mThemeResource, true);
        }
        return this.mTheme;
    }

    public ClassLoader getClassLoader() {
        return this.mPackageInfo != null ? this.mPackageInfo.getClassLoader() : ClassLoader.getSystemClassLoader();
    }

    public String getPackageName() {
        if (this.mPackageInfo != null) {
            return this.mPackageInfo.getPackageName();
        }
        throw new RuntimeException("Not supported in system context");
    }

    public ApplicationInfo getApplicationInfo() {
        if (this.mPackageInfo != null) {
            return this.mPackageInfo.getApplicationInfo();
        }
        throw new RuntimeException("Not supported in system context");
    }

    public String getPackageResourcePath() {
        if (this.mPackageInfo != null) {
            return this.mPackageInfo.getResDir();
        }
        throw new RuntimeException("Not supported in system context");
    }

    public String getPackageCodePath() {
        if (this.mPackageInfo != null) {
            return this.mPackageInfo.getAppDir();
        }
        throw new RuntimeException("Not supported in system context");
    }

    public File getSharedPrefsFile(String name) {
        return this.makeFilename(this.getPreferencesDir(), name + ".xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SharedPreferences getSharedPreferences(String name, int mode) {
        SharedPreferencesImpl sp;
        HashMap<String, SharedPreferencesImpl> hashMap = sSharedPrefs;
        synchronized (hashMap) {
            sp = sSharedPrefs.get(name);
            if (sp == null) {
                File prefsFile = this.getSharedPrefsFile(name);
                sp = new SharedPreferencesImpl(prefsFile, mode);
                sSharedPrefs.put(name, sp);
                return sp;
            }
        }
        if ((mode & 4) != 0 || this.getApplicationInfo().targetSdkVersion < 11) {
            sp.startReloadIfChangedUnexpectedly();
        }
        return sp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getPreferencesDir() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mPreferencesDir == null) {
                this.mPreferencesDir = new File(this.getDataDirFile(), "shared_prefs");
            }
            return this.mPreferencesDir;
        }
    }

    public FileInputStream openFileInput(String name) throws FileNotFoundException {
        File f = this.makeFilename(this.getFilesDir(), name);
        return new FileInputStream(f);
    }

    public FileOutputStream openFileOutput(String name, int mode) throws FileNotFoundException {
        boolean append = (mode & 0x8000) != 0;
        File f = this.makeFilename(this.getFilesDir(), name);
        try {
            FileOutputStream fos = new FileOutputStream(f, append);
            ContextImpl.setFilePermissionsFromMode(f.getPath(), mode, 0);
            return fos;
        }
        catch (FileNotFoundException e) {
            File parent = f.getParentFile();
            parent.mkdir();
            FileUtils.setPermissions(parent.getPath(), 505, -1, -1);
            FileOutputStream fos = new FileOutputStream(f, append);
            ContextImpl.setFilePermissionsFromMode(f.getPath(), mode, 0);
            return fos;
        }
    }

    public boolean deleteFile(String name) {
        File f = this.makeFilename(this.getFilesDir(), name);
        return f.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getFilesDir() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mFilesDir == null) {
                this.mFilesDir = new File(this.getDataDirFile(), "files");
            }
            if (!this.mFilesDir.exists()) {
                if (!this.mFilesDir.mkdirs()) {
                    Log.w(TAG, "Unable to create files directory " + this.mFilesDir.getPath());
                    return null;
                }
                FileUtils.setPermissions(this.mFilesDir.getPath(), 505, -1, -1);
            }
            return this.mFilesDir;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getExternalFilesDir(String type) {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mExternalFilesDir == null) {
                this.mExternalFilesDir = Environment.getExternalStorageAppFilesDirectory(this.getPackageName());
            }
            if (!this.mExternalFilesDir.exists()) {
                try {
                    new File(Environment.getExternalStorageAndroidDataDir(), ".nomedia").createNewFile();
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (!this.mExternalFilesDir.mkdirs()) {
                    Log.w(TAG, "Unable to create external files directory");
                    return null;
                }
            }
            if (type == null) {
                return this.mExternalFilesDir;
            }
            File dir = new File(this.mExternalFilesDir, type);
            if (!dir.exists() && !dir.mkdirs()) {
                Log.w(TAG, "Unable to create external media directory " + dir);
                return null;
            }
            return dir;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getObbDir() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mObbDir == null) {
                this.mObbDir = Environment.getExternalStorageAppObbDirectory(this.getPackageName());
            }
            return this.mObbDir;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getCacheDir() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mCacheDir == null) {
                this.mCacheDir = new File(this.getDataDirFile(), "cache");
            }
            if (!this.mCacheDir.exists()) {
                if (!this.mCacheDir.mkdirs()) {
                    Log.w(TAG, "Unable to create cache directory " + this.mCacheDir.getAbsolutePath());
                    return null;
                }
                FileUtils.setPermissions(this.mCacheDir.getPath(), 505, -1, -1);
            }
        }
        return this.mCacheDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getExternalCacheDir() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mExternalCacheDir == null) {
                this.mExternalCacheDir = Environment.getExternalStorageAppCacheDirectory(this.getPackageName());
            }
            if (!this.mExternalCacheDir.exists()) {
                try {
                    new File(Environment.getExternalStorageAndroidDataDir(), ".nomedia").createNewFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (!this.mExternalCacheDir.mkdirs()) {
                    Log.w(TAG, "Unable to create external cache directory");
                    return null;
                }
            }
            return this.mExternalCacheDir;
        }
    }

    public File getFileStreamPath(String name) {
        return this.makeFilename(this.getFilesDir(), name);
    }

    public String[] fileList() {
        String[] list = this.getFilesDir().list();
        return list != null ? list : EMPTY_FILE_LIST;
    }

    public SQLiteDatabase openOrCreateDatabase(String name, int mode, SQLiteDatabase.CursorFactory factory) {
        return this.openOrCreateDatabase(name, mode, factory, null);
    }

    public SQLiteDatabase openOrCreateDatabase(String name, int mode, SQLiteDatabase.CursorFactory factory, DatabaseErrorHandler errorHandler) {
        File f = this.validateFilePath(name, true);
        int flags = 0x10000000;
        if ((mode & 8) != 0) {
            flags |= 0x20000000;
        }
        SQLiteDatabase db = SQLiteDatabase.openDatabase(f.getPath(), factory, flags, errorHandler);
        ContextImpl.setFilePermissionsFromMode(f.getPath(), mode, 0);
        return db;
    }

    public boolean deleteDatabase(String name) {
        try {
            File f = this.validateFilePath(name, false);
            return SQLiteDatabase.deleteDatabase(f);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public File getDatabasePath(String name) {
        return this.validateFilePath(name, false);
    }

    public String[] databaseList() {
        String[] list = this.getDatabasesDir().list();
        return list != null ? list : EMPTY_FILE_LIST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getDatabasesDir() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mDatabasesDir == null) {
                this.mDatabasesDir = new File(this.getDataDirFile(), "databases");
            }
            if (this.mDatabasesDir.getPath().equals("databases")) {
                this.mDatabasesDir = new File("/data/system");
            }
            return this.mDatabasesDir;
        }
    }

    public Drawable getWallpaper() {
        return this.getWallpaperManager().getDrawable();
    }

    public Drawable peekWallpaper() {
        return this.getWallpaperManager().peekDrawable();
    }

    public int getWallpaperDesiredMinimumWidth() {
        return this.getWallpaperManager().getDesiredMinimumWidth();
    }

    public int getWallpaperDesiredMinimumHeight() {
        return this.getWallpaperManager().getDesiredMinimumHeight();
    }

    public void setWallpaper(Bitmap bitmap) throws IOException {
        this.getWallpaperManager().setBitmap(bitmap);
    }

    public void setWallpaper(InputStream data) throws IOException {
        this.getWallpaperManager().setStream(data);
    }

    public void clearWallpaper() throws IOException {
        this.getWallpaperManager().clear();
    }

    public void startActivity(Intent intent) {
        this.warnIfCallingFromSystemProcess();
        this.startActivity(intent, null);
    }

    public void startActivityAsUser(Intent intent, UserHandle user) {
        this.startActivityAsUser(intent, null, user);
    }

    public void startActivity(Intent intent, Bundle options) {
        this.warnIfCallingFromSystemProcess();
        if ((intent.getFlags() & 0x10000000) == 0) {
            throw new AndroidRuntimeException("Calling startActivity() from outside of an Activity  context requires the FLAG_ACTIVITY_NEW_TASK flag. Is this really what you want?");
        }
        this.mMainThread.getInstrumentation().execStartActivity(this.getOuterContext(), (IBinder)this.mMainThread.getApplicationThread(), null, (Activity)null, intent, -1, options);
    }

    public void startActivityAsUser(Intent intent, Bundle options, UserHandle user) {
        try {
            ActivityManagerNative.getDefault().startActivityAsUser(this.mMainThread.getApplicationThread(), intent, intent.resolveTypeIfNeeded(this.getContentResolver()), null, null, 0, 0x10000000, null, null, options, user.getIdentifier());
        }
        catch (RemoteException re) {
            // empty catch block
        }
    }

    public void startActivities(Intent[] intents) {
        this.warnIfCallingFromSystemProcess();
        this.startActivities(intents, null);
    }

    public void startActivitiesAsUser(Intent[] intents, Bundle options, UserHandle userHandle) {
        if ((intents[0].getFlags() & 0x10000000) == 0) {
            throw new AndroidRuntimeException("Calling startActivities() from outside of an Activity  context requires the FLAG_ACTIVITY_NEW_TASK flag on first Intent. Is this really what you want?");
        }
        this.mMainThread.getInstrumentation().execStartActivitiesAsUser(this.getOuterContext(), this.mMainThread.getApplicationThread(), null, null, intents, options, userHandle.getIdentifier());
    }

    public void startActivities(Intent[] intents, Bundle options) {
        this.warnIfCallingFromSystemProcess();
        if ((intents[0].getFlags() & 0x10000000) == 0) {
            throw new AndroidRuntimeException("Calling startActivities() from outside of an Activity  context requires the FLAG_ACTIVITY_NEW_TASK flag on first Intent. Is this really what you want?");
        }
        this.mMainThread.getInstrumentation().execStartActivities(this.getOuterContext(), this.mMainThread.getApplicationThread(), null, null, intents, options);
    }

    public void startIntentSender(IntentSender intent, Intent fillInIntent, int flagsMask, int flagsValues, int extraFlags) throws IntentSender.SendIntentException {
        this.startIntentSender(intent, fillInIntent, flagsMask, flagsValues, extraFlags, null);
    }

    public void startIntentSender(IntentSender intent, Intent fillInIntent, int flagsMask, int flagsValues, int extraFlags, Bundle options) throws IntentSender.SendIntentException {
        try {
            int result;
            String resolvedType = null;
            if (fillInIntent != null) {
                fillInIntent.setAllowFds(false);
                resolvedType = fillInIntent.resolveTypeIfNeeded(this.getContentResolver());
            }
            if ((result = ActivityManagerNative.getDefault().startActivityIntentSender(this.mMainThread.getApplicationThread(), intent, fillInIntent, resolvedType, null, null, 0, flagsMask, flagsValues, options)) == -6) {
                throw new IntentSender.SendIntentException();
            }
            Instrumentation.checkStartActivityResult(result, null);
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    public void sendBroadcast(Intent intent) {
        this.warnIfCallingFromSystemProcess();
        String resolvedType = intent.resolveTypeIfNeeded(this.getContentResolver());
        try {
            intent.setAllowFds(false);
            ActivityManagerNative.getDefault().broadcastIntent(this.mMainThread.getApplicationThread(), intent, resolvedType, null, -1, null, null, null, false, false, this.getUserId());
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void sendBroadcast(Intent intent, String receiverPermission) {
        this.warnIfCallingFromSystemProcess();
        String resolvedType = intent.resolveTypeIfNeeded(this.getContentResolver());
        try {
            intent.setAllowFds(false);
            ActivityManagerNative.getDefault().broadcastIntent(this.mMainThread.getApplicationThread(), intent, resolvedType, null, -1, null, null, receiverPermission, false, false, this.getUserId());
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    public void sendOrderedBroadcast(Intent intent, String receiverPermission) {
        this.warnIfCallingFromSystemProcess();
        String resolvedType = intent.resolveTypeIfNeeded(this.getContentResolver());
        try {
            intent.setAllowFds(false);
            ActivityManagerNative.getDefault().broadcastIntent(this.mMainThread.getApplicationThread(), intent, resolvedType, null, -1, null, null, receiverPermission, true, false, this.getUserId());
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    public void sendOrderedBroadcast(Intent intent, String receiverPermission, BroadcastReceiver resultReceiver, Handler scheduler, int initialCode, String initialData, Bundle initialExtras) {
        this.warnIfCallingFromSystemProcess();
        IIntentReceiver rd = null;
        if (resultReceiver != null) {
            if (this.mPackageInfo != null) {
                if (scheduler == null) {
                    scheduler = this.mMainThread.getHandler();
                }
                rd = this.mPackageInfo.getReceiverDispatcher(resultReceiver, this.getOuterContext(), scheduler, this.mMainThread.getInstrumentation(), false);
            } else {
                if (scheduler == null) {
                    scheduler = this.mMainThread.getHandler();
                }
                rd = new LoadedApk.ReceiverDispatcher(resultReceiver, this.getOuterContext(), scheduler, null, false).getIIntentReceiver();
            }
        }
        String resolvedType = intent.resolveTypeIfNeeded(this.getContentResolver());
        try {
            intent.setAllowFds(false);
            ActivityManagerNative.getDefault().broadcastIntent(this.mMainThread.getApplicationThread(), intent, resolvedType, rd, initialCode, initialData, initialExtras, receiverPermission, true, false, this.getUserId());
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    public void sendBroadcastAsUser(Intent intent, UserHandle user) {
        String resolvedType = intent.resolveTypeIfNeeded(this.getContentResolver());
        try {
            intent.setAllowFds(false);
            ActivityManagerNative.getDefault().broadcastIntent(this.mMainThread.getApplicationThread(), intent, resolvedType, null, -1, null, null, null, false, false, user.getIdentifier());
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    public void sendBroadcastAsUser(Intent intent, UserHandle user, String receiverPermission) {
        String resolvedType = intent.resolveTypeIfNeeded(this.getContentResolver());
        try {
            intent.setAllowFds(false);
            ActivityManagerNative.getDefault().broadcastIntent(this.mMainThread.getApplicationThread(), intent, resolvedType, null, -1, null, null, receiverPermission, false, false, user.getIdentifier());
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    public void sendOrderedBroadcastAsUser(Intent intent, UserHandle user, String receiverPermission, BroadcastReceiver resultReceiver, Handler scheduler, int initialCode, String initialData, Bundle initialExtras) {
        IIntentReceiver rd = null;
        if (resultReceiver != null) {
            if (this.mPackageInfo != null) {
                if (scheduler == null) {
                    scheduler = this.mMainThread.getHandler();
                }
                rd = this.mPackageInfo.getReceiverDispatcher(resultReceiver, this.getOuterContext(), scheduler, this.mMainThread.getInstrumentation(), false);
            } else {
                if (scheduler == null) {
                    scheduler = this.mMainThread.getHandler();
                }
                rd = new LoadedApk.ReceiverDispatcher(resultReceiver, this.getOuterContext(), scheduler, null, false).getIIntentReceiver();
            }
        }
        String resolvedType = intent.resolveTypeIfNeeded(this.getContentResolver());
        try {
            intent.setAllowFds(false);
            ActivityManagerNative.getDefault().broadcastIntent(this.mMainThread.getApplicationThread(), intent, resolvedType, rd, initialCode, initialData, initialExtras, receiverPermission, true, false, user.getIdentifier());
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    public void sendStickyBroadcast(Intent intent) {
        this.warnIfCallingFromSystemProcess();
        String resolvedType = intent.resolveTypeIfNeeded(this.getContentResolver());
        try {
            intent.setAllowFds(false);
            ActivityManagerNative.getDefault().broadcastIntent(this.mMainThread.getApplicationThread(), intent, resolvedType, null, -1, null, null, null, false, true, this.getUserId());
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void sendStickyOrderedBroadcast(Intent intent, BroadcastReceiver resultReceiver, Handler scheduler, int initialCode, String initialData, Bundle initialExtras) {
        this.warnIfCallingFromSystemProcess();
        IIntentReceiver rd = null;
        if (resultReceiver != null) {
            if (this.mPackageInfo != null) {
                if (scheduler == null) {
                    scheduler = this.mMainThread.getHandler();
                }
                rd = this.mPackageInfo.getReceiverDispatcher(resultReceiver, this.getOuterContext(), scheduler, this.mMainThread.getInstrumentation(), false);
            } else {
                if (scheduler == null) {
                    scheduler = this.mMainThread.getHandler();
                }
                rd = new LoadedApk.ReceiverDispatcher(resultReceiver, this.getOuterContext(), scheduler, null, false).getIIntentReceiver();
            }
        }
        String resolvedType = intent.resolveTypeIfNeeded(this.getContentResolver());
        try {
            intent.setAllowFds(false);
            ActivityManagerNative.getDefault().broadcastIntent(this.mMainThread.getApplicationThread(), intent, resolvedType, rd, initialCode, initialData, initialExtras, null, true, true, this.getUserId());
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    public void removeStickyBroadcast(Intent intent) {
        String resolvedType = intent.resolveTypeIfNeeded(this.getContentResolver());
        if (resolvedType != null) {
            intent = new Intent(intent);
            intent.setDataAndType(intent.getData(), resolvedType);
        }
        try {
            intent.setAllowFds(false);
            ActivityManagerNative.getDefault().unbroadcastIntent(this.mMainThread.getApplicationThread(), intent, this.getUserId());
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void sendStickyBroadcastAsUser(Intent intent, UserHandle user) {
        String resolvedType = intent.resolveTypeIfNeeded(this.getContentResolver());
        try {
            intent.setAllowFds(false);
            ActivityManagerNative.getDefault().broadcastIntent(this.mMainThread.getApplicationThread(), intent, resolvedType, null, -1, null, null, null, false, true, user.getIdentifier());
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    public void sendStickyOrderedBroadcastAsUser(Intent intent, UserHandle user, BroadcastReceiver resultReceiver, Handler scheduler, int initialCode, String initialData, Bundle initialExtras) {
        IIntentReceiver rd = null;
        if (resultReceiver != null) {
            if (this.mPackageInfo != null) {
                if (scheduler == null) {
                    scheduler = this.mMainThread.getHandler();
                }
                rd = this.mPackageInfo.getReceiverDispatcher(resultReceiver, this.getOuterContext(), scheduler, this.mMainThread.getInstrumentation(), false);
            } else {
                if (scheduler == null) {
                    scheduler = this.mMainThread.getHandler();
                }
                rd = new LoadedApk.ReceiverDispatcher(resultReceiver, this.getOuterContext(), scheduler, null, false).getIIntentReceiver();
            }
        }
        String resolvedType = intent.resolveTypeIfNeeded(this.getContentResolver());
        try {
            intent.setAllowFds(false);
            ActivityManagerNative.getDefault().broadcastIntent(this.mMainThread.getApplicationThread(), intent, resolvedType, rd, initialCode, initialData, initialExtras, null, true, true, user.getIdentifier());
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    public void removeStickyBroadcastAsUser(Intent intent, UserHandle user) {
        String resolvedType = intent.resolveTypeIfNeeded(this.getContentResolver());
        if (resolvedType != null) {
            intent = new Intent(intent);
            intent.setDataAndType(intent.getData(), resolvedType);
        }
        try {
            intent.setAllowFds(false);
            ActivityManagerNative.getDefault().unbroadcastIntent(this.mMainThread.getApplicationThread(), intent, user.getIdentifier());
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    public Intent registerReceiver(BroadcastReceiver receiver, IntentFilter filter) {
        return this.registerReceiver(receiver, filter, null, null);
    }

    public Intent registerReceiver(BroadcastReceiver receiver, IntentFilter filter, String broadcastPermission, Handler scheduler) {
        return this.registerReceiverInternal(receiver, this.getUserId(), filter, broadcastPermission, scheduler, this.getOuterContext());
    }

    public Intent registerReceiverAsUser(BroadcastReceiver receiver, UserHandle user, IntentFilter filter, String broadcastPermission, Handler scheduler) {
        return this.registerReceiverInternal(receiver, user.getIdentifier(), filter, broadcastPermission, scheduler, this.getOuterContext());
    }

    private Intent registerReceiverInternal(BroadcastReceiver receiver, int userId, IntentFilter filter, String broadcastPermission, Handler scheduler, Context context) {
        IIntentReceiver rd = null;
        if (receiver != null) {
            if (this.mPackageInfo != null && context != null) {
                if (scheduler == null) {
                    scheduler = this.mMainThread.getHandler();
                }
                rd = this.mPackageInfo.getReceiverDispatcher(receiver, context, scheduler, this.mMainThread.getInstrumentation(), true);
            } else {
                if (scheduler == null) {
                    scheduler = this.mMainThread.getHandler();
                }
                rd = new LoadedApk.ReceiverDispatcher(receiver, context, scheduler, null, true).getIIntentReceiver();
            }
        }
        try {
            return ActivityManagerNative.getDefault().registerReceiver(this.mMainThread.getApplicationThread(), this.mBasePackageName, rd, filter, broadcastPermission, userId);
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public void unregisterReceiver(BroadcastReceiver receiver) {
        if (this.mPackageInfo != null) {
            IIntentReceiver rd = this.mPackageInfo.forgetReceiverDispatcher(this.getOuterContext(), receiver);
            try {
                ActivityManagerNative.getDefault().unregisterReceiver(rd);
            }
            catch (RemoteException remoteException) {}
        } else {
            throw new RuntimeException("Not supported in system context");
        }
    }

    public ComponentName startService(Intent service) {
        this.warnIfCallingFromSystemProcess();
        return this.startServiceAsUser(service, this.mUser);
    }

    public boolean stopService(Intent service) {
        this.warnIfCallingFromSystemProcess();
        return this.stopServiceAsUser(service, this.mUser);
    }

    public ComponentName startServiceAsUser(Intent service, UserHandle user) {
        try {
            service.setAllowFds(false);
            ComponentName cn = ActivityManagerNative.getDefault().startService(this.mMainThread.getApplicationThread(), service, service.resolveTypeIfNeeded(this.getContentResolver()), user.getIdentifier());
            if (cn != null) {
                if (cn.getPackageName().equals("!")) {
                    throw new SecurityException("Not allowed to start service " + service + " without permission " + cn.getClassName());
                }
                if (cn.getPackageName().equals("!!")) {
                    throw new SecurityException("Unable to start service " + service + ": " + cn.getClassName());
                }
            }
            return cn;
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public boolean stopServiceAsUser(Intent service, UserHandle user) {
        try {
            service.setAllowFds(false);
            int res = ActivityManagerNative.getDefault().stopService(this.mMainThread.getApplicationThread(), service, service.resolveTypeIfNeeded(this.getContentResolver()), user.getIdentifier());
            if (res < 0) {
                throw new SecurityException("Not allowed to stop service " + service);
            }
            return res != 0;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean bindService(Intent service, ServiceConnection conn, int flags) {
        this.warnIfCallingFromSystemProcess();
        return this.bindService(service, conn, flags, UserHandle.getUserId(Process.myUid()));
    }

    public boolean bindService(Intent service, ServiceConnection conn, int flags, int userHandle) {
        if (conn == null) {
            throw new IllegalArgumentException("connection is null");
        }
        if (this.mPackageInfo == null) {
            throw new RuntimeException("Not supported in system context");
        }
        IServiceConnection sd = this.mPackageInfo.getServiceDispatcher(conn, this.getOuterContext(), this.mMainThread.getHandler(), flags);
        try {
            IBinder token = this.getActivityToken();
            if (token == null && (flags & 1) == 0 && this.mPackageInfo != null && this.mPackageInfo.getApplicationInfo().targetSdkVersion < 14) {
                flags |= 0x20;
            }
            service.setAllowFds(false);
            int res = ActivityManagerNative.getDefault().bindService(this.mMainThread.getApplicationThread(), this.getActivityToken(), service, service.resolveTypeIfNeeded(this.getContentResolver()), sd, flags, userHandle);
            if (res < 0) {
                throw new SecurityException("Not allowed to bind to service " + service);
            }
            return res != 0;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public void unbindService(ServiceConnection conn) {
        if (conn == null) {
            throw new IllegalArgumentException("connection is null");
        }
        if (this.mPackageInfo != null) {
            IServiceConnection sd = this.mPackageInfo.forgetServiceDispatcher(this.getOuterContext(), conn);
            try {
                ActivityManagerNative.getDefault().unbindService(sd);
            }
            catch (RemoteException remoteException) {}
        } else {
            throw new RuntimeException("Not supported in system context");
        }
    }

    public boolean startInstrumentation(ComponentName className, String profileFile, Bundle arguments) {
        try {
            if (arguments != null) {
                arguments.setAllowFds(false);
            }
            return ActivityManagerNative.getDefault().startInstrumentation(className, profileFile, 0, arguments, null, this.getUserId());
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public Object getSystemService(String name) {
        ServiceFetcher fetcher = SYSTEM_SERVICE_MAP.get(name);
        return fetcher == null ? null : fetcher.getService(this);
    }

    private WallpaperManager getWallpaperManager() {
        return (WallpaperManager)WALLPAPER_FETCHER.getService(this);
    }

    static DropBoxManager createDropBoxManager() {
        IBinder b = ServiceManager.getService("dropbox");
        IDropBoxManagerService service = IDropBoxManagerService.Stub.asInterface(b);
        if (service == null) {
            return null;
        }
        return new DropBoxManager(service);
    }

    public int checkPermission(String permission2, int pid, int uid) {
        if (permission2 == null) {
            throw new IllegalArgumentException("permission is null");
        }
        try {
            return ActivityManagerNative.getDefault().checkPermission(permission2, pid, uid);
        }
        catch (RemoteException e) {
            return -1;
        }
    }

    public int checkCallingPermission(String permission2) {
        if (permission2 == null) {
            throw new IllegalArgumentException("permission is null");
        }
        int pid = Binder.getCallingPid();
        if (pid != Process.myPid()) {
            return this.checkPermission(permission2, pid, Binder.getCallingUid());
        }
        return -1;
    }

    public int checkCallingOrSelfPermission(String permission2) {
        if (permission2 == null) {
            throw new IllegalArgumentException("permission is null");
        }
        return this.checkPermission(permission2, Binder.getCallingPid(), Binder.getCallingUid());
    }

    private void enforce(String permission2, int resultOfCheck, boolean selfToo, int uid, String message) {
        if (resultOfCheck != 0) {
            throw new SecurityException((message != null ? message + ": " : "") + (selfToo ? "Neither user " + uid + " nor current process has " : "uid " + uid + " does not have ") + permission2 + ".");
        }
    }

    public void enforcePermission(String permission2, int pid, int uid, String message) {
        this.enforce(permission2, this.checkPermission(permission2, pid, uid), false, uid, message);
    }

    public void enforceCallingPermission(String permission2, String message) {
        this.enforce(permission2, this.checkCallingPermission(permission2), false, Binder.getCallingUid(), message);
    }

    public void enforceCallingOrSelfPermission(String permission2, String message) {
        this.enforce(permission2, this.checkCallingOrSelfPermission(permission2), true, Binder.getCallingUid(), message);
    }

    public void grantUriPermission(String toPackage, Uri uri, int modeFlags) {
        try {
            ActivityManagerNative.getDefault().grantUriPermission(this.mMainThread.getApplicationThread(), toPackage, uri, modeFlags);
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    public void revokeUriPermission(Uri uri, int modeFlags) {
        try {
            ActivityManagerNative.getDefault().revokeUriPermission(this.mMainThread.getApplicationThread(), uri, modeFlags);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public int checkUriPermission(Uri uri, int pid, int uid, int modeFlags) {
        try {
            return ActivityManagerNative.getDefault().checkUriPermission(uri, pid, uid, modeFlags);
        }
        catch (RemoteException e) {
            return -1;
        }
    }

    public int checkCallingUriPermission(Uri uri, int modeFlags) {
        int pid = Binder.getCallingPid();
        if (pid != Process.myPid()) {
            return this.checkUriPermission(uri, pid, Binder.getCallingUid(), modeFlags);
        }
        return -1;
    }

    public int checkCallingOrSelfUriPermission(Uri uri, int modeFlags) {
        return this.checkUriPermission(uri, Binder.getCallingPid(), Binder.getCallingUid(), modeFlags);
    }

    public int checkUriPermission(Uri uri, String readPermission, String writePermission, int pid, int uid, int modeFlags) {
        if ((modeFlags & 1) != 0 && (readPermission == null || this.checkPermission(readPermission, pid, uid) == 0)) {
            return 0;
        }
        if ((modeFlags & 2) != 0 && (writePermission == null || this.checkPermission(writePermission, pid, uid) == 0)) {
            return 0;
        }
        return uri != null ? this.checkUriPermission(uri, pid, uid, modeFlags) : -1;
    }

    private String uriModeFlagToString(int uriModeFlags) {
        switch (uriModeFlags) {
            case 3: {
                return "read and write";
            }
            case 1: {
                return "read";
            }
            case 2: {
                return "write";
            }
        }
        throw new IllegalArgumentException("Unknown permission mode flags: " + uriModeFlags);
    }

    private void enforceForUri(int modeFlags, int resultOfCheck, boolean selfToo, int uid, Uri uri, String message) {
        if (resultOfCheck != 0) {
            throw new SecurityException((message != null ? message + ": " : "") + (selfToo ? "Neither user " + uid + " nor current process has " : "User " + uid + " does not have ") + this.uriModeFlagToString(modeFlags) + " permission on " + uri + ".");
        }
    }

    public void enforceUriPermission(Uri uri, int pid, int uid, int modeFlags, String message) {
        this.enforceForUri(modeFlags, this.checkUriPermission(uri, pid, uid, modeFlags), false, uid, uri, message);
    }

    public void enforceCallingUriPermission(Uri uri, int modeFlags, String message) {
        this.enforceForUri(modeFlags, this.checkCallingUriPermission(uri, modeFlags), false, Binder.getCallingUid(), uri, message);
    }

    public void enforceCallingOrSelfUriPermission(Uri uri, int modeFlags, String message) {
        this.enforceForUri(modeFlags, this.checkCallingOrSelfUriPermission(uri, modeFlags), true, Binder.getCallingUid(), uri, message);
    }

    public void enforceUriPermission(Uri uri, String readPermission, String writePermission, int pid, int uid, int modeFlags, String message) {
        this.enforceForUri(modeFlags, this.checkUriPermission(uri, readPermission, writePermission, pid, uid, modeFlags), false, uid, uri, message);
    }

    private void warnIfCallingFromSystemProcess() {
        if (Process.myUid() == 1000) {
            Slog.w(TAG, "Calling a method in the system process without a qualified user: " + Debug.getCallers(5));
        }
    }

    public Context createPackageContext(String packageName, int flags) throws PackageManager.NameNotFoundException {
        return this.createPackageContextAsUser(packageName, flags, this.mUser != null ? this.mUser : Process.myUserHandle());
    }

    public Context createPackageContextAsUser(String packageName, int flags, UserHandle user) throws PackageManager.NameNotFoundException {
        if (packageName.equals("system") || packageName.equals("android")) {
            ContextImpl context = new ContextImpl(this.mMainThread.getSystemContext());
            context.mRestricted = (flags & 4) == 4;
            context.init(this.mPackageInfo, null, this.mMainThread, this.mResources, this.mBasePackageName, user);
            return context;
        }
        LoadedApk pi = this.mMainThread.getPackageInfo(packageName, this.mResources.getCompatibilityInfo(), flags, user.getIdentifier());
        if (pi != null) {
            ContextImpl c = new ContextImpl();
            c.mRestricted = (flags & 4) == 4;
            c.init(pi, null, this.mMainThread, this.mResources, this.mBasePackageName, user);
            if (c.mResources != null) {
                return c;
            }
        }
        throw new PackageManager.NameNotFoundException("Application package " + packageName + " not found");
    }

    public Context createConfigurationContext(Configuration overrideConfiguration) {
        if (overrideConfiguration == null) {
            throw new IllegalArgumentException("overrideConfiguration must not be null");
        }
        ContextImpl c = new ContextImpl();
        c.init(this.mPackageInfo, null, this.mMainThread);
        c.mResources = this.mMainThread.getTopLevelResources(this.mPackageInfo.getResDir(), this.getDisplayId(), overrideConfiguration, this.mResources.getCompatibilityInfo());
        return c;
    }

    public Context createDisplayContext(Display display) {
        if (display == null) {
            throw new IllegalArgumentException("display must not be null");
        }
        int displayId = display.getDisplayId();
        CompatibilityInfo ci = CompatibilityInfo.DEFAULT_COMPATIBILITY_INFO;
        CompatibilityInfoHolder cih = this.getCompatibilityInfo(displayId);
        if (cih != null) {
            ci = cih.get();
        }
        ContextImpl context = new ContextImpl();
        context.init(this.mPackageInfo, null, this.mMainThread);
        context.mDisplay = display;
        context.mResources = this.mMainThread.getTopLevelResources(this.mPackageInfo.getResDir(), displayId, null, ci);
        return context;
    }

    private int getDisplayId() {
        return this.mDisplay != null ? this.mDisplay.getDisplayId() : 0;
    }

    public boolean isRestricted() {
        return this.mRestricted;
    }

    public CompatibilityInfoHolder getCompatibilityInfo(int displayId) {
        return displayId == 0 ? this.mPackageInfo.mCompatibilityInfo : null;
    }

    private File getDataDirFile() {
        if (this.mPackageInfo != null) {
            return this.mPackageInfo.getDataDirFile();
        }
        throw new RuntimeException("Not supported in system context");
    }

    public File getDir(String name, int mode) {
        name = "app_" + name;
        File file = this.makeFilename(this.getDataDirFile(), name);
        if (!file.exists()) {
            file.mkdir();
            ContextImpl.setFilePermissionsFromMode(file.getPath(), mode, 505);
        }
        return file;
    }

    public int getUserId() {
        return this.mUser.getIdentifier();
    }

    static ContextImpl createSystemContext(ActivityThread mainThread) {
        ContextImpl context = new ContextImpl();
        context.init(Resources.getSystem(), mainThread, Process.myUserHandle());
        return context;
    }

    ContextImpl() {
        this.mOuterContext = this;
    }

    public ContextImpl(ContextImpl context) {
        this.mPackageInfo = context.mPackageInfo;
        this.mBasePackageName = context.mBasePackageName;
        this.mResources = context.mResources;
        this.mMainThread = context.mMainThread;
        this.mContentResolver = context.mContentResolver;
        this.mUser = context.mUser;
        this.mDisplay = context.mDisplay;
        this.mOuterContext = this;
    }

    void init(LoadedApk packageInfo, IBinder activityToken, ActivityThread mainThread) {
        this.init(packageInfo, activityToken, mainThread, null, null, Process.myUserHandle());
    }

    void init(LoadedApk packageInfo, IBinder activityToken, ActivityThread mainThread, Resources container, String basePackageName, UserHandle user) {
        this.mPackageInfo = packageInfo;
        this.mBasePackageName = basePackageName != null ? basePackageName : packageInfo.mPackageName;
        this.mResources = this.mPackageInfo.getResources(mainThread);
        if (this.mResources != null && container != null && container.getCompatibilityInfo().applicationScale != this.mResources.getCompatibilityInfo().applicationScale) {
            this.mResources = mainThread.getTopLevelResources(this.mPackageInfo.getResDir(), 0, null, container.getCompatibilityInfo());
        }
        this.mMainThread = mainThread;
        this.mActivityToken = activityToken;
        this.mContentResolver = new ApplicationContentResolver(this, mainThread, user);
        this.mUser = user;
    }

    void init(Resources resources, ActivityThread mainThread, UserHandle user) {
        this.mPackageInfo = null;
        this.mBasePackageName = null;
        this.mResources = resources;
        this.mMainThread = mainThread;
        this.mContentResolver = new ApplicationContentResolver(this, mainThread, user);
        this.mUser = user;
    }

    void scheduleFinalCleanup(String who, String what) {
        this.mMainThread.scheduleContextCleanup(this, who, what);
    }

    void performFinalCleanup(String who, String what) {
        this.mPackageInfo.removeContextRegistrations(this.getOuterContext(), who, what);
    }

    Context getReceiverRestrictedContext() {
        if (this.mReceiverRestrictedContext != null) {
            return this.mReceiverRestrictedContext;
        }
        this.mReceiverRestrictedContext = new ReceiverRestrictedContext(this.getOuterContext());
        return this.mReceiverRestrictedContext;
    }

    void setOuterContext(Context context) {
        this.mOuterContext = context;
    }

    Context getOuterContext() {
        return this.mOuterContext;
    }

    IBinder getActivityToken() {
        return this.mActivityToken;
    }

    static void setFilePermissionsFromMode(String name, int mode, int extraPermissions) {
        int perms = 0x1B0 | extraPermissions;
        if ((mode & 1) != 0) {
            perms |= 4;
        }
        if ((mode & 2) != 0) {
            perms |= 2;
        }
        FileUtils.setPermissions(name, perms, -1, -1);
    }

    private File validateFilePath(String name, boolean createDirectory) {
        File f;
        File dir;
        if (name.charAt(0) == File.separatorChar) {
            String dirPath = name.substring(0, name.lastIndexOf(File.separatorChar));
            dir = new File(dirPath);
            name = name.substring(name.lastIndexOf(File.separatorChar));
            f = new File(dir, name);
        } else {
            dir = this.getDatabasesDir();
            f = this.makeFilename(dir, name);
        }
        if (createDirectory && !dir.isDirectory() && dir.mkdir()) {
            FileUtils.setPermissions(dir.getPath(), 505, -1, -1);
        }
        return f;
    }

    private File makeFilename(File base, String name) {
        if (name.indexOf(File.separatorChar) < 0) {
            return new File(base, name);
        }
        throw new IllegalArgumentException("File " + name + " contains a path separator");
    }

    static {
        ContextImpl.registerService("accessibility", new ServiceFetcher(){

            public Object getService(ContextImpl ctx) {
                return AccessibilityManager.getInstance(ctx);
            }
        });
        ContextImpl.registerService("account", new ServiceFetcher(){

            public Object createService(ContextImpl ctx) {
                IBinder b = ServiceManager.getService("account");
                IAccountManager service = IAccountManager.Stub.asInterface(b);
                return new AccountManager(ctx, service);
            }
        });
        ContextImpl.registerService("activity", new ServiceFetcher(){

            public Object createService(ContextImpl ctx) {
                return new ActivityManager(ctx.getOuterContext(), ctx.mMainThread.getHandler());
            }
        });
        ContextImpl.registerService("alarm", new StaticServiceFetcher(){

            public Object createStaticService() {
                IBinder b = ServiceManager.getService("alarm");
                IAlarmManager service = IAlarmManager.Stub.asInterface(b);
                return new AlarmManager(service);
            }
        });
        ContextImpl.registerService("audio", new ServiceFetcher(){

            public Object createService(ContextImpl ctx) {
                return new AudioManager(ctx);
            }
        });
        ContextImpl.registerService("media_router", new ServiceFetcher(){

            public Object createService(ContextImpl ctx) {
                return new MediaRouter(ctx);
            }
        });
        ContextImpl.registerService("bluetooth", new ServiceFetcher(){

            public Object createService(ContextImpl ctx) {
                return BluetoothAdapter.getDefaultAdapter();
            }
        });
        ContextImpl.registerService("clipboard", new ServiceFetcher(){

            public Object createService(ContextImpl ctx) {
                return new ClipboardManager(ctx.getOuterContext(), ctx.mMainThread.getHandler());
            }
        });
        ContextImpl.registerService("connectivity", new StaticServiceFetcher(){

            public Object createStaticService() {
                IBinder b = ServiceManager.getService("connectivity");
                return new ConnectivityManager(IConnectivityManager.Stub.asInterface(b));
            }
        });
        ContextImpl.registerService("country_detector", new StaticServiceFetcher(){

            public Object createStaticService() {
                IBinder b = ServiceManager.getService("country_detector");
                return new CountryDetector(ICountryDetector.Stub.asInterface(b));
            }
        });
        ContextImpl.registerService("device_policy", new ServiceFetcher(){

            public Object createService(ContextImpl ctx) {
                return DevicePolicyManager.create(ctx, ctx.mMainThread.getHandler());
            }
        });
        ContextImpl.registerService("download", new ServiceFetcher(){

            public Object createService(ContextImpl ctx) {
                return new DownloadManager(ctx.getContentResolver(), ctx.getPackageName());
            }
        });
        ContextImpl.registerService("nfc", new ServiceFetcher(){

            public Object createService(ContextImpl ctx) {
                return new NfcManager(ctx);
            }
        });
        ContextImpl.registerService("dropbox", new StaticServiceFetcher(){

            public Object createStaticService() {
                return ContextImpl.createDropBoxManager();
            }
        });
        ContextImpl.registerService("input", new StaticServiceFetcher(){

            public Object createStaticService() {
                return InputManager.getInstance();
            }
        });
        ContextImpl.registerService("display", new ServiceFetcher(){

            public Object createService(ContextImpl ctx) {
                return new DisplayManager(ctx.getOuterContext());
            }
        });
        ContextImpl.registerService("input_method", new ServiceFetcher(){

            public Object createService(ContextImpl ctx) {
                return InputMethodManager.getInstance(ctx);
            }
        });
        ContextImpl.registerService("textservices", new ServiceFetcher(){

            public Object createService(ContextImpl ctx) {
                return TextServicesManager.getInstance();
            }
        });
        ContextImpl.registerService("keyguard", new ServiceFetcher(){

            public Object getService(ContextImpl ctx) {
                return new KeyguardManager();
            }
        });
        ContextImpl.registerService("layout_inflater", new ServiceFetcher(){

            public Object createService(ContextImpl ctx) {
                return PolicyManager.makeNewLayoutInflater(ctx.getOuterContext());
            }
        });
        ContextImpl.registerService("location", new ServiceFetcher(){

            public Object createService(ContextImpl ctx) {
                IBinder b = ServiceManager.getService("location");
                return new LocationManager(ctx, ILocationManager.Stub.asInterface(b));
            }
        });
        ContextImpl.registerService("netpolicy", new ServiceFetcher(){

            public Object createService(ContextImpl ctx) {
                return new NetworkPolicyManager(INetworkPolicyManager.Stub.asInterface(ServiceManager.getService("netpolicy")));
            }
        });
        ContextImpl.registerService("notification", new ServiceFetcher(){

            public Object createService(ContextImpl ctx) {
                Context outerContext = ctx.getOuterContext();
                return new NotificationManager(new ContextThemeWrapper(outerContext, Resources.selectSystemTheme(0, outerContext.getApplicationInfo().targetSdkVersion, 16973835, 16973935, 16974126)), ctx.mMainThread.getHandler());
            }
        });
        ContextImpl.registerService("servicediscovery", new ServiceFetcher(){

            public Object createService(ContextImpl ctx) {
                IBinder b = ServiceManager.getService("servicediscovery");
                INsdManager service = INsdManager.Stub.asInterface(b);
                return new NsdManager(ctx.getOuterContext(), service);
            }
        });
        ContextImpl.registerService("power", new ServiceFetcher(){

            public Object createService(ContextImpl ctx) {
                IBinder b = ServiceManager.getService("power");
                IPowerManager service = IPowerManager.Stub.asInterface(b);
                return new PowerManager(ctx.getOuterContext(), service, ctx.mMainThread.getHandler());
            }
        });
        ContextImpl.registerService("search", new ServiceFetcher(){

            public Object createService(ContextImpl ctx) {
                return new SearchManager(ctx.getOuterContext(), ctx.mMainThread.getHandler());
            }
        });
        ContextImpl.registerService("sensor", new ServiceFetcher(){

            public Object createService(ContextImpl ctx) {
                return new SystemSensorManager(ctx.mMainThread.getHandler().getLooper());
            }
        });
        ContextImpl.registerService("statusbar", new ServiceFetcher(){

            public Object createService(ContextImpl ctx) {
                return new StatusBarManager(ctx.getOuterContext());
            }
        });
        ContextImpl.registerService("storage", new ServiceFetcher(){

            public Object createService(ContextImpl ctx) {
                try {
                    return new StorageManager(ctx.mMainThread.getHandler().getLooper());
                }
                catch (RemoteException rex) {
                    Log.e(ContextImpl.TAG, "Failed to create StorageManager", rex);
                    return null;
                }
            }
        });
        ContextImpl.registerService("phone", new ServiceFetcher(){

            public Object createService(ContextImpl ctx) {
                return new TelephonyManager(ctx.getOuterContext());
            }
        });
        ContextImpl.registerService("throttle", new StaticServiceFetcher(){

            public Object createStaticService() {
                IBinder b = ServiceManager.getService("throttle");
                return new ThrottleManager(IThrottleManager.Stub.asInterface(b));
            }
        });
        ContextImpl.registerService("uimode", new ServiceFetcher(){

            public Object createService(ContextImpl ctx) {
                return new UiModeManager();
            }
        });
        ContextImpl.registerService("usb", new ServiceFetcher(){

            public Object createService(ContextImpl ctx) {
                IBinder b = ServiceManager.getService("usb");
                return new UsbManager(ctx, IUsbManager.Stub.asInterface(b));
            }
        });
        ContextImpl.registerService("serial", new ServiceFetcher(){

            public Object createService(ContextImpl ctx) {
                IBinder b = ServiceManager.getService("serial");
                return new SerialManager(ctx, ISerialManager.Stub.asInterface(b));
            }
        });
        ContextImpl.registerService("vibrator", new ServiceFetcher(){

            public Object createService(ContextImpl ctx) {
                return new SystemVibrator();
            }
        });
        ContextImpl.registerService("wallpaper", WALLPAPER_FETCHER);
        ContextImpl.registerService("wifi", new ServiceFetcher(){

            public Object createService(ContextImpl ctx) {
                IBinder b = ServiceManager.getService("wifi");
                IWifiManager service = IWifiManager.Stub.asInterface(b);
                return new WifiManager(ctx.getOuterContext(), service);
            }
        });
        ContextImpl.registerService("wifip2p", new ServiceFetcher(){

            public Object createService(ContextImpl ctx) {
                IBinder b = ServiceManager.getService("wifip2p");
                IWifiP2pManager service = IWifiP2pManager.Stub.asInterface(b);
                return new WifiP2pManager(service);
            }
        });
        ContextImpl.registerService("window", new ServiceFetcher(){

            public Object getService(ContextImpl ctx) {
                Display display = ctx.mDisplay;
                if (display == null) {
                    DisplayManager dm = (DisplayManager)ctx.getOuterContext().getSystemService("display");
                    display = dm.getDisplay(0);
                }
                return new WindowManagerImpl(display);
            }
        });
        ContextImpl.registerService("user", new ServiceFetcher(){

            public Object getService(ContextImpl ctx) {
                IBinder b = ServiceManager.getService("user");
                IUserManager service = IUserManager.Stub.asInterface(b);
                return new UserManager(ctx, service);
            }
        });
    }

    private static class ApplicationContentResolver
    extends ContentResolver {
        private final ActivityThread mMainThread;
        private final UserHandle mUser;

        public ApplicationContentResolver(Context context, ActivityThread mainThread, UserHandle user) {
            super(context);
            this.mMainThread = Preconditions.checkNotNull(mainThread);
            this.mUser = Preconditions.checkNotNull(user);
        }

        protected IContentProvider acquireProvider(Context context, String auth) {
            return this.mMainThread.acquireProvider(context, auth, this.mUser.getIdentifier(), true);
        }

        protected IContentProvider acquireExistingProvider(Context context, String auth) {
            return this.mMainThread.acquireExistingProvider(context, auth, this.mUser.getIdentifier(), true);
        }

        public boolean releaseProvider(IContentProvider provider) {
            return this.mMainThread.releaseProvider(provider, true);
        }

        protected IContentProvider acquireUnstableProvider(Context c, String auth) {
            return this.mMainThread.acquireProvider(c, auth, this.mUser.getIdentifier(), false);
        }

        public boolean releaseUnstableProvider(IContentProvider icp) {
            return this.mMainThread.releaseProvider(icp, false);
        }

        public void unstableProviderDied(IContentProvider icp) {
            this.mMainThread.handleUnstableProviderDied(icp.asBinder(), true);
        }
    }

    static abstract class StaticServiceFetcher
    extends ServiceFetcher {
        private Object mCachedInstance;

        StaticServiceFetcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getService(ContextImpl unused) {
            StaticServiceFetcher staticServiceFetcher = this;
            synchronized (staticServiceFetcher) {
                Object service = this.mCachedInstance;
                if (service != null) {
                    return service;
                }
                this.mCachedInstance = this.createStaticService();
                return this.mCachedInstance;
            }
        }

        public abstract Object createStaticService();
    }

    static class ServiceFetcher {
        int mContextCacheIndex = -1;

        ServiceFetcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getService(ContextImpl ctx) {
            ArrayList<Object> cache;
            ArrayList<Object> arrayList = cache = ctx.mServiceCache;
            synchronized (arrayList) {
                Object service;
                if (cache.size() == 0) {
                    for (int i = 0; i < sNextPerContextServiceCacheIndex; ++i) {
                        cache.add(null);
                    }
                } else {
                    service = cache.get(this.mContextCacheIndex);
                    if (service != null) {
                        return service;
                    }
                }
                service = this.createService(ctx);
                cache.set(this.mContextCacheIndex, service);
                return service;
            }
        }

        public Object createService(ContextImpl ctx) {
            throw new RuntimeException("Not implemented");
        }
    }
}

