/*
 * Decompiled with CFR 0.152.
 */
package android.database;

import android.database.AbstractCursor;
import android.database.CharArrayBuffer;
import android.database.CursorWindow;
import android.database.StaleDataException;

public abstract class AbstractWindowedCursor
extends AbstractCursor {
    protected CursorWindow mWindow;

    public byte[] getBlob(int columnIndex) {
        this.checkPosition();
        return this.mWindow.getBlob(this.mPos, columnIndex);
    }

    public String getString(int columnIndex) {
        this.checkPosition();
        return this.mWindow.getString(this.mPos, columnIndex);
    }

    public void copyStringToBuffer(int columnIndex, CharArrayBuffer buffer) {
        this.checkPosition();
        this.mWindow.copyStringToBuffer(this.mPos, columnIndex, buffer);
    }

    public short getShort(int columnIndex) {
        this.checkPosition();
        return this.mWindow.getShort(this.mPos, columnIndex);
    }

    public int getInt(int columnIndex) {
        this.checkPosition();
        return this.mWindow.getInt(this.mPos, columnIndex);
    }

    public long getLong(int columnIndex) {
        this.checkPosition();
        return this.mWindow.getLong(this.mPos, columnIndex);
    }

    public float getFloat(int columnIndex) {
        this.checkPosition();
        return this.mWindow.getFloat(this.mPos, columnIndex);
    }

    public double getDouble(int columnIndex) {
        this.checkPosition();
        return this.mWindow.getDouble(this.mPos, columnIndex);
    }

    public boolean isNull(int columnIndex) {
        this.checkPosition();
        return this.mWindow.getType(this.mPos, columnIndex) == 0;
    }

    @Deprecated
    public boolean isBlob(int columnIndex) {
        return this.getType(columnIndex) == 4;
    }

    @Deprecated
    public boolean isString(int columnIndex) {
        return this.getType(columnIndex) == 3;
    }

    @Deprecated
    public boolean isLong(int columnIndex) {
        return this.getType(columnIndex) == 1;
    }

    @Deprecated
    public boolean isFloat(int columnIndex) {
        return this.getType(columnIndex) == 2;
    }

    public int getType(int columnIndex) {
        this.checkPosition();
        return this.mWindow.getType(this.mPos, columnIndex);
    }

    protected void checkPosition() {
        super.checkPosition();
        if (this.mWindow == null) {
            throw new StaleDataException("Attempting to access a closed CursorWindow.Most probable cause: cursor is deactivated prior to calling this method.");
        }
    }

    public CursorWindow getWindow() {
        return this.mWindow;
    }

    public void setWindow(CursorWindow window) {
        if (window != this.mWindow) {
            this.closeWindow();
            this.mWindow = window;
        }
    }

    public boolean hasWindow() {
        return this.mWindow != null;
    }

    protected void closeWindow() {
        if (this.mWindow != null) {
            this.mWindow.close();
            this.mWindow = null;
        }
    }

    protected void clearOrCreateWindow(String name) {
        if (this.mWindow == null) {
            this.mWindow = new CursorWindow(name);
        } else {
            this.mWindow.clear();
        }
    }

    protected void onDeactivateOrClose() {
        super.onDeactivateOrClose();
        this.closeWindow();
    }
}

