/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Matrix;
import android.graphics.RectF;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.impl.DelegateManager;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;

public final class Matrix_Delegate {
    private static final int MATRIX_SIZE = 9;
    private static final DelegateManager<Matrix_Delegate> sManager = new DelegateManager<Matrix_Delegate>(Matrix_Delegate.class);
    private float[] mValues = new float[9];
    private static final int kIdentity_Mask = 0;
    private static final int kTranslate_Mask = 1;
    private static final int kScale_Mask = 2;
    private static final int kAffine_Mask = 4;
    private static final int kPerspective_Mask = 8;
    private static final int kRectStaysRect_Mask = 16;
    private static final int kUnknown_Mask = 128;
    private static final int kAllMasks = 31;
    private static final int kTranslate_Shift = 0;
    private static final int kScale_Shift = 1;
    private static final int kAffine_Shift = 2;
    private static final int kPerspective_Shift = 3;
    private static final int kRectStaysRect_Shift = 4;

    public static Matrix_Delegate getDelegate(int n) {
        return sManager.getDelegate(n);
    }

    public static AffineTransform getAffineTransform(Matrix matrix) {
        Matrix_Delegate matrix_Delegate = sManager.getDelegate(matrix.native_instance);
        if (matrix_Delegate == null) {
            return null;
        }
        return matrix_Delegate.getAffineTransform();
    }

    public static boolean hasPerspective(Matrix matrix) {
        Matrix_Delegate matrix_Delegate = sManager.getDelegate(matrix.native_instance);
        if (matrix_Delegate == null) {
            return false;
        }
        return matrix_Delegate.hasPerspective();
    }

    public void set(Matrix_Delegate matrix_Delegate) {
        System.arraycopy(matrix_Delegate.mValues, 0, this.mValues, 0, 9);
    }

    public void set(float[] fArray) {
        System.arraycopy(fArray, 0, this.mValues, 0, 9);
    }

    public void reset() {
        Matrix_Delegate.reset(this.mValues);
    }

    public boolean isIdentity() {
        int n = 0;
        for (int i = 0; i < 3; ++i) {
            int n2 = 0;
            while (n2 < 3) {
                if (this.mValues[n] != (float)(i == n2 ? 1 : 0)) {
                    return false;
                }
                ++n2;
                ++n;
            }
        }
        return true;
    }

    public static float[] makeValues(AffineTransform affineTransform) {
        float[] fArray = new float[]{(float)affineTransform.getScaleX(), (float)affineTransform.getShearX(), (float)affineTransform.getTranslateX(), (float)affineTransform.getShearY(), (float)affineTransform.getScaleY(), (float)affineTransform.getTranslateY(), 0.0f, 0.0f, 1.0f};
        return fArray;
    }

    public static Matrix_Delegate make(AffineTransform affineTransform) {
        return new Matrix_Delegate(Matrix_Delegate.makeValues(affineTransform));
    }

    public boolean mapRect(RectF rectF, RectF rectF2) {
        float[] fArray = new float[]{rectF2.left, rectF2.top, rectF2.right, rectF2.top, rectF2.right, rectF2.bottom, rectF2.left, rectF2.bottom};
        this.mapPoints(fArray);
        rectF.left = Math.min(Math.min(fArray[0], fArray[2]), Math.min(fArray[4], fArray[6]));
        rectF.right = Math.max(Math.max(fArray[0], fArray[2]), Math.max(fArray[4], fArray[6]));
        rectF.top = Math.min(Math.min(fArray[1], fArray[3]), Math.min(fArray[5], fArray[7]));
        rectF.bottom = Math.max(Math.max(fArray[1], fArray[3]), Math.max(fArray[5], fArray[7]));
        return (this.computeTypeMask() & 0x10) != 0;
    }

    public AffineTransform getAffineTransform() {
        return Matrix_Delegate.getAffineTransform(this.mValues);
    }

    public boolean hasPerspective() {
        return this.mValues[6] != 0.0f || this.mValues[7] != 0.0f || this.mValues[8] != 1.0f;
    }

    @LayoutlibDelegate
    static int native_create(int n) {
        Matrix_Delegate matrix_Delegate;
        Matrix_Delegate matrix_Delegate2 = new Matrix_Delegate();
        if (n > 0 && (matrix_Delegate = sManager.getDelegate(n)) != null) {
            System.arraycopy(matrix_Delegate.mValues, 0, matrix_Delegate2.mValues, 0, 9);
        }
        return sManager.addNewDelegate(matrix_Delegate2);
    }

    @LayoutlibDelegate
    static boolean native_isIdentity(int n) {
        Matrix_Delegate matrix_Delegate = sManager.getDelegate(n);
        if (matrix_Delegate == null) {
            return false;
        }
        return matrix_Delegate.isIdentity();
    }

    @LayoutlibDelegate
    static boolean native_rectStaysRect(int n) {
        Matrix_Delegate matrix_Delegate = sManager.getDelegate(n);
        if (matrix_Delegate == null) {
            return true;
        }
        return (matrix_Delegate.computeTypeMask() & 0x10) != 0;
    }

    @LayoutlibDelegate
    static void native_reset(int n) {
        Matrix_Delegate matrix_Delegate = sManager.getDelegate(n);
        if (matrix_Delegate == null) {
            return;
        }
        Matrix_Delegate.reset(matrix_Delegate.mValues);
    }

    @LayoutlibDelegate
    static void native_set(int n, int n2) {
        Matrix_Delegate matrix_Delegate = sManager.getDelegate(n);
        if (matrix_Delegate == null) {
            return;
        }
        Matrix_Delegate matrix_Delegate2 = sManager.getDelegate(n2);
        if (matrix_Delegate2 == null) {
            return;
        }
        System.arraycopy(matrix_Delegate2.mValues, 0, matrix_Delegate.mValues, 0, 9);
    }

    @LayoutlibDelegate
    static void native_setTranslate(int n, float f, float f2) {
        Matrix_Delegate matrix_Delegate = sManager.getDelegate(n);
        if (matrix_Delegate == null) {
            return;
        }
        Matrix_Delegate.setTranslate(matrix_Delegate.mValues, f, f2);
    }

    @LayoutlibDelegate
    static void native_setScale(int n, float f, float f2, float f3, float f4) {
        Matrix_Delegate matrix_Delegate = sManager.getDelegate(n);
        if (matrix_Delegate == null) {
            return;
        }
        matrix_Delegate.mValues = Matrix_Delegate.getScale(f, f2, f3, f4);
    }

    @LayoutlibDelegate
    static void native_setScale(int n, float f, float f2) {
        Matrix_Delegate matrix_Delegate = sManager.getDelegate(n);
        if (matrix_Delegate == null) {
            return;
        }
        matrix_Delegate.mValues[0] = f;
        matrix_Delegate.mValues[1] = 0.0f;
        matrix_Delegate.mValues[2] = 0.0f;
        matrix_Delegate.mValues[3] = 0.0f;
        matrix_Delegate.mValues[4] = f2;
        matrix_Delegate.mValues[5] = 0.0f;
        matrix_Delegate.mValues[6] = 0.0f;
        matrix_Delegate.mValues[7] = 0.0f;
        matrix_Delegate.mValues[8] = 1.0f;
    }

    @LayoutlibDelegate
    static void native_setRotate(int n, float f, float f2, float f3) {
        Matrix_Delegate matrix_Delegate = sManager.getDelegate(n);
        if (matrix_Delegate == null) {
            return;
        }
        matrix_Delegate.mValues = Matrix_Delegate.getRotate(f, f2, f3);
    }

    @LayoutlibDelegate
    static void native_setRotate(int n, float f) {
        Matrix_Delegate matrix_Delegate = sManager.getDelegate(n);
        if (matrix_Delegate == null) {
            return;
        }
        Matrix_Delegate.setRotate(matrix_Delegate.mValues, f);
    }

    @LayoutlibDelegate
    static void native_setSinCos(int n, float f, float f2, float f3, float f4) {
        Matrix_Delegate matrix_Delegate = sManager.getDelegate(n);
        if (matrix_Delegate == null) {
            return;
        }
        Matrix_Delegate.setTranslate(matrix_Delegate.mValues, -f3, -f4);
        matrix_Delegate.postTransform(Matrix_Delegate.getRotate(f, f2));
        matrix_Delegate.postTransform(Matrix_Delegate.getTranslate(f3, f4));
    }

    @LayoutlibDelegate
    static void native_setSinCos(int n, float f, float f2) {
        Matrix_Delegate matrix_Delegate = sManager.getDelegate(n);
        if (matrix_Delegate == null) {
            return;
        }
        Matrix_Delegate.setRotate(matrix_Delegate.mValues, f, f2);
    }

    @LayoutlibDelegate
    static void native_setSkew(int n, float f, float f2, float f3, float f4) {
        Matrix_Delegate matrix_Delegate = sManager.getDelegate(n);
        if (matrix_Delegate == null) {
            return;
        }
        matrix_Delegate.mValues = Matrix_Delegate.getSkew(f, f2, f3, f4);
    }

    @LayoutlibDelegate
    static void native_setSkew(int n, float f, float f2) {
        Matrix_Delegate matrix_Delegate = sManager.getDelegate(n);
        if (matrix_Delegate == null) {
            return;
        }
        matrix_Delegate.mValues[0] = 1.0f;
        matrix_Delegate.mValues[1] = f;
        matrix_Delegate.mValues[2] = 0.0f;
        matrix_Delegate.mValues[3] = f2;
        matrix_Delegate.mValues[4] = 1.0f;
        matrix_Delegate.mValues[5] = 0.0f;
        matrix_Delegate.mValues[6] = 0.0f;
        matrix_Delegate.mValues[7] = 0.0f;
        matrix_Delegate.mValues[8] = 1.0f;
    }

    @LayoutlibDelegate
    static boolean native_setConcat(int n, int n2, int n3) {
        if (n2 == n) {
            return Matrix_Delegate.native_preConcat(n, n3);
        }
        if (n3 == n) {
            return Matrix_Delegate.native_postConcat(n, n2);
        }
        Matrix_Delegate matrix_Delegate = sManager.getDelegate(n);
        if (matrix_Delegate == null) {
            return false;
        }
        Matrix_Delegate matrix_Delegate2 = sManager.getDelegate(n2);
        if (matrix_Delegate2 == null) {
            return false;
        }
        Matrix_Delegate matrix_Delegate3 = sManager.getDelegate(n3);
        if (matrix_Delegate3 == null) {
            return false;
        }
        Matrix_Delegate.multiply(matrix_Delegate.mValues, matrix_Delegate2.mValues, matrix_Delegate3.mValues);
        return true;
    }

    @LayoutlibDelegate
    static boolean native_preTranslate(int n, float f, float f2) {
        Matrix_Delegate matrix_Delegate = sManager.getDelegate(n);
        if (matrix_Delegate == null) {
            return false;
        }
        matrix_Delegate.preTransform(Matrix_Delegate.getTranslate(f, f2));
        return true;
    }

    @LayoutlibDelegate
    static boolean native_preScale(int n, float f, float f2, float f3, float f4) {
        Matrix_Delegate matrix_Delegate = sManager.getDelegate(n);
        if (matrix_Delegate == null) {
            return false;
        }
        matrix_Delegate.preTransform(Matrix_Delegate.getScale(f, f2, f3, f4));
        return true;
    }

    @LayoutlibDelegate
    static boolean native_preScale(int n, float f, float f2) {
        Matrix_Delegate matrix_Delegate = sManager.getDelegate(n);
        if (matrix_Delegate == null) {
            return false;
        }
        matrix_Delegate.preTransform(Matrix_Delegate.getScale(f, f2));
        return true;
    }

    @LayoutlibDelegate
    static boolean native_preRotate(int n, float f, float f2, float f3) {
        Matrix_Delegate matrix_Delegate = sManager.getDelegate(n);
        if (matrix_Delegate == null) {
            return false;
        }
        matrix_Delegate.preTransform(Matrix_Delegate.getRotate(f, f2, f3));
        return true;
    }

    @LayoutlibDelegate
    static boolean native_preRotate(int n, float f) {
        Matrix_Delegate matrix_Delegate = sManager.getDelegate(n);
        if (matrix_Delegate == null) {
            return false;
        }
        double d = Math.toRadians(f);
        float f2 = (float)Math.sin(d);
        float f3 = (float)Math.cos(d);
        matrix_Delegate.preTransform(Matrix_Delegate.getRotate(f2, f3));
        return true;
    }

    @LayoutlibDelegate
    static boolean native_preSkew(int n, float f, float f2, float f3, float f4) {
        Matrix_Delegate matrix_Delegate = sManager.getDelegate(n);
        if (matrix_Delegate == null) {
            return false;
        }
        matrix_Delegate.preTransform(Matrix_Delegate.getSkew(f, f2, f3, f4));
        return true;
    }

    @LayoutlibDelegate
    static boolean native_preSkew(int n, float f, float f2) {
        Matrix_Delegate matrix_Delegate = sManager.getDelegate(n);
        if (matrix_Delegate == null) {
            return false;
        }
        matrix_Delegate.preTransform(Matrix_Delegate.getSkew(f, f2));
        return true;
    }

    @LayoutlibDelegate
    static boolean native_preConcat(int n, int n2) {
        Matrix_Delegate matrix_Delegate = sManager.getDelegate(n);
        if (matrix_Delegate == null) {
            return false;
        }
        Matrix_Delegate matrix_Delegate2 = sManager.getDelegate(n2);
        if (matrix_Delegate2 == null) {
            return false;
        }
        matrix_Delegate.preTransform(matrix_Delegate2.mValues);
        return true;
    }

    @LayoutlibDelegate
    static boolean native_postTranslate(int n, float f, float f2) {
        Matrix_Delegate matrix_Delegate = sManager.getDelegate(n);
        if (matrix_Delegate == null) {
            return false;
        }
        matrix_Delegate.postTransform(Matrix_Delegate.getTranslate(f, f2));
        return true;
    }

    @LayoutlibDelegate
    static boolean native_postScale(int n, float f, float f2, float f3, float f4) {
        Matrix_Delegate matrix_Delegate = sManager.getDelegate(n);
        if (matrix_Delegate == null) {
            return false;
        }
        matrix_Delegate.postTransform(Matrix_Delegate.getScale(f, f2, f3, f4));
        return true;
    }

    @LayoutlibDelegate
    static boolean native_postScale(int n, float f, float f2) {
        Matrix_Delegate matrix_Delegate = sManager.getDelegate(n);
        if (matrix_Delegate == null) {
            return false;
        }
        matrix_Delegate.postTransform(Matrix_Delegate.getScale(f, f2));
        return true;
    }

    @LayoutlibDelegate
    static boolean native_postRotate(int n, float f, float f2, float f3) {
        Matrix_Delegate matrix_Delegate = sManager.getDelegate(n);
        if (matrix_Delegate == null) {
            return false;
        }
        matrix_Delegate.postTransform(Matrix_Delegate.getRotate(f, f2, f3));
        return true;
    }

    @LayoutlibDelegate
    static boolean native_postRotate(int n, float f) {
        Matrix_Delegate matrix_Delegate = sManager.getDelegate(n);
        if (matrix_Delegate == null) {
            return false;
        }
        matrix_Delegate.postTransform(Matrix_Delegate.getRotate(f));
        return true;
    }

    @LayoutlibDelegate
    static boolean native_postSkew(int n, float f, float f2, float f3, float f4) {
        Matrix_Delegate matrix_Delegate = sManager.getDelegate(n);
        if (matrix_Delegate == null) {
            return false;
        }
        matrix_Delegate.postTransform(Matrix_Delegate.getSkew(f, f2, f3, f4));
        return true;
    }

    @LayoutlibDelegate
    static boolean native_postSkew(int n, float f, float f2) {
        Matrix_Delegate matrix_Delegate = sManager.getDelegate(n);
        if (matrix_Delegate == null) {
            return false;
        }
        matrix_Delegate.postTransform(Matrix_Delegate.getSkew(f, f2));
        return true;
    }

    @LayoutlibDelegate
    static boolean native_postConcat(int n, int n2) {
        Matrix_Delegate matrix_Delegate = sManager.getDelegate(n);
        if (matrix_Delegate == null) {
            return false;
        }
        Matrix_Delegate matrix_Delegate2 = sManager.getDelegate(n2);
        if (matrix_Delegate2 == null) {
            return false;
        }
        matrix_Delegate.postTransform(matrix_Delegate2.mValues);
        return true;
    }

    @LayoutlibDelegate
    static boolean native_setRectToRect(int n, RectF rectF, RectF rectF2, int n2) {
        Matrix_Delegate matrix_Delegate = sManager.getDelegate(n);
        if (matrix_Delegate == null) {
            return false;
        }
        if (rectF.isEmpty()) {
            Matrix_Delegate.reset(matrix_Delegate.mValues);
            return false;
        }
        if (rectF2.isEmpty()) {
            matrix_Delegate.mValues[7] = 0.0f;
            matrix_Delegate.mValues[6] = 0.0f;
            matrix_Delegate.mValues[5] = 0.0f;
            matrix_Delegate.mValues[4] = 0.0f;
            matrix_Delegate.mValues[3] = 0.0f;
            matrix_Delegate.mValues[2] = 0.0f;
            matrix_Delegate.mValues[1] = 0.0f;
            matrix_Delegate.mValues[0] = 0.0f;
            matrix_Delegate.mValues[8] = 1.0f;
        } else {
            float f = rectF2.width() / rectF.width();
            float f2 = rectF2.height() / rectF.height();
            boolean bl = false;
            if (n2 != Matrix.ScaleToFit.FILL.nativeInt) {
                if (f > f2) {
                    bl = true;
                    f = f2;
                } else {
                    f2 = f;
                }
            }
            float f3 = rectF2.left - rectF.left * f;
            float f4 = rectF2.top - rectF.top * f2;
            if (n2 == Matrix.ScaleToFit.CENTER.nativeInt || n2 == Matrix.ScaleToFit.END.nativeInt) {
                float f5 = bl ? rectF2.width() - rectF.width() * f2 : rectF2.height() - rectF.height() * f2;
                if (n2 == Matrix.ScaleToFit.CENTER.nativeInt) {
                    f5 /= 2.0f;
                }
                if (bl) {
                    f3 += f5;
                } else {
                    f4 += f5;
                }
            }
            matrix_Delegate.mValues[0] = f;
            matrix_Delegate.mValues[4] = f2;
            matrix_Delegate.mValues[2] = f3;
            matrix_Delegate.mValues[5] = f4;
            matrix_Delegate.mValues[7] = 0.0f;
            matrix_Delegate.mValues[6] = 0.0f;
            matrix_Delegate.mValues[3] = 0.0f;
            matrix_Delegate.mValues[1] = 0.0f;
        }
        matrix_Delegate.mValues[8] = 1.0f;
        return true;
    }

    @LayoutlibDelegate
    static boolean native_setPolyToPoly(int n, float[] fArray, int n2, float[] fArray2, int n3, int n4) {
        Bridge.getLog().fidelityWarning("unsupported", "Matrix.setPolyToPoly is not supported.", null, null);
        return false;
    }

    @LayoutlibDelegate
    static boolean native_invert(int n, int n2) {
        Matrix_Delegate matrix_Delegate = sManager.getDelegate(n);
        if (matrix_Delegate == null) {
            return false;
        }
        Matrix_Delegate matrix_Delegate2 = sManager.getDelegate(n2);
        if (matrix_Delegate2 == null) {
            return false;
        }
        try {
            AffineTransform affineTransform = matrix_Delegate.getAffineTransform();
            AffineTransform affineTransform2 = affineTransform.createInverse();
            matrix_Delegate2.mValues[0] = (float)affineTransform2.getScaleX();
            matrix_Delegate2.mValues[1] = (float)affineTransform2.getShearX();
            matrix_Delegate2.mValues[2] = (float)affineTransform2.getTranslateX();
            matrix_Delegate2.mValues[3] = (float)affineTransform2.getScaleX();
            matrix_Delegate2.mValues[4] = (float)affineTransform2.getShearY();
            matrix_Delegate2.mValues[5] = (float)affineTransform2.getTranslateY();
            return true;
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return false;
        }
    }

    @LayoutlibDelegate
    static void native_mapPoints(int n, float[] fArray, int n2, float[] fArray2, int n3, int n4, boolean bl) {
        Matrix_Delegate matrix_Delegate = sManager.getDelegate(n);
        if (matrix_Delegate == null) {
            return;
        }
        if (bl) {
            matrix_Delegate.mapPoints(fArray, n2, fArray2, n3, n4);
        } else {
            matrix_Delegate.mapVectors(fArray, n2, fArray2, n3, n4);
        }
    }

    @LayoutlibDelegate
    static boolean native_mapRect(int n, RectF rectF, RectF rectF2) {
        Matrix_Delegate matrix_Delegate = sManager.getDelegate(n);
        if (matrix_Delegate == null) {
            return false;
        }
        return matrix_Delegate.mapRect(rectF, rectF2);
    }

    @LayoutlibDelegate
    static float native_mapRadius(int n, float f) {
        Matrix_Delegate matrix_Delegate = sManager.getDelegate(n);
        if (matrix_Delegate == null) {
            return 0.0f;
        }
        float[] fArray = new float[]{f, 0.0f, 0.0f, f};
        matrix_Delegate.mapVectors(fArray, 0, fArray, 0, 2);
        float f2 = Matrix_Delegate.getPointLength(fArray, 0);
        float f3 = Matrix_Delegate.getPointLength(fArray, 2);
        return (float)Math.sqrt(f2 * f3);
    }

    @LayoutlibDelegate
    static void native_getValues(int n, float[] fArray) {
        Matrix_Delegate matrix_Delegate = sManager.getDelegate(n);
        if (matrix_Delegate == null) {
            return;
        }
        System.arraycopy(matrix_Delegate.mValues, 0, matrix_Delegate.mValues, 0, 9);
    }

    @LayoutlibDelegate
    static void native_setValues(int n, float[] fArray) {
        Matrix_Delegate matrix_Delegate = sManager.getDelegate(n);
        if (matrix_Delegate == null) {
            return;
        }
        System.arraycopy(fArray, 0, matrix_Delegate.mValues, 0, 9);
    }

    @LayoutlibDelegate
    static boolean native_equals(int n, int n2) {
        Matrix_Delegate matrix_Delegate = sManager.getDelegate(n);
        if (matrix_Delegate == null) {
            return false;
        }
        Matrix_Delegate matrix_Delegate2 = sManager.getDelegate(n2);
        if (matrix_Delegate2 == null) {
            return false;
        }
        for (int i = 0; i < 9; ++i) {
            if (matrix_Delegate.mValues[i] == matrix_Delegate2.mValues[i]) continue;
            return false;
        }
        return true;
    }

    @LayoutlibDelegate
    static void finalizer(int n) {
        sManager.removeJavaReferenceFor(n);
    }

    static AffineTransform getAffineTransform(float[] fArray) {
        return new AffineTransform(fArray[0], fArray[3], fArray[1], fArray[4], fArray[2], fArray[5]);
    }

    private static void reset(float[] fArray) {
        int n = 0;
        for (int i = 0; i < 3; ++i) {
            int n2 = 0;
            while (n2 < 3) {
                fArray[n] = i == n2 ? 1 : 0;
                ++n2;
                ++n;
            }
        }
    }

    private int computeTypeMask() {
        int n = 0;
        if ((double)this.mValues[6] != 0.0 || (double)this.mValues[7] != 0.0 || (double)this.mValues[8] != 1.0) {
            n |= 8;
        }
        if ((double)this.mValues[2] != 0.0 || (double)this.mValues[5] != 0.0) {
            n |= 1;
        }
        float f = this.mValues[0];
        float f2 = this.mValues[1];
        float f3 = this.mValues[3];
        float f4 = this.mValues[4];
        if ((double)f2 != 0.0 || (double)f3 != 0.0) {
            n |= 4;
        }
        if ((double)f != 1.0 || (double)f4 != 1.0) {
            n |= 2;
        }
        if ((n & 8) == 0) {
            boolean bl = f != 0.0f;
            boolean bl2 = f2 != 0.0f;
            boolean bl3 = f3 != 0.0f;
            boolean bl4 = f4 != 0.0f;
            boolean bl5 = (bl | bl4) ^ true;
            boolean bl6 = bl & bl4;
            boolean bl7 = (bl2 | bl3) ^ true;
            boolean bl8 = bl2 & bl3;
            n |= (bl5 & bl8 | bl6 & bl7) << 4;
        }
        return n;
    }

    private Matrix_Delegate() {
        this.reset();
    }

    private Matrix_Delegate(float[] fArray) {
        System.arraycopy(fArray, 0, this.mValues, 0, 9);
    }

    private void postTransform(float[] fArray) {
        float[] fArray2 = new float[9];
        Matrix_Delegate.multiply(fArray2, this.mValues, fArray);
        this.mValues = fArray2;
    }

    private void preTransform(float[] fArray) {
        float[] fArray2 = new float[9];
        Matrix_Delegate.multiply(fArray2, fArray, this.mValues);
        this.mValues = fArray2;
    }

    private void mapPoints(float[] fArray, int n, float[] fArray2, int n2, int n3) {
        boolean bl;
        int n4 = n3 * 2;
        float[] fArray3 = fArray;
        boolean bl2 = bl = fArray == fArray2;
        if (bl) {
            fArray3 = new float[n + n4];
        }
        for (int i = 0; i < n4; i += 2) {
            float f = this.mValues[0] * fArray2[i + n2] + this.mValues[1] * fArray2[i + n2 + 1] + this.mValues[2];
            float f2 = this.mValues[3] * fArray2[i + n2] + this.mValues[4] * fArray2[i + n2 + 1] + this.mValues[5];
            fArray3[i + n] = f;
            fArray3[i + n + 1] = f2;
        }
        if (bl) {
            System.arraycopy(fArray3, n, fArray, n, n4);
        }
    }

    private void mapPoints(float[] fArray) {
        this.mapPoints(fArray, 0, fArray, 0, fArray.length >> 1);
    }

    private void mapVectors(float[] fArray, int n, float[] fArray2, int n2, int n3) {
        if (this.hasPerspective()) {
            float[] fArray3 = new float[]{0.0f, 0.0f};
            this.mapPoints(fArray3);
            this.mapPoints(fArray, n, fArray2, n2, n3);
            int n4 = n3 * 2;
            for (int i = 0; i < n4; i += 2) {
                fArray[n + i] = fArray[n + i] - fArray3[0];
                fArray[n + i + 1] = fArray[n + i + 1] - fArray3[1];
            }
        } else {
            Matrix_Delegate matrix_Delegate = new Matrix_Delegate(this.mValues);
            Matrix_Delegate.setTranslate(matrix_Delegate.mValues, 0.0f, 0.0f);
            matrix_Delegate.mapPoints(fArray, n, fArray2, n2, n3);
        }
    }

    private static float getPointLength(float[] fArray, int n) {
        return (float)Math.sqrt(fArray[n] * fArray[n] + fArray[n + 1] * fArray[n + 1]);
    }

    static void multiply(float[] fArray, float[] fArray2, float[] fArray3) {
        fArray[0] = fArray3[0] * fArray2[0] + fArray3[1] * fArray2[3] + fArray3[2] * fArray2[6];
        fArray[1] = fArray3[0] * fArray2[1] + fArray3[1] * fArray2[4] + fArray3[2] * fArray2[7];
        fArray[2] = fArray3[0] * fArray2[2] + fArray3[1] * fArray2[5] + fArray3[2] * fArray2[8];
        fArray[3] = fArray3[3] * fArray2[0] + fArray3[4] * fArray2[3] + fArray3[5] * fArray2[6];
        fArray[4] = fArray3[3] * fArray2[1] + fArray3[4] * fArray2[4] + fArray3[5] * fArray2[7];
        fArray[5] = fArray3[3] * fArray2[2] + fArray3[4] * fArray2[5] + fArray3[5] * fArray2[8];
        fArray[6] = fArray3[6] * fArray2[0] + fArray3[7] * fArray2[3] + fArray3[8] * fArray2[6];
        fArray[7] = fArray3[6] * fArray2[1] + fArray3[7] * fArray2[4] + fArray3[8] * fArray2[7];
        fArray[8] = fArray3[6] * fArray2[2] + fArray3[7] * fArray2[5] + fArray3[8] * fArray2[8];
    }

    static float[] getTranslate(float f, float f2) {
        return Matrix_Delegate.setTranslate(new float[9], f, f2);
    }

    static float[] setTranslate(float[] fArray, float f, float f2) {
        fArray[0] = 1.0f;
        fArray[1] = 0.0f;
        fArray[2] = f;
        fArray[3] = 0.0f;
        fArray[4] = 1.0f;
        fArray[5] = f2;
        fArray[6] = 0.0f;
        fArray[7] = 0.0f;
        fArray[8] = 1.0f;
        return fArray;
    }

    static float[] getScale(float f, float f2) {
        return new float[]{f, 0.0f, 0.0f, 0.0f, f2, 0.0f, 0.0f, 0.0f, 1.0f};
    }

    static float[] getScale(float f, float f2, float f3, float f4) {
        float[] fArray = new float[9];
        float[] fArray2 = new float[9];
        Matrix_Delegate.setTranslate(fArray, -f3, -f4);
        Matrix_Delegate.multiply(fArray2, fArray, Matrix_Delegate.getScale(f, f2));
        Matrix_Delegate.multiply(fArray, fArray2, Matrix_Delegate.getTranslate(f3, f4));
        return fArray;
    }

    static float[] getRotate(float f) {
        double d = Math.toRadians(f);
        float f2 = (float)Math.sin(d);
        float f3 = (float)Math.cos(d);
        return Matrix_Delegate.getRotate(f2, f3);
    }

    static float[] getRotate(float f, float f2) {
        return Matrix_Delegate.setRotate(new float[9], f, f2);
    }

    static float[] setRotate(float[] fArray, float f) {
        double d = Math.toRadians(f);
        float f2 = (float)Math.sin(d);
        float f3 = (float)Math.cos(d);
        return Matrix_Delegate.setRotate(fArray, f2, f3);
    }

    static float[] setRotate(float[] fArray, float f, float f2) {
        fArray[0] = f2;
        fArray[1] = -f;
        fArray[2] = 0.0f;
        fArray[3] = f;
        fArray[4] = f2;
        fArray[5] = 0.0f;
        fArray[6] = 0.0f;
        fArray[7] = 0.0f;
        fArray[8] = 1.0f;
        return fArray;
    }

    static float[] getRotate(float f, float f2, float f3) {
        float[] fArray = new float[9];
        float[] fArray2 = new float[9];
        Matrix_Delegate.setTranslate(fArray, -f2, -f3);
        double d = Math.toRadians(f);
        float f4 = (float)Math.cos(d);
        float f5 = (float)Math.sin(d);
        Matrix_Delegate.multiply(fArray2, fArray, Matrix_Delegate.getRotate(f5, f4));
        Matrix_Delegate.multiply(fArray, fArray2, Matrix_Delegate.getTranslate(f2, f3));
        return fArray;
    }

    static float[] getSkew(float f, float f2) {
        return new float[]{1.0f, f, 0.0f, f2, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    }

    static float[] getSkew(float f, float f2, float f3, float f4) {
        float[] fArray = new float[9];
        float[] fArray2 = new float[9];
        Matrix_Delegate.setTranslate(fArray, -f3, -f4);
        Matrix_Delegate.multiply(fArray2, fArray, new float[]{1.0f, f, 0.0f, f2, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f});
        Matrix_Delegate.multiply(fArray, fArray2, Matrix_Delegate.getTranslate(f3, f4));
        return fArray;
    }
}

